/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.service.invoke;

import com.bizunited.platform.core.service.invoke.AbstractHandleChain;
import com.bizunited.platform.core.service.invoke.HandleChain;
import com.bizunited.platform.core.service.invoke.InvokeProxyContext;
import com.bizunited.platform.core.service.invoke.InvokeProxyException;
import com.bizunited.platform.core.service.invoke.InvokeRequestHandle;
import com.bizunited.platform.core.service.invoke.InvokeResponseHandle;
import java.util.List;
import org.apache.commons.lang3.Validate;

public class DefaultHandleChain
extends AbstractHandleChain
implements HandleChain {
    private List<InvokeRequestHandle> currentInvokeRequestHandles;
    private List<InvokeResponseHandle> currentInvokeResponseHandles;
    private InvokeProxyContext invokeProxyContext;
    private int currentRequestIndex = 0;
    private int currentResponseIndex = 0;

    @Override
    public void doHandle(InvokeProxyContext context, HandleChain.ChainLogic chainLogic) throws InvokeProxyException {
        Validate.notNull((Object)this.invokeProxyContext, (String)"\u8c03\u7528\u8fc7\u7a0b\u4e0a\u4e0b\u6587\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a!!", (Object[])new Object[0]);
        Validate.notNull(this.currentInvokeRequestHandles, (String)"\u672a\u53d1\u73b0\u4efb\u4f55request\u8bf7\u6c42\u8fde\u5904\u7406\u8282\u70b9\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.isTrue((!this.currentInvokeRequestHandles.isEmpty() ? 1 : 0) != 0, (String)"\u672a\u53d1\u73b0\u4efb\u4f55request\u8bf7\u6c42\u8fde\u5904\u7406\u8282\u70b9\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.notNull(this.currentInvokeResponseHandles, (String)"\u672a\u53d1\u73b0\u4efb\u4f55response\u8bf7\u6c42\u8fde\u5904\u7406\u8282\u70b9\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.isTrue((!this.currentInvokeResponseHandles.isEmpty() ? 1 : 0) != 0, (String)"\u672a\u53d1\u73b0\u4efb\u4f55response\u8bf7\u6c42\u8fde\u5904\u7406\u8282\u70b9\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        int maxRequestHandlesSize = this.currentInvokeRequestHandles.size();
        int maxResponseHandlesSize = this.currentInvokeResponseHandles.size();
        if (this.currentRequestIndex >= maxRequestHandlesSize && this.currentResponseIndex >= maxResponseHandlesSize) {
            this.throwException(context);
            return;
        }
        if (this.currentRequestIndex < maxRequestHandlesSize && chainLogic == HandleChain.ChainLogic.CONTINUE) {
            InvokeRequestHandle currentHandle = this.currentInvokeRequestHandles.get(this.currentRequestIndex++);
            try {
                currentHandle.doHandle(this.invokeProxyContext, this);
            }
            catch (Exception e) {
                this.buildException(this.invokeProxyContext, e);
                this.currentRequestIndex = maxRequestHandlesSize;
                this.doHandle(this.invokeProxyContext, HandleChain.ChainLogic.CONTINUE);
            }
            this.throwException(context);
            return;
        }
        if (this.currentRequestIndex < maxRequestHandlesSize && chainLogic == HandleChain.ChainLogic.BREAK) {
            this.currentRequestIndex = maxRequestHandlesSize;
            this.doHandle(this.invokeProxyContext, HandleChain.ChainLogic.CONTINUE);
            this.throwException(context);
            return;
        }
        if (this.currentResponseIndex < maxResponseHandlesSize && this.currentRequestIndex >= maxRequestHandlesSize && chainLogic == HandleChain.ChainLogic.CONTINUE) {
            InvokeResponseHandle currentHandle = this.currentInvokeResponseHandles.get(this.currentResponseIndex++);
            if (this.invokeProxyContext.isException() && currentHandle.handleException(this.invokeProxyContext)) {
                currentHandle.doHandle(this.invokeProxyContext, this);
                this.throwException(context);
                return;
            }
            if (this.invokeProxyContext.isException() && !currentHandle.handleException(this.invokeProxyContext)) {
                this.doHandle(context, chainLogic);
                this.throwException(context);
                return;
            }
            try {
                currentHandle.doHandle(this.invokeProxyContext, this);
            }
            catch (Exception e) {
                this.buildException(this.invokeProxyContext, e);
                throw new InvokeProxyException(this.invokeProxyContext, (Throwable)e);
            }
        }
        this.throwException(context);
    }

    void setInvokeRequestHandles(List<InvokeRequestHandle> currentInvokeRequestHandles) {
        this.currentInvokeRequestHandles = currentInvokeRequestHandles;
    }

    void setInvokeResponseHandles(List<InvokeResponseHandle> currentInvokeResponseHandles) {
        this.currentInvokeResponseHandles = currentInvokeResponseHandles;
    }

    void setInvokeProxyContext(InvokeProxyContext invokeProxyContext) {
        this.invokeProxyContext = invokeProxyContext;
    }
}

