/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.service.scheduler.handle;

import com.bizunited.platform.core.entity.DynamicTaskSchedulerEntity;
import com.bizunited.platform.core.entity.ScriptEntity;
import com.bizunited.platform.core.service.ScriptService;
import com.bizunited.platform.core.service.invoke.HandleChain;
import com.bizunited.platform.core.service.invoke.InvokeProxyContext;
import com.bizunited.platform.core.service.invoke.InvokeProxyException;
import com.bizunited.platform.core.service.invoke.InvokeRequestHandle;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component(value="DynamicTaskInvokeHandle")
public class DynamicTaskInvokeHandle
implements InvokeRequestHandle {
    @Autowired
    private ScriptService scriptService;
    @Autowired
    private ApplicationContext applicationContext;

    @Override
    public void doHandle(InvokeProxyContext context, HandleChain chain) throws InvokeProxyException {
        DynamicTaskSchedulerEntity currentTask = (DynamicTaskSchedulerEntity)context.getChainParam("currentTask");
        Validate.notNull((Object)currentTask, (String)"\u5728\u8fdb\u884c\u52a8\u6001\u4efb\u52a1\u6267\u884c\u65f6\uff0c\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u52a8\u6001\u8c03\u7528\u4efb\u52a1!", (Object[])new Object[0]);
        HashMap<String, Object> parmas = new HashMap<String, Object>();
        parmas.put("currentTask", currentTask);
        if (currentTask.getInvokeType() == 1) {
            this.invokeGroovyScript(currentTask, context, parmas);
        } else if (currentTask.getInvokeType() == 2) {
            this.invokeMethod(currentTask, context, parmas);
        } else {
            throw new InvokeProxyException(context, "\u9519\u8bef\u7684\u6267\u884c\u811a\u672c\u7c7b\u578b");
        }
        chain.doHandle(context, HandleChain.ChainLogic.CONTINUE);
    }

    private void invokeMethod(DynamicTaskSchedulerEntity currentTask, InvokeProxyContext context, Map<String, Object> parmas) throws InvokeProxyException {
        String taskCode = currentTask.getTaskCode();
        String invokeBeanName = currentTask.getInvokeBeanName();
        Validate.notBlank((CharSequence)invokeBeanName, (String)"\u6267\u884c\u52a8\u6001\u8c03\u7528\u4efb\u52a1\u65f6\uff0c\u53d1\u73b0\u57fa\u4e8eDynamicTaskService\u6ce8\u89e3\u7684\u52a8\u6001\u6267\u884c\u4efb\u52a1%s\uff0c\u5176invokeBeanName\u4fe1\u606f\u975e\u6cd5", (Object[])new Object[]{taskCode});
        String invokeMethod = currentTask.getInvokeMethod();
        Validate.notBlank((CharSequence)invokeMethod, (String)"\u6267\u884c\u52a8\u6001\u8c03\u7528\u4efb\u52a1\u65f6\uff0c\u53d1\u73b0\u57fa\u4e8eDynamicTaskService\u6ce8\u89e3\u7684\u52a8\u6001\u6267\u884c\u4efb\u52a1%s\uff0c\u5176invokeMethod\u4fe1\u606f\u975e\u6cd5", (Object[])new Object[]{taskCode});
        boolean proxyContextParam = currentTask.getProxyContextParam();
        Object currentBean = null;
        try {
            currentBean = this.applicationContext.getBean(invokeBeanName);
        }
        catch (NoSuchBeanDefinitionException e) {
            throw new IllegalArgumentException(String.format("\u6267\u884c\u52a8\u6001\u8c03\u7528\u4efb\u52a1\u65f6\uff0c\u672a\u53d1\u73b0\u540d\u4e3a%s\u7684spring bean\uff0c\u8bf7\u68c0\u67e5", invokeBeanName));
        }
        Class beanClass = this.applicationContext.getType(invokeBeanName);
        Method beanClassMethod = null;
        try {
            if (proxyContextParam) {
                beanClassMethod = beanClass.getMethod(invokeMethod, InvokeProxyContext.class);
                beanClassMethod.invoke(currentBean, context);
            } else {
                beanClassMethod = beanClass.getMethod(invokeMethod, new Class[0]);
                beanClassMethod.invoke(currentBean, new Object[0]);
            }
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(String.format("\u6267\u884c\u52a8\u6001\u8c03\u7528\u4efb\u52a1\u65f6\uff0c\u672a\u53d1\u73b0\u540d\u4e3a%s\u7684spring bean\u4e2d\u6307\u5b9a\u7684\u65b9\u6cd5%s\uff0c\u8bf7\u68c0\u67e5", invokeBeanName, invokeMethod));
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new IllegalArgumentException("\u6267\u884c\u52a8\u6001\u8c03\u7528\u4efb\u52a1\u65f6,\u65b9\u6cd5\u6267\u884c\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5", e);
        }
    }

    private void invokeGroovyScript(DynamicTaskSchedulerEntity currentTask, InvokeProxyContext context, Map<String, Object> parmas) throws InvokeProxyException {
        String scriptName = currentTask.getScriptName();
        ScriptEntity scriptEntity = this.scriptService.findByName(scriptName);
        Validate.notNull((Object)scriptEntity, (String)"\u5728\u8fdb\u884c\u52a8\u6001\u4efb\u52a1\u6267\u884c\u65f6\uff0c\u672a\u53d1\u73b0\u6307\u5b9a\u7684groovy\u811a\u672c\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5%s!", (Object[])new Object[]{currentTask.getId()});
        String scriptId = scriptEntity.getId();
        Set<String> chainParamsKeys = context.getParamKeys();
        for (String chainParamsKey : chainParamsKeys) {
            parmas.put(chainParamsKey, context.getChainParam(chainParamsKey));
        }
        Map<String, Object> returnResults = null;
        returnResults = this.scriptService.invoke(scriptId, parmas);
        if (returnResults != null && !returnResults.isEmpty()) {
            context.setChainParams(returnResults);
        }
    }
}

