/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.service.security;

import com.bizunited.platform.core.entity.RoleEntity;
import com.bizunited.platform.core.entity.UserEntity;
import com.bizunited.platform.core.repository.RoleRepository;
import com.bizunited.platform.core.repository.UserRepository;
import com.bizunited.platform.core.service.NebulaToolkitService;
import com.bizunited.platform.rbac.server.service.RoleService;
import com.bizunited.platform.rbac.server.service.UserService;
import com.bizunited.platform.rbac.server.vo.UserVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.util.CollectionUtils;

public class UserServiceImpl
implements UserService {
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private RoleRepository roleRepository;
    @Autowired
    private RoleService roleService;
    @Autowired
    @Qualifier(value="passwordEncoder")
    @Lazy
    private PasswordEncoder passwordEncoder;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    private static final String BASE_ROLE_NAME = "BASEROLE";

    @Transactional
    public UserVo create(UserVo userVo) {
        Validate.notNull((Object)userVo, (String)"\u5fc5\u987b\u4f20\u5165\u8981\u6dfb\u52a0\u7684\u7528\u6237\u4fe1\u606f!", (Object[])new Object[0]);
        String userName = userVo.getUserName();
        String account = userVo.getAccount();
        Validate.notBlank((CharSequence)userName, (String)"\u7528\u6237\u771f\u5b9e\u59d3\u540d\u5fc5\u987b\u4f20\u5165!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)account, (String)"\u7528\u6237\u8d26\u53f7\u4fe1\u606f\uff08\u4e00\u822c\u662f\u624b\u673a\u53f7\uff09\u5fc5\u987b\u4f20\u5165!", (Object[])new Object[0]);
        UserEntity currentUser = this.userRepository.findByAccount(account);
        Validate.isTrue((currentUser == null ? 1 : 0) != 0, (String)"\u8be5\u8d26\u53f7\u4fe1\u606f\u5df2\u7ecf\u88ab\u4f7f\u7528\uff0c\u8bf7\u91cd\u65b0\u586b\u5199!", (Object[])new Object[0]);
        String phone = userVo.getPhone();
        if (!StringUtils.isBlank((CharSequence)phone)) {
            currentUser = this.userRepository.findByPhone(phone);
            Validate.isTrue((currentUser == null ? 1 : 0) != 0, (String)"\u8be5\u8054\u7cfb\u65b9\u5f0f\u5df2\u7ecf\u88ab\u4f7f\u7528\uff0c\u8bf7\u91cd\u65b0\u586b\u5199!", (Object[])new Object[0]);
        } else {
            userVo.setPhone(null);
        }
        userVo.setCreateTime(new Date());
        userVo.setUseStatus(Integer.valueOf(1));
        String password = userVo.getPassword();
        Validate.notBlank((CharSequence)password, (String)"\u5bc6\u7801\u4fe1\u606f\u5fc5\u987b\u4f20\u5165!", (Object[])new Object[0]);
        userVo.setPassword(this.passwordEncoder.encode((CharSequence)password));
        currentUser = this.nebulaToolkitService.copyObjectByWhiteList(userVo, UserEntity.class, HashSet.class, ArrayList.class, new String[0]);
        this.userRepository.saveAndFlush(currentUser);
        RoleEntity baseRole = this.roleRepository.findByRoleName(BASE_ROLE_NAME);
        Validate.notNull((Object)baseRole, (String)"\u65b0\u589e\u7528\u6237\u7ed1\u5b9a\u57fa\u7840\u89d2\u8272\u65f6\uff0c\u672a\u627e\u5230\u57fa\u7840\u89d2\u8272", (Object[])new Object[0]);
        this.roleService.bindRoles(currentUser.getId(), new String[]{baseRole.getRoleName()});
        userVo.setId(currentUser.getId());
        return userVo;
    }

    @Transactional
    public UserVo update(UserVo user) {
        Validate.notNull((Object)user, (String)"\u5fc5\u987b\u4f20\u5165\u8981\u4fee\u6539\u7684\u7528\u6237\u4fe1\u606f!", (Object[])new Object[0]);
        String userId = user.getId();
        String userName = user.getUserName();
        String account = user.getAccount();
        Validate.notBlank((CharSequence)userId, (String)"\u4fee\u6539\u65f6\uff0c\u7528\u6237\u6570\u636e\u7684\u7f16\u53f7\u4fe1\u606f\u5fc5\u987b\u4f20\u5165!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)userName, (String)"\u7528\u6237\u771f\u5b9e\u59d3\u540d\u5fc5\u987b\u4f20\u5165!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)account, (String)"\u7528\u6237\u8d26\u53f7\u4fe1\u606f\uff08\u4e00\u822c\u662f\u624b\u673a\u53f7\uff09\u5fc5\u987b\u4f20\u5165!", (Object[])new Object[0]);
        UserEntity currentUser = this.userRepository.findByAccount(account);
        Validate.isTrue((currentUser == null || StringUtils.equals((CharSequence)currentUser.getId(), (CharSequence)userId) ? 1 : 0) != 0, (String)"\u8be5\u8d26\u53f7\u4fe1\u606f\u5df2\u7ecf\u88ab\u4f7f\u7528\uff0c\u8bf7\u91cd\u65b0\u586b\u5199!", (Object[])new Object[0]);
        String phone = user.getPhone();
        if (!StringUtils.isBlank((CharSequence)phone)) {
            currentUser = this.userRepository.findByPhone(phone);
            Validate.isTrue((currentUser == null || StringUtils.equals((CharSequence)currentUser.getId(), (CharSequence)userId) ? 1 : 0) != 0, (String)"\u6307\u5b9a\u7684\u7535\u8bdd\u4fe1\u606f\u5df2\u88ab\u4f7f\u7528\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        }
        Optional op = this.userRepository.findById(userId);
        UserEntity oldUser = op.orElse(null);
        Validate.notNull((Object)oldUser, (String)"\u672a\u627e\u5230\u539f\u59cb\u7684\u7528\u6237\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        oldUser.setAccount(account);
        oldUser.setEntryTime(user.getEntryTime());
        oldUser.setPhone(phone);
        oldUser.setUserHead(user.getUserHead());
        oldUser.setUserName(userName);
        this.userRepository.save(oldUser);
        return user;
    }

    @Transactional
    public UserVo updatePassword(String userId, String newPassword) {
        Validate.notBlank((CharSequence)userId, (String)"\u4fee\u6539\u5bc6\u7801\u65f6 ,\u7528\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)newPassword, (String)"\u4fee\u6539\u5bc6\u7801\u65f6 ,\u65b0\u7684\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a!!", (Object[])new Object[0]);
        Optional op = this.userRepository.findById(userId);
        UserEntity user = op.orElse(null);
        Validate.notNull((Object)user, (String)"\u6307\u5b9a\u7684\u7528\u6237\u6ca1\u6709\u88ab\u627e\u5230\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        user.setPassword(this.passwordEncoder.encode((CharSequence)newPassword));
        this.userRepository.saveAndFlush(user);
        return this.nebulaToolkitService.copyObjectByWhiteList(user, UserVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    @Transactional
    public UserVo updatePassword(String userId, String newPassword, String oldPassword) {
        Validate.notBlank((CharSequence)userId, (String)"\u4fee\u6539\u5bc6\u7801\u65f6 ,\u7528\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)newPassword, (String)"\u4fee\u6539\u5bc6\u7801\u65f6 ,\u65b0\u7684\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)oldPassword, (String)"\u4fee\u6539\u5bc6\u7801\u65f6 ,\u539f\u6709\u7684\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a!!", (Object[])new Object[0]);
        Optional op = this.userRepository.findById(userId);
        UserEntity user = op.orElse(null);
        Validate.notNull((Object)user, (String)"\u6307\u5b9a\u7684\u7528\u6237\u6ca1\u6709\u88ab\u627e\u5230\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.isTrue((boolean)this.passwordEncoder.matches((CharSequence)oldPassword, user.getPassword()), (String)"\u539f\u59cb\u5bc6\u7801\u8f93\u5165\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        user.setPassword(this.passwordEncoder.encode((CharSequence)newPassword));
        return this.nebulaToolkitService.copyObjectByWhiteList(user, UserVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    @Transactional
    public void updateLastloginTime(String account) {
        Validate.notBlank((CharSequence)account, (String)"\u4fee\u6539\u6700\u540e\u767b\u5f55\u65f6\u95f4\u65f6 ,\u7528\u6237\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a!!", (Object[])new Object[0]);
        Date lastloginTime = new Date();
        this.userRepository.updateLastloginTime(account, lastloginTime);
        this.userRepository.flush();
    }

    @Transactional
    public UserVo enabled(String account) {
        Validate.notBlank((CharSequence)account, (String)"\u7528\u6237\u8d26\u53f7\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        UserEntity user = this.userRepository.findByAccount(account);
        Validate.notNull((Object)user, (String)"\u672a\u627e\u5230\u9700\u8981\u4fee\u6539\u7684\u7528\u6237\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        user.setUseStatus(1);
        this.userRepository.save(user);
        return this.nebulaToolkitService.copyObjectByWhiteList(user, UserVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    @Transactional
    public UserVo disable(String account) {
        Validate.notBlank((CharSequence)account, (String)"\u7528\u6237\u8d26\u53f7\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        UserEntity user = this.userRepository.findByAccount(account);
        Validate.notNull((Object)user, (String)"\u672a\u627e\u5230\u9700\u8981\u4fee\u6539\u7684\u7528\u6237\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        user.setUseStatus(0);
        this.userRepository.save(user);
        return this.nebulaToolkitService.copyObjectByWhiteList(user, UserVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public UserVo findDetailsById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        UserEntity currentUser = this.userRepository.findDetailsById(id);
        if (currentUser == null) {
            return null;
        }
        UserVo userVo = this.nebulaToolkitService.copyObjectByWhiteList(currentUser, UserVo.class, HashSet.class, ArrayList.class, "positions", "orgs", "groups");
        List roles = this.roleService.findAllByUserId(id, Integer.valueOf(0));
        userVo.setRoles(CollectionUtils.isEmpty((Collection)roles) ? new HashSet() : new HashSet(roles));
        return userVo;
    }

    public UserVo findByAccount(String account) {
        if (StringUtils.isBlank((CharSequence)account)) {
            return null;
        }
        UserEntity currentUser = this.userRepository.findByAccount(account);
        if (currentUser == null) {
            return null;
        }
        return this.nebulaToolkitService.copyObjectByWhiteList(currentUser, UserVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public List<UserVo> findByAccountLikeOrNameLike(String param) {
        List<UserEntity> accountLike = this.userRepository.findByAccountLike(param);
        List<UserEntity> nameLike = this.userRepository.findByUserNameLike(param);
        ArrayList<UserEntity> total = new ArrayList<UserEntity>();
        total.addAll(accountLike);
        total.addAll(nameLike);
        return total.stream().distinct().map(o -> this.nebulaToolkitService.copyObjectByWhiteList(o, UserVo.class, HashSet.class, ArrayList.class, new String[0])).collect(Collectors.toList());
    }

    public Page<UserVo> findByConditions(String userName, String account, Integer useStatus, Pageable pageable) {
        HashMap<String, Object> conditions = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((CharSequence)userName)) {
            conditions.put("userName", userName);
        }
        if (StringUtils.isNotBlank((CharSequence)account)) {
            conditions.put("account", account);
        }
        if (useStatus != null) {
            conditions.put("useStatus", useStatus);
        }
        if (pageable == null) {
            pageable = PageRequest.of((int)0, (int)50);
        }
        Page userEntityPage = this.userRepository.findByConditions(pageable, conditions);
        List userEntitys = userEntityPage.getContent();
        PageImpl userVoPage = null;
        if (!userEntitys.isEmpty()) {
            Collection<UserVo> userVos = this.nebulaToolkitService.copyCollectionByWhiteList(userEntitys, UserEntity.class, UserVo.class, LinkedHashSet.class, ArrayList.class, "roles");
            userVoPage = new PageImpl(new ArrayList<UserVo>(userVos), pageable, userEntityPage.getTotalElements());
        } else {
            userVoPage = new PageImpl((List)Lists.newArrayList(), pageable, 0L);
        }
        return userVoPage;
    }

    public UserVo findByUserId(String userId) {
        Validate.notBlank((CharSequence)userId, (String)"\u4f20\u5165\u7684\u7528\u6237ID\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        UserEntity user = this.userRepository.findDetailsById(userId);
        if (user == null) {
            return null;
        }
        return this.nebulaToolkitService.copyObjectByWhiteList(user, UserVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public Set<UserVo> findByIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Sets.newHashSet();
        }
        Set<UserEntity> users = this.userRepository.findByIds(ids);
        if (CollectionUtils.isEmpty(users)) {
            return Sets.newHashSet();
        }
        return (Set)this.nebulaToolkitService.copyCollectionByWhiteList(users, UserEntity.class, UserVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public UserVo findByPhone(String phone) {
        if (StringUtils.isBlank((CharSequence)phone)) {
            return null;
        }
        UserEntity user = this.userRepository.findByPhone(phone);
        if (user == null) {
            return null;
        }
        return this.nebulaToolkitService.copyObjectByWhiteList(user, UserVo.class, HashSet.class, ArrayList.class, new String[0]);
    }
}

