package com.bizunited.platform.ui.configuration;

import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.CacheControl;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.resource.EncodedResourceResolver;

import java.util.concurrent.TimeUnit;

/**
 * @description:技术中台默认ui页面，静态文件加载方式
 * @author: yanwe yinwenjie
 * @date: 15/Feb/2019 13:29
 */
@Configuration
@EnableAutoConfiguration
@ComponentScan(basePackages = {"com.bizunited.platform.ui"})
public class NebulaUIConfig implements WebMvcConfigurer {
  @Override
  public void addResourceHandlers(ResourceHandlerRegistry registry) {
    // pc端页面支持
    this.registryPath(registry, "/default/**", "classpath:/META-INF/nebula/");
    this.registryPath(registry, "/default/css/**", "classpath:/META-INF/nebula/css/");
    this.registryPath(registry, "/default/resource/**", "classpath:/META-INF/nebula/resource/");
    this.registryPath(registry, "/default/resource/fonts/**", "classpath:/META-INF/nebula/resource/fonts/");
    this.registryPath(registry, "/default/resource/images/**", "classpath:/META-INF/nebula/resource/images/");
    this.registryPath(registry, "/default/resource/static/**", "classpath:/META-INF/nebula/resource/static/");
    this.registryPath(registry, "/default/resource/static/apps/**", "classpath:/META-INF/nebula/resource/static/apps/");
    this.registryPath(registry, "/default/resource/static/theme/**", "classpath:/META-INF/nebula/resource/static/theme/");
    this.registryPath(registry, "/default/resource/static/fonts/**", "classpath:/META-INF/nebula/resource/static/fonts/");
    this.registryPath(registry, "/default/scripts/**", "classpath:/META-INF/nebula/scripts/");
    this.registryPath(registry, "/default/static/**", "classpath:/META-INF/nebula/static/");
    this.registryPath(registry, "/default/static/editor/**", "classpath:/META-INF/nebula/static/editor/");
  }
  
  private void registryPath (ResourceHandlerRegistry registry , String handlerLocal , String locations) {
    registry.addResourceHandler(handlerLocal)
    .addResourceLocations(locations)
    // 开启 http304
    .setCacheControl(CacheControl.maxAge(30, TimeUnit.MINUTES).cachePrivate().cachePublic())
    .setCachePeriod(1800)
    .resourceChain(false)
    // 开启gzip
    .addResolver(new EncodedResourceResolver());
  }
}