package com.biz.crm.util;

import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

import java.util.concurrent.TimeUnit;

/** 需要控制粒度的时候使用
 * @Author zhangyuzhu
 * @Description
 * @Created data 2018/10/29 14:17
 */
@Component
public class RedissonUtil {

    private Logger logger = LoggerFactory.getLogger(getClass());

    @Autowired
    private RedissonClient redissonClient;


    /**
     * 初始化一个分布式锁
     * @param key 锁的关键字（在redis中一定独一无二的）
     * @return
     */
    public RLock createLock(String key){
        RLock lock = redissonClient.getLock(key);
        return lock;
    }


    /**
     * 开始加锁
     * @param rLock 锁对象
     * @param waitTime 如果加锁不成功，最大等待时间,在这段时间内会重试，两倍自动失效时间
     * @param lockTime 锁的自动失效时间
     * @return
     */
    public boolean tryLock(RLock rLock, long waitTime, long lockTime){
        boolean reBoolean = false;
        try {
            reBoolean = rLock.tryLock(waitTime, lockTime, TimeUnit.SECONDS);
        } catch (InterruptedException e) {
            logger.error("加锁失败，锁：{}", rLock.getName(),e);
        }
        return reBoolean;
    }


    /**
     * 自动释放锁
     * @param rLock
     * @return
     */
    public void unLock(RLock rLock){
        if(null == rLock){
           return;
        }
        try {
            rLock.unlock();
        }catch (Exception e){
            String name = rLock.getName();
            logger.error("释放锁失败，锁：{}", StringUtils.isEmpty(name)?"":name,e);
        }
    }

}
