/*
 * Decompiled with CFR 0.152.
 */
package com.biz.cascore.interceptor;

import com.biz.cascore.pagination.Page;
import com.biz.cascore.pagination.Pageable;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.ibatis.executor.statement.RoutingStatementHandler;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.scripting.defaults.DefaultParameterHandler;
import org.springframework.util.ReflectionUtils;

@Intercepts(value={@Signature(type=StatementHandler.class, method="prepare", args={Connection.class})})
public class PageableHelper
implements Interceptor {
    private String pageSqlId;
    private String dialect;

    public Object intercept(Invocation invocation) throws Throwable {
        if (invocation.getTarget() instanceof StatementHandler) {
            this.statementHandlerExecutor(invocation);
        }
        return invocation.proceed();
    }

    public Object plugin(Object target) {
        if (target instanceof StatementHandler) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        return target;
    }

    public void setProperties(Properties properties) {
        this.dialect = properties.getProperty("dialect");
        this.pageSqlId = properties.getProperty("pageSqlId");
    }

    private void setTotalRecord(Page<?> page, MappedStatement mappedStatement, Connection connection) {
        BoundSql boundSql = mappedStatement.getBoundSql(page);
        String sql = boundSql.getSql();
        String countSql = this.getCountSql(sql);
        List parameterMappings = boundSql.getParameterMappings();
        BoundSql countBoundSql = new BoundSql(mappedStatement.getConfiguration(), countSql, parameterMappings, page);
        DefaultParameterHandler parameterHandler = new DefaultParameterHandler(mappedStatement, page, countBoundSql);
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        int retryCount = 5;
        boolean transactionCompleted = false;
        do {
            try {
                try {
                    pstmt = connection.prepareStatement(countSql);
                    parameterHandler.setParameters(pstmt);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        Long totalRecordCount = rs.getLong(1);
                        page.setTotal(totalRecordCount);
                    }
                    transactionCompleted = true;
                }
                catch (SQLException e) {
                    String sqlState = e.getSQLState();
                    retryCount = "08S01".equals(sqlState) || "40001".equals(sqlState) ? --retryCount : 0;
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                        if (pstmt == null) continue;
                        pstmt.close();
                    }
                    catch (SQLException e2) {
                        e2.printStackTrace();
                    }
                    continue;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                if (rs != null) {
                    rs.close();
                }
                if (pstmt == null) continue;
                pstmt.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        } while (!transactionCompleted && retryCount > 0);
    }

    private String getCountSql(String sql) {
        int index = StringUtils.indexOfAny((String)sql, (String[])new String[]{"from", "FROM"});
        return "select count(*) " + sql.substring(index);
    }

    private String getPageSql(Pageable pageable, String sql) {
        StringBuffer sqlBuffer = new StringBuffer(sql);
        if ("mysql".equalsIgnoreCase(this.dialect)) {
            return this.getMysqlPageSql(pageable, sqlBuffer);
        }
        if ("oracle".equalsIgnoreCase(this.dialect)) {
            return this.getOraclePageSql(pageable, sqlBuffer);
        }
        return sqlBuffer.toString();
    }

    private String getOraclePageSql(Pageable pageable, StringBuffer sqlBuffer) {
        int offset = (pageable.getPage() - 1) * pageable.getRows();
        int endResult = pageable.getPage() * pageable.getRows();
        StringBuffer pageBuffer = new StringBuffer();
        pageBuffer.append(" SELECT T.* FROM ( SELECT ROWNUM RN,TMP.* FROM ( ").append(sqlBuffer).append(" )TMP WHERE ROWNUM  &lt;= ").append(endResult).append(" )  T ");
        pageBuffer.append(" WHERE RN &gt;").append(offset);
        return pageBuffer.toString();
    }

    private String getMysqlPageSql(Pageable pageable, StringBuffer sqlBuffer) {
        int offset = (pageable.getPage() - 1) * pageable.getRows();
        sqlBuffer.append(" limit ").append(offset).append(",").append(pageable.getRows());
        return sqlBuffer.toString();
    }

    public String getPageSqlId() {
        return this.pageSqlId;
    }

    public String getDialect() {
        return this.dialect;
    }

    public void setPageSqlId(String pageSqlId) {
        this.pageSqlId = pageSqlId;
    }

    public void setDialect(String dialect) {
        this.dialect = dialect;
    }

    private void statementHandlerExecutor(Invocation invocation) throws Throwable {
        Matcher matcher;
        RoutingStatementHandler handler = (RoutingStatementHandler)invocation.getTarget();
        Field delegateField = ReflectionUtils.findField(handler.getClass(), (String)"delegate");
        delegateField.setAccessible(true);
        StatementHandler statementHandler = (StatementHandler)ReflectionUtils.getField((Field)delegateField, (Object)handler);
        Field mappedField = ReflectionUtils.findField(statementHandler.getClass(), (String)"mappedStatement");
        mappedField.setAccessible(true);
        MappedStatement mappedStatement = (MappedStatement)ReflectionUtils.getField((Field)mappedField, (Object)statementHandler);
        String queryId = mappedStatement.getId();
        Pattern pattern = Pattern.compile(this.pageSqlId);
        if (StringUtils.isNotBlank((String)queryId) && (matcher = pattern.matcher(queryId)).find()) {
            BoundSql boundSql = statementHandler.getBoundSql();
            Field sqlField = ReflectionUtils.findField(boundSql.getClass(), (String)"sql");
            sqlField.setAccessible(true);
            Object parameterObj = boundSql.getParameterObject();
            Page page = null;
            Pageable pageable = null;
            if (parameterObj instanceof Page) {
                page = (Page)parameterObj;
            } else if (parameterObj instanceof Map) {
                for (Map.Entry e : ((Map)parameterObj).entrySet()) {
                    if (!(e.getValue() instanceof Page)) continue;
                    page = (Page)e.getValue();
                    break;
                }
            }
            if (page != null) {
                pageable = page.getPageable();
                Connection connection = (Connection)invocation.getArgs()[0];
                String sql = boundSql.getSql();
                this.setTotalRecord(page, mappedStatement, connection);
                String pageSql = this.getPageSql(pageable, sql);
                ReflectionUtils.setField((Field)sqlField, (Object)boundSql, (Object)pageSql);
            }
        }
    }
}

