/*
 * Decompiled with CFR 0.152.
 */
package com.biz.cascore.pagination;

import com.biz.cascore.pagination.CommonSearch;
import com.biz.cascore.pagination.CommonSort;
import com.biz.cascore.pagination.Pageable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Page<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty
    private List<T> rows = new ArrayList<T>();
    @JsonProperty
    private long total = 0L;
    @JsonIgnore
    private Pageable pageable = new Pageable();
    @JsonIgnore
    private Map<String, Object> queryCondition = new HashMap<String, Object>();
    @JsonIgnore
    private CommonSearch searchCondition;
    @JsonIgnore
    private CommonSort sortCondition;

    public Page() {
    }

    public Page(Pageable pageable) {
        this.pageable = pageable;
    }

    public Page(List<T> rows, Pageable pageable) {
        this.rows = rows;
        this.pageable = pageable;
    }

    public Page(List<T> rows, long total, Pageable pageable) {
        this.rows = rows;
        this.total = total;
        this.pageable = pageable;
    }

    public List<T> getRows() {
        return this.rows;
    }

    public long getTotal() {
        return this.total;
    }

    public void setRows(List<T> rows) {
        this.rows = rows;
    }

    public void setTotal(long total) {
        this.total = total;
    }

    public Pageable getPageable() {
        return this.pageable;
    }

    public void setPageable(Pageable pageable) {
        this.pageable = pageable;
    }

    public Map<String, Object> getQueryCondition() {
        if (this.getPageable() != null && !this.getPageable().getQueryCondition().isEmpty()) {
            this.queryCondition = this.getPageable().getQueryCondition();
        }
        return this.queryCondition;
    }

    public CommonSearch getSearchCondition() {
        if (this.getPageable() != null && this.getPageable().getSearchCondition() != null) {
            CommonSearch commonSearch;
            this.searchCondition = commonSearch = this.getPageable().getSearchCondition();
        }
        return this.searchCondition;
    }

    public CommonSort getSortCondition() {
        if (this.getPageable() != null && this.getPageable().getSortCondition() != null) {
            CommonSort commonSort;
            this.sortCondition = commonSort = this.getPageable().getSortCondition();
        }
        return this.sortCondition;
    }
}

