/*
 * Decompiled with CFR 0.152.
 */
package com.biz.cascore.shiro;

import com.biz.cascore.api.service.AuthenticationApiService;
import com.biz.cascore.utils.WebApplicationContextUtils;
import com.biz.cascore.vo.PermissionContextVo;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.cas.CasRealm;
import org.apache.shiro.subject.PrincipalCollection;

public class AuthenticationRealmCenter
extends CasRealm {
    @Resource(name="authenticationApiServiceImpl")
    private AuthenticationApiService authenticationApiService;

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        SimpleAuthorizationInfo sai = (SimpleAuthorizationInfo)super.doGetAuthorizationInfo(principals);
        Integer adminId = null;
        if (!principals.isEmpty()) {
            for (Object principal : principals.asList()) {
                if (!(principal instanceof Map)) continue;
                adminId = Integer.valueOf((String)((Map)principal).get("id"));
                break;
            }
        }
        String appName = WebApplicationContextUtils.getInstance().getCurrentAppName();
        if (adminId != null) {
            if (StringUtils.equals((String)appName, (String)"main")) {
                appName = null;
            }
            PermissionContextVo permissionContext = this.authenticationApiService.getPermissions(adminId, appName);
            sai.addStringPermissions(permissionContext.getPermissions());
            sai.addRoles(permissionContext.getRoles());
        }
        return sai;
    }

    public void onLogout(PrincipalCollection principals) {
        super.onLogout(principals);
    }

    protected void clearCache(PrincipalCollection principals) {
        System.out.println("AuthenticationRealmCenter.clearCache()");
        super.clearCache(principals);
    }

    protected void clearCachedAuthenticationInfo(PrincipalCollection principals) {
        System.out.println("AuthenticationRealmCenter.clearCachedAuthenticationInfo()");
        super.clearCachedAuthenticationInfo(principals);
    }

    protected void clearCachedAuthorizationInfo(PrincipalCollection principals) {
        System.out.println("AuthenticationRealmCenter.clearCachedAuthorizationInfo()");
        super.clearCachedAuthorizationInfo(principals);
    }
}

