/*
 * Decompiled with CFR 0.152.
 */
package com.biz.cascore.utils;

import com.biz.cascore.pagination.CommonSearch;
import com.biz.cascore.pagination.CommonSort;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;

public class AdminLTEParseUtils {
    public static CommonSort getSortByRequest(HttpServletRequest request, Map<String, String> definedColumnMap) {
        Integer columnIndex = Integer.parseInt(request.getParameter("order[0][column]"));
        String columnName = request.getParameter("columns[" + columnIndex + "][data]");
        String sort = request.getParameter("order[0][dir]");
        String sortName = columnName;
        if (definedColumnMap != null && !definedColumnMap.isEmpty() && StringUtils.isBlank((String)(sortName = definedColumnMap.get(columnName)))) {
            sortName = columnName;
        }
        return new CommonSort(sortName, sort);
    }

    public static CommonSearch getSearchByRequest(HttpServletRequest request) {
        String searchVal = request.getParameter("search[value]");
        searchVal = StringUtils.trim((String)searchVal);
        searchVal = AdminLTEParseUtils.toChinese(searchVal);
        Boolean regex = BooleanUtils.toBoolean((String)request.getParameter("search[regex]"));
        return new CommonSearch(searchVal, regex);
    }

    private static boolean isChinese(char c) {
        Character.UnicodeBlock ub = Character.UnicodeBlock.of(c);
        return ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A || ub == Character.UnicodeBlock.GENERAL_PUNCTUATION || ub == Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION || ub == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS;
    }

    private static boolean isMessyCode(String strName) {
        Pattern p = Pattern.compile("\\s*|\t*|\r*|\n*");
        Matcher m = p.matcher(strName);
        String after = m.replaceAll("");
        String temp = after.replaceAll("\\p{P}", "");
        char[] ch = temp.trim().toCharArray();
        float chLength = 0.0f;
        float count = 0.0f;
        int i = 0;
        while (i < ch.length) {
            char c = ch[i];
            if (!Character.isLetterOrDigit(c)) {
                if (!AdminLTEParseUtils.isChinese(c)) {
                    count += 1.0f;
                }
                chLength += 1.0f;
            }
            ++i;
        }
        float result = count / chLength;
        return (double)result > 0.4;
    }

    private static String toChinese(String msg) {
        if (AdminLTEParseUtils.isMessyCode(msg)) {
            try {
                return new String(msg.getBytes("ISO8859-1"), "UTF-8");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return msg;
    }

    public static String parseToUTF8(String toParseStr) {
        if (StringUtils.isNotBlank((String)toParseStr)) {
            return AdminLTEParseUtils.toChinese(toParseStr);
        }
        return toParseStr;
    }
}

