/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.generator.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.generator.mapper.SysGeneratorMapper;
import com.biz.crm.generator.model.PageResult;
import com.biz.crm.generator.model.TableEntity;
import com.biz.crm.generator.service.SysGeneratorService;
import com.biz.crm.generator.utils.GenUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipOutputStream;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysGeneratorServiceImpl
extends ServiceImpl<SysGeneratorMapper, TableEntity>
implements SysGeneratorService {
    private static final Logger log = LoggerFactory.getLogger(SysGeneratorServiceImpl.class);
    @Autowired(required=true)
    private SysGeneratorMapper sysGeneratorMapper;
    @Autowired
    private BaseMapper baseMapper;

    public PageResult<Map<String, Object>> queryList(Map<String, Object> map) {
        Page page = new Page((long)MapUtils.getInteger(map, (Object)"page").intValue(), (long)MapUtils.getInteger(map, (Object)"limit").intValue());
        List list = this.sysGeneratorMapper.queryList(page, map);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    public Map<String, String> queryTable(String tableName) {
        return this.sysGeneratorMapper.queryTable(tableName);
    }

    public List<Map<String, Object>> queryColumns(String tableName) {
        return this.sysGeneratorMapper.queryColumns(tableName);
    }

    public byte[] generatorCode(String[] tableNames, String functionPackageName, String applicationName) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try (ZipOutputStream zip = new ZipOutputStream(outputStream);){
            for (String tableName : tableNames) {
                Map table = this.queryTable(tableName);
                List columns = this.queryColumns(tableName);
                GenUtils.generatorCode((Map)table, (List)columns, (ZipOutputStream)zip, (String)functionPackageName, (String)applicationName);
            }
        }
        catch (IOException e) {
            log.error("generatorCode-error: ", (Throwable)e);
        }
        return outputStream.toByteArray();
    }
}

