package com.biz.crm.activiti.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.BaseIdEntity;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.persistence.Column;
import javax.persistence.Id;
import java.sql.Timestamp;

/**
 * @author weston
 * @date 2020-12-13
 */
@Data
@Builder
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("act_hi_taskinst")
public class ActHiTaskinstEntity extends BaseIdEntity {
    @Id
    @Column(name = "id_")
    private String id;

    // 流程定义ID
    @Column(name = "proc_def_id_", length = 64)
    private String procDefId;

    // 任务ID
    @Column(name = "task_def_key_")
    private String taskDefKey;

    // 流程实例ID
    @Column(name = "proc_inst_id_", length = 64)
    private String procInstId;

    // 流程运行表活动实例ID
    @Column(name = "execution_id_", length = 64)
    private String executionId;

    // 任务定义名称
    @Column(name = "name_")
    private String name;

    // 父任务ID
    @Column(name = "parent_task_id_", length = 64)
    private String parentTaskId;

    // 任务描述，在流程文件中配置
    @Column(name = "description_")
    private String description;

    // 任务拥有人，没有做外键关联
    @Column(name = "owner_")
    private String owner;

    // 被指派执行该任务的人，没有做外键关联
    @Column(name = "assignee_")
    private String assignee;

    // 开始时间
    @Column(name = "start_time_", nullable = false, length = 29)
    private Timestamp startTime;

    // 结束时间
    @Column(name = "end_time_", length = 29)
    private Timestamp endTime;

    // 持续时间
    @Column(name = "duration_")
    private Long duration;

    // 任务委托状态，有等候中和已解决两种状态
    @Column(name = "delete_reason_")
    private String deleteReason;

    // 任务优先级，默认为50
    @Column(name = "priority_")
    private Integer priority;

    // 任务预定日期
    @Column(name = "due_date_", length = 29)
    private Timestamp dueDate;
}
