package com.biz.crm.activiti.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.BaseIdEntity;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.persistence.Column;
import javax.persistence.Id;
import java.sql.Timestamp;

/**
 * @author weston
 * @date 2020-12-13
 */
@Data
@Builder
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("act_hi_actinst")
public class ActHiActinstEntity extends BaseIdEntity {
    @Id
    @Column(name = "id_", unique = true, nullable = false, length = 64)
    private String id;// 主键ID

    @Column(name = "proc_def_id_", nullable = false, length = 64)
    private String procDefId;// 流程定义ID(流程名：版本号：自增ID)

    @Column(name = "proc_inst_id_", nullable = false, length = 64)
    private String procInstId; // 流程实例ID

    @Column(name = "execution_id_", nullable = false, length = 64)
    private String executionId;// 流程运行时ID

    @Column(name = "act_id_", nullable = false)
    private String actId;// 节点编码

    @Column(name = "task_id_", length = 64)
    private String taskId;// 任务表ID

    @Column(name = "call_proc_inst_id_", length = 64)
    private String callProcInstId;// 调用流程实例ID

    @Column(name = "act_name_")
    private String actName;// 节点名称

    @Column(name = "act_type_", nullable = false)
    private String actType;// 节点类型

    @Column(name = "assignee_", length = 64)
    private String assignee;// 执行人

    @Column(name = "start_time_", nullable = false, length = 29)
    private Timestamp startTime;// 节点开始时间

    @Column(name = "end_time_", length = 29)
    private Timestamp endTime;// 节点结束时间

    @Column(name = "duration_")
    private Long duration;// 持续时间

}
