package com.biz.crm.activiti.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.BaseIdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.sql.Timestamp;

/**
 * @author weston
 * @date 2021-01-04
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("act_ru_task")
public class ActRuTaskEntity extends BaseIdEntity {

    private String id;
    // 流程定义ID
    private String procDefId;
    // 任务ID
    private String taskDefKey;
    // 流程实例ID
    private String procInstId;
    // 流程运行表活动实例ID
    private String executionId;
    // 数据版本号
    private Integer rev;
    // 任务名称，在流程文件中定义
    private String name;
    // 父任务id，子任务才会设置该字段的值
    private String parentTaskId;
    // 任务描述，在流程文件中配置
    private String description;
    // 任务拥有人，没有做外键关联
    private String owner;
    // 被指派执行该任务的人，没有做外键关联
    private String assignee;
    // 任务委托状态，有等候中和已解决两种状态
    private String delegation;
    // 任务优先级，默认为50
    private Integer priority;
    // 任务创建时间
    private Timestamp createTime;
    // 任务预定日期
    private Timestamp dueDate;
    // 挂起激活状态
    private Integer suspensionState;

    private String category;

    private String tenantId;

    private String formKey;
}
