package com.biz.crm.activiti.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Index;
import java.util.Date;

/**
 * @author jianglong
 * @version V1.0
 * @Package com.biz.crm.activiti.entity
 * @Description: TODO
 * @date 2021/4/22 下午3:46
 */
@Data
@EqualsAndHashCode(callSuper = false)
@TableName(value = "ACT_RE_MODEL",autoResultMap = true)
@CrmTable(name = "ACT_RE_MODEL", tableNote = "act-流程设计模型", indexes = {
        @Index(name = "act_re_model_index1",  columnList = "KEY_",unique = true)
})
public class ActReModelEntity {

    /**
     *主键id
     */
    @TableId(type = IdType.ASSIGN_UUID,value = "ID_")
    private  String id;
    /**
     * 乐观锁版本号,每次修改会自增1
     */
    @TableField(value = "REV_")
    private String rev;
    /**
     * 模型的名称
     */
    @TableField(value = "NAME_")
    private String name;
    /**
     * 流程key
     */
    @TableField(value = "KEY_")
    private String key;
    /**
     * 分类
     */
    @TableField(value = "CATEGORY_")
    private String category;

    @TableField(value = "CREATE_TIME_")
    private Date createTime;
    /**
     * 更新时间
     */
    @TableField(value = "LAST_UPDATE_TIME_")
    private Date lastUpdateTime;
    /**
     * 版本(目前默认是1,不做修改)
     */
    @TableField(value = "VERSION_")
    private Integer version;
    /**
     * 数据源信息
     */
    @TableField(value = "META_INFO_")
    private String metaInfo;
    /**
     * 部署id
     */
    @TableField(value = "DEPLOYMENT_ID_")
    private String deploymentId;
    /**
     * 编辑源值id
     */
    @TableField(value = "EDITOR_SOURCE_VALUE_ID_")
    private String editOrSourceValueId;
    /**
     * 编辑源额外值id
     */
    @TableField(value = "EDITOR_SOURCE_EXTRA_VALUE_ID_")
    private String editOrSourceExtraValueId;
    /**
     * 组织
     */
    @TableField(value = "TENANT_ID_")
    private String tenantId;

    /**
     * 新加的字段,为了记录流程的状态
     */
    @CrmColumn(name = "PROCESS_STATUS",  mysqlType = "int(2)" ,oracleType = "NUMBER(2,0)",note = "流程状态 1-未发布 ，2-已发布")
    @TableField(value = "PROCESS_STATUS")
    private Integer processStatus;
}
