package com.biz.crm.activiti.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.base.CrmExtEntity;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Index;

/**
 * @author jianglong
 * @version V1.0
 * @Package com.biz.crm.activiti.entity
 * @Description: TODO
 * @date 2021/4/22 下午3:00
 */
@Data
@EqualsAndHashCode(callSuper = false)
@TableName("activiti_business_no")
@CrmTable(name = "activiti_business_no", tableNote = "工作流编号与业务编号对应", indexes = {
        @Index(name = "activiti_business_index1",  columnList = "crm_process_instance_id",unique = true),
        @Index(name = "activiti_business_index2",  columnList = "process_instance_id",unique = true)
})
public class ActivitiBusinessEntity extends CrmExtTenEntity<ActivitiBusinessEntity> {
    //业务流程编号
    @CrmColumn(name = "crm_process_instance_id", length = 60,note = "业务流程编号",nullable = true)
    private String crmProcessInstanceId;
    //工作流编号
    @CrmColumn(name = "process_instance_id", length = 60 ,note = "工作流编号",nullable = true)
    private String processInstanceId;
    //枚举 ActivitiOperateTypeEnum
    @CrmColumn(name = "bpm_status", length = 20 ,note = "流程状态",nullable = true)
    private String bpmStatus;

    //枚举 ProcessInstanceStatusEnum
    @CrmColumn(name = "process_instance_status", length = 20 ,note = "流程实例状态(启用,禁用,暂停,结束)")
    private String processInstanceStatus;

    @CrmColumn(name = "business_id", length = 200 ,note = "表单id主键",nullable = true)
    private String businessId;

    @CrmColumn(name = "business_no", length = 64 ,note = "表单编码")
    private String businessNo;

    @CrmColumn(name = "process_key", length = 100 ,note = "流程key")
    private String processKey;

    @CrmColumn(name = "process_name", length = 200 ,note = "流程名称")
    private String processName;

    @CrmColumn(name = "process_title", length = 300 ,note = "标题")
    private String processTitle;

    @CrmColumn(name = "commit_pos", length = 60 ,note = "发起人职位编码")
    private String commitPos;

    @CrmColumn(name = "commit_pos_name", length = 60 ,note = "发起人职位名称")
    private String commitPosName;

    @CrmColumn(name = "commit_code", length = 60 ,note = "发起人编码")
    private String commitCode;

    @CrmColumn(name = "commit_name", length = 60 ,note = "发起人名称")
    private String commitName;

    @CrmColumn(name = "commit_by_org", length = 60 ,note = "发起人组织编码")
    private String commitByOrg;

    @CrmColumn(name = "commit_by_org_name", length = 60 ,note = "发起人组织名称")
    private String commitByOrgName;

    @CrmColumn(name = "commit_date", length = 40 ,note = "流程发起时间")
    private String commitDate;

    @CrmColumn(name = "befor_pass_date", length = 40 ,note = "上一节点时间")
    private String beforPassDate;

    @CrmColumn(name = "commit_elapsed_time", length = 40 ,note = "总耗时")
    private String commitElapsedTime;

    @CrmColumn(name = "key_target_list_json", mysqlType = "text",oracleType = "clob" ,note = "关键指标集合的json字符串")
    private String keyTargetListJson;

    @CrmColumn(name = "menu_code", length = 32 ,note = "菜单编码")
    private String menuCode;

    /**
     * 回调feign
     */
    @CrmColumn(name = "call_back_feign", length = 100 ,note = "回调feign")
    private String callBackFeign;

    @CrmColumn(name = "process_version_key", length = 100 ,note = "流程版本KEY(取自ACT_RE_PROCDEF表的id)")
    private String processVersionKey;

    @ApiModelProperty(value = "业务流程类型")
    @CrmColumn(name = "cost_type", length = 64 ,note = "业务流程类型")
    private String costType;

    @CrmColumn(name = "form_type", length = 64 ,note = "业务来源系统")
    @ApiModelProperty(value = "业务来源系统")
    private String formType;

}
