package com.biz.crm.activiti.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.persistence.Index;

/**
 * @author jianglong
 * @version V1.0
 * @Package com.biz.crm.activiti.entity
 * @Description: TODO
 * @date 2021/4/22 下午6:48
 */
@Data
@EqualsAndHashCode(callSuper = false)
@TableName("activiti_current_task")
@CrmTable(name = "activiti_current_task", tableNote = "当前任务流程", indexes = {
        @Index(name = "activiti_current_task_index1",  columnList = "crm_process_instance_id"),
        @Index(name = "activiti_current_task_index2",  columnList = "process_instance_id"),
        @Index(name = "activiti_current_task_index3",  columnList = "date_type"),
})
public class ActivitiCurrentTaskEntity extends CrmBaseEntity<ActivitiCurrentTaskEntity> {
    //业务流程编号
    @CrmColumn(name = "crm_process_instance_id", length = 60,note = "业务流程编号",nullable = true)
    private String crmProcessInstanceId;
    //工作流编号
    @CrmColumn(name = "process_instance_id", length = 60 ,note = "工作流编号",nullable = true)
    private String processInstanceId;
    @CrmColumn(name = "date_type", length = 8 ,note = "任务类型 1：待办流程，2：沟通，3：传阅，4：抄送，5：我的申请",nullable = true)
    private String dateType;
    @CrmColumn(name = "process_title", length = 200 ,note = "流程主题",nullable = true)
    private String processTitle;
    @CrmColumn(name = "submit_by", length = 60 ,note = "流程提交人")
    private String submitBy;
    @CrmColumn(name = "task_no", length = 100 ,note = "任务编号",nullable = true)
    private String taskNo;
    @CrmColumn(name = "position_code", length = 60 ,note = "任务处理人",nullable = true)
    private String positionCode;
    @CrmColumn(name = "bpm_roe_code", length = 60 ,note = "任务处理人角色",nullable = true)
    private String bpmRoeCode;
//    @CrmColumn(name = "task_id", length = 60 ,note = "任务id(工作流的taskId)",nullable = true)
//    private String taskId;
}
