package com.biz.crm.activiti.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import javax.persistence.Index;

/**
 * 实体类
 *
 * @author jerry7
 * @date 2021-01-14 18:17:13
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("ta_act_file")
@CrmTable(name = "ta_act_file",tableNote = "工作流-文件表", indexes = {
        @Index(name = "ta_act_file_index1",  columnList = "process_inst_id"),
        @Index(name = "ta_act_file_index2",  columnList = "task_id")
})
public class TaActFileEntity extends CrmBaseEntity<TaActFileEntity> {


    @CrmColumn(name = "process_inst_id", length = 60,note = "流程实例ID")
    private String processInstId;

    @CrmColumn(name = "task_id", length = 60,note = "任务ID（审批时才会有这个值）")
    private String taskId;

    @CrmColumn(name = "node_id", length = 60,note = "节点id（审批时才会有这个值）")
    private String nodeId;

    @CrmColumn(name = "node_code", length = 60,note = "节点编码（审批时才会有这个值）")
    private String nodeCode;

    @CrmColumn(name = "node_name", length = 60,note = "节点名称（审批时才会有这个值）")
    private String nodeName;

    @CrmColumn(name = "object_name", length = 60,note = "文件名称")
    private String objectName;

    @CrmColumn(name = "file_address", length = 200,note = "文件地址")
    private String fileAddress;


    /**
     * 枚举Indicator.ACTIVITI_FILE_START
     */
    @CrmColumn(name = "file_type",  mysqlType = "int(2)" ,oracleType = "NUMBER(2,0)",note = "文件类型（1-流程提交文件，2-审批提交文件）")
    private Integer fileType;

}
