package com.biz.crm.activiti.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExt20Entity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Index;

/**
 * 流程指标实体类
 *
 * @author jerry7
 * @date 2021-04-08 18:17:13
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@TableName("ta_act_target")
@CrmTable(name = "ta_act_target",tableNote = "工作流-指标字段表", indexes = {
        @Index(name = "ta_act_target_index1",  columnList = "process_key")
})
public class TaActTargetEntity extends CrmExt20Entity<TaActTargetEntity> {

    @CrmColumn(name = "field", length = 60,note = "属性")
    private String field;

    @CrmColumn(name = "process_key", length = 60,note = "流程key")
    private String processKey;

    @CrmColumn(name = "title", length = 60,note = "标题")
    private String title;

    @CrmColumn(name = "width", length = 60,note = "宽度")
    private String width;

    @CrmColumn(name = "visible", length = 60,note = "是否展示")
    private String visible;

    @CrmColumn(name = "formorder", length = 60,note = "展示顺序")
    private String formorder;

    @CrmColumn(name = "default_value",length = 60,note = "默认值")
    private String defaultValue;
}
