package com.biz.crm.activiti.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * 实体类
 *
 * @author jerry7
 * @date 2021-01-11 16:39:03
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@TableName("ta_agency_approval")
@CrmTable(name = "ta_agency_approval",tableNote = "流程-代理审批")
public class TaAgencyApprovalEntity extends CrmBaseEntity<TaAgencyApprovalEntity> {

    @CrmColumn(name = "from_pos_code", length = 60,note = "被代理人的岗位编码")
    private String fromPosCode;

    @CrmColumn(name = "from_pos_name", length = 60,note = "被代理人的岗位名称")
    private String fromPosName;

    @CrmColumn(name = "from_user_code", length = 60,note = "被代理人的用户编码")
    private String fromUserCode;

    @CrmColumn(name = "from_user_name", length = 60,note = "被代理人的用户名称")
    private String fromUserName;

    @CrmColumn(name = "proxy_pos_code", length = 60,note = "代理人的岗位编码")
    private String proxyPosCode;

    @CrmColumn(name = "proxy_pos_name", length = 60,note = "代理人的岗位名称")
    private String proxyPosName;

    @CrmColumn(name = "proxy_user_code", length = 60,note = "代理人的用户编码")
    private String proxyUserCode;

    @CrmColumn(name = "proxy_user_name", length = 60,note = "代理人的用户名称")
    private String proxyUserName;

    @CrmColumn(name = "proxy_begin_date", length = 60,note = "代理开始时间")
    private String proxyBeginDate;

    @CrmColumn(name = "proxy_end_date", length = 60,note = "代理结束时间")
    private String proxyEndDate;

    @CrmColumn(name = "is_all_proxy", length = 10,note = "是否全部代理(Y/N)")
    private String isAllProxy;

    @CrmColumn(name = "process_key", length = 100,note = "代理流程key")
    private String processKey;

}
