package com.biz.crm.activiti.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 按钮权限配置
 * @author weston
 * @date 2020-12-10
 */
@Data
@EqualsAndHashCode(callSuper = false)
@TableName("ta_func_role")
@CrmTable(name = "ta_func_role",tableNote = "流程-功能角色")
public class TaFuncRoleEntity extends CrmBaseEntity<TaFuncRoleEntity> {

    @CrmColumn(name = "role_code", length = 60,note = "功能角色编码")
    private String roleCode;

    @CrmColumn(name = "role_name", length = 60,note = "功能角色名称")
    private String roleName;

    @CrmColumn(name = "role_auths", mysqlType = "text", oracleType = "CLOB", note = "功能角色按钮组合")
    private String roleAuths;

}
