package com.biz.crm.activiti.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * 实体类
 *
 * @author jerry7
 * @date 2020-12-04 10:33:17
 */
@Data
@EqualsAndHashCode(callSuper = false)
@TableName("ta_node_config")
@CrmTable(name = "ta_node_config",tableNote = "流程-流程节点")
public class TaNodeConfigEntity extends CrmBaseEntity<TaNodeConfigEntity> {


    /**
     * 流程节点id
     */
    @CrmColumn(name = "process_node_id", length = 100,note = "流程节点id")
    private String processNodeId;


    @CrmColumn(name = "node_index",  mysqlType = "int(4)" ,oracleType = "NUMBER(4,0)",note = "节点顺序")
    private Integer nodeIndex;

    /**
     * 流程节点编码
     */
    @CrmColumn(name = "process_node_code", length = 100,note = "流程节点编码")
    private String processNodeCode;

    /**
     * 流程节点名称
     */
    @CrmColumn(name = "process_node_name", length = 100,note = "流程节点名称")
    private String processNodeName;

    /**
     *  角色编码
     */
    @CrmColumn(name = "role_code", length = 32,note = "角色编码")
    private String roleCode;

    /**
     * 带版本的流程定义KEY(processInstance.getProcessDefinitionId())
     */
    @CrmColumn(name = "process_version_key", length = 200,note = "带版本的流程定义KEY")
    private String processVersionKey;

    /**
     * 按钮权限角色ID
     */
    @CrmColumn(name = "btn_auth_role_id", length = 64,note = "按钮权限角色ID")
    private String btnAuthRoleId;

    /**
     * 审批重复跳过 1-true  0-false
     */
    @CrmColumn(name = "audit_repeat_skip",  mysqlType = "int(2)" ,oracleType = "NUMBER(2,0)",note = "审批重复跳过 1-true  0-false")
    private Integer auditRepeatSkip;

    /**
     * 审批时 人员为空跳过   1-true  0-false
     */
    @CrmColumn(name = "audit_null_skip",  mysqlType = "int(2)" ,oracleType = "NUMBER(2,0)",note = "审批时 人员为空跳过   1-true  0-false")
    private Integer auditNullSkip;

    /**
     * 节点期限 0-表示无期限限制
     */
    @CrmColumn(name = "node_timeout",  mysqlType = "int(2)" ,oracleType = "NUMBER(2,0)",note = "节点期限 0-表示无期限限制")
    private Integer nodeTimeout;

    /**
     * 是否允许退回
     */
    @CrmColumn(name = "can_back",  mysqlType = "int(2)" ,oracleType = "NUMBER(2,0)",note = "是否允许退回")
    private Integer canBack;

    /**
     * 是否默认分配节点
     */
    @CrmColumn(name = "is_default_choose",  mysqlType = "int(2)" ,oracleType = "NUMBER(2,0)",note = "是否默认分配节点")
    private Integer isDefaultChoose;

    /**
     * 是否可以手动选择下一个节点(0=不能1=能)
     */
    @CrmColumn(name = "manual_next",  mysqlType = "int(2)" ,oracleType = "NUMBER(2,0)",note = "是否可以手动选择下一个节点(0=不能1=能)")
    private Integer manualNext;

    /**
     * 是否允许被分配
     */
    @CrmColumn(name = "can_distribution",  mysqlType = "int(2)" ,oracleType = "NUMBER(2,0)",note = "是否允许被分配")
    private Integer canDistribution;

    /**
     * 允许被指向
     */
    @CrmColumn(name = "can_point",  mysqlType = "int(2)" ,oracleType = "NUMBER(2,0)",note = "允许被指向")
    private Integer canPoint;

    /**
     * 是否是内部审批(0=否1=是)
     */
    @CrmColumn(name = "config_inside",  mysqlType = "int(2)" ,oracleType = "NUMBER(2,0)",note = "是否是内部审批(0=否1=是)")
    private Integer configInside;

    /**
     * 指派参数
     */
    @CrmColumn(name = "node_params", length = 64,note = "指派参数")
    private String nodeParams;

    /**
     * 是否使用
     */
    @CrmColumn(name = "state", length = 10,note = "是否使用")
    private String state;

    /**
     * 撤销标识(0=否1=是),此节点标识为1，则流程之后的节点都不能撤销了
     */
    @CrmColumn(name = "cancel_flag",  mysqlType = "int(2)" ,oracleType = "NUMBER(2,0)",note = "撤销标识(0=否1=是),此节点标识为1，则流程之后的节点都不能撤销了")
    private Integer cancelFlag;

    /**
     * 配置审批类型
     */
    @CrmColumn(name = "candidate_type", length = 64,note = "配置审批类型")
    private String candidateType;

    /**
     * 配置审批值
     */
    @CrmColumn(name = "candidate_value", length = 64,note = "配置审批值")
    private String candidateValue;

    /**
     * 审批人可见
     */
    @CrmColumn(name = "user_is_view",  mysqlType = "int(2)" ,oracleType = "NUMBER(2,0)",note = "审批人可见")
    private Integer userIsView;

    /**
     * 审批通过类型(0=普通1=最终审批2=审核3=复核4=财务审批)
     */
    @CrmColumn(name = "approve_type",  mysqlType = "int(2)" ,oracleType = "NUMBER(2,0)",note = "审批通过类型(0=普通1=最终审批2=审核3=复核4=财务审批)")
    private Integer approveType;

    /**
     * 
     */
    @CrmColumn(name = "org_hierarchy", length = 64,note = "")
    private String orgHierarchy;

    /**
     * 是否查看关联附件1是0否默认为1
     */
    @CrmColumn(name = "view_relation",  mysqlType = "int(2)" ,oracleType = "NUMBER(2,0)",note = "是否查看关联附件1是0否默认为1")
    private Integer viewRelation;

    /**
     * 是否开启动态节点1是0否
     */
    @CrmColumn(name = "is_add_flow",  mysqlType = "int(2)" ,oracleType = "NUMBER(2,0)",note = "是否开启动态节点1是0否")
    private Integer isAddFlow;

    /**
     * 是否允许移动审批（默认1-允许移动审批）
     */
    @CrmColumn(name = "allow_mobile",  mysqlType = "int(2)" ,oracleType = "NUMBER(2,0)",note = "是否允许移动审批（默认1-允许移动审批）")
    private Integer allowMobile  = 1;


    @CrmColumn(name = "form_role", length = 64,note = "")
    private String formRole;
}
