package com.biz.crm.activiti.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.persistence.Index;

/**
 * 这是流程绘制-业务关系实体
 * @author YuanZiJian
 * @date 2020/12/15 16:46
 * @version: V1.0
 */

@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("ta_process_biz_relation")
@CrmTable(name = "ta_process_biz_relation",tableNote = "流程-业务关系表", indexes = {
        @Index(name = "ta_process_biz_relation_index1",  columnList = "process_key")})
public class TaProcessBizRelationEntity extends CrmBaseEntity {
    /**
     * 业务编码
     */
    @CrmColumn(name = "biz_code", length = 100 ,note = "业务编码",nullable = true)
    private String bizCode;
    /**
     * 业务名称
     */
    @CrmColumn(name = "biz_name", length = 100 ,note = "业务名称",nullable = true)
    private String bizName;
    /**
     * 流程key
     */
    @CrmColumn(name = "process_key", length = 100 ,note = "流程key",nullable = true)
    private String processKey;
    /**
     * 关系类型： menu 可选页面（菜单）， org 可选组织
     */
    @CrmColumn(name = "relation_type", length = 10 ,note = "关系类型： menu 可选页面（菜单）， org 可选组织",nullable = true)
    private String relationType;

    /**
     * 是否仅当前组织（Y-是，N-否）
     */
    @CrmColumn(name = "is_only_current_org", length = 2 ,note = "是否仅当前组织（Y-是，N-否）",nullable = true)
    private String isOnlyCurrentOrg;
}
