package com.biz.crm.activiti.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.sql.Timestamp;

/**
 * @author weston
 * @date 2020-12-23
 */
@Data
@EqualsAndHashCode(callSuper = false)
@TableName("ta_task_communicate")
@CrmTable(name = "ta_task_communicate",tableNote = "流程-沟通表")
public class TaTaskCommunicateEntity extends CrmBaseEntity<TaTaskCommunicateEntity> {


    @CrmColumn(name = "task_id", length = 60,note = "待办节点ID")
    private String taskId;

    @CrmColumn(name = "process_instance_id", length = 60,note = "流程实例ID")
    private String processInstanceId;

    @CrmColumn(name = "crm_process_instance_id", length = 60,note = "业务流程编号")
    private String crmProcessInstanceId;

    @CrmColumn(name = "task_def_key", length = 60,note = "沟通时节点定义KEY")
    private String taskDefKey;

    @CrmColumn(name = "task_name", length = 60,note = "沟通时的节点名称")
    private String taskName;

    @CrmColumn(name = "target_user_code", length = 60,note = "目标用户编码(userName)")
    private String targetUserCode;

    @CrmColumn(name = "target_user_name", length = 60,note = "目标用户名称(fullName)")
    private String targetUserName;

    @CrmColumn(name = "target_pos_code", length = 60,note = "指定沟通岗位编码")
    private String targetPosCode;

    @CrmColumn(name = "target_pos_name", length = 60,note = "指定沟通岗位名称")
    private String targetPosName;

    @CrmColumn(name = "target_org_code", length = 60,note = "指定沟通组织编码")
    private String targetOrgCode;

    @CrmColumn(name = "target_org_name", length = 60,note = "指定沟通组织名称")
    private String targetOrgName;


    @CrmColumn(name = "content", length = 200,note = "沟通内容")
    private String content;

    @CrmColumn(name = "status",  mysqlType = "int(2)" ,oracleType = "NUMBER(2,0)",note = "沟通任务状态(1=未处理=已确认)")
    private Integer status;

    @CrmColumn(name = "is_need_reply", length = 10,note = "是否需要回复才可以继续审批,Y:是,N否")
    private String isNeedReply;
}
