package com.biz.crm.bpmlog.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.persistence.Index;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 审批配置主表实体类
 *
 * @author Tao.Chen
 * @date 2021-03-01 17:50:29
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("activiti_bpmlog")
@CrmTable(name = "activiti_bpmlog", tableNote = "工作流日志", indexes = {
        @Index(name = "activiti_bpmlog_index1",  columnList = "crm_process_instance_id"),
        @Index(name = "activiti_bpmlog_index2",  columnList = "process_instance_id"),
        @Index(name = "activiti_bpmlog_index3",  columnList = "business_id")
})
public class ActivitiBpmlogEntity extends CrmBaseEntity<ActivitiBpmlogEntity> {

    @CrmColumn(name = "crm_process_instance_id", length = 60,note = "业务流程编号")
    private String crmProcessInstanceId;

    @CrmColumn(name = "process_instance_id", length = 60 ,note = "流程实例id")
    private String processInstanceId;

    @CrmColumn(name = "business_id", length = 64 ,note = "表单id主键")
    private String businessId;

    @CrmColumn(name = "business_no", length = 64 ,note = "表单编码")
    private String businessNo;

    @CrmColumn(name = "operate_type", length = 10 ,note = "操作类型")
    private String operateType;

    @CrmColumn(name = "log_code", length = 40 ,note = "流程日志编号")
    private String logCode;
    @CrmColumn(name = "node_name", length = 100,note = "操作节点")
    private String nodeName;
    @CrmColumn(name = "node_id", length = 100,note = "操作id")
    private String nodeId;

    @CrmColumn(name = "node_code", length = 100,note = "操作节点编码")
    private String nodeCode;

    @CrmColumn(name = "task_id", length = 60,note = "任务id")
    private String taskId;

    @CrmColumn(name = "is_auto_execute", length = 5,note = "是否系统自动执行(Y/N)")
    private String isAutoExecute;

    @CrmColumn(name = "content", length = 255,note = "确认沟通内容")
    private String content;

//    @CrmColumn(name = "create_time_stamp",mysqlType = "decimal(16,0)",oracleType = "NUMBER(16, 0)",note = "创建时间的时间戳")
//    private BigDecimal createTimeStamp;


}
