package com.biz.crm.copy.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Index;

/**
 * @author jianglong
 * @version V1.0
 * @Package com.biz.crm.activiti.entity
 * @Description: TODO
 * @date 2021/4/22 下午3:46
 */
@Data
@EqualsAndHashCode(callSuper = false)
@TableName("activiti_copy_config")
@CrmTable(name = "activiti_copy_config", tableNote = "抄送配置", indexes = {
        @Index(name = "activiti_copy_config_index1",  columnList = "process_key")
})
@ApiModel(value = "抄送配置实体", description = "抄送配置实体")
public class ActivitiCopyConfigEntity extends CrmBaseEntity<ActivitiCopyConfigEntity> {
    //流程key
    @ApiModelProperty("流程key")
    @CrmColumn(name = "process_key", length = 60,note = "流程key",nullable = true)
    private String processKey;
    @ApiModelProperty("抄送类型 0:职位，1角色")
    @CrmColumn(name = "data_type", length = 10,note = "抄送类型 0:职位，1角色",nullable = true)
    private String dataType;
    @ApiModelProperty("数据字典(filter_type)过滤类型")
    @CrmColumn(name = "filter_type", length = 10,note = "数据字典(filter_type)过滤类型 0：职位，1: 角色下所有组织，2：提交人组织及其上级所有组织，3：提交人当前组织",nullable = true)
    private String filterType;
    @ApiModelProperty("抄送扩展监听")
    @CrmColumn(name = "expand_lister", length = 100,note = "抄送扩展监听")
    private String expandLister;
    @ApiModelProperty("角色或者职位编码")
    @CrmColumn(name = "date_code", length = 100,note = "角色或者职位编码")
    private String dateCode;
    @ApiModelProperty("角色或者职位名称")
    @CrmColumn(name = "date_name", length = 100,note = "角色或者职位名称")
    private String dateName;
}
