package com.biz.crm.copy.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Index;

/**
 * @author jianglong
 * @version V1.0
 * @Package com.biz.crm.copy.entity
 * @Description: TODO
 * @date 2021/5/14 上午10:45
 */
@Data
@EqualsAndHashCode(callSuper = false)
@TableName("activiti_copy_task")
@CrmTable(name = "activiti_copy_task", tableNote = "抄送/传阅任务表", indexes = {
        @Index(name = "activiti_copy_task_index1",  columnList = "process_key")
})
@ApiModel(value = "抄送/传阅任务表", description = "抄送/传阅任务表")
public class ActivitiCopyTaskEntity extends CrmBaseEntity<ActivitiCopyTaskEntity> {
    @CrmColumn(name = "process_key", length = 100,note = "流程key",nullable = true)
    private String processKey;

    @CrmColumn(name = "position_code", length = 60,note = "职位编码",nullable = true)
    private String positionCode;

    @CrmColumn(name = "crm_process_instance_id", length = 60,note = "业务流程编号",nullable = true)
    private String crmProcessInstanceId;

    @CrmColumn(name = "process_instance_id", length = 60 ,note = "工作流编号",nullable = true)
    private String processInstanceId;

    @CrmColumn(name = "read_status", length =10 , note = "是否查阅 N 未查阅 Y 已查阅")
    private String readStatus;

    @CrmColumn(name = "task_type", length =10 , note = "0:抄送,1:传阅")
    private String taskType;
}
