/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.activiti.controller;

import com.biz.crm.activiti.service.IActivitiInstanceService;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.nebular.activiti.common.req.ActivitiCCCDataReqVo;
import com.biz.crm.nebular.activiti.common.req.ActivitiMyStartReqVo;
import com.biz.crm.nebular.activiti.common.resp.ActivitiCommonRespVo;
import com.biz.crm.nebular.activiti.start.req.ActivitiStartInfoReqVo;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Objects;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"activitiInstance"})
@Api(tags={"\u6d41\u7a0b\u5b9e\u4f8b"})
public class ActivitiInstanceController {
    @Resource
    private IActivitiInstanceService iActivitiInstanceService;

    @ApiOperation(value="\u67e5\u8be2\u6d41\u7a0b\u5b9e\u4f8b\u5217\u8868")
    @PostMapping(value={"/list"})
    @CrmDictMethod
    public Result<PageResult<ActivitiCommonRespVo>> list(@RequestBody ActivitiMyStartReqVo activitiMyStartReqVo) {
        PageResult<ActivitiCommonRespVo> result = this.iActivitiInstanceService.findList(activitiMyStartReqVo);
        result.getData().stream().forEach(e -> {
            if (Objects.nonNull(e.getEndTime()) && Objects.nonNull(e.getStartTime())) {
                e.setConsumingTime(DateUtil.calSpendTimes((String)DateUtil.datetimeFormat.format(e.getStartTime()), (String)DateUtil.datetimeFormat.format(e.getEndTime())));
            }
        });
        return Result.ok(result);
    }

    @ApiOperation(value="\u6d41\u7a0b\u6682\u505c")
    @PostMapping(value={"/suspend"})
    public Result suspend(@RequestBody ActivitiStartInfoReqVo activitiStartInfoReqVo) {
        this.iActivitiInstanceService.suspend(activitiStartInfoReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u6d41\u7a0b\u6fc0\u6d3b")
    @PostMapping(value={"/active"})
    public Result active(@RequestBody ActivitiStartInfoReqVo activitiStartInfoReqVo) {
        this.iActivitiInstanceService.active(activitiStartInfoReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u6d41\u7a0b\u5173\u95ed")
    @PostMapping(value={"/close"})
    public Result close(@RequestBody ActivitiStartInfoReqVo activitiStartInfoReqVo) {
        this.iActivitiInstanceService.close(activitiStartInfoReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u6d41\u7a0b\u59d4\u6d3e")
    @PostMapping(value={"/reassign"})
    public Result reassign(@RequestBody ActivitiCCCDataReqVo activitiCCCDataReqVo) {
        this.iActivitiInstanceService.reassign(activitiCCCDataReqVo);
        return Result.ok();
    }
}

