/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.listener.base;

import com.biz.crm.listener.base.FlowListenerFactory;
import com.biz.crm.listener.exception.ActivitiRuntimeException;
import com.biz.crm.listener.service.ITaListenerService;
import com.biz.crm.listener.vo.TaListenerQueryVO;
import com.biz.crm.util.ApplicationContextUtils;
import java.util.List;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.ExecutionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDefExecutionListener
implements ExecutionListener {
    private static final Logger log = LoggerFactory.getLogger(AbstractDefExecutionListener.class);
    private static final long serialVersionUID = -1572732785104423172L;
    private String nodeCode;
    private String eventCode;
    private ITaListenerService taListenerService = (ITaListenerService)ApplicationContextUtils.getContext().getBean("taListenerService");
    private FlowListenerFactory flowListenerFactory = (FlowListenerFactory)ApplicationContextUtils.getContext().getBean("flowListenerFactory");

    public void notify(DelegateExecution execution) throws Exception {
        TaListenerQueryVO query = this.getTaListenerQueryVO(execution);
        List<TaListenerQueryVO> list = this.taListenerService.findExtListenerList(query);
        for (TaListenerQueryVO listener : list) {
            String packageName = listener.getListenerValue();
            Object obj = this.flowListenerFactory.getListener(packageName);
            if (obj == null) continue;
            try {
                execution = this.flowListenerFactory.notifyExecution(obj, execution);
            }
            catch (Exception e) {
                e.printStackTrace();
                Throwable cause = e.getCause();
                if (cause == null) {
                    cause = e;
                }
                throw new ActivitiRuntimeException(e.getMessage(), cause);
            }
        }
    }

    private TaListenerQueryVO getTaListenerQueryVO(DelegateExecution execution) {
        String proDefId = execution.getProcessDefinitionId();
        String processKey = proDefId.substring(0, proDefId.indexOf(":"));
        TaListenerQueryVO query = new TaListenerQueryVO();
        query.setListenerEvent(this.eventCode);
        query.setNodeCode(this.nodeCode);
        query.setProcessKey(processKey);
        query.setListenerState(Integer.valueOf("1"));
        query.setProcessVersionKey(execution.getProcessDefinitionId());
        return query;
    }

    public String getNodeCode() {
        return this.nodeCode;
    }

    public void setNodeCode(String nodeCode) {
        this.nodeCode = nodeCode;
    }

    public String getEventCode() {
        return this.eventCode;
    }

    public void setEventCode(String eventCode) {
        this.eventCode = eventCode;
    }
}

