/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.listener.base;

import com.biz.crm.listener.base.FlowListenerFactory;
import com.biz.crm.listener.exception.ActivitiRuntimeException;
import com.biz.crm.listener.service.ITaListenerService;
import com.biz.crm.listener.vo.TaListenerQueryVO;
import com.biz.crm.util.ApplicationContextUtils;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.activiti.engine.delegate.DelegateTask;
import org.activiti.engine.delegate.TaskListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDefTaskListener
implements TaskListener {
    private static final Logger log = LoggerFactory.getLogger(AbstractDefTaskListener.class);
    private static final long serialVersionUID = 332954756707734456L;
    private String eventCode;
    private ITaListenerService taListenerService = (ITaListenerService)ApplicationContextUtils.getContext().getBean("taListenerService");
    private FlowListenerFactory flowListenerFactory = (FlowListenerFactory)ApplicationContextUtils.getContext().getBean("flowListenerFactory");

    public void notify(DelegateTask delegateTask) {
        TaListenerQueryVO query = this.getTaListenerQueryVO(delegateTask);
        List<TaListenerQueryVO> list = this.taListenerService.findExtListenerList(query);
        for (TaListenerQueryVO listener : list) {
            String packageName = listener.getListenerValue();
            Object obj = this.flowListenerFactory.getListener(packageName);
            if (obj == null) continue;
            try {
                delegateTask = this.flowListenerFactory.notifyTask(obj, delegateTask);
            }
            catch (Exception e) {
                e.printStackTrace();
                Throwable cause = e.getCause();
                String msg = e.getMessage();
                StringWriter sw = new StringWriter();
                e.printStackTrace(new PrintWriter(sw));
                if (cause == null) {
                    if (e instanceof InvocationTargetException) {
                        InvocationTargetException ex = (InvocationTargetException)e;
                        msg = ex.getTargetException().getMessage();
                    }
                    cause = e;
                } else if (cause instanceof ActivitiRuntimeException) {
                    if (msg == null || msg == "") {
                        msg = cause.getMessage();
                    }
                } else if (cause instanceof NullPointerException) {
                    if (msg == null || msg == "") {
                        msg = "java.lang.NullPointerException";
                    }
                } else if (cause instanceof RuntimeException && (msg == null || msg == "")) {
                    msg = cause.getMessage();
                }
                throw new ActivitiRuntimeException(msg, cause);
            }
        }
    }

    private TaListenerQueryVO getTaListenerQueryVO(DelegateTask delegateTask) {
        String proDefId = delegateTask.getProcessDefinitionId();
        String processKey = proDefId.substring(0, proDefId.indexOf(":"));
        TaListenerQueryVO query = new TaListenerQueryVO();
        query.setNodeCode(delegateTask.getTaskDefinitionKey());
        query.setListenerEvent(this.eventCode);
        query.setProcessKey(processKey);
        query.setListenerState(Integer.valueOf("1"));
        query.setProcessVersionKey(delegateTask.getProcessDefinitionId());
        return query;
    }

    public String getEventCode() {
        return this.eventCode;
    }

    public void setEventCode(String eventCode) {
        this.eventCode = eventCode;
    }
}

