/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.act.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.act.mapper.TaTaskCopyMapper;
import com.biz.crm.act.model.TaProcessOptRecordEntity;
import com.biz.crm.act.model.TaTaskCopyEntity;
import com.biz.crm.act.service.ITaProcessOptRecordService;
import com.biz.crm.act.service.ITaTaskCopyService;
import com.biz.crm.act.service.ITaTaskService;
import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.activiti.Column;
import com.biz.crm.eunm.activiti.Indicator;
import com.biz.crm.eunm.activiti.IndicatorStr;
import com.biz.crm.mdm.position.MdmPositionFeign;
import com.biz.crm.nebular.activiti.act.req.CopyToUserReqVO;
import com.biz.crm.nebular.activiti.act.req.TaskCopyReqVO;
import com.biz.crm.nebular.activiti.task.req.CopyTaskReqVO;
import com.biz.crm.nebular.activiti.task.resp.CopyTaskRspVO;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionDetailRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.Result;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.activiti.engine.task.TaskInfo;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="taTaskCopyService")
public class TaTaskCopyServiceImpl
extends ServiceImpl<TaTaskCopyMapper, TaTaskCopyEntity>
implements ITaTaskCopyService {
    private static final Logger log = LoggerFactory.getLogger(TaTaskCopyServiceImpl.class);
    @Autowired
    private ITaTaskService taTaskService;
    @Autowired
    private MdmPositionFeign mdmPositionFeign;
    @Resource
    private TaTaskCopyMapper taTaskCopyMapper;
    @Autowired
    private ITaProcessOptRecordService taProcessOptRecordService;

    @Override
    public String copyTaskToOne(TaskCopyReqVO reqVO) {
        TaskInfo taskInfo = this.taTaskService.getTaskInfoByTaskId(reqVO.getTaskId());
        AssertUtils.isNotNull((Object)taskInfo, (String)"\u672a\u627e\u5230\u5f85\u6284\u9001\u7684\u8282\u70b9");
        AssertUtils.isNotEmpty((Collection)reqVO.getUsers(), (String)"\u6284\u9001\u76ee\u6807\u4e0d\u80fd\u4e3a\u7a7a!");
        int total = reqVO.getUsers().size();
        int success = 0;
        List userList = reqVO.getUsers();
        for (CopyToUserReqVO user : userList) {
            try {
                Result resultTo = this.mdmPositionFeign.getPositionDetail(null, user.getPosCode());
                MdmPositionDetailRespVo positionUserTo = (MdmPositionDetailRespVo)ApiResultUtil.objResult((Result)resultTo, (boolean)Boolean.TRUE);
                AssertUtils.isTrue((boolean)user.getUserCode().equals(positionUserTo.getUser().getUserName()), (String)"\u6284\u9001\u5c97\u4f4d\u4e0b\u4eba\u5458\u4e0d\u5339\u914d!");
                Result resultSend = this.mdmPositionFeign.getPositionDetail(null, reqVO.getFromUserPosCode());
                MdmPositionDetailRespVo positionUserSend = (MdmPositionDetailRespVo)ApiResultUtil.objResult((Result)resultSend, (boolean)Boolean.TRUE);
                AssertUtils.isTrue((boolean)user.getUserCode().equals(positionUserSend.getUser().getUserName()), (String)"\u5f53\u524d\u5c97\u4f4d\u4e0b\u4eba\u5458\u4e0d\u5339\u914d!");
                TaTaskCopyEntity taskCopy = new TaTaskCopyEntity();
                taskCopy.setTaskId(taskInfo.getId()).setProcessInstId(taskInfo.getProcessInstanceId()).setTaskDefKey("CP:" + taskInfo.getTaskDefinitionKey()).setTaskName(taskInfo.getName()).setUserCode(user.getUserCode()).setUserName(positionUserTo.getUser().getFullName()).setPosCode(user.getPosCode()).setPosName(positionUserTo.getPositionName()).setFromUser(reqVO.getFromUserCode()).setFromUserName(positionUserSend.getUser().getFullName()).setFromPosCode(positionUserSend.getPositionCode()).setFromPosName(positionUserSend.getPositionName()).setStatus(Indicator.COPY_TASK_STATUS_UNREAD.getCode());
                this.save((Object)taskCopy);
                TaProcessOptRecordEntity optRecord = new TaProcessOptRecordEntity();
                optRecord.setProcessInstId(taskCopy.getProcessInstId()).setTaskId(taskInfo.getId()).setTaskDefKey(taskCopy.getTaskDefKey()).setTaskName(taskInfo.getName()).setUserCode(reqVO.getFromUserCode()).setUserName(positionUserSend.getUser().getUserName()).setPositionCode(positionUserSend.getPositionCode()).setPositionName(positionUserSend.getPositionName()).setProcessVersionKey(taskInfo.getProcessDefinitionId()).setOperation(IndicatorStr.PROCESS_BTN_INFORM.getCode()).setContent(positionUserSend.getUser().getFullName() + "\u53d1\u8d77\u4e86\u6284\u9001\u64cd\u4f5c\uff0c\u6284\u9001\u7ed9:" + positionUserTo.getUser().getFullName()).setCreateTime(new Date()).setSourceId(taskCopy.getId());
                if (StringUtils.isNotEmpty((CharSequence)reqVO.getRemark())) {
                    optRecord.setContent(optRecord.getContent() + "|" + reqVO.getRemark());
                }
                this.taProcessOptRecordService.save((Object)optRecord);
                ++success;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return "\u603b\u8ba1\u6284\u9001\u76ee\u6807\u6570\u91cf:" + total + ",\u6284\u9001\u6210\u529f\u6570\u91cf:" + success;
    }

    @Override
    public PageResult<CopyTaskRspVO> findMyCopyTask(CopyTaskReqVO reqVO) {
        Page taskRspVOPage = PageUtil.buildPage((Integer)reqVO.getPageNum(), (Integer)reqVO.getPageSize());
        List<CopyTaskRspVO> list = this.taTaskCopyMapper.queryCopyTask((Page<CopyTaskReqVO>)taskRspVOPage, reqVO);
        list.forEach(vo -> vo.setStatusDesc(Column.COPY_TASK_STATUS.getLabelByCode(vo.getStatus())));
        return PageResult.builder().count(Long.valueOf(taskRspVOPage.getTotal())).data(list).build();
    }
}

