/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.act.controller;

import com.biz.crm.act.model.TaActBaseProcessEntity;
import com.biz.crm.act.service.ITaActBaseService;
import com.biz.crm.act.service.TaProcessImgService;
import com.biz.crm.act.vo.SubmitActivitiResp;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.exception.CrmExceptionType;
import com.biz.crm.exception.activiti.ActivitiException;
import com.biz.crm.nebular.activiti.act.req.StartProcessReqVo;
import com.biz.crm.nebular.activiti.common.ProcessCommonVo;
import com.biz.crm.nebular.activiti.start.req.CancelProcessReqVO;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.Result;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"taActBaseController"})
@Api(tags={"\u6d41\u7a0b\u5b9e\u4f8b\u64cd\u4f5c"})
public class TaActBaseController {
    private static final Logger log = LoggerFactory.getLogger(TaActBaseController.class);
    @Autowired
    private ITaActBaseService taActBaseService;
    @Autowired
    private TaProcessImgService taProcessImgService;

    @ApiOperation(value="\u53d1\u8d77\u6d41\u7a0b--\u5176\u4ed6\u4e1a\u52a1\u7cfb\u7edf\u8c03\u7528")
    @PostMapping(value={"/startProcess"})
    @CrmLog
    public Result<ProcessCommonVo> startProcess(@RequestBody StartProcessReqVo startProcessReqVo) {
        TaActBaseProcessEntity actBaseProcess = this.taActBaseService.startProcess(startProcessReqVo);
        ProcessCommonVo processCommonVo = new ProcessCommonVo();
        processCommonVo.setProcessNo(actBaseProcess.getProcessNo());
        return Result.ok((Object)processCommonVo);
    }

    @ApiOperation(value="\u64a4\u9500\u6d41\u7a0b")
    @PostMapping(value={"/cancelProcess"})
    @CrmLog
    public Result cancelProcess(@RequestBody CancelProcessReqVO cancelProcessReqVO) {
        AssertUtils.isNotEmpty((String)cancelProcessReqVO.getUserCode(), (CrmExceptionType)ActivitiException.ACT_PARAM_USER);
        AssertUtils.isNotEmpty((String)cancelProcessReqVO.getFormNo(), (CrmExceptionType)ActivitiException.ACT_PARAM_FROM_NO);
        String msg = this.taActBaseService.cancelProcess(cancelProcessReqVO);
        return Result.ok((String)msg);
    }

    @GetMapping(value={"/getProcessPicInfo"})
    public void getProcessPicInfo(HttpServletRequest request, HttpServletResponse response) throws Exception {
        response.setContentType("UTF-8");
        response.setCharacterEncoding("UTF-8");
        String fromView = request.getParameter("fromView");
        String processInstanceId = request.getParameter("processInstanceId");
        UserRedis user = UserUtils.getUser();
        InputStream is = this.taProcessImgService.processTracking(processInstanceId, null, fromView);
        if (is == null) {
            return;
        }
        int len = 0;
        byte[] b = new byte[1024];
        while ((len = is.read(b, 0, 1024)) != -1) {
            response.getOutputStream().write(b, 0, len);
        }
    }

    @ApiImplicitParams(value={@ApiImplicitParam(name="key", value="\u4e1a\u52a1\u552f\u4e00\u6761\u4ef6", required=false, paramType="query")})
    @ApiOperation(value="\u63d0\u4ea4\u6d41\u7a0b\u83b7\u53d6\u4fe1\u606f")
    @PostMapping(value={"/getSubmitActiviti"})
    public Result<SubmitActivitiResp> getSubmitActiviti(@RequestParam(value="key", required=false) String key) {
        Result respResult = new Result();
        SubmitActivitiResp submitActivitiResp = this.taActBaseService.getSubmitActiviti(key);
        respResult.setResult((Object)submitActivitiResp);
        return respResult;
    }
}

