/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.design.controller;

import com.biz.crm.design.service.RuntimeInfoService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.engine.TaskService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"runtime"})
public class RuntimeController {
    private static final Logger log = LoggerFactory.getLogger(RuntimeController.class);
    @Autowired
    private RuntimeInfoService runtimeInfoService;
    @Autowired
    private TaskService taskService;

    @PostMapping(value={"tasks/do/{taskId}"})
    public Object tasks(@PathVariable String taskId, @RequestBody Map<String, Object> params) {
        boolean taskDo = true;
        if (null == params || params.isEmpty()) {
            this.taskService.complete(taskId);
            return taskDo;
        }
        String dealType = (String)params.get("dealType");
        String dealReason = (String)params.get("dealReason");
        if ("1".equals(dealType)) {
            try {
                String rejectElemKey = (String)params.get("rejectElemKey");
                if ("S00000".equals(rejectElemKey)) {
                    this.completeTasks(taskId, params);
                } else {
                    this.taskService.setVariableLocal(taskId, "dealUserId", params.get("dealUserId"));
                    this.taskService.setVariableLocal(taskId, "dealUnitId", params.get("dealUnitId"));
                    this.taskService.setVariable(taskId, "dealType", (Object)dealType);
                    this.taskService.setVariable(taskId, "dealReason", (Object)dealReason);
                }
                taskDo = this.runtimeInfoService.rejected(taskId, rejectElemKey, dealReason);
            }
            catch (Exception e) {
                taskDo = false;
                log.error("\u9a73\u56de\u5904\u7406\u5f02\u5e38\uff1a{}", (Throwable)e);
            }
        } else if ("0".equals(dealType)) {
            this.completeTasks(taskId, params);
        }
        return taskDo;
    }

    private void completeTasks(@PathVariable String taskId, @RequestBody Map<String, Object> params) {
        log.info("\u5b8c\u6210\u4efb\u52a1\u53c2\u6570\uff1ataskId={} ,params={}", (Object)taskId, params);
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("dealUserId", params.get("dealUserId"));
        variables.put("dealUnitId", params.get("dealUnitId"));
        this.taskService.setVariablesLocal(taskId, variables);
        variables = new HashMap();
        variables.put("dealType", params.get("dealType"));
        variables.put("dealReason", params.get("dealReason"));
        this.taskService.complete(taskId, variables);
        log.info("\u5b8c\u6210\u4efb\u52a1\uff1a\u4efb\u52a1ID\uff1a" + taskId);
    }

    @GetMapping(value={"/tasks/buss"})
    public Object bussNow(@RequestParam(value="taskId") String taskId) {
        Map variables = this.taskService.getVariables(taskId);
        return variables;
    }

    @GetMapping(value={"/tasks/ing"})
    public Object myTasks(@RequestParam(value="userId") String userId) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        List<Map<String, Object>> tasks = this.runtimeInfoService.myTasks(userId);
        if (!CollectionUtils.isEmpty(tasks)) {
            for (Map<String, Object> task : tasks) {
                Map variables = this.taskService.getVariables((String)task.get("ID_"));
                task.putAll(variables);
                list.add(task);
            }
        }
        return list;
    }
}

