/**
 * This notice must be untouched at all times. This is the COMPRESSED version of
 * the Draw2D Library WebSite: http://www.draw2d.org Copyright: 2006 Andreas
 * Herz. All rights reserved. Created: 5.11.2006 by Andreas Herz (Web:
 * http://www.freegroup.de ) LICENSE: LGPL
 */
var draw2d = new Object();
var _errorStack_ = [];
function pushErrorStack(e, _56b2) {
	_errorStack_.push(_56b2 + "\n");
	throw e;
}
draw2d.AbstractEvent = function() {
	this.type = null;
	this.target = null;
	this.relatedTarget = null;
	this.cancelable = false;
	this.timeStamp = null;
	this.returnValue = true;
};
draw2d.AbstractEvent.prototype.initEvent = function(sType, _56b4) {
	this.type = sType;
	this.cancelable = _56b4;
	this.timeStamp = (new Date()).getTime();
};
draw2d.AbstractEvent.prototype.preventDefault = function() {
	if (this.cancelable) {
		this.returnValue = false;
	}
};
draw2d.AbstractEvent.fireDOMEvent = function(_56b5, _56b6) {
	if (document.createEvent) {
		var evt = document.createEvent("Events");
		evt.initEvent(_56b5, true, true);
		_56b6.dispatchEvent(evt);
	} else {
		if (document.createEventObject) {
			var evt = document.createEventObject();
			_56b6.fireEvent("on" + _56b5, evt);
		}
	}
};
draw2d.EventTarget = function() {
	this.eventhandlers = {};
};
draw2d.EventTarget.prototype.addEventListener = function(sType, _56b9) {
	if (typeof this.eventhandlers[sType] == "undefined") {
		this.eventhandlers[sType] = [];
	}
	this.eventhandlers[sType][this.eventhandlers[sType].length] = _56b9;
};
draw2d.EventTarget.prototype.dispatchEvent = function(_56ba) {
	_56ba.target = this;
	if (typeof this.eventhandlers[_56ba.type] != "undefined") {
		for ( var i = 0; i < this.eventhandlers[_56ba.type].length; i++) {
			this.eventhandlers[_56ba.type][i](_56ba);
		}
	}
	return _56ba.returnValue;
};
draw2d.EventTarget.prototype.removeEventListener = function(sType, _56bd) {
	if (typeof this.eventhandlers[sType] != "undefined") {
		var _56be = [];
		for ( var i = 0; i < this.eventhandlers[sType].length; i++) {
			if (this.eventhandlers[sType][i] != _56bd) {
				_56be[_56be.length] = this.eventhandlers[sType][i];
			}
		}
		this.eventhandlers[sType] = _56be;
	}
};
String.prototype.trim = function() {
	return (this.replace(new RegExp("^([\\s]+)|([\\s]+)$", "gm"), ""));
};
String.prototype.lefttrim = function() {
	return (this.replace(new RegExp("^[\\s]+", "gm"), ""));
};
String.prototype.righttrim = function() {
	return (this.replace(new RegExp("[\\s]+$", "gm"), ""));
};
String.prototype.between = function(left, right, _558a) {
	if (!_558a) {
		_558a = 0;
	}
	var li = this.indexOf(left, _558a);
	if (li == -1) {
		return null;
	}
	var ri = this.indexOf(right, li);
	if (ri == -1) {
		return null;
	}
	return this.substring(li + left.length, ri);
};
draw2d.UUID = function() {
};
draw2d.UUID.prototype.type = "draw2d.UUID";
draw2d.UUID.create = function() {
	var _4a13 = function() {
		return (((1 + Math.random()) * 65536) | 0).toString(16).substring(1);
	};
	return (_4a13() + _4a13() + "-" + _4a13() + "-" + _4a13() + "-" + _4a13()
			+ "-" + _4a13() + _4a13() + _4a13());
};
draw2d.ArrayList = function() {
	this.increment = 10;
	this.size = 0;
	this.data = new Array(this.increment);
};
draw2d.ArrayList.EMPTY_LIST = new draw2d.ArrayList();
draw2d.ArrayList.prototype.type = "draw2d.ArrayList";
draw2d.ArrayList.prototype.reverse = function() {
	var _4b1e = new Array(this.size);
	for ( var i = 0; i < this.size; i++) {
		_4b1e[i] = this.data[this.size - i - 1];
	}
	this.data = _4b1e;
};
draw2d.ArrayList.prototype.getCapacity = function() {
	return this.data.length;
};
draw2d.ArrayList.prototype.getSize = function() {
	return this.size;
};
draw2d.ArrayList.prototype.isEmpty = function() {
	return this.getSize() === 0;
};
draw2d.ArrayList.prototype.getLastElement = function() {
	if (this.data[this.getSize() - 1] !== null) {
		return this.data[this.getSize() - 1];
	}
};
draw2d.ArrayList.prototype.getFirstElement = function() {
	if (this.data[0] !== null && this.data[0] !== undefined) {
		return this.data[0];
	}
	return null;
};
draw2d.ArrayList.prototype.get = function(i) {
	return this.data[i];
};
draw2d.ArrayList.prototype.add = function(obj) {
	if (this.getSize() == this.data.length) {
		this.resize();
	}
	this.data[this.size++] = obj;
};
draw2d.ArrayList.prototype.addAll = function(obj) {
	for ( var i = 0; i < obj.getSize(); i++) {
		this.add(obj.get(i));
	}
};
draw2d.ArrayList.prototype.remove = function(obj) {
	var index = this.indexOf(obj);
	if (index >= 0) {
		return this.removeElementAt(index);
	}
	return null;
};
draw2d.ArrayList.prototype.insertElementAt = function(obj, index) {
	if (this.size == this.capacity) {
		this.resize();
	}
	for ( var i = this.getSize(); i > index; i--) {
		this.data[i] = this.data[i - 1];
	}
	this.data[index] = obj;
	this.size++;
};
draw2d.ArrayList.prototype.removeElementAt = function(index) {
	var _4b2a = this.data[index];
	for ( var i = index; i < (this.getSize() - 1); i++) {
		this.data[i] = this.data[i + 1];
	}
	this.data[this.getSize() - 1] = null;
	this.size--;
	return _4b2a;
};
draw2d.ArrayList.prototype.removeAllElements = function() {
	this.size = 0;
	for ( var i = 0; i < this.data.length; i++) {
		this.data[i] = null;
	}
};
draw2d.ArrayList.prototype.indexOf = function(obj) {
	for ( var i = 0; i < this.getSize(); i++) {
		if (this.data[i] == obj) {
			return i;
		}
	}
	return -1;
};
draw2d.ArrayList.prototype.contains = function(obj) {
	for ( var i = 0; i < this.getSize(); i++) {
		if (this.data[i] == obj) {
			return true;
		}
	}
	return false;
};
draw2d.ArrayList.prototype.resize = function() {
	newData = new Array(this.data.length + this.increment);
	for ( var i = 0; i < this.data.length; i++) {
		newData[i] = this.data[i];
	}
	this.data = newData;
};
draw2d.ArrayList.prototype.trimToSize = function() {
	if (this.data.length == this.size) {
		return;
	}
	var temp = new Array(this.getSize());
	for ( var i = 0; i < this.getSize(); i++) {
		temp[i] = this.data[i];
	}
	this.size = temp.length;
	this.data = temp;
};
draw2d.ArrayList.prototype.sort = function(f) {
	var i, j;
	var _4b36;
	var _4b37;
	var _4b38;
	var _4b39;
	for (i = 1; i < this.getSize(); i++) {
		_4b37 = this.data[i];
		_4b36 = _4b37[f];
		j = i - 1;
		_4b38 = this.data[j];
		_4b39 = _4b38[f];
		while (j >= 0 && _4b39 > _4b36) {
			this.data[j + 1] = this.data[j];
			j--;
			if (j >= 0) {
				_4b38 = this.data[j];
				_4b39 = _4b38[f];
			}
		}
		this.data[j + 1] = _4b37;
	}
};
draw2d.ArrayList.prototype.clone = function() {
	var _4b3a = new draw2d.ArrayList(this.size);
	for ( var i = 0; i < this.size; i++) {
		_4b3a.add(this.data[i]);
	}
	return _4b3a;
};
draw2d.ArrayList.prototype.overwriteElementAt = function(obj, index) {
	this.data[index] = obj;
};
draw2d.ArrayList.prototype.getPersistentAttributes = function() {
	return {
		data : this.data,
		increment : this.increment,
		size : this.getSize()
	};
};
function trace(_5cb5) {
	var _5cb6 = openwindow("about:blank", 700, 400);
	_5cb6.document.writeln("<pre>" + _5cb5 + "</pre>");
}
function openwindow(url, width, _5cb9) {
	var left = (screen.width - width) / 2;
	var top = (screen.height - _5cb9) / 2;
	property = "left="
			+ left
			+ ", top="
			+ top
			+ ", toolbar=0,scrollbars=0,location=0,statusbar=0,menubar=0,resizable=1,alwaysRaised,width="
			+ width + ",height=" + _5cb9;
	return window.open(url, "_blank", property);
}
function dumpObject(obj) {
	trace("----------------------------------------------------------------------------");
	trace("- Object dump");
	trace("----------------------------------------------------------------------------");
	for ( var i in obj) {
		try {
			if (typeof obj[i] != "function") {
				trace(i + " --&gt; " + obj[i]);
			}
		} catch (e) {
		}
	}
	for ( var i in obj) {
		try {
			if (typeof obj[i] == "function") {
				trace(i + " --&gt; " + obj[i]);
			}
		} catch (e) {
		}
	}
	trace("----------------------------------------------------------------------------");
}
draw2d.Drag = function() {
};
draw2d.Drag.current = null;
draw2d.Drag.currentTarget = null;
draw2d.Drag.currentHover = null;
draw2d.Drag.currentCompartment = null;
draw2d.Drag.dragging = false;
draw2d.Drag.isDragging = function() {
	return this.dragging;
};
draw2d.Drag.setCurrent = function(_604e) {
	this.current = _604e;
	this.dragging = true;
};
draw2d.Drag.getCurrent = function() {
	return this.current;
};
draw2d.Drag.clearCurrent = function() {
	this.current = null;
	this.dragging = false;
	this.currentTarget = null;
};
draw2d.Draggable = function(_604f, _6050) {
	this.id = draw2d.UUID.create();
	this.node = null;
	draw2d.EventTarget.call(this);
	this.construct(_604f, _6050);
	this.diffX = 0;
	this.diffY = 0;
	this.targets = new draw2d.ArrayList();
};
draw2d.Draggable.prototype = new draw2d.EventTarget();
draw2d.Draggable.prototype.construct = function(_6051) {
	if (_6051 === null || _6051 === undefined) {
		return;
	}
	this.element = _6051;
	var oThis = this;
	var _6053 = function() {
		var _6054 = new draw2d.DragDropEvent();
		_6054.initDragDropEvent("dblclick", true);
		oThis.dispatchEvent(_6054);
		var _6055 = arguments[0] || window.event;
		_6055.cancelBubble = true;
		_6055.returnValue = false;
	};
	var _6056 = function() {
		var _6057 = arguments[0] || window.event;
		var _6058 = new draw2d.DragDropEvent();
		if (oThis.node !== null) {
			var _6059 = oThis.node.getWorkflow().getAbsoluteX();
			var _605a = oThis.node.getWorkflow().getAbsoluteY();
			var _605b = oThis.node.getWorkflow().getScrollLeft();
			var _605c = oThis.node.getWorkflow().getScrollTop();
			_6058.x = _6057.clientX - oThis.element.offsetLeft + _605b - _6059;
			_6058.y = _6057.clientY - oThis.element.offsetTop + _605c - _605a;
		}
		if (_6057.button === 2) {
			_6058.initDragDropEvent("contextmenu", true);
			oThis.dispatchEvent(_6058);
		} else {
			_6058.initDragDropEvent("dragstart", true);
			if (oThis.dispatchEvent(_6058)) {
				oThis.diffX = _6057.clientX - oThis.element.offsetLeft;
				oThis.diffY = _6057.clientY - oThis.element.offsetTop;
				draw2d.Drag.setCurrent(oThis);
				if (oThis.isAttached == true) {
					oThis.detachEventHandlers();
				}
				oThis.attachEventHandlers();
			}
		}
		_6057.cancelBubble = true;
		_6057.returnValue = false;
	};
	var _605d = function() {
		if (draw2d.Drag.getCurrent() === null) {
			var _605e = arguments[0] || window.event;
			if (draw2d.Drag.currentHover !== null
					&& oThis !== draw2d.Drag.currentHover) {
				var _605f = new draw2d.DragDropEvent();
				_605f.initDragDropEvent("mouseleave", false, oThis);
				draw2d.Drag.currentHover.dispatchEvent(_605f);
			}
			if (oThis !== null && oThis !== draw2d.Drag.currentHover) {
				var _605f = new draw2d.DragDropEvent();
				_605f.initDragDropEvent("mouseenter", false, oThis);
				oThis.dispatchEvent(_605f);
			}
			draw2d.Drag.currentHover = oThis;
		} else {
		}
	};
	if (this.element.addEventListener) {
		this.element.addEventListener("mousemove", _605d, false);
		this.element.addEventListener("mousedown", _6056, false);
		this.element.addEventListener("dblclick", _6053, false);
	} else {
		if (this.element.attachEvent) {
			this.element.attachEvent("onmousemove", _605d);
			this.element.attachEvent("onmousedown", _6056);
			this.element.attachEvent("ondblclick", _6053);
		} else {
			throw "Drag not supported in this browser.";
		}
	}
};
draw2d.Draggable.prototype.onDrop = function(_6060, _6061) {
};
draw2d.Draggable.prototype.attachEventHandlers = function() {
	var oThis = this;
	oThis.isAttached = true;
	this.tempMouseMove = function() {
		var _6063 = arguments[0] || window.event;
		var _6064 = new draw2d.Point(_6063.clientX - oThis.diffX, _6063.clientY
				- oThis.diffY);
		if (oThis.node !== null && oThis.node.getCanSnapToHelper()) {
			_6064 = oThis.node.getWorkflow().snapToHelper(oThis.node, _6064);
		}
		oThis.element.style.left = _6064.x + "px";
		oThis.element.style.top = _6064.y + "px";
		if (oThis.node !== null) {
			var _6065 = oThis.node.getWorkflow().getScrollLeft();
			var _6066 = oThis.node.getWorkflow().getScrollTop();
			var _6067 = oThis.node.getWorkflow().getAbsoluteX();
			var _6068 = oThis.node.getWorkflow().getAbsoluteY();
			var _6069 = oThis.getDropTarget(_6063.clientX + _6065 - _6067,
					_6063.clientY + _6066 - _6068);
			var _606a = oThis.getCompartment(_6063.clientX + _6065 - _6067,
					_6063.clientY + _6066 - _6068);
			if (draw2d.Drag.currentTarget !== null
					&& _6069 != draw2d.Drag.currentTarget) {
				var _606b = new draw2d.DragDropEvent();
				_606b.initDragDropEvent("dragleave", false, oThis);
				draw2d.Drag.currentTarget.dispatchEvent(_606b);
			}
			if (_6069 !== null && _6069 !== draw2d.Drag.currentTarget) {
				var _606b = new draw2d.DragDropEvent();
				_606b.initDragDropEvent("dragenter", false, oThis);
				_6069.dispatchEvent(_606b);
			}
			draw2d.Drag.currentTarget = _6069;
			if (draw2d.Drag.currentCompartment !== null
					&& _606a !== draw2d.Drag.currentCompartment) {
				var _606b = new draw2d.DragDropEvent();
				_606b.initDragDropEvent("figureleave", false, oThis);
				draw2d.Drag.currentCompartment.dispatchEvent(_606b);
			}
			if (_606a !== null && _606a.node != oThis.node
					&& _606a !== draw2d.Drag.currentCompartment) {
				var _606b = new draw2d.DragDropEvent();
				_606b.initDragDropEvent("figureenter", false, oThis);
				_606a.dispatchEvent(_606b);
			}
			draw2d.Drag.currentCompartment = _606a;
		}
		var _606c = new draw2d.DragDropEvent();
		_606c.initDragDropEvent("drag", false);
		oThis.dispatchEvent(_606c);
	};
	oThis.tempMouseUp = function() {
		oThis.detachEventHandlers();
		var _606d = arguments[0] || window.event;
		if (oThis.node !== null) {
			var _606e = oThis.node.getWorkflow().getScrollLeft();
			var _606f = oThis.node.getWorkflow().getScrollTop();
			var _6070 = oThis.node.getWorkflow().getAbsoluteX();
			var _6071 = oThis.node.getWorkflow().getAbsoluteY();
			var _6072 = oThis.getDropTarget(_606d.clientX + _606e - _6070,
					_606d.clientY + _606f - _6071);
			var _6073 = oThis.getCompartment(_606d.clientX + _606e - _6070,
					_606d.clientY + _606f - _6071);
			if (_6072 !== null) {
				var _6074 = new draw2d.DragDropEvent();
				_6074.initDragDropEvent("drop", false, oThis);
				_6072.dispatchEvent(_6074);
			}
			if (_6073 !== null && _6073.node !== oThis.node) {
				var _6074 = new draw2d.DragDropEvent();
				_6074.initDragDropEvent("figuredrop", false, oThis);
				_6073.dispatchEvent(_6074);
			}
			if (draw2d.Drag.currentTarget !== null) {
				var _6074 = new draw2d.DragDropEvent();
				_6074.initDragDropEvent("dragleave", false, oThis);
				draw2d.Drag.currentTarget.dispatchEvent(_6074);
				draw2d.Drag.currentTarget = null;
			}
		}
		var _6075 = new draw2d.DragDropEvent();
		_6075.initDragDropEvent("dragend", false);
		oThis.dispatchEvent(_6075);
		oThis.onDrop(_606d.clientX, _606d.clientY);
		draw2d.Drag.currentCompartment = null;
		draw2d.Drag.clearCurrent();
	};
	if (document.body.addEventListener) {
		document.body.addEventListener("mousemove", this.tempMouseMove, false);
		document.body.addEventListener("mouseup", this.tempMouseUp, false);
	} else {
		if (document.body.attachEvent) {
			document.body.attachEvent("onmousemove", this.tempMouseMove);
			document.body.attachEvent("onmouseup", this.tempMouseUp);
		} else {
			throw new Error("Drag doesn't support this browser.");
		}
	}
};
draw2d.Draggable.prototype.detachEventHandlers = function() {
	this.isAttached = false;
	if (document.body.removeEventListener) {
		document.body.removeEventListener("mousemove", this.tempMouseMove,
				false);
		document.body.removeEventListener("mouseup", this.tempMouseUp, false);
	} else {
		if (document.body.detachEvent) {
			document.body.detachEvent("onmousemove", this.tempMouseMove);
			document.body.detachEvent("onmouseup", this.tempMouseUp);
		} else {
			throw new Error("Drag doesn't support this browser.");
		}
	}
};
draw2d.Draggable.prototype.getDropTarget = function(x, y) {
	for ( var i = 0; i < this.targets.getSize(); i++) {
		var _6079 = this.targets.get(i);
		if (_6079.node.isOver(x, y) && _6079.node !== this.node) {
			return _6079;
		}
	}
	return null;
};
draw2d.Draggable.prototype.getCompartment = function(x, y) {
	var _607c = null;
	for ( var i = 0; i < this.node.getWorkflow().compartments.getSize(); i++) {
		var _607e = this.node.getWorkflow().compartments.get(i);
		if (_607e.isOver(x, y) && _607e !== this.node) {
			if (_607c === null) {
				_607c = _607e;
			} else {
				if (_607c.getZOrder() < _607e.getZOrder()) {
					_607c = _607e;
				}
			}
		}
	}
	return _607c === null ? null : _607c.dropable;
};
draw2d.Draggable.prototype.getLeft = function() {
	return this.element.offsetLeft;
};
draw2d.Draggable.prototype.getTop = function() {
	return this.element.offsetTop;
};
draw2d.DragDropEvent = function() {
	draw2d.AbstractEvent.call(this);
};
draw2d.DragDropEvent.prototype = new draw2d.AbstractEvent();
draw2d.DragDropEvent.prototype.initDragDropEvent = function(sType, _6080, _6081) {
	this.initEvent(sType, _6080);
	this.relatedTarget = _6081;
};
draw2d.DropTarget = function(_6082) {
	draw2d.EventTarget.call(this);
	this.construct(_6082);
};
draw2d.DropTarget.prototype = new draw2d.EventTarget();
draw2d.DropTarget.prototype.construct = function(_6083) {
	this.element = _6083;
};
draw2d.DropTarget.prototype.getLeft = function() {
	var el = this.element;
	var ol = el.offsetLeft;
	while ((el = el.offsetParent) !== null) {
		ol += el.offsetLeft;
	}
	return ol;
};
draw2d.DropTarget.prototype.getTop = function() {
	var el = this.element;
	var ot = el.offsetTop;
	while ((el = el.offsetParent) !== null) {
		ot += el.offsetTop;
	}
	return ot;
};
draw2d.DropTarget.prototype.getHeight = function() {
	return this.element.offsetHeight;
};
draw2d.DropTarget.prototype.getWidth = function() {
	return this.element.offsetWidth;
};
draw2d.PositionConstants = function() {
};
draw2d.PositionConstants.NORTH = 1;
draw2d.PositionConstants.SOUTH = 4;
draw2d.PositionConstants.WEST = 8;
draw2d.PositionConstants.EAST = 16;
draw2d.Color = function(red, green, blue) {
	if (typeof green == "undefined") {
		var rgb = this.hex2rgb(red);
		this.red = rgb[0];
		this.green = rgb[1];
		this.blue = rgb[2];
	} else {
		this.red = red;
		this.green = green;
		this.blue = blue;
	}
};
draw2d.Color.prototype.type = "draw2d.Color";
draw2d.Color.prototype.getHTMLStyle = function() {
	return "rgb(" + this.red + "," + this.green + "," + this.blue + ")";
};
draw2d.Color.prototype.getRed = function() {
	return this.red;
};
draw2d.Color.prototype.getGreen = function() {
	return this.green;
};
draw2d.Color.prototype.getBlue = function() {
	return this.blue;
};
draw2d.Color.prototype.getIdealTextColor = function() {
	var _5062 = 105;
	var _5063 = (this.red * 0.299) + (this.green * 0.587) + (this.blue * 0.114);
	return (255 - _5063 < _5062) ? new draw2d.Color(0, 0, 0)
			: new draw2d.Color(255, 255, 255);
};
draw2d.Color.prototype.hex2rgb = function(_5064) {
	_5064 = _5064.replace("#", "");
	return ( {
		0 : parseInt(_5064.substr(0, 2), 16),
		1 : parseInt(_5064.substr(2, 2), 16),
		2 : parseInt(_5064.substr(4, 2), 16)
	});
};
draw2d.Color.prototype.hex = function() {
	return (this.int2hex(this.red) + this.int2hex(this.green) + this
			.int2hex(this.blue));
};
draw2d.Color.prototype.int2hex = function(v) {
	v = Math.round(Math.min(Math.max(0, v), 255));
	return ("0123456789ABCDEF".charAt((v - v % 16) / 16) + "0123456789ABCDEF"
			.charAt(v % 16));
};
draw2d.Color.prototype.darker = function(_5066) {
	var red = parseInt(Math.round(this.getRed() * (1 - _5066)));
	var green = parseInt(Math.round(this.getGreen() * (1 - _5066)));
	var blue = parseInt(Math.round(this.getBlue() * (1 - _5066)));
	if (red < 0) {
		red = 0;
	} else {
		if (red > 255) {
			red = 255;
		}
	}
	if (green < 0) {
		green = 0;
	} else {
		if (green > 255) {
			green = 255;
		}
	}
	if (blue < 0) {
		blue = 0;
	} else {
		if (blue > 255) {
			blue = 255;
		}
	}
	return new draw2d.Color(red, green, blue);
};
draw2d.Color.prototype.lighter = function(_506a) {
	var red = parseInt(Math.round(this.getRed() * (1 + _506a)));
	var green = parseInt(Math.round(this.getGreen() * (1 + _506a)));
	var blue = parseInt(Math.round(this.getBlue() * (1 + _506a)));
	if (red < 0) {
		red = 0;
	} else {
		if (red > 255) {
			red = 255;
		}
	}
	if (green < 0) {
		green = 0;
	} else {
		if (green > 255) {
			green = 255;
		}
	}
	if (blue < 0) {
		blue = 0;
	} else {
		if (blue > 255) {
			blue = 255;
		}
	}
	return new draw2d.Color(red, green, blue);
};
draw2d.Point = function(x, y) {
	this.x = x;
	this.y = y;
};
draw2d.Point.prototype.type = "draw2d.Point";
draw2d.Point.prototype.getX = function() {
	return this.x;
};
draw2d.Point.prototype.getY = function() {
	return this.y;
};
draw2d.Point.prototype.getPosition = function(p) {
	var dx = p.x - this.x;
	var dy = p.y - this.y;
	if (Math.abs(dx) > Math.abs(dy)) {
		if (dx < 0) {
			return draw2d.PositionConstants.WEST;
		}
		return draw2d.PositionConstants.EAST;
	}
	if (dy < 0) {
		return draw2d.PositionConstants.NORTH;
	}
	return draw2d.PositionConstants.SOUTH;
};
draw2d.Point.prototype.equals = function(o) {
	return this.x == o.x && this.y == o.y;
};
draw2d.Point.prototype.getDistance = function(other) {
	return Math.sqrt((this.x - other.x) * (this.x - other.x)
			+ (this.y - other.y) * (this.y - other.y));
};
draw2d.Point.prototype.getTranslated = function(other) {
	return new draw2d.Point(this.x + other.x, this.y + other.y);
};
draw2d.Point.prototype.getPersistentAttributes = function() {
	return {
		x : this.x,
		y : this.y
	};
};
draw2d.Dimension = function(x, y, w, h) {
	draw2d.Point.call(this, x, y);
	this.w = w;
	this.h = h;
};
draw2d.Dimension.prototype = new draw2d.Point();
draw2d.Dimension.prototype.type = "draw2d.Dimension";
draw2d.Dimension.prototype.translate = function(dx, dy) {
	this.x += dx;
	this.y += dy;
	return this;
};
draw2d.Dimension.prototype.resize = function(dw, dh) {
	this.w += dw;
	this.h += dh;
	return this;
};
draw2d.Dimension.prototype.setBounds = function(rect) {
	this.x = rect.x;
	this.y = rect.y;
	this.w = rect.w;
	this.h = rect.h;
	return this;
};
draw2d.Dimension.prototype.isEmpty = function() {
	return this.w <= 0 || this.h <= 0;
};
draw2d.Dimension.prototype.getWidth = function() {
	return this.w;
};
draw2d.Dimension.prototype.getHeight = function() {
	return this.h;
};
draw2d.Dimension.prototype.getRight = function() {
	return this.x + this.w;
};
draw2d.Dimension.prototype.getBottom = function() {
	return this.y + this.h;
};
draw2d.Dimension.prototype.getTopLeft = function() {
	return new draw2d.Point(this.x, this.y);
};
draw2d.Dimension.prototype.getCenter = function() {
	return new draw2d.Point(this.x + this.w / 2, this.y + this.h / 2);
};
draw2d.Dimension.prototype.getBottomRight = function() {
	return new draw2d.Point(this.x + this.w, this.y + this.h);
};
draw2d.Dimension.prototype.equals = function(o) {
	return this.x == o.x && this.y == o.y && this.w == o.w && this.h == o.h;
};
draw2d.SnapToHelper = function(_5932) {
	this.workflow = _5932;
};
draw2d.SnapToHelper.NORTH = 1;
draw2d.SnapToHelper.SOUTH = 4;
draw2d.SnapToHelper.WEST = 8;
draw2d.SnapToHelper.EAST = 16;
draw2d.SnapToHelper.CENTER = 32;
draw2d.SnapToHelper.NORTH_EAST = draw2d.SnapToHelper.NORTH
		| draw2d.SnapToHelper.EAST;
draw2d.SnapToHelper.NORTH_WEST = draw2d.SnapToHelper.NORTH
		| draw2d.SnapToHelper.WEST;
draw2d.SnapToHelper.SOUTH_EAST = draw2d.SnapToHelper.SOUTH
		| draw2d.SnapToHelper.EAST;
draw2d.SnapToHelper.SOUTH_WEST = draw2d.SnapToHelper.SOUTH
		| draw2d.SnapToHelper.WEST;
draw2d.SnapToHelper.NORTH_SOUTH = draw2d.SnapToHelper.NORTH
		| draw2d.SnapToHelper.SOUTH;
draw2d.SnapToHelper.EAST_WEST = draw2d.SnapToHelper.EAST
		| draw2d.SnapToHelper.WEST;
draw2d.SnapToHelper.NSEW = draw2d.SnapToHelper.NORTH_SOUTH
		| draw2d.SnapToHelper.EAST_WEST;
draw2d.SnapToHelper.prototype.snapPoint = function(_5933, _5934, _5935) {
	return _5934;
};
draw2d.SnapToHelper.prototype.snapRectangle = function(_5936, _5937) {
	return _5936;
};
draw2d.SnapToHelper.prototype.onSetDocumentDirty = function() {
};
draw2d.SnapToGrid = function(_4a14) {
	draw2d.SnapToHelper.call(this, _4a14);
};
draw2d.SnapToGrid.prototype = new draw2d.SnapToHelper();
draw2d.SnapToGrid.prototype.type = "draw2d.SnapToGrid";
draw2d.SnapToGrid.prototype.snapPoint = function(_4a15, _4a16, _4a17) {
	_4a17.x = this.workflow.gridWidthX
			* Math
					.floor(((_4a16.x + this.workflow.gridWidthX / 2) / this.workflow.gridWidthX));
	_4a17.y = this.workflow.gridWidthY
			* Math
					.floor(((_4a16.y + this.workflow.gridWidthY / 2) / this.workflow.gridWidthY));
	return 0;
};
draw2d.SnapToGrid.prototype.snapRectangle = function(_4a18, _4a19) {
	_4a19.x = _4a18.x;
	_4a19.y = _4a18.y;
	_4a19.w = _4a18.w;
	_4a19.h = _4a18.h;
	return 0;
};
draw2d.SnapToGeometryEntry = function(type, _5944) {
	this.type = type;
	this.location = _5944;
};
draw2d.SnapToGeometryEntry.prototype.getLocation = function() {
	return this.location;
};
draw2d.SnapToGeometryEntry.prototype.getType = function() {
	return this.type;
};
draw2d.SnapToGeometry = function(_5afe) {
	draw2d.SnapToHelper.call(this, _5afe);
	this.rows = null;
	this.cols = null;
};
draw2d.SnapToGeometry.prototype = new draw2d.SnapToHelper();
draw2d.SnapToGeometry.THRESHOLD = 5;
draw2d.SnapToGeometry.prototype.snapPoint = function(_5aff, _5b00, _5b01) {
	if (this.rows === null || this.cols === null) {
		this.populateRowsAndCols();
	}
	if ((_5aff & draw2d.SnapToHelper.EAST) !== 0) {
		var _5b02 = this.getCorrectionFor(this.cols, _5b00.getX() - 1, 1);
		if (_5b02 !== draw2d.SnapToGeometry.THRESHOLD) {
			_5aff &= ~draw2d.SnapToHelper.EAST;
			_5b01.x += _5b02;
		}
	}
	if ((_5aff & draw2d.SnapToHelper.WEST) !== 0) {
		var _5b03 = this.getCorrectionFor(this.cols, _5b00.getX(), -1);
		if (_5b03 !== draw2d.SnapToGeometry.THRESHOLD) {
			_5aff &= ~draw2d.SnapToHelper.WEST;
			_5b01.x += _5b03;
		}
	}
	if ((_5aff & draw2d.SnapToHelper.SOUTH) !== 0) {
		var _5b04 = this.getCorrectionFor(this.rows, _5b00.getY() - 1, 1);
		if (_5b04 !== draw2d.SnapToGeometry.THRESHOLD) {
			_5aff &= ~draw2d.SnapToHelper.SOUTH;
			_5b01.y += _5b04;
		}
	}
	if ((_5aff & draw2d.SnapToHelper.NORTH) !== 0) {
		var _5b05 = this.getCorrectionFor(this.rows, _5b00.getY(), -1);
		if (_5b05 !== draw2d.SnapToGeometry.THRESHOLD) {
			_5aff &= ~draw2d.SnapToHelper.NORTH;
			_5b01.y += _5b05;
		}
	}
	return _5aff;
};
draw2d.SnapToGeometry.prototype.snapRectangle = function(_5b06, _5b07) {
	var _5b08 = _5b06.getTopLeft();
	var _5b09 = _5b06.getBottomRight();
	var _5b0a = this.snapPoint(draw2d.SnapToHelper.NORTH_WEST, _5b06
			.getTopLeft(), _5b08);
	_5b07.x = _5b08.x;
	_5b07.y = _5b08.y;
	var _5b0b = this.snapPoint(draw2d.SnapToHelper.SOUTH_EAST, _5b06
			.getBottomRight(), _5b09);
	if (_5b0a & draw2d.SnapToHelper.WEST) {
		_5b07.x = _5b09.x - _5b06.getWidth();
	}
	if (_5b0a & draw2d.SnapToHelper.NORTH) {
		_5b07.y = _5b09.y - _5b06.getHeight();
	}
	return _5b0a | _5b0b;
};
draw2d.SnapToGeometry.prototype.populateRowsAndCols = function() {
	this.rows = [];
	this.cols = [];
	var _5b0c = this.workflow.getDocument().getFigures();
	var index = 0;
	for ( var i = 0; i < _5b0c.getSize(); i++) {
		var _5b0f = _5b0c.get(i);
		if (_5b0f != this.workflow.getCurrentSelection()) {
			var _5b10 = _5b0f.getBounds();
			this.cols[index * 3] = new draw2d.SnapToGeometryEntry(-1, _5b10
					.getX());
			this.rows[index * 3] = new draw2d.SnapToGeometryEntry(-1, _5b10
					.getY());
			this.cols[index * 3 + 1] = new draw2d.SnapToGeometryEntry(0,
					_5b10.x + (_5b10.getWidth() - 1) / 2);
			this.rows[index * 3 + 1] = new draw2d.SnapToGeometryEntry(0,
					_5b10.y + (_5b10.getHeight() - 1) / 2);
			this.cols[index * 3 + 2] = new draw2d.SnapToGeometryEntry(1, _5b10
					.getRight() - 1);
			this.rows[index * 3 + 2] = new draw2d.SnapToGeometryEntry(1, _5b10
					.getBottom() - 1);
			index++;
		}
	}
};
draw2d.SnapToGeometry.prototype.getCorrectionFor = function(_5b11, value, side) {
	var _5b14 = draw2d.SnapToGeometry.THRESHOLD;
	var _5b15 = draw2d.SnapToGeometry.THRESHOLD;
	for ( var i = 0; i < _5b11.length; i++) {
		var entry = _5b11[i];
		var _5b18;
		if (entry.type === -1 && side !== 0) {
			_5b18 = Math.abs(value - entry.location);
			if (_5b18 < _5b14) {
				_5b14 = _5b18;
				_5b15 = entry.location - value;
			}
		} else {
			if (entry.type === 0 && side === 0) {
				_5b18 = Math.abs(value - entry.location);
				if (_5b18 < _5b14) {
					_5b14 = _5b18;
					_5b15 = entry.location - value;
				}
			} else {
				if (entry.type === 1 && side !== 0) {
					_5b18 = Math.abs(value - entry.location);
					if (_5b18 < _5b14) {
						_5b14 = _5b18;
						_5b15 = entry.location - value;
					}
				}
			}
		}
	}
	return _5b15;
};
draw2d.SnapToGeometry.prototype.onSetDocumentDirty = function() {
	this.rows = null;
	this.cols = null;
};
draw2d.Border = function() {
	this.color = null;
};
draw2d.Border.prototype.type = "draw2d.Border";
draw2d.Border.prototype.dispose = function() {
	this.color = null;
};
draw2d.Border.prototype.getHTMLStyle = function() {
	return "";
};
draw2d.Border.prototype.setColor = function(c) {
	this.color = c;
};
draw2d.Border.prototype.getColor = function() {
	return this.color;
};
draw2d.Border.prototype.refresh = function() {
};
draw2d.LineBorder = function(width) {
	draw2d.Border.call(this);
	this.width = 1;
	if (width) {
		this.width = width;
	}
	this.figure = null;
};
draw2d.LineBorder.prototype = new draw2d.Border();
draw2d.LineBorder.prototype.type = "draw2d.LineBorder";
draw2d.LineBorder.prototype.dispose = function() {
	draw2d.Border.prototype.dispose.call(this);
	this.figure = null;
};
draw2d.LineBorder.prototype.setLineWidth = function(w) {
	this.width = w;
	if (this.figure !== null) {
		this.figure.html.style.border = this.getHTMLStyle();
	}
};
draw2d.LineBorder.prototype.getHTMLStyle = function() {
	if (this.getColor() !== null) {
		return this.width + "px solid " + this.getColor().getHTMLStyle();
	}
	return this.width + "px solid black";
};
draw2d.LineBorder.prototype.refresh = function() {
	this.setLineWidth(this.width);
};
draw2d.Figure = function() {
	this.construct();
};
draw2d.Figure.prototype.type = "draw2d.Figure";
draw2d.Figure.ZOrderBaseIndex = 100;
draw2d.Figure.setZOrderBaseIndex = function(index) {
	draw2d.Figure.ZOrderBaseIndex = index;
};
draw2d.Figure.prototype.construct = function() {
	this.lastDragStartTime = 0;
	this.x = 0;
	this.y = 0;
	this.width = 10;
	this.height = 10;
	this.border = null;
	this.id = draw2d.UUID.create();
	this.html = this.createHTMLElement();
	this.canvas = null;
	this.workflow = null;
	this.draggable = null;
	this.parent = null;
	this.isMoving = false;
	this.canSnapToHelper = true;
	this.snapToGridAnchor = new draw2d.Point(0, 0);
	this.timer = -1;
	this.model = null;
	this.alpha = 1;
	this.alphaBeforeOnDrag = 1;
	this.properties = {};
	this.moveListener = new draw2d.ArrayList();
	this.setDimension(this.width, this.height);
	this.setDeleteable(true);
	this.setCanDrag(true);
	this.setResizeable(true);
	this.setSelectable(true);
};
draw2d.Figure.prototype.dispose = function() {
	
	this.canvas = null;
	this.workflow = null;
	this.moveListener = null;
	if (this.draggable !== null) {
		this.draggable.removeEventListener("mouseenter", this.tmpMouseEnter);
		this.draggable.removeEventListener("mouseleave", this.tmpMouseLeave);
		this.draggable.removeEventListener("dragend", this.tmpDragend);
		this.draggable.removeEventListener("dragstart", this.tmpDragstart);
		this.draggable.removeEventListener("drag", this.tmpDrag);
		this.draggable.removeEventListener("dblclick", this.tmpDoubleClick);
		this.draggable.node = null;
		this.draggable.target.removeAllElements();
	}
	this.draggable = null;
	if (this.border !== null) {
		this.border.dispose();
	}
	this.border = null;
	if (this.parent !== null) {
		this.parent.removeChild(this);
	}
};
draw2d.Figure.prototype.getProperties = function() {
	return this.properties;
};
draw2d.Figure.prototype.getProperty = function(key) {
	return this.properties[key];
};
draw2d.Figure.prototype.setProperty = function(key, value) {
	this.properties[key] = value;
	this.setDocumentDirty();
};
draw2d.Figure.prototype.getId = function() {
	return this.id;
};
draw2d.Figure.prototype.setId = function(id) {
	this.id = id;
	if (this.html !== null) {
		this.html.id = id;
	}
};
draw2d.Figure.prototype.setCanvas = function(_59c6) {
	this.canvas = _59c6;
};
draw2d.Figure.prototype.getWorkflow = function() {
	return this.workflow;
};
draw2d.Figure.prototype.setWorkflow = function(_59c7) {
	
	if (this.draggable === null) {
		this.html.tabIndex = "0";
		var oThis = this;
		this.keyDown = function(event) {
			event.cancelBubble = true;
			event.returnValue = true;
			oThis.onKeyDown(event.keyCode, event.ctrlKey);
		};
		if (this.html.addEventListener) {
			this.html.addEventListener("keydown", this.keyDown, false);
		} else {
			if (this.html.attachEvent) {
				this.html.attachEvent("onkeydown", this.keyDown);
			}
		}
		this.draggable = new draw2d.Draggable(this.html,
				draw2d.Draggable.DRAG_X | draw2d.Draggable.DRAG_Y);
		this.draggable.node = this;
		this.tmpContextMenu = function(_59ca) {
			oThis.onContextMenu(oThis.x + _59ca.x, _59ca.y + oThis.y);
		};
		this.tmpMouseEnter = function(_59cb) {
			oThis.onMouseEnter();
		};
		this.tmpMouseLeave = function(_59cc) {
			oThis.onMouseLeave();
		};
		this.tmpDragend = function(_59cd) {
			oThis.onDragend();
		};
		this.tmpDragstart = function(_59ce) {
			var w = oThis.workflow;
			w.showMenu(null);
			if (w.toolPalette && w.toolPalette.activeTool) {
				_59ce.returnValue = false;
				w.onMouseDown(oThis.x + _59ce.x, _59ce.y + oThis.y);
				w.onMouseUp(oThis.x + _59ce.x, _59ce.y + oThis.y);
				return;
			}
			if (!(oThis instanceof draw2d.ResizeHandle)
					&& !(oThis instanceof draw2d.Port)) {
				var line = w.getBestLine(oThis.x + _59ce.x, _59ce.y + oThis.y);
				if (line !== null) {
					_59ce.returnValue = false;
					w.setCurrentSelection(line);
					w.showLineResizeHandles(line);
					w.onMouseDown(oThis.x + _59ce.x, _59ce.y + oThis.y);
					return;
				} else {
					if (oThis.isSelectable()) {
						w.showResizeHandles(oThis);
						w.setCurrentSelection(oThis);
					}
				}
			}
			_59ce.returnValue = oThis.onDragstart(_59ce.x, _59ce.y);
		};
		this.tmpDrag = function(_59d1) {
			oThis.onDrag();
		};
		this.tmpDoubleClick = function(_59d2) {
			oThis.onDoubleClick();
		};
		this.draggable.addEventListener("contextmenu", this.tmpContextMenu);
		this.draggable.addEventListener("mouseenter", this.tmpMouseEnter);
		this.draggable.addEventListener("mouseleave", this.tmpMouseLeave);
		this.draggable.addEventListener("dragend", this.tmpDragend);
		this.draggable.addEventListener("dragstart", this.tmpDragstart);
		this.draggable.addEventListener("drag", this.tmpDrag);
		this.draggable.addEventListener("dblclick", this.tmpDoubleClick);
	}
	this.workflow = _59c7;
};
draw2d.Figure.prototype.createHTMLElement = function() {
	var item = document.createElement("div");
	item.id = this.id;
	item.style.position = "absolute";
	item.style.left = this.x + "px";
	item.style.top = this.y + "px";
	item.style.height = this.width + "px";
	item.style.width = this.height + "px";
	item.style.margin = "0px";
	item.style.padding = "0px";
	item.style.outline = "none";
	item.style.zIndex = "" + draw2d.Figure.ZOrderBaseIndex;
	return item;
};
draw2d.Figure.prototype.setParent = function(_59d4) {
	this.parent = _59d4;
};
draw2d.Figure.prototype.getParent = function() {
	return this.parent;
};
draw2d.Figure.prototype.getZOrder = function() {
	return this.html.style.zIndex;
};
draw2d.Figure.prototype.setZOrder = function(index) {
	this.html.style.zIndex = index;
};
draw2d.Figure.prototype.hasFixedPosition = function() {
	return false;
};
draw2d.Figure.prototype.getMinWidth = function() {
	return 5;
};
draw2d.Figure.prototype.getMinHeight = function() {
	return 5;
};
draw2d.Figure.prototype.getHTMLElement = function() {
	if (this.html === null) {
		this.html = this.createHTMLElement();
	}
	return this.html;
};
draw2d.Figure.prototype.paint = function() {
};
draw2d.Figure.prototype.setBorder = function(_59d6) {
	if (this.border !== null) {
		this.border.figure = null;
	}
	this.border = _59d6;
	this.border.figure = this;
	this.border.refresh();
	this.setDocumentDirty();
};
draw2d.Figure.prototype.onRemove = function(_59d7) {
};
draw2d.Figure.prototype.onContextMenu = function(x, y) {
	var menu = this.getContextMenu();
	if (menu !== null) {
		this.workflow.showMenu(menu, x, y);
	}
};
draw2d.Figure.prototype.getContextMenu = function() {
	return null;
};
draw2d.Figure.prototype.onDoubleClick = function() {
	this.figureDoubleClick();
	
};

draw2d.Figure.prototype.figureDoubleClick = function() {
	return null;
};

draw2d.Figure.prototype.onMouseEnter = function() {
};
draw2d.Figure.prototype.onMouseLeave = function() {
};
draw2d.Figure.prototype.onDrag = function() {
	this.x = this.draggable.getLeft();
	this.y = this.draggable.getTop();
	if (this.isMoving == false) {
		this.isMoving = true;
		this.alphaBeforeOnDrag = this.getAlpha();
		this.setAlpha(this.alphaBeforeOnDrag * 0.5);
	}
	this.fireMoveEvent();
};
draw2d.Figure.prototype.onDragend = function() {
	if (this.getWorkflow().getEnableSmoothFigureHandling() === true) {
		var oThis = this;
		var _59dc = function() {
			if (oThis.alpha < oThis.alphaBeforeOnDrag) {
				oThis.setAlpha(Math.min(1, oThis.alpha + 0.05));
			} else {
				window.clearInterval(oThis.timer);
				oThis.timer = -1;
			}
		};
		if (oThis.timer > 0) {
			window.clearInterval(oThis.timer);
		}
		oThis.timer = window.setInterval(_59dc, 20);
	} else {
		this.setAlpha(this.alphaBeforeOnDrag);
	}
	this.command.setPosition(this.x, this.y);
	this.workflow.commandStack.execute(this.command);
	this.command = null;
	this.isMoving = false;
	this.workflow.hideSnapToHelperLines();
	this.fireMoveEvent();
};
draw2d.Figure.prototype.onDragstart = function(x, y) {
	this.command = this.createCommand(new draw2d.EditPolicy(
			draw2d.EditPolicy.MOVE));
	return this.command !== null;
};
draw2d.Figure.prototype.setCanDrag = function(flag) {
	this.canDrag = flag;
	if (flag) {
		this.html.style.cursor = "move";
	} else {
		this.html.style.cursor = "";
	}
};
draw2d.Figure.prototype.getCanDrag = function() {
	return this.canDrag;
};
draw2d.Figure.prototype.setAlpha = function(_59e0) {
	if (this.alpha === _59e0) {
		return;
	}
	this.alpha = Math.max(0, Math.min(1, _59e0));
	if (this.alpha == 1) {
		this.html.style.filter = "";
		this.html.style.opacity = "";
	} else {
		this.html.style.filter = "alpha(opacity="
				+ Math.round(this.alpha * 100) + ")";
		this.html.style.opacity = this.alpha;
	}
};
draw2d.Figure.prototype.getAlpha = function() {
	return this.alpha;
};
draw2d.Figure.prototype.setDimension = function(w, h) {
	this.width = Math.max(this.getMinWidth(), w);
	this.height = Math.max(this.getMinHeight(), h);
	if (this.html === null) {
		return;
	}
	this.html.style.width = this.width + "px";
	this.html.style.height = this.height + "px";
	this.fireMoveEvent();
	if (this.workflow !== null && this.workflow.getCurrentSelection() == this) {
		this.workflow.showResizeHandles(this);
	}
};
draw2d.Figure.prototype.setPosition = function(xPos, yPos) {
	this.x = xPos;
	this.y = yPos;
	if (this.html === null) {
		return;
	}
	this.html.style.left = this.x + "px";
	this.html.style.top = this.y + "px";
	this.fireMoveEvent();
	if (this.workflow !== null && this.workflow.getCurrentSelection() == this) {
		this.workflow.showResizeHandles(this);
	}
};
draw2d.Figure.prototype.isResizeable = function() {
	return this.resizeable;
};
draw2d.Figure.prototype.setResizeable = function(flag) {
	this.resizeable = flag;
};
draw2d.Figure.prototype.isSelectable = function() {
	return this.selectable;
};
draw2d.Figure.prototype.setSelectable = function(flag) {
	this.selectable = flag;
};
draw2d.Figure.prototype.isStrechable = function() {
	return true;
};
draw2d.Figure.prototype.isDeleteable = function() {
	return this.deleteable;
};
draw2d.Figure.prototype.setDeleteable = function(flag) {
	this.deleteable = flag;
};
draw2d.Figure.prototype.setCanSnapToHelper = function(flag) {
	this.canSnapToHelper = flag;
};
draw2d.Figure.prototype.getCanSnapToHelper = function() {
	return this.canSnapToHelper;
};
draw2d.Figure.prototype.getSnapToGridAnchor = function() {
	return this.snapToGridAnchor;
};
draw2d.Figure.prototype.setSnapToGridAnchor = function(point) {
	this.snapToGridAnchor = point;
};
draw2d.Figure.prototype.getBounds = function() {
	return new draw2d.Dimension(this.getX(), this.getY(), this.getWidth(), this
			.getHeight());
};
draw2d.Figure.prototype.getWidth = function() {
	return this.width;
};
draw2d.Figure.prototype.getHeight = function() {
	return this.height;
};
draw2d.Figure.prototype.getY = function() {
	return this.y;
};
draw2d.Figure.prototype.getX = function() {
	return this.x;
};
draw2d.Figure.prototype.getAbsoluteY = function() {
	return this.y;
};
draw2d.Figure.prototype.getAbsoluteX = function() {
	return this.x;
};
draw2d.Figure.prototype.onKeyDown = function(_59ea, ctrl) {
	if (_59ea == 46) {
		this.workflow.getCommandStack().execute(
				this.createCommand(new draw2d.EditPolicy(
						draw2d.EditPolicy.DELETE)));
	}
	if (ctrl) {
		this.workflow.onKeyDown(_59ea, ctrl);
	}
};
draw2d.Figure.prototype.getPosition = function() {
	return new draw2d.Point(this.x, this.y);
};
draw2d.Figure.prototype.isOver = function(iX, iY) {
	var x = this.getAbsoluteX();
	var y = this.getAbsoluteY();
	var iX2 = x + this.width;
	var iY2 = y + this.height;
	return (iX >= x && iX <= iX2 && iY >= y && iY <= iY2);
};
draw2d.Figure.prototype.attachMoveListener = function(_59f2) {
	
	if (_59f2 === null || this.moveListener === null) {
		return;
	}
	this.moveListener.add(_59f2);
};
draw2d.Figure.prototype.detachMoveListener = function(_59f3) {
	if (_59f3 === null || this.moveListener === null) {
		return;
	}
	this.moveListener.remove(_59f3);
};
draw2d.Figure.prototype.fireMoveEvent = function() {
	
	this.setDocumentDirty();
	var size = this.moveListener.getSize();
	for ( var i = 0; i < size; i++) {
		this.moveListener.get(i).onOtherFigureMoved(this);
	}
};
draw2d.Figure.prototype.setModel = function(model) {
	if (this.model !== null) {
		this.model.removePropertyChangeListener(this);
	}
	this.model = model;
	if (this.model !== null) {
		this.model.addPropertyChangeListener(this);
	}
};
draw2d.Figure.prototype.getModel = function() {
	return this.model;
};
draw2d.Figure.prototype.onOtherFigureMoved = function(_59f7) {
};
draw2d.Figure.prototype.setDocumentDirty = function() {
	if (this.workflow !== null) {
		this.workflow.setDocumentDirty();
	}
};
draw2d.Figure.prototype.disableTextSelection = function(_59f8) {
	_59f8.onselectstart = function() {
		return false;
	};
	_59f8.unselectable = "on";
	_59f8.style.MozUserSelect = "none";
	_59f8.onmousedown = function() {
		return false;
	};
};
draw2d.Figure.prototype.createCommand = function(_59f9) {
	if (_59f9.getPolicy() == draw2d.EditPolicy.MOVE) {
		if (!this.canDrag) {
			return null;
		}
		return new draw2d.CommandMove(this);
	}
	if (_59f9.getPolicy() == draw2d.EditPolicy.DELETE) {
		if (!this.isDeleteable()) {
			return null;
		}
		return new draw2d.CommandDelete(this);
	}
	if (_59f9.getPolicy() == draw2d.EditPolicy.RESIZE) {
		if (!this.isResizeable()) {
			return null;
		}
		return new draw2d.CommandResize(this);
	}
	return null;
};
draw2d.Node = function() {
	this.bgColor = null;
	this.lineColor = new draw2d.Color(128, 128, 255);
	this.lineStroke = 1;
	this.ports = new draw2d.ArrayList();
	draw2d.Figure.call(this);
};
draw2d.Node.prototype = new draw2d.Figure();
draw2d.Node.prototype.type = "draw2d.Node";
draw2d.Node.prototype.dispose = function() {
	for ( var i = 0; i < this.ports.getSize(); i++) {
		this.ports.get(i).dispose();
	}
	this.ports = null;
	draw2d.Figure.prototype.dispose.call(this);
};
draw2d.Node.prototype.createHTMLElement = function() {
	var item = draw2d.Figure.prototype.createHTMLElement.call(this);
	item.style.width = "auto";
	item.style.height = "auto";
	item.style.margin = "0px";
	item.style.padding = "0px";
	if (this.lineColor !== null) {
		item.style.border = this.lineStroke + "px solid "
				+ this.lineColor.getHTMLStyle();
	}
	item.style.fontSize = "1px";
	if (this.bgColor !== null) {
		item.style.backgroundColor = this.bgColor.getHTMLStyle();
	}
	return item;
};
draw2d.Node.prototype.paint = function() {
	draw2d.Figure.prototype.paint.call(this);
	for ( var i = 0; i < this.ports.getSize(); i++) {
		this.ports.get(i).paint();
	}
};
draw2d.Node.prototype.getPorts = function() {
	return this.ports;
};
draw2d.Node.prototype.getInputPorts = function() {
	var _4ad8 = new draw2d.ArrayList();
	for ( var i = 0; i < this.ports.getSize(); i++) {
		var port = this.ports.get(i);
		if (port instanceof draw2d.InputPort) {
			_4ad8.add(port);
		}
	}
	return _4ad8;
};
draw2d.Node.prototype.getOutputPorts = function() {
	var _4adb = new draw2d.ArrayList();
	for ( var i = 0; i < this.ports.getSize(); i++) {
		var port = this.ports.get(i);
		if (port instanceof draw2d.OutputPort) {
			_4adb.add(port);
		}
	}
	return _4adb;
};
draw2d.Node.prototype.getPort = function(_4ade) {
	if (this.ports === null) {
		return null;
	}
	for ( var i = 0; i < this.ports.getSize(); i++) {
		var port = this.ports.get(i);
		if (port.getName() == _4ade) {
			return port;
		}
	}
};
draw2d.Node.prototype.getInputPort = function(_4ae1) {
	if (this.ports === null) {
		return null;
	}
	for ( var i = 0; i < this.ports.getSize(); i++) {
		var port = this.ports.get(i);
		if (port.getName() == _4ae1 && port instanceof draw2d.InputPort) {
			return port;
		}
	}
};
draw2d.Node.prototype.getOutputPort = function(_4ae4) {
	if (this.ports === null) {
		return null;
	}
	for ( var i = 0; i < this.ports.getSize(); i++) {
		var port = this.ports.get(i);
		if (port.getName() == _4ae4 && port instanceof draw2d.OutputPort) {
			return port;
		}
	}
};
draw2d.Node.prototype.addPort = function(port, x, y) {
	this.ports.add(port);
	port.setOrigin(x, y);
	port.setPosition(x, y);
	port.setParent(this);
	port.setDeleteable(false);
	this.html.appendChild(port.getHTMLElement());
	if (this.workflow !== null) {
		this.workflow.registerPort(port);
	}
};
draw2d.Node.prototype.removePort = function(port) {
	if (this.ports !== null) {
		this.ports.remove(port);
	}
	try {
		this.html.removeChild(port.getHTMLElement());
	} catch (exc) {
	}
	if (this.workflow !== null) {
		this.workflow.unregisterPort(port);
	}
	var _4aeb = port.getConnections();
	for ( var i = 0; i < _4aeb.getSize(); ++i) {
		this.workflow.removeFigure(_4aeb.get(i));
	}
};
draw2d.Node.prototype.setWorkflow = function(_4aed) {
	var _4aee = this.workflow;
	draw2d.Figure.prototype.setWorkflow.call(this, _4aed);
	if (_4aee !== null) {
		for ( var i = 0; i < this.ports.getSize(); i++) {
			_4aee.unregisterPort(this.ports.get(i));
		}
	}
	if (this.workflow !== null) {
		for ( var i = 0; i < this.ports.getSize(); i++) {
			this.workflow.registerPort(this.ports.get(i));
		}
	}
};
draw2d.Node.prototype.setBackgroundColor = function(color) {
	this.bgColor = color;
	if (this.bgColor !== null) {
		this.html.style.backgroundColor = this.bgColor.getHTMLStyle();
	} else {
		this.html.style.backgroundColor = "transparent";
	}
};
draw2d.Node.prototype.getBackgroundColor = function() {
	return this.bgColor;
};
draw2d.Node.prototype.setColor = function(color) {
	this.lineColor = color;
	if (this.lineColor !== null) {
		this.html.style.border = this.lineStroke + "px solid "
				+ this.lineColor.getHTMLStyle();
	} else {
		this.html.style.border = "0px";
	}
};
draw2d.Node.prototype.setLineWidth = function(w) {
	this.lineStroke = w;
	if (this.lineColor !== null) {
		this.html.style.border = this.lineStroke + "px solid "
				+ this.lineColor.getHTMLStyle();
	} else {
		this.html.style.border = "0px";
	}
};
draw2d.Node.prototype.getModelSourceConnections = function() {
	throw "You must override the method [Node.prototype.getModelSourceConnections]";
};
draw2d.Node.prototype.refreshConnections = function() {
	if (this.workflow !== null) {
		this.workflow.refreshConnections(this);
	}
};
draw2d.VectorFigure = function() {
	this.bgColor = null;
	this.lineColor = new draw2d.Color(0, 0, 0);
	this.stroke = 1;
	this.graphics = null;
	draw2d.Node.call(this);
};
draw2d.VectorFigure.prototype = new draw2d.Node;
draw2d.VectorFigure.prototype.type = "draw2d.VectorFigure";
draw2d.VectorFigure.prototype.dispose = function() {
	draw2d.Node.prototype.dispose.call(this);
	this.bgColor = null;
	this.lineColor = null;
	if (this.graphics !== null) {
		this.graphics.clear();
	}
	this.graphics = null;
};
draw2d.VectorFigure.prototype.createHTMLElement = function() {
	var item = draw2d.Node.prototype.createHTMLElement.call(this);
	item.style.border = "0px";
	item.style.backgroundColor = "transparent";
	return item;
};
draw2d.VectorFigure.prototype.setWorkflow = function(_4b44) {
	draw2d.Node.prototype.setWorkflow.call(this, _4b44);
	if (this.workflow === null) {
		this.graphics.clear();
		this.graphics = null;
	}
};
draw2d.VectorFigure.prototype.paint = function() {
	if (this.html === null) {
		return;
	}
	try {
		if (this.graphics === null) {
			this.graphics = new jsGraphics(this.html);
		} else {
			this.graphics.clear();
		}
		draw2d.Node.prototype.paint.call(this);
		for ( var i = 0; i < this.ports.getSize(); i++) {
			this.getHTMLElement().appendChild(
					this.ports.get(i).getHTMLElement());
		}
	} catch (e) {
		pushErrorStack(e, "draw2d.VectorFigure.prototype.paint=function()["
				+ area + "]");
	}
};
draw2d.VectorFigure.prototype.setDimension = function(w, h) {
	draw2d.Node.prototype.setDimension.call(this, w, h);
	if (this.graphics !== null) {
		this.paint();
	}
};
draw2d.VectorFigure.prototype.setBackgroundColor = function(color) {
	this.bgColor = color;
	if (this.graphics !== null) {
		this.paint();
	}
};
draw2d.VectorFigure.prototype.getBackgroundColor = function() {
	return this.bgColor;
};
draw2d.VectorFigure.prototype.setLineWidth = function(w) {
	this.stroke = w;
	if (this.graphics !== null) {
		this.paint();
	}
};
draw2d.VectorFigure.prototype.setColor = function(color) {
	this.lineColor = color;
	if (this.graphics !== null) {
		this.paint();
	}
};
draw2d.VectorFigure.prototype.getColor = function() {
	return this.lineColor;
};
draw2d.SVGFigure = function(width, _5070) {
	this.bgColor = null;
	this.lineColor = new draw2d.Color(0, 0, 0);
	this.stroke = 1;
	this.context = null;
	draw2d.Node.call(this);
	if (width && _5070) {
		this.setDimension(width, _5070);
	}
};
draw2d.SVGFigure.prototype = new draw2d.Node();
draw2d.SVGFigure.prototype.type = "draw2d.SVGFigure";
draw2d.SVGFigure.prototype.createHTMLElement = function() {
	var item = new MooCanvas(this.id, {
		width : 100,
		height : 100
	});
	item.style.position = "absolute";
	item.style.left = this.x + "px";
	item.style.top = this.y + "px";
	item.style.zIndex = "" + draw2d.Figure.ZOrderBaseIndex;
	this.context = item.getContext("2d");
	return item;
};
draw2d.SVGFigure.prototype.paint = function() {
	this.context.clearRect(0, 0, this.getWidth(), this.getHeight());
	this.context.fillStyle = "rgba(200,0,0,0.3)";
	this.context.fillRect(0, 0, this.getWidth(), this.getHeight());
};
draw2d.SVGFigure.prototype.setDimension = function(w, h) {
	draw2d.Node.prototype.setDimension.call(this, w, h);
	this.html.width = w;
	this.html.height = h;
	this.html.style.width = w + "px";
	this.html.style.height = h + "px";
	if (this.context !== null) {
		if (this.context.element) {
			this.context.element.style.width = w + "px";
			this.context.element.style.height = h + "px";
		}
		this.paint();
	}
};
draw2d.SVGFigure.prototype.setBackgroundColor = function(color) {
	this.bgColor = color;
	if (this.graphics !== null) {
		this.paint();
	}
};
draw2d.SVGFigure.prototype.getBackgroundColor = function() {
	return this.bgColor;
};
draw2d.SVGFigure.prototype.setLineWidth = function(w) {
	this.stroke = w;
	if (this.context !== null) {
		this.paint();
	}
};
draw2d.SVGFigure.prototype.setColor = function(color) {
	this.lineColor = color;
	if (this.context !== null) {
		this.paint();
	}
};
draw2d.SVGFigure.prototype.getColor = function() {
	return this.lineColor;
};
draw2d.Label = function(msg) {
	this.msg = msg;
	this.bgColor = null;
	this.color = new draw2d.Color(0, 0, 0);
	this.fontSize = 10;
	this.textNode = null;
	this.align = "center";
	draw2d.Figure.call(this);
};
draw2d.Label.prototype = new draw2d.Figure();
draw2d.Label.prototype.type = "draw2d.Label";
draw2d.Label.prototype.createHTMLElement = function() {
	var item = draw2d.Figure.prototype.createHTMLElement.call(this);
	this.textNode = document.createTextNode(this.msg);
	item.appendChild(this.textNode);
	item.style.color = this.color.getHTMLStyle();
	item.style.fontSize = this.fontSize + "pt";
	item.style.width = "auto";
	item.style.height = "auto";
	item.style.paddingLeft = "3px";
	item.style.paddingRight = "3px";
	item.style.textAlign = this.align;
	item.style.MozUserSelect = "none";
	this.disableTextSelection(item);
	if (this.bgColor !== null) {
		item.style.backgroundColor = this.bgColor.getHTMLStyle();
	}
	return item;
};
draw2d.Label.prototype.isResizeable = function() {
	return false;
};
draw2d.Label.prototype.setWordwrap = function(flag) {
	this.html.style.whiteSpace = flag ? "wrap" : "nowrap";
};
draw2d.Label.prototype.setAlign = function(align) {
	this.align = align;
	this.html.style.textAlign = align;
};
draw2d.Label.prototype.setBackgroundColor = function(color) {
	this.bgColor = color;
	if (this.bgColor !== null) {
		this.html.style.backgroundColor = this.bgColor.getHTMLStyle();
	} else {
		this.html.style.backgroundColor = "transparent";
	}
};
draw2d.Label.prototype.setColor = function(color) {
	this.color = color;
	this.html.style.color = this.color.getHTMLStyle();
};
draw2d.Label.prototype.setFontSize = function(size) {
	this.fontSize = size;
	this.html.style.fontSize = this.fontSize + "pt";
};
draw2d.Label.prototype.setDimension = function(w, h) {
};
draw2d.Label.prototype.getWidth = function() {
	if (window.getComputedStyle) {
		return parseInt(getComputedStyle(this.html, "").getPropertyValue(
				"width"));
	}
	return parseInt(this.html.clientWidth);
};
draw2d.Label.prototype.getHeight = function() {
	if (window.getComputedStyle) {
		return parseInt(getComputedStyle(this.html, "").getPropertyValue(
				"height"));
	}
	return parseInt(this.html.clientHeight);
};
draw2d.Label.prototype.getText = function() {
	return this.msg;
};
draw2d.Label.prototype.setText = function(text) {
	this.msg = text;
	this.html.removeChild(this.textNode);
	this.textNode = document.createTextNode(this.msg);
	this.html.appendChild(this.textNode);
};
draw2d.Label.prototype.setStyledText = function(text) {
	this.msg = text;
	this.html.removeChild(this.textNode);
	this.textNode = document.createElement("div");
	this.textNode.style.whiteSpace = "nowrap";
	this.textNode.innerHTML = text;
	this.html.appendChild(this.textNode);
};
draw2d.Oval = function() {
	draw2d.VectorFigure.call(this);
};
draw2d.Oval.prototype = new draw2d.VectorFigure();
draw2d.Oval.prototype.type = "draw2d.Oval";
draw2d.Oval.prototype.paint = function() {
	if (this.html === null) {
		return;
	}
	try {
		draw2d.VectorFigure.prototype.paint.call(this);
		this.graphics.setStroke(this.stroke);
		if (this.bgColor !== null) {
			this.graphics.setColor(this.bgColor.getHTMLStyle());
			this.graphics.fillOval(0, 0, this.getWidth() - 1,
					this.getHeight() - 1);
		}
		if (this.lineColor !== null) {
			this.graphics.setColor(this.lineColor.getHTMLStyle());
			this.graphics.drawOval(0, 0, this.getWidth() - 1,
					this.getHeight() - 1);
		}
		this.graphics.paint();
	} catch (e) {
		pushErrorStack(e, "draw2d.Oval.prototype.paint=function()");
	}
};
draw2d.Circle = function(_5044) {
	draw2d.Oval.call(this);
	if (_5044) {
		this.setDimension(_5044, _5044);
	}
};
draw2d.Circle.prototype = new draw2d.Oval();
draw2d.Circle.prototype.type = "draw2d.Circle";
draw2d.Circle.prototype.setDimension = function(w, h) {
	if (w > h) {
		draw2d.Oval.prototype.setDimension.call(this, w, w);
	} else {
		draw2d.Oval.prototype.setDimension.call(this, h, h);
	}
};
draw2d.Circle.prototype.isStrechable = function() {
	return false;
};
draw2d.Rectangle = function(width, _5698) {
	this.bgColor = null;
	this.lineColor = new draw2d.Color(0, 0, 0);
	this.lineStroke = 1;
	draw2d.Figure.call(this);
	if (width && _5698) {
		this.setDimension(width, _5698);
	}
};
draw2d.Rectangle.prototype = new draw2d.Figure();
draw2d.Rectangle.prototype.type = "draw2d.Rectangle";
draw2d.Rectangle.prototype.dispose = function() {
	draw2d.Figure.prototype.dispose.call(this);
	this.bgColor = null;
	this.lineColor = null;
};
draw2d.Rectangle.prototype.createHTMLElement = function() {
	var item = draw2d.Figure.prototype.createHTMLElement.call(this);
	item.style.width = "auto";
	item.style.height = "auto";
	item.style.margin = "0px";
	item.style.padding = "0px";
	item.style.border = this.lineStroke + "px solid "
			+ this.lineColor.getHTMLStyle();
	item.style.fontSize = "1px";
	item.style.lineHeight = "1px";
	item.innerHTML = "&nbsp";
	if (this.bgColor !== null) {
		item.style.backgroundColor = this.bgColor.getHTMLStyle();
	}
	return item;
};
draw2d.Rectangle.prototype.setBackgroundColor = function(color) {
	this.bgColor = color;
	if (this.bgColor !== null) {
		this.html.style.backgroundColor = this.bgColor.getHTMLStyle();
	} else {
		this.html.style.backgroundColor = "transparent";
	}
};
draw2d.Rectangle.prototype.getBackgroundColor = function() {
	return this.bgColor;
};
draw2d.Rectangle.prototype.setColor = function(color) {
	this.lineColor = color;
	if (this.lineColor !== null) {
		this.html.style.border = this.lineStroke + "px solid "
				+ this.lineColor.getHTMLStyle();
	} else {
		this.html.style.border = this.lineStroke + "0px";
	}
};
draw2d.Rectangle.prototype.getColor = function() {
	return this.lineColor;
};
draw2d.Rectangle.prototype.getWidth = function() {
	return draw2d.Figure.prototype.getWidth.call(this) + 2 * this.lineStroke;
};
draw2d.Rectangle.prototype.getHeight = function() {
	return draw2d.Figure.prototype.getHeight.call(this) + 2 * this.lineStroke;
};
draw2d.Rectangle.prototype.setDimension = function(w, h) {
	draw2d.Figure.prototype.setDimension.call(this, w - 2 * this.lineStroke, h
			- 2 * this.lineStroke);
};
draw2d.Rectangle.prototype.setLineWidth = function(w) {
	var diff = w - this.lineStroke;
	this.setDimension(this.getWidth() - 2 * diff, this.getHeight() - 2 * diff);
	this.lineStroke = w;
	var c = "transparent";
	if (this.lineColor !== null) {
		c = this.lineColor.getHTMLStyle();
	}
	this.html.style.border = this.lineStroke + "px solid " + c;
};
draw2d.Rectangle.prototype.getLineWidth = function() {
	return this.lineStroke;
};
draw2d.ImageFigure = function(url) {
	if (url === undefined) {
		url = null;
	}
	this.url = url;
	draw2d.Node.call(this);
	this.setDimension(40, 40);
};
draw2d.ImageFigure.prototype = new draw2d.Node;
draw2d.ImageFigure.prototype.type = "draw2d.Image";
draw2d.ImageFigure.prototype.createHTMLElement = function() {
	var item = draw2d.Node.prototype.createHTMLElement.call(this);
	item.style.width = this.width + "px";
	item.style.height = this.height + "px";
	item.style.margin = "0px";
	item.style.padding = "0px";
	item.style.border = "0px";
	if (this.url !== null) {
		item.style.backgroundImage = "url(" + this.url + ")";
	} else {
		item.style.backgroundImage = "";
	}
	return item;
};
draw2d.ImageFigure.prototype.setColor = function(color) {
};
draw2d.ImageFigure.prototype.isResizeable = function() {
	return false;
};
draw2d.ImageFigure.prototype.setImage = function(url) {
	if (url === undefined) {
		url = null;
	}
	this.url = url;
	if (this.url !== null) {
		this.html.style.backgroundImage = "url(" + this.url + ")";
	} else {
		this.html.style.backgroundImage = "";
	}
};
draw2d.Port = function(_5730, _5731) {
	Corona = function() {
	};
	Corona.prototype = new draw2d.Circle();
	Corona.prototype.setAlpha = function(_5732) {
		draw2d.Circle.prototype.setAlpha.call(this, Math.min(0.3, _5732));
		this.setDeleteable(false);
		this.setCanDrag(false);
		this.setResizeable(false);
		this.setSelectable(false);
	};
	if (_5730 === null || _5730 === undefined) {
		this.currentUIRepresentation = new draw2d.Circle();
	} else {
		this.currentUIRepresentation = _5730;
	}
	if (_5731 === null || _5731 === undefined) {
		this.connectedUIRepresentation = new draw2d.Circle();
		this.connectedUIRepresentation.setColor(null);
	} else {
		this.connectedUIRepresentation = _5731;
	}
	this.disconnectedUIRepresentation = this.currentUIRepresentation;
	this.hideIfConnected = false;
	this.uiRepresentationAdded = true;
	this.parentNode = null;
	this.originX = 0;
	this.originY = 0;
	this.coronaWidth = 10;
	this.corona = null;
	draw2d.Rectangle.call(this);
	this.setDimension(8, 8);
	this.setBackgroundColor(new draw2d.Color(100, 180, 100));
	this.setColor(new draw2d.Color(90, 150, 90));
	draw2d.Rectangle.prototype.setColor.call(this, null);
	this.dropable = new draw2d.DropTarget(this.html);
	this.dropable.node = this;
	this.dropable.addEventListener("dragenter", function(_5733) {
		_5733.target.node.onDragEnter(_5733.relatedTarget.node);
	});
	this.dropable.addEventListener("dragleave", function(_5734) {
		_5734.target.node.onDragLeave(_5734.relatedTarget.node);
	});
	this.dropable.addEventListener("drop", function(_5735) {
		_5735.relatedTarget.node.onDrop(_5735.target.node);
	});
};
draw2d.Port.prototype = new draw2d.Rectangle();
draw2d.Port.prototype.type = "draw2d.Port";
draw2d.Port.ZOrderBaseIndex = 5000;
draw2d.Port.setZOrderBaseIndex = function(index) {
	draw2d.Port.ZOrderBaseIndex = index;
};
draw2d.Port.prototype.setHideIfConnected = function(flag) {
	this.hideIfConnected = flag;
};
draw2d.Port.prototype.dispose = function() {
	var size = this.moveListener.getSize();
	for ( var i = 0; i < size; i++) {
		var _573a = this.moveListener.get(i);
		this.parentNode.workflow.removeFigure(_573a);
		_573a.dispose();
	}
	draw2d.Rectangle.prototype.dispose.call(this);
	this.parentNode = null;
	this.dropable.node = null;
	this.dropable = null;
	this.disconnectedUIRepresentation.dispose();
	this.connectedUIRepresentation.dispose();
};
draw2d.Port.prototype.createHTMLElement = function() {
	var item = draw2d.Rectangle.prototype.createHTMLElement.call(this);
	item.style.zIndex = draw2d.Port.ZOrderBaseIndex;
	this.currentUIRepresentation.html.zIndex = draw2d.Port.ZOrderBaseIndex;
	item.appendChild(this.currentUIRepresentation.html);
	this.uiRepresentationAdded = true;
	return item;
};
draw2d.Port.prototype.setUiRepresentation = function(_573c) {
	if (_573c === null) {
		_573c = new draw2d.Figure();
	}
	if (this.uiRepresentationAdded) {
		this.html.removeChild(this.currentUIRepresentation.getHTMLElement());
	}
	this.html.appendChild(_573c.getHTMLElement());
	_573c.paint();
	this.currentUIRepresentation = _573c;
};
draw2d.Port.prototype.onMouseEnter = function() {
	this.setLineWidth(2);
};
draw2d.Port.prototype.onMouseLeave = function() {
	this.setLineWidth(0);
};
draw2d.Port.prototype.setDimension = function(width, _573e) {
	draw2d.Rectangle.prototype.setDimension.call(this, width, _573e);
	this.connectedUIRepresentation.setDimension(width, _573e);
	this.disconnectedUIRepresentation.setDimension(width, _573e);
	this.setPosition(this.x, this.y);
};
draw2d.Port.prototype.setBackgroundColor = function(color) {
	this.currentUIRepresentation.setBackgroundColor(color);
};
draw2d.Port.prototype.getBackgroundColor = function() {
	return this.currentUIRepresentation.getBackgroundColor();
};
draw2d.Port.prototype.getConnections = function() {
	var _5740 = new draw2d.ArrayList();
	var size = this.moveListener.getSize();
	for ( var i = 0; i < size; i++) {
		var _5743 = this.moveListener.get(i);
		if (_5743 instanceof draw2d.Connection) {
			_5740.add(_5743);
		}
	}
	return _5740;
};
draw2d.Port.prototype.setColor = function(color) {
	this.currentUIRepresentation.setColor(color);
};
draw2d.Port.prototype.getColor = function() {
	return this.currentUIRepresentation.getColor();
};
draw2d.Port.prototype.setLineWidth = function(width) {
	this.currentUIRepresentation.setLineWidth(width);
};
draw2d.Port.prototype.getLineWidth = function() {
	return this.currentUIRepresentation.getLineWidth();
};
draw2d.Port.prototype.paint = function() {
	try {
		this.currentUIRepresentation.paint();
	} catch (e) {
		pushErrorStack(e, "draw2d.Port.prototype.paint=function()");
	}
};
draw2d.Port.prototype.setPosition = function(xPos, yPos) {
	this.originX = xPos;
	this.originY = yPos;
	draw2d.Rectangle.prototype.setPosition.call(this, xPos, yPos);
	if (this.html === null) {
		return;
	}
	this.html.style.left = (this.x - this.getWidth() / 2) + "px";
	this.html.style.top = (this.y - this.getHeight() / 2) + "px";
};
draw2d.Port.prototype.setParent = function(_5748) {
	if (this.parentNode !== null) {
		this.parentNode.detachMoveListener(this);
	}
	this.parentNode = _5748;
	if (this.parentNode !== null) {
		this.parentNode.attachMoveListener(this);
	}
};
draw2d.Port.prototype.attachMoveListener = function(_5749) {
	draw2d.Rectangle.prototype.attachMoveListener.call(this, _5749);
	if (this.hideIfConnected == true) {
		this.setUiRepresentation(this.connectedUIRepresentation);
	}
};
draw2d.Port.prototype.detachMoveListener = function(_574a) {
	draw2d.Rectangle.prototype.detachMoveListener.call(this, _574a);
	if (this.getConnections().getSize() == 0) {
		this.setUiRepresentation(this.disconnectedUIRepresentation);
	}
};
draw2d.Port.prototype.getParent = function() {
	return this.parentNode;
};
draw2d.Port.prototype.onDrag = function() {
	draw2d.Rectangle.prototype.onDrag.call(this);
	this.parentNode.workflow.showConnectionLine(this.parentNode.x + this.x,
			this.parentNode.y + this.y, this.parentNode.x + this.originX,
			this.parentNode.y + this.originY);
};
draw2d.Port.prototype.getCoronaWidth = function() {
	return this.coronaWidth;
};
draw2d.Port.prototype.setCoronaWidth = function(width) {
	this.coronaWidth = width;
};
draw2d.Port.prototype.setOrigin = function(x, y) {
	this.originX = x;
	this.originY = y;
};
draw2d.Port.prototype.onDragend = function() {
	this.setAlpha(1);
	this.setPosition(this.originX, this.originY);
	this.parentNode.workflow.hideConnectionLine();
	document.body.focus();
};
draw2d.Port.prototype.onDragEnter = function(port) {
	var _574f = new draw2d.EditPolicy(draw2d.EditPolicy.CONNECT);
	_574f.canvas = this.parentNode.workflow;
	_574f.source = port;
	_574f.target = this;
	var _5750 = this.createCommand(_574f);
	if (_5750 === null) {
		return;
	}
	this.parentNode.workflow.connectionLine
			.setColor(new draw2d.Color(0, 150, 0));
	this.parentNode.workflow.connectionLine.setLineWidth(3);
	this.showCorona(true);
};
draw2d.Port.prototype.onDragLeave = function(port) {
	this.parentNode.workflow.connectionLine.setColor(new draw2d.Color(0, 0, 0));
	this.parentNode.workflow.connectionLine.setLineWidth(1);
	this.showCorona(false);
};
draw2d.Port.prototype.onDrop = function(port) {
	var _5753 = new draw2d.EditPolicy(draw2d.EditPolicy.CONNECT);
	_5753.canvas = this.parentNode.workflow;
	_5753.source = port;
	_5753.target = this;
	var _5754 = this.createCommand(_5753);
	if (_5754 !== null) {
		this.parentNode.workflow.getCommandStack().execute(_5754);
	}
};
draw2d.Port.prototype.getAbsolutePosition = function() {
	return new draw2d.Point(this.getAbsoluteX(), this.getAbsoluteY());
};
draw2d.Port.prototype.getAbsoluteBounds = function() {
	return new draw2d.Dimension(this.getAbsoluteX(), this.getAbsoluteY(), this
			.getWidth(), this.getHeight());
};
draw2d.Port.prototype.getAbsoluteY = function() {
	return this.originY + this.parentNode.getY();
};
draw2d.Port.prototype.getAbsoluteX = function() {
	return this.originX + this.parentNode.getX();
};
draw2d.Port.prototype.onOtherFigureMoved = function(_5755) {
	this.fireMoveEvent();
};
draw2d.Port.prototype.getName = function() {
	return this.name;
};
draw2d.Port.prototype.setName = function(name) {
	this.name = name;
};
draw2d.Port.prototype.isOver = function(iX, iY) {
	var x = this.getAbsoluteX() - this.coronaWidth - this.getWidth() / 2;
	var y = this.getAbsoluteY() - this.coronaWidth - this.getHeight() / 2;
	var iX2 = x + this.width + (this.coronaWidth * 2) + this.getWidth() / 2;
	var iY2 = y + this.height + (this.coronaWidth * 2) + this.getHeight() / 2;
	return (iX >= x && iX <= iX2 && iY >= y && iY <= iY2);
};
draw2d.Port.prototype.showCorona = function(flag, _575e) {
	if (flag === true) {
		this.corona = new Corona();
		this.corona.setAlpha(0.3);
		this.corona.setBackgroundColor(new draw2d.Color(0, 125, 125));
		this.corona.setColor(null);
		this.corona.setDimension(this.getWidth() + (this.getCoronaWidth() * 2),
				this.getWidth() + (this.getCoronaWidth() * 2));
		this.parentNode.getWorkflow().addFigure(
				this.corona,
				this.getAbsoluteX() - this.getCoronaWidth() - this.getWidth()
						/ 2,
				this.getAbsoluteY() - this.getCoronaWidth() - this.getHeight()
						/ 2);
	} else {
		if (flag === false && this.corona !== null) {
			this.parentNode.getWorkflow().removeFigure(this.corona);
			this.corona = null;
		}
	}
};
draw2d.Port.prototype.createCommand = function(_575f) {
	if (_575f.getPolicy() === draw2d.EditPolicy.MOVE) {
		if (!this.canDrag) {
			return null;
		}
		return new draw2d.CommandMovePort(this);
	}
	if (_575f.getPolicy() === draw2d.EditPolicy.CONNECT) {
		if (_575f.source.parentNode.id === _575f.target.parentNode.id) {
			return null;
		} else {
			return new draw2d.CommandConnect(_575f.canvas, _575f.source,
					_575f.target);
		}
	}
	return null;
};
draw2d.InputPort = function(_590b) {
	draw2d.Port.call(this, _590b);
};
draw2d.InputPort.prototype = new draw2d.Port();
draw2d.InputPort.prototype.type = "draw2d.InputPort";
draw2d.InputPort.prototype.onDragstart = function(x, y) {
	if (!this.canDrag) {
		return false;
	}
	return true;
};
draw2d.InputPort.prototype.onDragEnter = function(port) {
	if (port instanceof draw2d.OutputPort) {
		draw2d.Port.prototype.onDragEnter.call(this, port);
	} else {
		if (port instanceof draw2d.LineStartResizeHandle) {
			var line = this.workflow.currentSelection;
			if (line instanceof draw2d.Connection
					&& line.getSource() instanceof draw2d.InputPort) {
				draw2d.Port.prototype.onDragEnter.call(this, line.getTarget());
			}
		} else {
			if (port instanceof draw2d.LineEndResizeHandle) {
				var line = this.workflow.currentSelection;
				if (line instanceof draw2d.Connection
						&& line.getTarget() instanceof draw2d.InputPort) {
					draw2d.Port.prototype.onDragEnter.call(this, line
							.getSource());
				}
			}
		}
	}
};
draw2d.InputPort.prototype.onDragLeave = function(port) {
	if (port instanceof draw2d.OutputPort) {
		draw2d.Port.prototype.onDragLeave.call(this, port);
	} else {
		if (port instanceof draw2d.LineStartResizeHandle) {
			var line = this.workflow.currentSelection;
			if (line instanceof draw2d.Connection
					&& line.getSource() instanceof draw2d.InputPort) {
				draw2d.Port.prototype.onDragLeave.call(this, line.getTarget());
			}
		} else {
			if (port instanceof draw2d.LineEndResizeHandle) {
				var line = this.workflow.currentSelection;
				if (line instanceof draw2d.Connection
						&& line.getTarget() instanceof draw2d.InputPort) {
					draw2d.Port.prototype.onDragLeave.call(this, line
							.getSource());
				}
			}
		}
	}
};
draw2d.InputPort.prototype.createCommand = function(_5912) {
	if (_5912.getPolicy() == draw2d.EditPolicy.CONNECT) {
		if (_5912.source.parentNode.id == _5912.target.parentNode.id) {
			return null;
		}
		if (_5912.source instanceof draw2d.OutputPort) {
			return new draw2d.CommandConnect(_5912.canvas, _5912.source,
					_5912.target);
		}
		return null;
	}
	return draw2d.Port.prototype.createCommand.call(this, _5912);
};
draw2d.OutputPort = function(_5ca2) {
	draw2d.Port.call(this, _5ca2);
	this.maxFanOut = 100;
};
draw2d.OutputPort.prototype = new draw2d.Port();
draw2d.OutputPort.prototype.type = "draw2d.OutputPort";
draw2d.OutputPort.prototype.onDragEnter = function(port) {
	if (this.getMaxFanOut() <= this.getFanOut()) {
		return;
	}
	if (port instanceof draw2d.InputPort) {
		draw2d.Port.prototype.onDragEnter.call(this, port);
	} else {
		if (port instanceof draw2d.LineStartResizeHandle) {
			var line = this.workflow.currentSelection;
			if (line instanceof draw2d.Connection
					&& line.getSource() instanceof draw2d.OutputPort) {
				draw2d.Port.prototype.onDragEnter.call(this, line.getTarget());
			}
		} else {
			if (port instanceof draw2d.LineEndResizeHandle) {
				var line = this.workflow.currentSelection;
				if (line instanceof draw2d.Connection
						&& line.getTarget() instanceof draw2d.OutputPort) {
					draw2d.Port.prototype.onDragEnter.call(this, line
							.getSource());
				}
			}
		}
	}
};
draw2d.OutputPort.prototype.onDragLeave = function(port) {
	if (port instanceof draw2d.InputPort) {
		draw2d.Port.prototype.onDragLeave.call(this, port);
	} else {
		if (port instanceof draw2d.LineStartResizeHandle) {
			var line = this.workflow.currentSelection;
			if (line instanceof draw2d.Connection
					&& line.getSource() instanceof draw2d.OutputPort) {
				draw2d.Port.prototype.onDragLeave.call(this, line.getTarget());
			}
		} else {
			if (port instanceof draw2d.LineEndResizeHandle) {
				var line = this.workflow.currentSelection;
				if (line instanceof draw2d.Connection
						&& line.getTarget() instanceof draw2d.OutputPort) {
					draw2d.Port.prototype.onDragLeave.call(this, line
							.getSource());
				}
			}
		}
	}
};
draw2d.OutputPort.prototype.onDragstart = function(x, y) {
	if (!this.canDrag) {
		return false;
	}
	if (this.maxFanOut === -1) {
		return true;
	}
	if (this.getMaxFanOut() <= this.getFanOut()) {
		return false;
	}
	return true;
};
draw2d.OutputPort.prototype.setMaxFanOut = function(count) {
	this.maxFanOut = count;
};
draw2d.OutputPort.prototype.getMaxFanOut = function() {
	return this.maxFanOut;
};
draw2d.OutputPort.prototype.getFanOut = function() {
	if (this.getParent().workflow === null) {
		return 0;
	}
	var count = 0;
	var lines = this.getParent().workflow.getLines();
	var size = lines.getSize();
	for ( var i = 0; i < size; i++) {
		var line = lines.get(i);
		if (line instanceof draw2d.Connection) {
			if (line.getSource() == this) {
				count++;
			} else {
				if (line.getTarget() == this) {
					count++;
				}
			}
		}
	}
	return count;
};
draw2d.OutputPort.prototype.createCommand = function(_5caf) {
	if (_5caf.getPolicy() === draw2d.EditPolicy.CONNECT) {
		if (_5caf.source.parentNode.id === _5caf.target.parentNode.id) {
			return null;
		}
		if (_5caf.source instanceof draw2d.InputPort) {
			return new draw2d.CommandConnect(_5caf.canvas, _5caf.target,
					_5caf.source);
		}
		return null;
	}
	return draw2d.Port.prototype.createCommand.call(this, _5caf);
};
draw2d.Line = function() {
	this.lineColor = new draw2d.Color(0, 0, 0);
	this.stroke = 1;
	this.canvas = null;
	this.parent = null;
	this.workflow = null;
	this.html = null;
	this.graphics = null;
	this.id = draw2d.UUID.create();
	this.startX = 30;
	this.startY = 30;
	this.endX = 100;
	this.endY = 100;
	this.alpha = 1;
	this.isMoving = false;
	this.model = null;
	this.zOrder = draw2d.Line.ZOrderBaseIndex;
	this.corona = draw2d.Line.CoronaWidth;
	this.properties = {};
	this.moveListener = new draw2d.ArrayList();
	this.setSelectable(true);
	this.setDeleteable(true);
};
draw2d.Line.prototype.type = "draw2d.Line";
draw2d.Line.ZOrderBaseIndex = 200;
draw2d.Line.ZOrderBaseIndex = 200;
draw2d.Line.CoronaWidth = 5;
draw2d.Line.setZOrderBaseIndex = function(index) {
	draw2d.Line.ZOrderBaseIndex = index;
};
draw2d.Line.setDefaultCoronaWidth = function(width) {
	draw2d.Line.CoronaWidth = width;
};
draw2d.Line.prototype.dispose = function() {
	this.canvas = null;
	this.workflow = null;
	if (this.graphics !== null) {
		this.graphics.clear();
	}
	this.graphics = null;
};
draw2d.Line.prototype.getZOrder = function() {
	return this.zOrder;
};
draw2d.Line.prototype.setZOrder = function(index) {
	if (this.html !== null) {
		this.html.style.zIndex = index;
	}
	this.zOrder = index;
};
draw2d.Line.prototype.setCoronaWidth = function(width) {
	this.corona = width;
};
draw2d.Line.prototype.createHTMLElement = function() {
	var item = document.createElement("div");
	item.id = this.id;
	item.style.position = "absolute";
	item.style.left = "0px";
	item.style.top = "0px";
	item.style.height = "0px";
	item.style.width = "0px";
	item.style.zIndex = this.zOrder;
	return item;
};
draw2d.Line.prototype.setId = function(id) {
	this.id = id;
	if (this.html !== null) {
		this.html.id = id;
	}
};
draw2d.Line.prototype.getId = function() {
	return this.id;
};
draw2d.Line.prototype.getProperties = function() {
	return this.properties;
};
draw2d.Line.prototype.getProperty = function(key) {
	return this.properties[key];
};
draw2d.Line.prototype.setProperty = function(key, value) {
	this.properties[key] = value;
	this.setDocumentDirty();
};
draw2d.Line.prototype.getHTMLElement = function() {
	if (this.html === null) {
		this.html = this.createHTMLElement();
	}
	return this.html;
};
draw2d.Line.prototype.getWorkflow = function() {
	return this.workflow;
};
draw2d.Line.prototype.isResizeable = function() {
	return true;
};
draw2d.Line.prototype.setCanvas = function(_56ed) {
	this.canvas = _56ed;
	if (this.graphics !== null) {
		this.graphics.clear();
	}
	this.graphics = null;
};
draw2d.Line.prototype.setWorkflow = function(_56ee) {
	this.workflow = _56ee;
	if (this.graphics !== null) {
		this.graphics.clear();
	}
	this.graphics = null;
};
draw2d.Line.prototype.paint = function() {
	if (this.html === null) {
		return;
	}
	try {
		if (this.graphics === null) {
			this.graphics = new jsGraphics(this.html);
		} else {
			this.graphics.clear();
		}
		this.graphics.setStroke(this.stroke);
		this.graphics.setColor(this.lineColor.getHTMLStyle());
		this.graphics.drawLine(this.startX, this.startY, this.endX, this.endY);
		this.graphics.paint();
	} catch (e) {
		pushErrorStack(e, "draw2d.Line.prototype.paint=function()");
	}
};
draw2d.Line.prototype.attachMoveListener = function(_56ef) {
	this.moveListener.add(_56ef);
};
draw2d.Line.prototype.detachMoveListener = function(_56f0) {
	this.moveListener.remove(_56f0);
};
draw2d.Line.prototype.fireMoveEvent = function() {
	var size = this.moveListener.getSize();
	for ( var i = 0; i < size; i++) {
		this.moveListener.get(i).onOtherFigureMoved(this);
	}
};
draw2d.Line.prototype.onOtherFigureMoved = function(_56f3) {
};
draw2d.Line.prototype.setLineWidth = function(w) {
	this.stroke = w;
	if (this.graphics !== null) {
		this.paint();
	}
	this.setDocumentDirty();
};
draw2d.Line.prototype.setColor = function(color) {
	this.lineColor = color;
	if (this.graphics !== null) {
		this.paint();
	}
	this.setDocumentDirty();
};
draw2d.Line.prototype.getColor = function() {
	return this.lineColor;
};
draw2d.Line.prototype.setAlpha = function(_56f6) {
	if (_56f6 == this.alpha) {
		return;
	}
	try {
		this.html.style.MozOpacity = _56f6;
	} catch (exc1) {
	}
	try {
		this.html.style.opacity = _56f6;
	} catch (exc2) {
	}
	try {
		var _56f7 = Math.round(_56f6 * 100);
		if (_56f7 >= 99) {
			this.html.style.filter = "";
		} else {
			this.html.style.filter = "alpha(opacity=" + _56f7 + ")";
		}
	} catch (exc3) {
	}
	this.alpha = _56f6;
};
draw2d.Line.prototype.setStartPoint = function(x, y) {
	this.startX = x;
	this.startY = y;
	if (this.graphics !== null) {
		this.paint();
	}
	this.setDocumentDirty();
};
draw2d.Line.prototype.setEndPoint = function(x, y) {
	this.endX = x;
	this.endY = y;
	if (this.graphics !== null) {
		this.paint();
	}
	this.setDocumentDirty();
};
draw2d.Line.prototype.getStartX = function() {
	return this.startX;
};
draw2d.Line.prototype.getStartY = function() {
	return this.startY;
};
draw2d.Line.prototype.getStartPoint = function() {
	return new draw2d.Point(this.startX, this.startY);
};
draw2d.Line.prototype.getEndX = function() {
	return this.endX;
};
draw2d.Line.prototype.getEndY = function() {
	return this.endY;
};
draw2d.Line.prototype.getEndPoint = function() {
	return new draw2d.Point(this.endX, this.endY);
};
draw2d.Line.prototype.isSelectable = function() {
	return this.selectable;
};
draw2d.Line.prototype.setSelectable = function(flag) {
	this.selectable = flag;
};
draw2d.Line.prototype.isDeleteable = function() {
	return this.deleteable;
};
draw2d.Line.prototype.setDeleteable = function(flag) {
	this.deleteable = flag;
};
draw2d.Line.prototype.getLength = function() {
	return Math.sqrt((this.startX - this.endX) * (this.startX - this.endX)
			+ (this.startY - this.endY) * (this.startY - this.endY));
};
draw2d.Line.prototype.getAngle = function() {
	var _56fe = this.getLength();
	var angle = -(180 / Math.PI) * Math.asin((this.startY - this.endY) / _56fe);
	if (angle < 0) {
		if (this.endX < this.startX) {
			angle = Math.abs(angle) + 180;
		} else {
			angle = 360 - Math.abs(angle);
		}
	} else {
		if (this.endX < this.startX) {
			angle = 180 - angle;
		}
	}
	return angle;
};
draw2d.Line.prototype.createCommand = function(_5700) {
	if (_5700.getPolicy() == draw2d.EditPolicy.MOVE) {
		var x1 = this.getStartX();
		var y1 = this.getStartY();
		var x2 = this.getEndX();
		var y2 = this.getEndY();
		return new draw2d.CommandMoveLine(this, x1, y1, x2, y2);
	}
	if (_5700.getPolicy() == draw2d.EditPolicy.DELETE) {
		if (this.isDeleteable() == false) {
			return null;
		}
		return new draw2d.CommandDelete(this);
	}
	return null;
};
draw2d.Line.prototype.setModel = function(model) {
	if (this.model !== null) {
		this.model.removePropertyChangeListener(this);
	}
	this.model = model;
	if (this.model !== null) {
		this.model.addPropertyChangeListener(this);
	}
};
draw2d.Line.prototype.getModel = function() {
	return this.model;
};
draw2d.Line.prototype.onRemove = function(_5706) {
};
draw2d.Line.prototype.onContextMenu = function(x, y) {
	var menu = this.getContextMenu();
	if (menu !== null) {
		this.workflow.showMenu(menu, x, y);
	}
};
draw2d.Line.prototype.getContextMenu = function() {
	return null;
};
draw2d.Line.prototype.onDoubleClick = function() {
};
draw2d.Line.prototype.setDocumentDirty = function() {
	if (this.workflow !== null) {
		this.workflow.setDocumentDirty();
	}
};
draw2d.Line.prototype.containsPoint = function(px, py) {
	return draw2d.Line.hit(this.corona, this.startX, this.startY, this.endX,
			this.endY, px, py);
};
draw2d.Line.hit = function(_570c, X1, Y1, X2, Y2, px, py) {
	X2 -= X1;
	Y2 -= Y1;
	px -= X1;
	py -= Y1;
	var _5713 = px * X2 + py * Y2;
	var _5714;
	if (_5713 <= 0) {
		_5714 = 0;
	} else {
		px = X2 - px;
		py = Y2 - py;
		_5713 = px * X2 + py * Y2;
		if (_5713 <= 0) {
			_5714 = 0;
		} else {
			_5714 = _5713 * _5713 / (X2 * X2 + Y2 * Y2);
		}
	}
	var lenSq = px * px + py * py - _5714;
	if (lenSq < 0) {
		lenSq = 0;
	}
	return Math.sqrt(lenSq) < _570c;
};
draw2d.ConnectionRouter = function() {
};
draw2d.ConnectionRouter.prototype.type = "draw2d.ConnectionRouter";
draw2d.ConnectionRouter.prototype.getDirection = function(r, p) {
	var _5b2e = Math.abs(r.x - p.x);
	var _5b2f = 3;
	var i = Math.abs(r.y - p.y);
	if (i <= _5b2e) {
		_5b2e = i;
		_5b2f = 0;
	}
	i = Math.abs(r.getBottom() - p.y);
	if (i <= _5b2e) {
		_5b2e = i;
		_5b2f = 2;
	}
	i = Math.abs(r.getRight() - p.x);
	if (i < _5b2e) {
		_5b2e = i;
		_5b2f = 1;
	}
	return _5b2f;
};
draw2d.ConnectionRouter.prototype.getEndDirection = function(conn) {
	var p = conn.getEndPoint();
	var rect = conn.getTarget().getParent().getBounds();
	return this.getDirection(rect, p);
};
draw2d.ConnectionRouter.prototype.getStartDirection = function(conn) {
	var p = conn.getStartPoint();
	var rect = conn.getSource().getParent().getBounds();
	return this.getDirection(rect, p);
};
draw2d.ConnectionRouter.prototype.route = function(_5b37) {
};
draw2d.NullConnectionRouter = function() {
};
draw2d.NullConnectionRouter.prototype = new draw2d.ConnectionRouter();
draw2d.NullConnectionRouter.prototype.type = "draw2d.NullConnectionRouter";
draw2d.NullConnectionRouter.prototype.invalidate = function() {
};
draw2d.NullConnectionRouter.prototype.route = function(_4a11) {
	_4a11.addPoint(_4a11.getStartPoint());
	_4a11.addPoint(_4a11.getEndPoint());
};
draw2d.ManhattanConnectionRouter = function() {
	this.MINDIST = 20;
};
draw2d.ManhattanConnectionRouter.prototype = new draw2d.ConnectionRouter();
draw2d.ManhattanConnectionRouter.prototype.type = "draw2d.ManhattanConnectionRouter";
draw2d.ManhattanConnectionRouter.prototype.route = function(conn) {
	var _5525 = conn.getStartPoint();
	var _5526 = this.getStartDirection(conn);
	var toPt = conn.getEndPoint();
	var toDir = this.getEndDirection(conn);
	this._route(conn, toPt, toDir, _5525, _5526);
};
draw2d.ManhattanConnectionRouter.prototype._route = function(conn, _552a,
		_552b, toPt, toDir) {
	var TOL = 0.1;
	var _552f = 0.01;
	var UP = 0;
	var RIGHT = 1;
	var DOWN = 2;
	var LEFT = 3;
	var xDiff = _552a.x - toPt.x;
	var yDiff = _552a.y - toPt.y;
	var point;
	var dir;
	if (((xDiff * xDiff) < (_552f)) && ((yDiff * yDiff) < (_552f))) {
		conn.addPoint(new draw2d.Point(toPt.x, toPt.y));
		return;
	}
	if (_552b == LEFT) {
		if ((xDiff > 0) && ((yDiff * yDiff) < TOL) && (toDir === RIGHT)) {
			point = toPt;
			dir = toDir;
		} else {
			if (xDiff < 0) {
				point = new draw2d.Point(_552a.x - this.MINDIST, _552a.y);
			} else {
				if (((yDiff > 0) && (toDir === DOWN))
						|| ((yDiff < 0) && (toDir == UP))) {
					point = new draw2d.Point(toPt.x, _552a.y);
				} else {
					if (_552b == toDir) {
						var pos = Math.min(_552a.x, toPt.x) - this.MINDIST;
						point = new draw2d.Point(pos, _552a.y);
					} else {
						point = new draw2d.Point(_552a.x - (xDiff / 2), _552a.y);
					}
				}
			}
			if (yDiff > 0) {
				dir = UP;
			} else {
				dir = DOWN;
			}
		}
	} else {
		if (_552b == RIGHT) {
			if ((xDiff < 0) && ((yDiff * yDiff) < TOL) && (toDir === LEFT)) {
				point = toPt;
				dir = toDir;
			} else {
				if (xDiff > 0) {
					point = new draw2d.Point(_552a.x + this.MINDIST, _552a.y);
				} else {
					if (((yDiff > 0) && (toDir === DOWN))
							|| ((yDiff < 0) && (toDir === UP))) {
						point = new draw2d.Point(toPt.x, _552a.y);
					} else {
						if (_552b == toDir) {
							var pos = Math.max(_552a.x, toPt.x) + this.MINDIST;
							point = new draw2d.Point(pos, _552a.y);
						} else {
							point = new draw2d.Point(_552a.x - (xDiff / 2),
									_552a.y);
						}
					}
				}
				if (yDiff > 0) {
					dir = UP;
				} else {
					dir = DOWN;
				}
			}
		} else {
			if (_552b == DOWN) {
				if (((xDiff * xDiff) < TOL) && (yDiff < 0) && (toDir == UP)) {
					point = toPt;
					dir = toDir;
				} else {
					if (yDiff > 0) {
						point = new draw2d.Point(_552a.x, _552a.y
								+ this.MINDIST);
					} else {
						if (((xDiff > 0) && (toDir === RIGHT))
								|| ((xDiff < 0) && (toDir === LEFT))) {
							point = new draw2d.Point(_552a.x, toPt.y);
						} else {
							if (_552b === toDir) {
								var pos = Math.max(_552a.y, toPt.y)
										+ this.MINDIST;
								point = new draw2d.Point(_552a.x, pos);
							} else {
								point = new draw2d.Point(_552a.x, _552a.y
										- (yDiff / 2));
							}
						}
					}
					if (xDiff > 0) {
						dir = LEFT;
					} else {
						dir = RIGHT;
					}
				}
			} else {
				if (_552b == UP) {
					if (((xDiff * xDiff) < TOL) && (yDiff > 0)
							&& (toDir === DOWN)) {
						point = toPt;
						dir = toDir;
					} else {
						if (yDiff < 0) {
							point = new draw2d.Point(_552a.x, _552a.y
									- this.MINDIST);
						} else {
							if (((xDiff > 0) && (toDir === RIGHT))
									|| ((xDiff < 0) && (toDir === LEFT))) {
								point = new draw2d.Point(_552a.x, toPt.y);
							} else {
								if (_552b === toDir) {
									var pos = Math.min(_552a.y, toPt.y)
											- this.MINDIST;
									point = new draw2d.Point(_552a.x, pos);
								} else {
									point = new draw2d.Point(_552a.x, _552a.y
											- (yDiff / 2));
								}
							}
						}
						if (xDiff > 0) {
							dir = LEFT;
						} else {
							dir = RIGHT;
						}
					}
				}
			}
		}
	}
	this._route(conn, point, dir, toPt, toDir);
	conn.addPoint(_552a);
};
draw2d.BezierConnectionRouter = function(_5fa4) {
	if (!_5fa4) {
		this.cheapRouter = new draw2d.ManhattanConnectionRouter();
	} else {
		this.cheapRouter = null;
	}
	this.iteration = 5;
};
draw2d.BezierConnectionRouter.prototype = new draw2d.ConnectionRouter();
draw2d.BezierConnectionRouter.prototype.type = "draw2d.BezierConnectionRouter";
draw2d.BezierConnectionRouter.prototype.drawBezier = function(_5fa5, _5fa6, t,
		iter) {
	var n = _5fa5.length - 1;
	var q = [];
	var _5fab = n + 1;
	for ( var i = 0; i < _5fab; i++) {
		q[i] = [];
		q[i][0] = _5fa5[i];
	}
	for ( var j = 1; j <= n; j++) {
		for ( var i = 0; i <= (n - j); i++) {
			q[i][j] = new draw2d.Point((1 - t) * q[i][j - 1].x + t
					* q[i + 1][j - 1].x, (1 - t) * q[i][j - 1].y + t
					* q[i + 1][j - 1].y);
		}
	}
	var c1 = [];
	var c2 = [];
	for ( var i = 0; i < n + 1; i++) {
		c1[i] = q[0][i];
		c2[i] = q[i][n - i];
	}
	if (iter >= 0) {
		this.drawBezier(c1, _5fa6, t, --iter);
		this.drawBezier(c2, _5fa6, t, --iter);
	} else {
		for ( var i = 0; i < n; i++) {
			_5fa6.push(q[i][n - i]);
		}
	}
};
draw2d.BezierConnectionRouter.prototype.route = function(conn) {
	if (this.cheapRouter !== null
			&& (conn.getSource().getParent().isMoving === true || conn
					.getTarget().getParent().isMoving === true)) {
		this.cheapRouter.route(conn);
		return;
	}
	var _5fb1 = [];
	var _5fb2 = conn.getStartPoint();
	var toPt = conn.getEndPoint();
	this._route(_5fb1, conn, toPt, this.getEndDirection(conn), _5fb2, this
			.getStartDirection(conn));
	var _5fb4 = [];
	this.drawBezier(_5fb1, _5fb4, 0.5, this.iteration);
	for ( var i = 0; i < _5fb4.length; i++) {
		conn.addPoint(_5fb4[i]);
	}
	conn.addPoint(toPt);
};
draw2d.BezierConnectionRouter.prototype._route = function(_5fb6, conn, _5fb8,
		_5fb9, toPt, toDir) {
	var TOL = 0.1;
	var _5fbd = 0.01;
	var _5fbe = 90;
	var UP = 0;
	var RIGHT = 1;
	var DOWN = 2;
	var LEFT = 3;
	var xDiff = _5fb8.x - toPt.x;
	var yDiff = _5fb8.y - toPt.y;
	var point;
	var dir;
	if (((xDiff * xDiff) < (_5fbd)) && ((yDiff * yDiff) < (_5fbd))) {
		_5fb6.push(new draw2d.Point(toPt.x, toPt.y));
		return;
	}
	if (_5fb9 === LEFT) {
		if ((xDiff > 0) && ((yDiff * yDiff) < TOL) && (toDir === RIGHT)) {
			point = toPt;
			dir = toDir;
		} else {
			if (xDiff < 0) {
				point = new draw2d.Point(_5fb8.x - _5fbe, _5fb8.y);
			} else {
				if (((yDiff > 0) && (toDir === DOWN))
						|| ((yDiff < 0) && (toDir === UP))) {
					point = new draw2d.Point(toPt.x, _5fb8.y);
				} else {
					if (_5fb9 === toDir) {
						var pos = Math.min(_5fb8.x, toPt.x) - _5fbe;
						point = new draw2d.Point(pos, _5fb8.y);
					} else {
						point = new draw2d.Point(_5fb8.x - (xDiff / 2), _5fb8.y);
					}
				}
			}
			if (yDiff > 0) {
				dir = UP;
			} else {
				dir = DOWN;
			}
		}
	} else {
		if (_5fb9 === RIGHT) {
			if ((xDiff < 0) && ((yDiff * yDiff) < TOL) && (toDir == LEFT)) {
				point = toPt;
				dir = toDir;
			} else {
				if (xDiff > 0) {
					point = new draw2d.Point(_5fb8.x + _5fbe, _5fb8.y);
				} else {
					if (((yDiff > 0) && (toDir === DOWN))
							|| ((yDiff < 0) && (toDir === UP))) {
						point = new draw2d.Point(toPt.x, _5fb8.y);
					} else {
						if (_5fb9 === toDir) {
							var pos = Math.max(_5fb8.x, toPt.x) + _5fbe;
							point = new draw2d.Point(pos, _5fb8.y);
						} else {
							point = new draw2d.Point(_5fb8.x - (xDiff / 2),
									_5fb8.y);
						}
					}
				}
				if (yDiff > 0) {
					dir = UP;
				} else {
					dir = DOWN;
				}
			}
		} else {
			if (_5fb9 === DOWN) {
				if (((xDiff * xDiff) < TOL) && (yDiff < 0) && (toDir === UP)) {
					point = toPt;
					dir = toDir;
				} else {
					if (yDiff > 0) {
						point = new draw2d.Point(_5fb8.x, _5fb8.y + _5fbe);
					} else {
						if (((xDiff > 0) && (toDir === RIGHT))
								|| ((xDiff < 0) && (toDir === LEFT))) {
							point = new draw2d.Point(_5fb8.x, toPt.y);
						} else {
							if (_5fb9 === toDir) {
								var pos = Math.max(_5fb8.y, toPt.y) + _5fbe;
								point = new draw2d.Point(_5fb8.x, pos);
							} else {
								point = new draw2d.Point(_5fb8.x, _5fb8.y
										- (yDiff / 2));
							}
						}
					}
					if (xDiff > 0) {
						dir = LEFT;
					} else {
						dir = RIGHT;
					}
				}
			} else {
				if (_5fb9 === UP) {
					if (((xDiff * xDiff) < TOL) && (yDiff > 0)
							&& (toDir === DOWN)) {
						point = toPt;
						dir = toDir;
					} else {
						if (yDiff < 0) {
							point = new draw2d.Point(_5fb8.x, _5fb8.y - _5fbe);
						} else {
							if (((xDiff > 0) && (toDir === RIGHT))
									|| ((xDiff < 0) && (toDir === LEFT))) {
								point = new draw2d.Point(_5fb8.x, toPt.y);
							} else {
								if (_5fb9 === toDir) {
									var pos = Math.min(_5fb8.y, toPt.y) - _5fbe;
									point = new draw2d.Point(_5fb8.x, pos);
								} else {
									point = new draw2d.Point(_5fb8.x, _5fb8.y
											- (yDiff / 2));
								}
							}
						}
						if (xDiff > 0) {
							dir = LEFT;
						} else {
							dir = RIGHT;
						}
					}
				}
			}
		}
	}
	this._route(_5fb6, conn, point, dir, toPt, toDir);
	_5fb6.push(_5fb8);
};
draw2d.FanConnectionRouter = function() {
};
draw2d.FanConnectionRouter.prototype = new draw2d.NullConnectionRouter();
draw2d.FanConnectionRouter.prototype.type = "draw2d.FanConnectionRouter";
draw2d.FanConnectionRouter.prototype.route = function(conn) {
	var _5680 = conn.getStartPoint();
	var toPt = conn.getEndPoint();
	var lines = conn.getSource().getConnections();
	var _5683 = new draw2d.ArrayList();
	var index = 0;
	for ( var i = 0; i < lines.getSize(); i++) {
		var _5686 = lines.get(i);
		if (_5686.getTarget() == conn.getTarget()
				|| _5686.getSource() == conn.getTarget()) {
			_5683.add(_5686);
			if (conn == _5686) {
				index = _5683.getSize();
			}
		}
	}
	if (_5683.getSize() > 1) {
		this.routeCollision(conn, index);
	} else {
		draw2d.NullConnectionRouter.prototype.route.call(this, conn);
	}
};
draw2d.FanConnectionRouter.prototype.routeNormal = function(conn) {
	conn.addPoint(conn.getStartPoint());
	conn.addPoint(conn.getEndPoint());
};
draw2d.FanConnectionRouter.prototype.routeCollision = function(conn, index) {
	var start = conn.getStartPoint();
	var end = conn.getEndPoint();
	conn.addPoint(start);
	var _568c = 10;
	var _568d = new draw2d.Point((end.x + start.x) / 2, (end.y + start.y) / 2);
	var _568e = end.getPosition(start);
	var ray;
	if (_568e == draw2d.PositionConstants.SOUTH
			|| _568e == draw2d.PositionConstants.EAST) {
		ray = new draw2d.Point(end.x - start.x, end.y - start.y);
	} else {
		ray = new draw2d.Point(start.x - end.x, start.y - end.y);
	}
	var _5690 = Math.sqrt(ray.x * ray.x + ray.y * ray.y);
	var _5691 = _568c * ray.x / _5690;
	var _5692 = _568c * ray.y / _5690;
	var _5693;
	if (index % 2 === 0) {
		_5693 = new draw2d.Point(_568d.x + (index / 2) * (-1 * _5692), _568d.y
				+ (index / 2) * _5691);
	} else {
		_5693 = new draw2d.Point(_568d.x + (index / 2) * _5692, _568d.y
				+ (index / 2) * (-1 * _5691));
	}
	conn.addPoint(_5693);
	conn.addPoint(end);
};
draw2d.Graphics = function(_6019, _601a, _601b) {
	this.jsGraphics = _6019;
	this.xt = _601b.x;
	this.yt = _601b.y;
	this.radian = _601a * Math.PI / 180;
	this.sinRadian = Math.sin(this.radian);
	this.cosRadian = Math.cos(this.radian);
};
draw2d.Graphics.prototype.setStroke = function(x) {
	this.jsGraphics.setStroke(x);
};
draw2d.Graphics.prototype.drawLine = function(x1, y1, x2, y2) {
	var _x1 = this.xt + x1 * this.cosRadian - y1 * this.sinRadian;
	var _y1 = this.yt + x1 * this.sinRadian + y1 * this.cosRadian;
	var _x2 = this.xt + x2 * this.cosRadian - y2 * this.sinRadian;
	var _y2 = this.yt + x2 * this.sinRadian + y2 * this.cosRadian;
	this.jsGraphics.drawLine(_x1, _y1, _x2, _y2);
};
draw2d.Graphics.prototype.fillRect = function(x, y, w, h) {
	var x1 = this.xt + x * this.cosRadian - y * this.sinRadian;
	var y1 = this.yt + x * this.sinRadian + y * this.cosRadian;
	var x2 = this.xt + (x + w) * this.cosRadian - y * this.sinRadian;
	var y2 = this.yt + (x + w) * this.sinRadian + y * this.cosRadian;
	var x3 = this.xt + (x + w) * this.cosRadian - (y + h) * this.sinRadian;
	var y3 = this.yt + (x + w) * this.sinRadian + (y + h) * this.cosRadian;
	var x4 = this.xt + x * this.cosRadian - (y + h) * this.sinRadian;
	var y4 = this.yt + x * this.sinRadian + (y + h) * this.cosRadian;
	this.jsGraphics.fillPolygon( [ x1, x2, x3, x4 ], [ y1, y2, y3, y4 ]);
};
draw2d.Graphics.prototype.fillPolygon = function(_6031, _6032) {
	var rotX = [];
	var rotY = [];
	for ( var i = 0; i < _6031.length; i++) {
		rotX[i] = this.xt + _6031[i] * this.cosRadian - _6032[i]
				* this.sinRadian;
		rotY[i] = this.yt + _6031[i] * this.sinRadian + _6032[i]
				* this.cosRadian;
	}
	this.jsGraphics.fillPolygon(rotX, rotY);
};
draw2d.Graphics.prototype.setColor = function(color) {
	this.jsGraphics.setColor(color.getHTMLStyle());
};
draw2d.Graphics.prototype.drawPolygon = function(_6037, _6038) {
	var rotX = [];
	var rotY = [];
	for ( var i = 0; i < _6037.length; i++) {
		rotX[i] = this.xt + _6037[i] * this.cosRadian - _6038[i]
				* this.sinRadian;
		rotY[i] = this.yt + _6037[i] * this.sinRadian + _6038[i]
				* this.cosRadian;
	}
	this.jsGraphics.drawPolygon(rotX, rotY);
};
draw2d.Connection = function() {
	draw2d.Line.call(this);
	this.sourcePort = null;
	this.targetPort = null;
	this.canDrag = true;
	this.sourceDecorator = null;
	this.targetDecorator = null;
	this.sourceAnchor = new draw2d.ConnectionAnchor();
	this.targetAnchor = new draw2d.ConnectionAnchor();
	this.router = draw2d.Connection.defaultRouter;
	this.lineSegments = new draw2d.ArrayList();
	this.children = new draw2d.ArrayList();
	this.setColor(new draw2d.Color(0, 0, 115));
	this.setLineWidth(1);
};
draw2d.Connection.prototype = new draw2d.Line();
draw2d.Connection.prototype.type = "draw2d.Connection";
draw2d.Connection.defaultRouter = new draw2d.ManhattanConnectionRouter();
draw2d.Connection.setDefaultRouter = function(_58bd) {
	draw2d.Connection.defaultRouter = _58bd;
};
draw2d.Connection.prototype.disconnect = function() {
	if (this.sourcePort !== null) {
		this.sourcePort.detachMoveListener(this);
		this.fireSourcePortRouteEvent();
	}
	if (this.targetPort !== null) {
		this.targetPort.detachMoveListener(this);
		this.fireTargetPortRouteEvent();
	}
};
draw2d.Connection.prototype.reconnect = function() {
	if (this.sourcePort !== null) {
		this.sourcePort.attachMoveListener(this);
		this.fireSourcePortRouteEvent();
	}
	if (this.targetPort !== null) {
		this.targetPort.attachMoveListener(this);
		this.fireTargetPortRouteEvent();
	}
};
draw2d.Connection.prototype.isResizeable = function() {
	return this.getCanDrag();
};
draw2d.Connection.prototype.setCanDrag = function(flag) {
	this.canDrag = flag;
};
draw2d.Connection.prototype.getCanDrag = function() {
	return this.canDrag;
};
draw2d.Connection.prototype.addFigure = function(_58bf, _58c0) {
	var entry = {};
	entry.figure = _58bf;
	entry.locator = _58c0;
	this.children.add(entry);
	if (this.graphics !== null) {
		this.paint();
	}
	var oThis = this;
	var _58c3 = function() {
		var _58c4 = arguments[0] || window.event;
		_58c4.returnValue = false;
		oThis.getWorkflow().setCurrentSelection(oThis);
		oThis.getWorkflow().showLineResizeHandles(oThis);
	};
	if (_58bf.getHTMLElement().addEventListener) {
		_58bf.getHTMLElement().addEventListener("mousedown", _58c3, false);
	} else {
		if (_58bf.getHTMLElement().attachEvent) {
			_58bf.getHTMLElement().attachEvent("onmousedown", _58c3);
		}
	}
};
draw2d.Connection.prototype.setSourceDecorator = function(_58c5) {
	this.sourceDecorator = _58c5;
	if (this.graphics !== null) {
		this.paint();
	}
};
draw2d.Connection.prototype.getSourceDecorator = function() {
	return this.sourceDecorator;
};
draw2d.Connection.prototype.setTargetDecorator = function(_58c6) {
	this.targetDecorator = _58c6;
	if (this.graphics !== null) {
		this.paint();
	}
};
draw2d.Connection.prototype.getTargetDecorator = function() {
	return this.targetDecorator;
};
draw2d.Connection.prototype.setSourceAnchor = function(_58c7) {
	this.sourceAnchor = _58c7;
	this.sourceAnchor.setOwner(this.sourcePort);
	if (this.graphics !== null) {
		this.paint();
	}
};
draw2d.Connection.prototype.setTargetAnchor = function(_58c8) {
	this.targetAnchor = _58c8;
	this.targetAnchor.setOwner(this.targetPort);
	if (this.graphics !== null) {
		this.paint();
	}
};
draw2d.Connection.prototype.setRouter = function(_58c9) {
	if (_58c9 !== null) {
		this.router = _58c9;
	} else {
		this.router = new draw2d.NullConnectionRouter();
	}
	if (this.graphics !== null) {
		this.paint();
	}
};
draw2d.Connection.prototype.getRouter = function() {
	return this.router;
};
draw2d.Connection.prototype.setWorkflow = function(_58ca) {
	draw2d.Line.prototype.setWorkflow.call(this, _58ca);
	for ( var i = 0; i < this.children.getSize(); i++) {
		this.children.get(i).isAppended = false;
	}
};
draw2d.Connection.prototype.paint = function() {
	if (this.html === null) {
		return;
	}
	try {
		for ( var i = 0; i < this.children.getSize(); i++) {
			var entry = this.children.get(i);
			if (entry.isAppended == true) {
				this.html.removeChild(entry.figure.getHTMLElement());
			}
			entry.isAppended = false;
		}
		if (this.graphics === null) {
			this.graphics = new jsGraphics(this.html);
		} else {
			this.graphics.clear();
		}
		this.graphics.setStroke(this.stroke);
		this.graphics.setColor(this.lineColor.getHTMLStyle());
		this.startStroke();
		this.router.route(this);
		if (this.getSource().getParent().isMoving == false
				&& this.getTarget().getParent().isMoving == false) {
			if (this.targetDecorator !== null) {
				this.targetDecorator.paint(new draw2d.Graphics(this.graphics,
						this.getEndAngle(), this.getEndPoint()));
			}
			if (this.sourceDecorator !== null) {
				this.sourceDecorator.paint(new draw2d.Graphics(this.graphics,
						this.getStartAngle(), this.getStartPoint()));
			}
		}
		this.finishStroke();
		for ( var i = 0; i < this.children.getSize(); i++) {
			var entry = this.children.get(i);
			this.html.appendChild(entry.figure.getHTMLElement());
			entry.isAppended = true;
			entry.locator.relocate(entry.figure);
		}
	} catch (e) {
		pushErrorStack(e, "draw2d.Connection.prototype.paint=function()");
	}
};
draw2d.Connection.prototype.getStartPoint = function() {
	if (this.isMoving == false) {
		return this.sourceAnchor.getLocation(this.targetAnchor
				.getReferencePoint());
	} else {
		return draw2d.Line.prototype.getStartPoint.call(this);
	}
};
draw2d.Connection.prototype.getEndPoint = function() {
	if (this.isMoving == false) {
		return this.targetAnchor.getLocation(this.sourceAnchor
				.getReferencePoint());
	} else {
		return draw2d.Line.prototype.getEndPoint.call(this);
	}
};
draw2d.Connection.prototype.startStroke = function() {
	this.oldPoint = null;
	this.lineSegments = new draw2d.ArrayList();
};
draw2d.Connection.prototype.finishStroke = function() {
	this.graphics.paint();
	this.oldPoint = null;
};
draw2d.Connection.prototype.getPoints = function() {
	var _58ce = new draw2d.ArrayList();
	var line = null;
	for ( var i = 0; i < this.lineSegments.getSize(); i++) {
		line = this.lineSegments.get(i);
		_58ce.add(line.start);
	}
	if (line !== null) {
		_58ce.add(line.end);
	}
	return _58ce;
};
draw2d.Connection.prototype.addPoint = function(p) {
	p = new draw2d.Point(parseInt(p.x), parseInt(p.y));
	if (this.oldPoint !== null) {
		this.graphics.drawLine(this.oldPoint.x, this.oldPoint.y, p.x, p.y);
		var line = {};
		line.start = this.oldPoint;
		line.end = p;
		this.lineSegments.add(line);
	}
	this.oldPoint = {};
	this.oldPoint.x = p.x;
	this.oldPoint.y = p.y;
};
draw2d.Connection.prototype.refreshSourcePort = function() {
	var model = this.getModel().getSourceModel();
	var _58d4 = this.getModel().getSourcePortName();
	var _58d5 = this.getWorkflow().getDocument().getFigures();
	var count = _58d5.getSize();
	for ( var i = 0; i < count; i++) {
		var _58d8 = _58d5.get(i);
		if (_58d8.getModel() == model) {
			var port = _58d8.getOutputPort(_58d4);
			this.setSource(port);
		}
	}
	this.setRouter(this.getRouter());
};
draw2d.Connection.prototype.refreshTargetPort = function() {
	var model = this.getModel().getTargetModel();
	var _58db = this.getModel().getTargetPortName();
	var _58dc = this.getWorkflow().getDocument().getFigures();
	var count = _58dc.getSize();
	for ( var i = 0; i < count; i++) {
		var _58df = _58dc.get(i);
		if (_58df.getModel() == model) {
			var port = _58df.getInputPort(_58db);
			this.setTarget(port);
		}
	}
	this.setRouter(this.getRouter());
};
draw2d.Connection.prototype.setSource = function(port) {
	if (this.sourcePort !== null) {
		this.sourcePort.detachMoveListener(this);
	}
	this.sourcePort = port;
	if (this.sourcePort === null) {
		return;
	}
	this.sourceAnchor.setOwner(this.sourcePort);
	this.fireSourcePortRouteEvent();
	this.sourcePort.attachMoveListener(this);
	this.setStartPoint(port.getAbsoluteX(), port.getAbsoluteY());
};
draw2d.Connection.prototype.getSource = function() {
	return this.sourcePort;
};
draw2d.Connection.prototype.setTarget = function(port) {
	if (this.targetPort !== null) {
		this.targetPort.detachMoveListener(this);
	}
	this.targetPort = port;
	if (this.targetPort === null) {
		return;
	}
	this.targetAnchor.setOwner(this.targetPort);
	this.fireTargetPortRouteEvent();
	this.targetPort.attachMoveListener(this);
	this.setEndPoint(port.getAbsoluteX(), port.getAbsoluteY());
};
draw2d.Connection.prototype.getTarget = function() {
	return this.targetPort;
};
draw2d.Connection.prototype.onOtherFigureMoved = function(_58e3) {
	if (_58e3 == this.sourcePort) {
		this.setStartPoint(this.sourcePort.getAbsoluteX(), this.sourcePort
				.getAbsoluteY());
	} else {
		this.setEndPoint(this.targetPort.getAbsoluteX(), this.targetPort
				.getAbsoluteY());
	}
};
draw2d.Connection.prototype.containsPoint = function(px, py) {
	for ( var i = 0; i < this.lineSegments.getSize(); i++) {
		var line = this.lineSegments.get(i);
		if (draw2d.Line.hit(this.corona, line.start.x, line.start.y,
				line.end.x, line.end.y, px, py)) {
			return true;
		}
	}
	return false;
};
draw2d.Connection.prototype.getStartAngle = function() {
	var p1 = this.lineSegments.get(0).start;
	var p2 = this.lineSegments.get(0).end;
	if (this.router instanceof draw2d.BezierConnectionRouter) {
		p2 = this.lineSegments.get(5).end;
	}
	var _58ea = Math.sqrt((p1.x - p2.x) * (p1.x - p2.x) + (p1.y - p2.y)
			* (p1.y - p2.y));
	var angle = -(180 / Math.PI) * Math.asin((p1.y - p2.y) / _58ea);
	if (angle < 0) {
		if (p2.x < p1.x) {
			angle = Math.abs(angle) + 180;
		} else {
			angle = 360 - Math.abs(angle);
		}
	} else {
		if (p2.x < p1.x) {
			angle = 180 - angle;
		}
	}
	return angle;
};
draw2d.Connection.prototype.getEndAngle = function() {
	if (this.lineSegments.getSize() === 0) {
		return 90;
	}
	var p1 = this.lineSegments.get(this.lineSegments.getSize() - 1).end;
	var p2 = this.lineSegments.get(this.lineSegments.getSize() - 1).start;
	if (this.router instanceof draw2d.BezierConnectionRouter) {
		p2 = this.lineSegments.get(this.lineSegments.getSize() - 5).end;
	}
	var _58ee = Math.sqrt((p1.x - p2.x) * (p1.x - p2.x) + (p1.y - p2.y)
			* (p1.y - p2.y));
	var angle = -(180 / Math.PI) * Math.asin((p1.y - p2.y) / _58ee);
	if (angle < 0) {
		if (p2.x < p1.x) {
			angle = Math.abs(angle) + 180;
		} else {
			angle = 360 - Math.abs(angle);
		}
	} else {
		if (p2.x < p1.x) {
			angle = 180 - angle;
		}
	}
	return angle;
};
draw2d.Connection.prototype.fireSourcePortRouteEvent = function() {
	var _58f0 = this.sourcePort.getConnections();
	for ( var i = 0; i < _58f0.getSize(); i++) {
		_58f0.get(i).paint();
	}
};
draw2d.Connection.prototype.fireTargetPortRouteEvent = function() {
	var _58f2 = this.targetPort.getConnections();
	for ( var i = 0; i < _58f2.getSize(); i++) {
		_58f2.get(i).paint();
	}
};
draw2d.Connection.prototype.createCommand = function(_58f4) {
	if (_58f4.getPolicy() == draw2d.EditPolicy.MOVE) {
		return new draw2d.CommandReconnect(this);
	}
	if (_58f4.getPolicy() == draw2d.EditPolicy.DELETE) {
		if (this.isDeleteable() == true) {
			return new draw2d.CommandDelete(this);
		}
		return null;
	}
	return null;
};
draw2d.ConnectionAnchor = function(owner) {
	this.owner = owner;
};
draw2d.ConnectionAnchor.prototype.type = "draw2d.ConnectionAnchor";
draw2d.ConnectionAnchor.prototype.getLocation = function(_5901) {
	return this.getReferencePoint();
};
draw2d.ConnectionAnchor.prototype.getOwner = function() {
	return this.owner;
};
draw2d.ConnectionAnchor.prototype.setOwner = function(owner) {
	this.owner = owner;
};
draw2d.ConnectionAnchor.prototype.getBox = function() {
	return this.getOwner().getAbsoluteBounds();
};
draw2d.ConnectionAnchor.prototype.getReferencePoint = function() {
	if (this.getOwner() === null) {
		return null;
	} else {
		return this.getOwner().getAbsolutePosition();
	}
};
draw2d.ChopboxConnectionAnchor = function(owner) {
	draw2d.ConnectionAnchor.call(this, owner);
};
draw2d.ChopboxConnectionAnchor.prototype = new draw2d.ConnectionAnchor();
draw2d.ChopboxConnectionAnchor.prototype.type = "draw2d.ChopboxConnectionAnchor";
draw2d.ChopboxConnectionAnchor.prototype.getLocation = function(_5009) {
	var r = new draw2d.Dimension();
	r.setBounds(this.getBox());
	r.translate(-1, -1);
	r.resize(1, 1);
	var _500b = r.x + r.w / 2;
	var _500c = r.y + r.h / 2;
	if (r.isEmpty() || (_5009.x == _500b && _5009.y == _500c)) {
		return new Point(_500b, _500c);
	}
	var dx = _5009.x - _500b;
	var dy = _5009.y - _500c;
	var scale = 0.5 / Math.max(Math.abs(dx) / r.w, Math.abs(dy) / r.h);
	dx *= scale;
	dy *= scale;
	_500b += dx;
	_500c += dy;
	return new draw2d.Point(Math.round(_500b), Math.round(_500c));
};
draw2d.ChopboxConnectionAnchor.prototype.getBox = function() {
	return this.getOwner().getParent().getBounds();
};
draw2d.ChopboxConnectionAnchor.prototype.getReferencePoint = function() {
	return this.getBox().getCenter();
};
draw2d.ConnectionDecorator = function() {
	this.color = new draw2d.Color(0, 0, 0);
	this.backgroundColor = new draw2d.Color(250, 250, 250);
};
draw2d.ConnectionDecorator.prototype.type = "draw2d.ConnectionDecorator";
draw2d.ConnectionDecorator.prototype.paint = function(g) {
};
draw2d.ConnectionDecorator.prototype.setColor = function(c) {
	this.color = c;
};
draw2d.ConnectionDecorator.prototype.setBackgroundColor = function(c) {
	this.backgroundColor = c;
};
draw2d.ArrowConnectionDecorator = function(_4b3e, width) {
	draw2d.ConnectionDecorator.call(this);
	if (_4b3e === undefined || _4b3e < 1) {
		this.lenght = 15;
	}
	if (width === undefined || width < 1) {
		this.width = 10;
	}
};
draw2d.ArrowConnectionDecorator.prototype = new draw2d.ConnectionDecorator();
draw2d.ArrowConnectionDecorator.prototype.type = "draw2d.ArrowConnectionDecorator";
draw2d.ArrowConnectionDecorator.prototype.paint = function(g) {
	if (this.backgroundColor !== null) {
		g.setColor(this.backgroundColor);
		g.fillPolygon( [ 3, this.lenght, this.lenght, 3 ], [ 0,
				(this.width / 2), -(this.width / 2), 0 ]);
	}
	g.setColor(this.color);
	g.setStroke(1);
	g.drawPolygon( [ 3, this.lenght, this.lenght, 3 ], [ 0, (this.width / 2),
			-(this.width / 2), 0 ]);
};
draw2d.ArrowConnectionDecorator.prototype.setDimension = function(l, width) {
	this.width = w;
	this.lenght = l;
};
draw2d.CompartmentFigure = function() {
	draw2d.Node.call(this);
	this.children = new draw2d.ArrayList();
	this.setBorder(new draw2d.LineBorder(1));
	this.dropable = new draw2d.DropTarget(this.html);
	this.dropable.node = this;
	this.dropable.addEventListener("figureenter", function(_4b0a) {
		_4b0a.target.node.onFigureEnter(_4b0a.relatedTarget.node);
	});
	this.dropable.addEventListener("figureleave", function(_4b0b) {
		_4b0b.target.node.onFigureLeave(_4b0b.relatedTarget.node);
	});
	this.dropable.addEventListener("figuredrop", function(_4b0c) {
		_4b0c.target.node.onFigureDrop(_4b0c.relatedTarget.node);
	});
};
draw2d.CompartmentFigure.prototype = new draw2d.Node();
draw2d.CompartmentFigure.prototype.type = "draw2d.CompartmentFigure";
draw2d.CompartmentFigure.prototype.onFigureEnter = function(_4b0d) {
};
draw2d.CompartmentFigure.prototype.onFigureLeave = function(_4b0e) {
};
draw2d.CompartmentFigure.prototype.onFigureDrop = function(_4b0f) {
};
draw2d.CompartmentFigure.prototype.getChildren = function() {
	return this.children;
};
draw2d.CompartmentFigure.prototype.addChild = function(_4b10) {
	_4b10.setZOrder(this.getZOrder() + 1);
	_4b10.setParent(this);
	this.children.add(_4b10);
};
draw2d.CompartmentFigure.prototype.removeChild = function(_4b11) {
	_4b11.setParent(null);
	this.children.remove(_4b11);
};
draw2d.CompartmentFigure.prototype.setZOrder = function(index) {
	draw2d.Node.prototype.setZOrder.call(this, index);
	for ( var i = 0; i < this.children.getSize(); i++) {
		this.children.get(i).setZOrder(index + 1);
	}
};
draw2d.CompartmentFigure.prototype.setPosition = function(xPos, yPos) {
	
	var oldX = this.getX();
	var oldY = this.getY();
	draw2d.Node.prototype.setPosition.call(this, xPos, yPos);
	for ( var i = 0; i < this.children.getSize(); i++) {
		var child = this.children.get(i);
		child.setPosition(child.getX() + this.getX() - oldX, child.getY()
				+ this.getY() - oldY);
	}
};
draw2d.CompartmentFigure.prototype.onDrag = function() {
	var oldX = this.getX();
	var oldY = this.getY();
	draw2d.Node.prototype.onDrag.call(this);
	for ( var i = 0; i < this.children.getSize(); i++) {
		var child = this.children.get(i);
		child.setPosition(child.getX() + this.getX() - oldX, child.getY()
				+ this.getY() - oldY);
	}
};
draw2d.CanvasDocument = function(_56a8) {
	this.canvas = _56a8;
};
draw2d.CanvasDocument.prototype.type = "draw2d.CanvasDocument";
draw2d.CanvasDocument.prototype.getFigures = function() {
	var _56a9 = new draw2d.ArrayList();
	var _56aa = this.canvas.figures;
	var _56ab = this.canvas.dialogs;
	for ( var i = 0; i < _56aa.getSize(); i++) {
		var _56ad = _56aa.get(i);
		if (_56ab.indexOf(_56ad) == -1 && _56ad.getParent() === null
				&& !(_56ad instanceof draw2d.WindowFigure)) {
			_56a9.add(_56ad);
		}
	}
	return _56a9;
};
draw2d.CanvasDocument.prototype.getFigure = function(id) {
	return this.canvas.getFigure(id);
};
draw2d.CanvasDocument.prototype.getLines = function() {
	return this.canvas.getLines();
};
draw2d.CanvasDocument.prototype.getLine = function(id) {
	return this.canvas.getLine(id);
};
draw2d.Annotation = function(msg) {
	this.msg = msg;
	this.alpha = 1;
	this.color = new draw2d.Color(0, 0, 0);
	this.bgColor = new draw2d.Color(241, 241, 121);
	this.fontSize = 10;
	this.textNode = null;
	draw2d.Figure.call(this);
};
draw2d.Annotation.prototype = new draw2d.Figure();
draw2d.Annotation.prototype.type = "draw2d.Annotation";
draw2d.Annotation.prototype.createHTMLElement = function() {
	var item = draw2d.Figure.prototype.createHTMLElement.call(this);
	item.style.color = this.color.getHTMLStyle();
	item.style.backgroundColor = this.bgColor.getHTMLStyle();
	item.style.fontSize = this.fontSize + "pt";
	item.style.width = "auto";
	item.style.height = "auto";
	item.style.margin = "0px";
	item.style.padding = "0px";
	item.onselectstart = function() {
		return false;
	};
	item.unselectable = "on";
	item.style.cursor = "default";
	this.textNode = document.createTextNode(this.msg);
	item.appendChild(this.textNode);
	this.disableTextSelection(item);
	return item;
};
draw2d.Annotation.prototype.onDoubleClick = function() {
	var _57d0 = new draw2d.AnnotationDialog(this);
	this.workflow.showDialog(_57d0);
};
draw2d.Annotation.prototype.setBackgroundColor = function(color) {
	this.bgColor = color;
	if (this.bgColor !== null) {
		this.html.style.backgroundColor = this.bgColor.getHTMLStyle();
	} else {
		this.html.style.backgroundColor = "transparent";
	}
};
draw2d.Annotation.prototype.getBackgroundColor = function() {
	return this.bgColor;
};
draw2d.Annotation.prototype.setFontSize = function(size) {
	this.fontSize = size;
	this.html.style.fontSize = this.fontSize + "pt";
};
draw2d.Annotation.prototype.getText = function() {
	return this.msg;
};
draw2d.Annotation.prototype.setText = function(text) {
	this.msg = text;
	this.html.removeChild(this.textNode);
	this.textNode = document.createTextNode(this.msg);
	this.html.appendChild(this.textNode);
};
draw2d.Annotation.prototype.setStyledText = function(text) {
	this.msg = text;
	this.html.removeChild(this.textNode);
	this.textNode = document.createElement("div");
	this.textNode.innerHTML = text;
	this.html.appendChild(this.textNode);
};
draw2d.ResizeHandle = function(_57e4, type) {
	draw2d.Rectangle.call(this, 5, 5);
	this.type = type;
	var _57e6 = this.getWidth();
	var _57e7 = _57e6 / 2;
	switch (this.type) {
	case 1:
		this.setSnapToGridAnchor(new draw2d.Point(_57e6, _57e6));
		break;
	case 2:
		this.setSnapToGridAnchor(new draw2d.Point(_57e7, _57e6));
		break;
	case 3:
		this.setSnapToGridAnchor(new draw2d.Point(0, _57e6));
		break;
	case 4:
		this.setSnapToGridAnchor(new draw2d.Point(0, _57e7));
		break;
	case 5:
		this.setSnapToGridAnchor(new draw2d.Point(0, 0));
		break;
	case 6:
		this.setSnapToGridAnchor(new draw2d.Point(_57e7, 0));
		break;
	case 7:
		this.setSnapToGridAnchor(new draw2d.Point(_57e6, 0));
		break;
	case 8:
		this.setSnapToGridAnchor(new draw2d.Point(_57e6, _57e7));
	case 9:
		this.setSnapToGridAnchor(new draw2d.Point(_57e7, _57e7));
		break;
	}
	this.setBackgroundColor(new draw2d.Color(0, 255, 0));
	this.setWorkflow(_57e4);
	this.setZOrder(10000);
};
draw2d.ResizeHandle.prototype = new draw2d.Rectangle();
draw2d.ResizeHandle.prototype.type = "draw2d.ResizeHandle";
draw2d.ResizeHandle.prototype.getSnapToDirection = function() {
	switch (this.type) {
	case 1:
		return draw2d.SnapToHelper.NORTH_WEST;
	case 2:
		return draw2d.SnapToHelper.NORTH;
	case 3:
		return draw2d.SnapToHelper.NORTH_EAST;
	case 4:
		return draw2d.SnapToHelper.EAST;
	case 5:
		return draw2d.SnapToHelper.SOUTH_EAST;
	case 6:
		return draw2d.SnapToHelper.SOUTH;
	case 7:
		return draw2d.SnapToHelper.SOUTH_WEST;
	case 8:
		return draw2d.SnapToHelper.WEST;
	case 9:
		return draw2d.SnapToHelper.CENTER;
	}
};
draw2d.ResizeHandle.prototype.onDragend = function() {
	var _57e8 = this.workflow.currentSelection;
	if (this.commandMove !== null) {
		this.commandMove.setPosition(_57e8.getX(), _57e8.getY());
		this.workflow.getCommandStack().execute(this.commandMove);
		this.commandMove = null;
	}
	if (this.commandResize !== null) {
		this.commandResize.setDimension(_57e8.getWidth(), _57e8.getHeight());
		this.workflow.getCommandStack().execute(this.commandResize);
		this.commandResize = null;
	}
	this.workflow.hideSnapToHelperLines();
};
draw2d.ResizeHandle.prototype.setPosition = function(xPos, yPos) {
	this.x = xPos;
	this.y = yPos;
	if (this.html === null) {
		return;
	}
	this.html.style.left = this.x + "px";
	this.html.style.top = this.y + "px";
};
draw2d.ResizeHandle.prototype.onDragstart = function(x, y) {
	if (!this.canDrag) {
		return false;
	}
	var _57ed = this.workflow.currentSelection;
	this.commandMove = _57ed.createCommand(new draw2d.EditPolicy(
			draw2d.EditPolicy.MOVE));
	this.commandResize = _57ed.createCommand(new draw2d.EditPolicy(
			draw2d.EditPolicy.RESIZE));
	return true;
};
draw2d.ResizeHandle.prototype.onDrag = function() {
	var oldX = this.getX();
	var oldY = this.getY();
	draw2d.Rectangle.prototype.onDrag.call(this);
	var diffX = oldX - this.getX();
	var diffY = oldY - this.getY();
	var _57f2 = this.workflow.currentSelection.getX();
	var _57f3 = this.workflow.currentSelection.getY();
	var _57f4 = this.workflow.currentSelection.getWidth();
	var _57f5 = this.workflow.currentSelection.getHeight();
	switch (this.type) {
	case 1:
		this.workflow.currentSelection
				.setPosition(_57f2 - diffX, _57f3 - diffY);
		this.workflow.currentSelection.setDimension(_57f4 + diffX, _57f5
				+ diffY);
		break;
	case 2:
		this.workflow.currentSelection.setPosition(_57f2, _57f3 - diffY);
		this.workflow.currentSelection.setDimension(_57f4, _57f5 + diffY);
		break;
	case 3:
		this.workflow.currentSelection.setPosition(_57f2, _57f3 - diffY);
		this.workflow.currentSelection.setDimension(_57f4 - diffX, _57f5
				+ diffY);
		break;
	case 4:
		this.workflow.currentSelection.setPosition(_57f2, _57f3);
		this.workflow.currentSelection.setDimension(_57f4 - diffX, _57f5);
		break;
	case 5:
		this.workflow.currentSelection.setPosition(_57f2, _57f3);
		this.workflow.currentSelection.setDimension(_57f4 - diffX, _57f5
				- diffY);
		break;
	case 6:
		this.workflow.currentSelection.setPosition(_57f2, _57f3);
		this.workflow.currentSelection.setDimension(_57f4, _57f5 - diffY);
		break;
	case 7:
		this.workflow.currentSelection.setPosition(_57f2 - diffX, _57f3);
		this.workflow.currentSelection.setDimension(_57f4 + diffX, _57f5
				- diffY);
		break;
	case 8:
		this.workflow.currentSelection.setPosition(_57f2 - diffX, _57f3);
		this.workflow.currentSelection.setDimension(_57f4 + diffX, _57f5);
		break;
	}
	this.workflow.moveResizeHandles(this.workflow.getCurrentSelection());
};
draw2d.ResizeHandle.prototype.setCanDrag = function(flag) {
	draw2d.Rectangle.prototype.setCanDrag.call(this, flag);
	if (this.html === null) {
		return;
	}
	if (!flag) {
		this.html.style.cursor = "";
		return;
	}
	switch (this.type) {
	case 1:
		this.html.style.cursor = "nw-resize";
		break;
	case 2:
		this.html.style.cursor = "s-resize";
		break;
	case 3:
		this.html.style.cursor = "ne-resize";
		break;
	case 4:
		this.html.style.cursor = "w-resize";
		break;
	case 5:
		this.html.style.cursor = "se-resize";
		break;
	case 6:
		this.html.style.cursor = "n-resize";
		break;
	case 7:
		this.html.style.cursor = "sw-resize";
		break;
	case 8:
		this.html.style.cursor = "e-resize";
		break;
	case 9:
		this.html.style.cursor = "resize";
		break;
	}
};
draw2d.ResizeHandle.prototype.onKeyDown = function(_57f7, ctrl) {
	this.workflow.onKeyDown(_57f7, ctrl);
};
draw2d.ResizeHandle.prototype.fireMoveEvent = function() {
};
draw2d.LineStartResizeHandle = function(_5b1e) {
	draw2d.ResizeHandle.call(this, _5b1e, 9);
	this.setDimension(10, 10);
	this.setBackgroundColor(new draw2d.Color(100, 255, 0));
	this.setZOrder(10000);
};
draw2d.LineStartResizeHandle.prototype = new draw2d.ResizeHandle();
draw2d.LineStartResizeHandle.prototype.type = "draw2d.LineStartResizeHandle";
draw2d.LineStartResizeHandle.prototype.onDragend = function() {
	if (this.workflow.currentSelection instanceof draw2d.Connection) {
		if (this.command !== null) {
			this.command.cancel();
		}
	} else {
		if (this.command !== null) {
			this.getWorkflow().getCommandStack().execute(this.command);
		}
	}
	this.command = null;
};
draw2d.LineStartResizeHandle.prototype.onDragstart = function(x, y) {
	if (!this.canDrag) {
		return false;
	}
	this.command = this.workflow.currentSelection
			.createCommand(new draw2d.EditPolicy(draw2d.EditPolicy.MOVE));
	return this.command !== null;
};
draw2d.LineStartResizeHandle.prototype.onDrag = function() {
	var oldX = this.getX();
	var oldY = this.getY();
	draw2d.Rectangle.prototype.onDrag.call(this);
	var diffX = oldX - this.getX();
	var diffY = oldY - this.getY();
	var _5b25 = this.workflow.currentSelection.getStartPoint();
	var line = this.workflow.currentSelection;
	line.setStartPoint(_5b25.x - diffX, _5b25.y - diffY);
	line.isMoving = true;
};
draw2d.LineStartResizeHandle.prototype.onDrop = function(_5b27) {
	var line = this.workflow.currentSelection;
	line.isMoving = false;
	if (line instanceof draw2d.Connection) {
		this.command.setNewPorts(_5b27, line.getTarget());
		this.getWorkflow().getCommandStack().execute(this.command);
	}
	this.command = null;
};
draw2d.LineEndResizeHandle = function(_58f5) {
	draw2d.ResizeHandle.call(this, _58f5, 9);
	this.setDimension(10, 10);
	this.setBackgroundColor(new draw2d.Color(0, 255, 0));
	this.setZOrder(10000);
};
draw2d.LineEndResizeHandle.prototype = new draw2d.ResizeHandle();
draw2d.LineEndResizeHandle.prototype.type = "draw2d.LineEndResizeHandle";
draw2d.LineEndResizeHandle.prototype.onDragend = function() {
	if (this.workflow.currentSelection instanceof draw2d.Connection) {
		if (this.command !== null) {
			this.command.cancel();
		}
	} else {
		if (this.command !== null) {
			this.workflow.getCommandStack().execute(this.command);
		}
	}
	this.command = null;
};
draw2d.LineEndResizeHandle.prototype.onDragstart = function(x, y) {
	if (!this.canDrag) {
		return false;
	}
	this.command = this.workflow.currentSelection
			.createCommand(new draw2d.EditPolicy(draw2d.EditPolicy.MOVE));
	return this.command !== null;
};
draw2d.LineEndResizeHandle.prototype.onDrag = function() {
	var oldX = this.getX();
	var oldY = this.getY();
	draw2d.Rectangle.prototype.onDrag.call(this);
	var diffX = oldX - this.getX();
	var diffY = oldY - this.getY();
	var _58fc = this.workflow.currentSelection.getEndPoint();
	var line = this.workflow.currentSelection;
	line.setEndPoint(_58fc.x - diffX, _58fc.y - diffY);
	line.isMoving = true;
};
draw2d.LineEndResizeHandle.prototype.onDrop = function(_58fe) {
	var line = this.workflow.currentSelection;
	line.isMoving = false;
	if (line instanceof draw2d.Connection) {
		this.command.setNewPorts(line.getSource(), _58fe);
		this.getWorkflow().getCommandStack().execute(this.command);
	}
	this.command = null;
};
draw2d.Canvas = function(_5020) {
	try {
		if (_5020) {
			this.construct(_5020);
		}
		this.enableSmoothFigureHandling = false;
		this.canvasLines = new draw2d.ArrayList();
	} catch (e) {
		pushErrorStack(e, "draw2d.Canvas=function(/*:String*/id)");
	}
};
draw2d.Canvas.IMAGE_BASE_URL = "";
draw2d.Canvas.prototype.type = "draw2d.Canvas";
draw2d.Canvas.prototype.construct = function(_5021) {
	this.canvasId = _5021;
	this.html = document.getElementById(this.canvasId);
	this.scrollArea = document.body.parentNode;
};
draw2d.Canvas.prototype.setViewPort = function(divId) {
	this.scrollArea = document.getElementById(divId);
};
draw2d.Canvas.prototype.addFigure = function(_5023, xPos, yPos, _5026) {
	try {
		if (this.enableSmoothFigureHandling === true) {
			if (_5023.timer <= 0) {
				_5023.setAlpha(0.001);
			}
			var _5027 = _5023;
			var _5028 = function() {
				if (_5027.alpha < 1) {
					_5027.setAlpha(Math.min(1, _5027.alpha + 0.05));
				} else {
					window.clearInterval(_5027.timer);
					_5027.timer = -1;
				}
			};
			if (_5027.timer > 0) {
				window.clearInterval(_5027.timer);
			}
			_5027.timer = window.setInterval(_5028, 30);
		}
		_5023.setCanvas(this);
		if (xPos && yPos) {
			_5023.setPosition(xPos, yPos);
		}
		if (_5023 instanceof draw2d.Line) {
			this.canvasLines.add(_5023);
			this.html.appendChild(_5023.getHTMLElement());
		} else {
			var obj = this.canvasLines.getFirstElement();
			if (obj === null) {
				this.html.appendChild(_5023.getHTMLElement());
			} else {
				this.html.insertBefore(_5023.getHTMLElement(), obj
						.getHTMLElement());
			}
		}
		if (!_5026) {
			_5023.paint();
		}
	} catch (e) {
		pushErrorStack(
				e,
				"draw2d.Canvas.prototype.addFigure= function( /*:draw2d.Figure*/figure,/*:int*/ xPos,/*:int*/ yPos, /*:boolean*/ avoidPaint)");
	}
};
draw2d.Canvas.prototype.removeFigure = function(_502a) {
	if (this.enableSmoothFigureHandling === true) {
		var oThis = this;
		var _502c = _502a;
		var _502d = function() {
			if (_502c.alpha > 0) {
				_502c.setAlpha(Math.max(0, _502c.alpha - 0.05));
			} else {
				window.clearInterval(_502c.timer);
				_502c.timer = -1;
				oThis.html.removeChild(_502c.html);
				_502c.setCanvas(null);
			}
		};
		if (_502c.timer > 0) {
			window.clearInterval(_502c.timer);
		}
		_502c.timer = window.setInterval(_502d, 20);
	} else {
		this.html.removeChild(_502a.html);
		_502a.setCanvas(null);
	}
	if (_502a instanceof draw2d.Line) {
		this.canvasLines.remove(_502a);
	}
};
draw2d.Canvas.prototype.getEnableSmoothFigureHandling = function() {
	return this.enableSmoothFigureHandling;
};
draw2d.Canvas.prototype.setEnableSmoothFigureHandling = function(flag) {
	this.enableSmoothFigureHandling = flag;
};
draw2d.Canvas.prototype.getWidth = function() {
	return parseInt(this.html.style.width);
};
draw2d.Canvas.prototype.setWidth = function(width) {
	if (this.scrollArea !== null) {
		this.scrollArea.style.width = width + "px";
	} else {
		this.html.style.width = width + "px";
	}
};
draw2d.Canvas.prototype.getHeight = function() {
	return parseInt(this.html.style.height);
};
draw2d.Canvas.prototype.setHeight = function(_5030) {
	if (this.scrollArea !== null) {
		this.scrollArea.style.height = _5030 + "px";
	} else {
		this.html.style.height = _5030 + "px";
	}
};
draw2d.Canvas.prototype.setBackgroundImage = function(_5031, _5032) {
	if (_5031 !== null) {
		if (_5032) {
			this.html.style.background = "transparent url(" + _5031 + ") ";
		} else {
			this.html.style.background = "transparent url(" + _5031
					+ ") no-repeat";
		}
	} else {
		this.html.style.background = "transparent";
	}
};
draw2d.Canvas.prototype.getY = function() {
	return this.y;
};
draw2d.Canvas.prototype.getX = function() {
	return this.x;
};
draw2d.Canvas.prototype.getAbsoluteY = function() {
	var el = this.html;
	var ot = el.offsetTop;
	while ((el = el.offsetParent) !== null) {
		ot += el.offsetTop;
	}
	return ot;
};
draw2d.Canvas.prototype.getAbsoluteX = function() {
	var el = this.html;
	var ol = el.offsetLeft;
	while ((el = el.offsetParent) !== null) {
		ol += el.offsetLeft;
	}
	return ol;
};
draw2d.Canvas.prototype.getScrollLeft = function() {
	return this.scrollArea.scrollLeft;
};
draw2d.Canvas.prototype.getScrollTop = function() {
	return this.scrollArea.scrollTop;
};
draw2d.Workflow = function(id) {
	try {
		if (!id) {
			return;
		}
		this.menu = null;
		this.gridWidthX = 10;
		this.gridWidthY = 10;
		this.snapToGridHelper = null;
		this.verticalSnapToHelperLine = null;
		this.horizontalSnapToHelperLine = null;
		this.snapToGeometryHelper = null;
		this.figures = new draw2d.ArrayList();
		this.lines = new draw2d.ArrayList();
		this.commonPorts = new draw2d.ArrayList();
		this.dropTargets = new draw2d.ArrayList();
		this.compartments = new draw2d.ArrayList();
		this.selectionListeners = new draw2d.ArrayList();
		this.dialogs = new draw2d.ArrayList();
		this.toolPalette = null;
		this.dragging = false;
		this.tooltip = null;
		this.draggingLine = null;
		this.draggingLineCommand = null;
		this.commandStack = new draw2d.CommandStack();
		this.oldScrollPosLeft = 0;
		this.oldScrollPosTop = 0;
		this.currentSelection = null;
		this.currentMenu = null;
		this.connectionLine = new draw2d.Line();
		this.resizeHandleStart = new draw2d.LineStartResizeHandle(this);
		this.resizeHandleEnd = new draw2d.LineEndResizeHandle(this);
		this.resizeHandle1 = new draw2d.ResizeHandle(this, 1);
		this.resizeHandle2 = new draw2d.ResizeHandle(this, 2);
		this.resizeHandle3 = new draw2d.ResizeHandle(this, 3);
		this.resizeHandle4 = new draw2d.ResizeHandle(this, 4);
		this.resizeHandle5 = new draw2d.ResizeHandle(this, 5);
		this.resizeHandle6 = new draw2d.ResizeHandle(this, 6);
		this.resizeHandle7 = new draw2d.ResizeHandle(this, 7);
		this.resizeHandle8 = new draw2d.ResizeHandle(this, 8);
		this.resizeHandleHalfWidth = parseInt(this.resizeHandle2.getWidth() / 2);
		draw2d.Canvas.call(this, id);
		this.setPanning(false);
		if (this.html !== null) {
			this.html.style.backgroundImage = "url(grid_10.png)";
			this.html.className = "Workflow";
			oThis = this;
			this.html.tabIndex = "0";
			var _4a24 = function() {
				var _4a25 = arguments[0] || window.event;
				_4a25.cancelBubble = true;
				_4a25.returnValue = false;
				_4a25.stopped = true;
				var diffX = _4a25.clientX;
				var diffY = _4a25.clientY;
				var _4a28 = oThis.getScrollLeft();
				var _4a29 = oThis.getScrollTop();
				var _4a2a = oThis.getAbsoluteX();
				var _4a2b = oThis.getAbsoluteY();
				var line = oThis.getBestLine(diffX + _4a28 - _4a2a, diffY
						+ _4a29 - _4a2b, null);
				if (line !== null) {
					line.onContextMenu(diffX + _4a28 - _4a2a, diffY + _4a29
							- _4a2b);
				} else {
					oThis.onContextMenu(diffX + _4a28 - _4a2a, diffY + _4a29
							- _4a2b);
				}
			};
			this.html.oncontextmenu = function() {
				return false;
			};
			var oThis = this;
			var _4a2e = function(event) {
				var ctrl = event.ctrlKey;
				oThis.onKeyDown(event.keyCode, ctrl);
			};
			var _4a31 = function() {
				var _4a32 = arguments[0] || window.event;
				if (_4a32.returnValue == false) {
					return;
				}
				var diffX = _4a32.clientX;
				var diffY = _4a32.clientY;
				var _4a35 = oThis.getScrollLeft();
				var _4a36 = oThis.getScrollTop();
				var _4a37 = oThis.getAbsoluteX();
				var _4a38 = oThis.getAbsoluteY();
				oThis.onMouseDown(diffX + _4a35 - _4a37, diffY + _4a36 - _4a38);
			};
			var _4a39 = function() {
				var _4a3a = arguments[0] || window.event;
				if (oThis.currentMenu !== null) {
					oThis.removeFigure(oThis.currentMenu);
					oThis.currentMenu = null;
				}
				if (_4a3a.button == 2) {
					return;
				}
				var diffX = _4a3a.clientX;
				var diffY = _4a3a.clientY;
				var _4a3d = oThis.getScrollLeft();
				var _4a3e = oThis.getScrollTop();
				var _4a3f = oThis.getAbsoluteX();
				var _4a40 = oThis.getAbsoluteY();
				oThis.onMouseUp(diffX + _4a3d - _4a3f, diffY + _4a3e - _4a40);
			};
			var _4a41 = function() {
				var _4a42 = arguments[0] || window.event;
				var diffX = _4a42.clientX;
				var diffY = _4a42.clientY;
				var _4a45 = oThis.getScrollLeft();
				var _4a46 = oThis.getScrollTop();
				var _4a47 = oThis.getAbsoluteX();
				var _4a48 = oThis.getAbsoluteY();
				oThis.currentMouseX = diffX + _4a45 - _4a47;
				oThis.currentMouseY = diffY + _4a46 - _4a48;
				var obj = oThis.getBestFigure(oThis.currentMouseX,
						oThis.currentMouseY);
				if (draw2d.Drag.currentHover !== null && obj === null) {
					var _4a4a = new draw2d.DragDropEvent();
					_4a4a.initDragDropEvent("mouseleave", false, oThis);
					draw2d.Drag.currentHover.dispatchEvent(_4a4a);
				} else {
					var diffX = _4a42.clientX;
					var diffY = _4a42.clientY;
					var _4a45 = oThis.getScrollLeft();
					var _4a46 = oThis.getScrollTop();
					var _4a47 = oThis.getAbsoluteX();
					var _4a48 = oThis.getAbsoluteY();
					oThis.onMouseMove(diffX + _4a45 - _4a47, diffY + _4a46
							- _4a48);
				}
				if (obj === null) {
					draw2d.Drag.currentHover = null;
				}
				if (oThis.tooltip !== null) {
					if (Math.abs(oThis.currentTooltipX - oThis.currentMouseX) > 10
							|| Math.abs(oThis.currentTooltipY
									- oThis.currentMouseY) > 10) {
						oThis.showTooltip(null);
					}
				}
			};
			var _4a4b = function(_4a4c) {
				var _4a4c = arguments[0] || window.event;
				var diffX = _4a4c.clientX;
				var diffY = _4a4c.clientY;
				var _4a4f = oThis.getScrollLeft();
				var _4a50 = oThis.getScrollTop();
				var _4a51 = oThis.getAbsoluteX();
				var _4a52 = oThis.getAbsoluteY();
				var line = oThis.getBestLine(diffX + _4a4f - _4a51, diffY
						+ _4a50 - _4a52, null);
				if (line !== null) {
					line.onDoubleClick();
				}
			};
			if (this.html.addEventListener) {
				this.html.addEventListener("contextmenu", _4a24, false);
				this.html.addEventListener("mousemove", _4a41, false);
				this.html.addEventListener("mouseup", _4a39, false);
				this.html.addEventListener("mousedown", _4a31, false);
				this.html.addEventListener("keydown", _4a2e, false);
				this.html.addEventListener("dblclick", _4a4b, false);
			} else {
				if (this.html.attachEvent) {
					this.html.attachEvent("oncontextmenu", _4a24);
					this.html.attachEvent("onmousemove", _4a41);
					this.html.attachEvent("onmousedown", _4a31);
					this.html.attachEvent("onmouseup", _4a39);
					this.html.attachEvent("onkeydown", _4a2e);
					this.html.attachEvent("ondblclick", _4a4b);
				} else {
					throw "Open-jACOB Draw2D not supported in this browser.";
				}
			}
		}
	} catch (e) {
		pushErrorStack(e, "draw2d.Workflow=function(/*:String*/id)");
	}
};
draw2d.Workflow.prototype = new draw2d.Canvas();
draw2d.Workflow.prototype.type = "draw2d.Workflow";
draw2d.Workflow.COLOR_GREEN = new draw2d.Color(0, 255, 0);
draw2d.Workflow.prototype.clear = function() {
	this.scrollTo(0, 0, true);
	this.gridWidthX = 10;
	this.gridWidthY = 10;
	this.snapToGridHelper = null;
	this.verticalSnapToHelperLine = null;
	this.horizontalSnapToHelperLine = null;
	var _4a54 = this.getDocument();
	var _4a55 = _4a54.getLines().clone();
	for ( var i = 0; i < _4a55.getSize(); i++) {
		(new draw2d.CommandDelete(_4a55.get(i))).execute();
	}
	var _4a57 = _4a54.getFigures().clone();
	for ( var i = 0; i < _4a57.getSize(); i++) {
		(new draw2d.CommandDelete(_4a57.get(i))).execute();
	}
	this.commonPorts.removeAllElements();
	this.dropTargets.removeAllElements();
	this.compartments.removeAllElements();
	this.selectionListeners.removeAllElements();
	this.dialogs.removeAllElements();
	this.commandStack = new draw2d.CommandStack();
	this.currentSelection = null;
	this.currentMenu = null;
	draw2d.Drag.clearCurrent();
};
draw2d.Workflow.prototype.onScroll = function() {
	var _4a58 = this.getScrollLeft();
	var _4a59 = this.getScrollTop();
	var _4a5a = _4a58 - this.oldScrollPosLeft;
	var _4a5b = _4a59 - this.oldScrollPosTop;
	for ( var i = 0; i < this.figures.getSize(); i++) {
		var _4a5d = this.figures.get(i);
		if (_4a5d.hasFixedPosition && _4a5d.hasFixedPosition() == true) {
			_4a5d.setPosition(_4a5d.getX() + _4a5a, _4a5d.getY() + _4a5b);
		}
	}
	this.oldScrollPosLeft = _4a58;
	this.oldScrollPosTop = _4a59;
};
draw2d.Workflow.prototype.setPanning = function(flag) {
	this.panning = flag;
	if (flag) {
		this.html.style.cursor = "move";
	} else {
		this.html.style.cursor = "default";
	}
};
draw2d.Workflow.prototype.scrollTo = function(x, y, fast) {
	if (fast) {
		this.scrollArea.scrollLeft = x;
		this.scrollArea.scrollTop = y;
	} else {
		var steps = 40;
		var xStep = (x - this.getScrollLeft()) / steps;
		var yStep = (y - this.getScrollTop()) / steps;
		var oldX = this.getScrollLeft();
		var oldY = this.getScrollTop();
		for ( var i = 0; i < steps; i++) {
			this.scrollArea.scrollLeft = oldX + (xStep * i);
			this.scrollArea.scrollTop = oldY + (yStep * i);
		}
	}
};
draw2d.Workflow.prototype.showTooltip = function(_4a68, _4a69) {
	if (this.tooltip !== null) {
		this.removeFigure(this.tooltip);
		this.tooltip = null;
		if (this.tooltipTimer >= 0) {
			window.clearTimeout(this.tooltipTimer);
			this.tooltipTimer = -1;
		}
	}
	this.tooltip = _4a68;
	if (this.tooltip !== null) {
		this.currentTooltipX = this.currentMouseX;
		this.currentTooltipY = this.currentMouseY;
		this.addFigure(this.tooltip, this.currentTooltipX + 10,
				this.currentTooltipY + 10);
		var oThis = this;
		var _4a6b = function() {
			oThis.tooltipTimer = -1;
			oThis.showTooltip(null);
		};
		if (_4a69 == true) {
			this.tooltipTimer = window.setTimeout(_4a6b, 5000);
		}
	}
};
draw2d.Workflow.prototype.showDialog = function(_4a6c, xPos, yPos) {
	if (xPos) {
		this.addFigure(_4a6c, xPos, yPos);
	} else {
		this.addFigure(_4a6c, 200, 100);
	}
	this.dialogs.add(_4a6c);
};
draw2d.Workflow.prototype.showMenu = function(menu, xPos, yPos) {
	if (this.menu !== null) {
		this.html.removeChild(this.menu.getHTMLElement());
		this.menu.setWorkflow();
	}
	this.menu = menu;
	if (this.menu !== null) {
		this.menu.setWorkflow(this);
		this.menu.setPosition(xPos, yPos);
		this.html.appendChild(this.menu.getHTMLElement());
		this.menu.paint();
	}
};
draw2d.Workflow.prototype.onContextMenu = function(x, y) {
	var menu = this.getContextMenu();
	if (menu !== null) {
		this.showMenu(menu, x, y);
	}
};
draw2d.Workflow.prototype.getContextMenu = function() {
	return null;
};
draw2d.Workflow.prototype.setToolWindow = function(_4a75, x, y) {
	this.toolPalette = _4a75;
	if (y) {
		this.addFigure(_4a75, x, y);
	} else {
		this.addFigure(_4a75, 20, 20);
	}
	this.dialogs.add(_4a75);
};
draw2d.Workflow.prototype.setSnapToGrid = function(flag) {
	if (flag) {
		this.snapToGridHelper = new draw2d.SnapToGrid(this);
	} else {
		this.snapToGridHelper = null;
	}
};
draw2d.Workflow.prototype.setSnapToGeometry = function(flag) {
	if (flag) {
		this.snapToGeometryHelper = new draw2d.SnapToGeometry(this);
	} else {
		this.snapToGeometryHelper = null;
	}
};
draw2d.Workflow.prototype.setGridWidth = function(dx, dy) {
	this.gridWidthX = dx;
	this.gridWidthY = dy;
};
draw2d.Workflow.prototype.addFigure = function(_4a7c, xPos, yPos) {
	try {
		draw2d.Canvas.prototype.addFigure.call(this, _4a7c, xPos, yPos, true);
		_4a7c.setWorkflow(this);
		var _4a7f = this;
		if (_4a7c instanceof draw2d.CompartmentFigure) {
			this.compartments.add(_4a7c);
		}
		if (_4a7c instanceof draw2d.Line) {
			this.lines.add(_4a7c);
		} else {
			this.figures.add(_4a7c);
			_4a7c.draggable.addEventListener("drag", function(_4a80) {
				var _4a81 = _4a7f.getFigure(_4a80.target.element.id);
				if (_4a81 === null) {
					return;
				}
				if (_4a81.isSelectable() == false) {
					return;
				}
				_4a7f.moveResizeHandles(_4a81);
			});
		}
		_4a7c.paint();
		this.setDocumentDirty();
	} catch (e) {
		pushErrorStack(
				e,
				"draw2d.Workflow.prototype.addFigure=function(/*:draw2d.Figure*/ figure ,/*:int*/ xPos, /*:int*/ yPos)");
	}
};
draw2d.Workflow.prototype.removeFigure = function(_4a82) {
	draw2d.Canvas.prototype.removeFigure.call(this, _4a82);
	this.figures.remove(_4a82);
	this.lines.remove(_4a82);
	this.dialogs.remove(_4a82);
	_4a82.setWorkflow(null);
	if (_4a82 instanceof draw2d.CompartmentFigure) {
		this.compartments.remove(_4a82);
	}
	if (_4a82 instanceof draw2d.Connection) {
		_4a82.disconnect();
	}
	if (this.currentSelection == _4a82) {
		this.setCurrentSelection(null);
	}
	this.setDocumentDirty();
	_4a82.onRemove(this);
};
draw2d.Workflow.prototype.moveFront = function(_4a83) {
	this.html.removeChild(_4a83.getHTMLElement());
	this.html.appendChild(_4a83.getHTMLElement());
};
draw2d.Workflow.prototype.moveBack = function(_4a84) {
	this.html.removeChild(_4a84.getHTMLElement());
	this.html.insertBefore(_4a84.getHTMLElement(), this.html.firstChild);
};
draw2d.Workflow.prototype.getBestCompartmentFigure = function(x, y, _4a87) {
	var _4a88 = null;
	for ( var i = 0; i < this.figures.getSize(); i++) {
		var _4a8a = this.figures.get(i);
		if ((_4a8a instanceof draw2d.CompartmentFigure)
				&& _4a8a.isOver(x, y) == true && _4a8a != _4a87) {
			if (_4a88 === null) {
				_4a88 = _4a8a;
			} else {
				if (_4a88.getZOrder() < _4a8a.getZOrder()) {
					_4a88 = _4a8a;
				}
			}
		}
	}
	return _4a88;
};
draw2d.Workflow.prototype.getBestFigure = function(x, y, _4a8d) {
	var _4a8e = null;
	for ( var i = 0; i < this.figures.getSize(); i++) {
		var _4a90 = this.figures.get(i);
		if (_4a90.isOver(x, y) == true && _4a90 != _4a8d) {
			if (_4a8e === null) {
				_4a8e = _4a90;
			} else {
				if (_4a8e.getZOrder() < _4a90.getZOrder()) {
					_4a8e = _4a90;
				}
			}
		}
	}
	return _4a8e;
};
draw2d.Workflow.prototype.getBestLine = function(x, y, _4a93) {
	var _4a94 = null;
	var count = this.lines.getSize();
	for ( var i = 0; i < count; i++) {
		var line = this.lines.get(i);
		if (line.containsPoint(x, y) == true && line != _4a93) {
			if (_4a94 === null) {
				_4a94 = line;
			} else {
				if (_4a94.getZOrder() < line.getZOrder()) {
					_4a94 = line;
				}
			}
		}
	}
	return _4a94;
};
draw2d.Workflow.prototype.getFigure = function(id) {
	for ( var i = 0; i < this.figures.getSize(); i++) {
		var _4a9a = this.figures.get(i);
		if (_4a9a.id == id) {
			return _4a9a;
		}
	}
	return null;
};
draw2d.Workflow.prototype.getFigures = function() {
	return this.figures;
};
draw2d.Workflow.prototype.getDocument = function() {
	return new draw2d.CanvasDocument(this);
};
draw2d.Workflow.prototype.addSelectionListener = function(w) {
	if (w !== null) {
		if (w.onSelectionChanged) {
			this.selectionListeners.add(w);
		} else {
			throw "Object doesn't implement required callback method [onSelectionChanged]";
		}
	}
};
draw2d.Workflow.prototype.removeSelectionListener = function(w) {
	this.selectionListeners.remove(w);
};
draw2d.Workflow.prototype.setCurrentSelection = function(_4a9d) {
	if (_4a9d === null || this.currentSelection != _4a9d) {
		this.hideResizeHandles();
		this.hideLineResizeHandles();
	}
	this.currentSelection = _4a9d;
	for ( var i = 0; i < this.selectionListeners.getSize(); i++) {
		var w = this.selectionListeners.get(i);
		if (w.onSelectionChanged) {
			w.onSelectionChanged(this.currentSelection,
					this.currentSelection ? this.currentSelection.getModel()
							: null);
		}
	}
	if (_4a9d instanceof draw2d.Line) {
		this.showLineResizeHandles(_4a9d);
		if (!(_4a9d instanceof draw2d.Connection)) {
			this.draggingLineCommand = line
					.createCommand(new draw2d.EditPolicy(draw2d.EditPolicy.MOVE));
			if (this.draggingLineCommand !== null) {
				this.draggingLine = _4a9d;
			}
		}
	}
};
draw2d.Workflow.prototype.getCurrentSelection = function() {
	return this.currentSelection;
};
draw2d.Workflow.prototype.getLine = function(id) {
	var count = this.lines.getSize();
	for ( var i = 0; i < count; i++) {
		var line = this.lines.get(i);
		if (line.getId() == id) {
			return line;
		}
	}
	return null;
};
draw2d.Workflow.prototype.getLines = function() {
	return this.lines;
};
draw2d.Workflow.prototype.registerPort = function(port) {
	port.draggable.targets = this.dropTargets;
	this.commonPorts.add(port);
	this.dropTargets.add(port.dropable);
};
draw2d.Workflow.prototype.unregisterPort = function(port) {
	port.draggable.targets = null;
	this.commonPorts.remove(port);
	this.dropTargets.remove(port.dropable);
};
draw2d.Workflow.prototype.getCommandStack = function() {
	return this.commandStack;
};
draw2d.Workflow.prototype.showConnectionLine = function(x1, y1, x2, y2) {
	this.connectionLine.setStartPoint(x1, y1);
	this.connectionLine.setEndPoint(x2, y2);
	if (this.connectionLine.canvas === null) {
		draw2d.Canvas.prototype.addFigure.call(this, this.connectionLine);
	}
};
draw2d.Workflow.prototype.hideConnectionLine = function() {
	if (this.connectionLine.canvas !== null) {
		draw2d.Canvas.prototype.removeFigure.call(this, this.connectionLine);
	}
};
draw2d.Workflow.prototype.showLineResizeHandles = function(_4aaa) {
	var _4aab = this.resizeHandleStart.getWidth() / 2;
	var _4aac = this.resizeHandleStart.getHeight() / 2;
	var _4aad = _4aaa.getStartPoint();
	var _4aae = _4aaa.getEndPoint();
	draw2d.Canvas.prototype.addFigure.call(this, this.resizeHandleStart,
			_4aad.x - _4aab, _4aad.y - _4aab);
	draw2d.Canvas.prototype.addFigure.call(this, this.resizeHandleEnd, _4aae.x
			- _4aab, _4aae.y - _4aab);
	this.resizeHandleStart.setCanDrag(_4aaa.isResizeable());
	this.resizeHandleEnd.setCanDrag(_4aaa.isResizeable());
	if (_4aaa.isResizeable()) {
		this.resizeHandleStart.setBackgroundColor(draw2d.Workflow.COLOR_GREEN);
		this.resizeHandleEnd.setBackgroundColor(draw2d.Workflow.COLOR_GREEN);
		this.resizeHandleStart.draggable.targets = this.dropTargets;
		this.resizeHandleEnd.draggable.targets = this.dropTargets;
	} else {
		this.resizeHandleStart.setBackgroundColor(null);
		this.resizeHandleEnd.setBackgroundColor(null);
	}
};
draw2d.Workflow.prototype.hideLineResizeHandles = function() {
	if (this.resizeHandleStart.canvas !== null) {
		draw2d.Canvas.prototype.removeFigure.call(this, this.resizeHandleStart);
	}
	if (this.resizeHandleEnd.canvas !== null) {
		draw2d.Canvas.prototype.removeFigure.call(this, this.resizeHandleEnd);
	}
};
draw2d.Workflow.prototype.showResizeHandles = function(_4aaf) {
	this.hideLineResizeHandles();
	this.hideResizeHandles();
	if (this.getEnableSmoothFigureHandling() == true
			&& this.getCurrentSelection() != _4aaf) {
		this.resizeHandle1.setAlpha(0.01);
		this.resizeHandle2.setAlpha(0.01);
		this.resizeHandle3.setAlpha(0.01);
		this.resizeHandle4.setAlpha(0.01);
		this.resizeHandle5.setAlpha(0.01);
		this.resizeHandle6.setAlpha(0.01);
		this.resizeHandle7.setAlpha(0.01);
		this.resizeHandle8.setAlpha(0.01);
	}
	var _4ab0 = this.resizeHandle1.getWidth();
	var _4ab1 = this.resizeHandle1.getHeight();
	var _4ab2 = _4aaf.getHeight();
	var _4ab3 = _4aaf.getWidth();
	var xPos = _4aaf.getX();
	var yPos = _4aaf.getY();
	draw2d.Canvas.prototype.addFigure.call(this, this.resizeHandle1, xPos
			- _4ab0, yPos - _4ab1);
	draw2d.Canvas.prototype.addFigure.call(this, this.resizeHandle3, xPos
			+ _4ab3, yPos - _4ab1);
	draw2d.Canvas.prototype.addFigure.call(this, this.resizeHandle5, xPos
			+ _4ab3, yPos + _4ab2);
	draw2d.Canvas.prototype.addFigure.call(this, this.resizeHandle7, xPos
			- _4ab0, yPos + _4ab2);
	this.moveFront(this.resizeHandle1);
	this.moveFront(this.resizeHandle3);
	this.moveFront(this.resizeHandle5);
	this.moveFront(this.resizeHandle7);
	this.resizeHandle1.setCanDrag(_4aaf.isResizeable());
	this.resizeHandle3.setCanDrag(_4aaf.isResizeable());
	this.resizeHandle5.setCanDrag(_4aaf.isResizeable());
	this.resizeHandle7.setCanDrag(_4aaf.isResizeable());
	if (_4aaf.isResizeable()) {
		var green = new draw2d.Color(0, 255, 0);
		this.resizeHandle1.setBackgroundColor(green);
		this.resizeHandle3.setBackgroundColor(green);
		this.resizeHandle5.setBackgroundColor(green);
		this.resizeHandle7.setBackgroundColor(green);
	} else {
		this.resizeHandle1.setBackgroundColor(null);
		this.resizeHandle3.setBackgroundColor(null);
		this.resizeHandle5.setBackgroundColor(null);
		this.resizeHandle7.setBackgroundColor(null);
	}
	if (_4aaf.isStrechable() && _4aaf.isResizeable()) {
		this.resizeHandle2.setCanDrag(_4aaf.isResizeable());
		this.resizeHandle4.setCanDrag(_4aaf.isResizeable());
		this.resizeHandle6.setCanDrag(_4aaf.isResizeable());
		this.resizeHandle8.setCanDrag(_4aaf.isResizeable());
		draw2d.Canvas.prototype.addFigure.call(this, this.resizeHandle2, xPos
				+ (_4ab3 / 2) - this.resizeHandleHalfWidth, yPos - _4ab1);
		draw2d.Canvas.prototype.addFigure.call(this, this.resizeHandle4, xPos
				+ _4ab3, yPos + (_4ab2 / 2) - (_4ab1 / 2));
		draw2d.Canvas.prototype.addFigure.call(this, this.resizeHandle6, xPos
				+ (_4ab3 / 2) - this.resizeHandleHalfWidth, yPos + _4ab2);
		draw2d.Canvas.prototype.addFigure.call(this, this.resizeHandle8, xPos
				- _4ab0, yPos + (_4ab2 / 2) - (_4ab1 / 2));
		this.moveFront(this.resizeHandle2);
		this.moveFront(this.resizeHandle4);
		this.moveFront(this.resizeHandle6);
		this.moveFront(this.resizeHandle8);
	}
};
draw2d.Workflow.prototype.hideResizeHandles = function() {
	if (this.resizeHandle1.canvas !== null) {
		draw2d.Canvas.prototype.removeFigure.call(this, this.resizeHandle1);
	}
	if (this.resizeHandle2.canvas !== null) {
		draw2d.Canvas.prototype.removeFigure.call(this, this.resizeHandle2);
	}
	if (this.resizeHandle3.canvas !== null) {
		draw2d.Canvas.prototype.removeFigure.call(this, this.resizeHandle3);
	}
	if (this.resizeHandle4.canvas !== null) {
		draw2d.Canvas.prototype.removeFigure.call(this, this.resizeHandle4);
	}
	if (this.resizeHandle5.canvas !== null) {
		draw2d.Canvas.prototype.removeFigure.call(this, this.resizeHandle5);
	}
	if (this.resizeHandle6.canvas !== null) {
		draw2d.Canvas.prototype.removeFigure.call(this, this.resizeHandle6);
	}
	if (this.resizeHandle7.canvas !== null) {
		draw2d.Canvas.prototype.removeFigure.call(this, this.resizeHandle7);
	}
	if (this.resizeHandle8.canvas !== null) {
		draw2d.Canvas.prototype.removeFigure.call(this, this.resizeHandle8);
	}
};
draw2d.Workflow.prototype.moveResizeHandles = function(_4ab7) {
	var _4ab8 = this.resizeHandle1.getWidth();
	var _4ab9 = this.resizeHandle1.getHeight();
	var _4aba = _4ab7.getHeight();
	var _4abb = _4ab7.getWidth();
	var xPos = _4ab7.getX();
	var yPos = _4ab7.getY();
	this.resizeHandle1.setPosition(xPos - _4ab8, yPos - _4ab9);
	this.resizeHandle3.setPosition(xPos + _4abb, yPos - _4ab9);
	this.resizeHandle5.setPosition(xPos + _4abb, yPos + _4aba);
	this.resizeHandle7.setPosition(xPos - _4ab8, yPos + _4aba);
	if (_4ab7.isStrechable()) {
		this.resizeHandle2.setPosition(xPos + (_4abb / 2)
				- this.resizeHandleHalfWidth, yPos - _4ab9);
		this.resizeHandle4.setPosition(xPos + _4abb, yPos + (_4aba / 2)
				- (_4ab9 / 2));
		this.resizeHandle6.setPosition(xPos + (_4abb / 2)
				- this.resizeHandleHalfWidth, yPos + _4aba);
		this.resizeHandle8.setPosition(xPos - _4ab8, yPos + (_4aba / 2)
				- (_4ab9 / 2));
	}
};
draw2d.Workflow.prototype.onMouseDown = function(x, y) {
	this.dragging = true;
	this.mouseDownPosX = x;
	this.mouseDownPosY = y;
	if (this.toolPalette !== null && this.toolPalette.getActiveTool() !== null) {
		this.toolPalette.getActiveTool().execute(x, y);
	}
	this.showMenu(null);
	var line = this.getBestLine(x, y);
	if (line !== null && line.isSelectable()) {
		this.setCurrentSelection(line);
	} else {
		this.setCurrentSelection(null);
	}
};
draw2d.Workflow.prototype.onMouseUp = function(x, y) {
	this.dragging = false;
	if (this.draggingLineCommand !== null) {
		this.getCommandStack().execute(this.draggingLineCommand);
		this.draggingLine = null;
		this.draggingLineCommand = null;
	}
};
draw2d.Workflow.prototype.onMouseMove = function(x, y) {
	if (this.dragging === true && this.draggingLine !== null) {
		var diffX = x - this.mouseDownPosX;
		var diffY = y - this.mouseDownPosY;
		this.draggingLine.startX = this.draggingLine.getStartX() + diffX;
		this.draggingLine.startY = this.draggingLine.getStartY() + diffY;
		this.draggingLine.setEndPoint(this.draggingLine.getEndX() + diffX,
				this.draggingLine.getEndY() + diffY);
		this.mouseDownPosX = x;
		this.mouseDownPosY = y;
		this.showLineResizeHandles(this.currentSelection);
	} else {
		if (this.dragging === true && this.panning === true) {
			var diffX = x - this.mouseDownPosX;
			var diffY = y - this.mouseDownPosY;
			this.scrollTo(this.getScrollLeft() - diffX, this.getScrollTop()
					- diffY, true);
			this.onScroll();
		}
	}
};
draw2d.Workflow.prototype.onKeyDown = function(_4ac7, ctrl) {
	if (_4ac7 == 46 && this.currentSelection !== null) {
		this.commandStack
				.execute(this.currentSelection
						.createCommand(new draw2d.EditPolicy(
								draw2d.EditPolicy.DELETE)));
	} else {
		if (_4ac7 == 90 && ctrl) {
			this.commandStack.undo();
		} else {
			if (_4ac7 == 89 && ctrl) {
				this.commandStack.redo();
			}
		}
	}
};
draw2d.Workflow.prototype.setDocumentDirty = function() {
	try {
		for ( var i = 0; i < this.dialogs.getSize(); i++) {
			var d = this.dialogs.get(i);
			if (d !== null && d.onSetDocumentDirty) {
				d.onSetDocumentDirty();
			}
		}
		if (this.snapToGeometryHelper !== null) {
			this.snapToGeometryHelper.onSetDocumentDirty();
		}
		if (this.snapToGridHelper !== null) {
			this.snapToGridHelper.onSetDocumentDirty();
		}
	} catch (e) {
		pushErrorStack(e,
				"draw2d.Workflow.prototype.setDocumentDirty=function()");
	}
};
draw2d.Workflow.prototype.snapToHelper = function(_4acb, pos) {
	if (this.snapToGeometryHelper !== null) {
		if (_4acb instanceof draw2d.ResizeHandle) {
			var _4acd = _4acb.getSnapToGridAnchor();
			pos.x += _4acd.x;
			pos.y += _4acd.y;
			var _4ace = new draw2d.Point(pos.x, pos.y);
			var _4acf = _4acb.getSnapToDirection();
			var _4ad0 = this.snapToGeometryHelper.snapPoint(_4acf, pos, _4ace);
			if ((_4acf & draw2d.SnapToHelper.EAST_WEST)
					&& !(_4ad0 & draw2d.SnapToHelper.EAST_WEST)) {
				this.showSnapToHelperLineVertical(_4ace.x);
			} else {
				this.hideSnapToHelperLineVertical();
			}
			if ((_4acf & draw2d.SnapToHelper.NORTH_SOUTH)
					&& !(_4ad0 & draw2d.SnapToHelper.NORTH_SOUTH)) {
				this.showSnapToHelperLineHorizontal(_4ace.y);
			} else {
				this.hideSnapToHelperLineHorizontal();
			}
			_4ace.x -= _4acd.x;
			_4ace.y -= _4acd.y;
			return _4ace;
		} else {
			var _4ad1 = new draw2d.Dimension(pos.x, pos.y, _4acb.getWidth(),
					_4acb.getHeight());
			var _4ace = new draw2d.Dimension(pos.x, pos.y, _4acb.getWidth(),
					_4acb.getHeight());
			var _4acf = draw2d.SnapToHelper.NSEW;
			var _4ad0 = this.snapToGeometryHelper.snapRectangle(_4ad1, _4ace);
			if ((_4acf & draw2d.SnapToHelper.WEST)
					&& !(_4ad0 & draw2d.SnapToHelper.WEST)) {
				this.showSnapToHelperLineVertical(_4ace.x);
			} else {
				if ((_4acf & draw2d.SnapToHelper.EAST)
						&& !(_4ad0 & draw2d.SnapToHelper.EAST)) {
					this.showSnapToHelperLineVertical(_4ace.getX()
							+ _4ace.getWidth());
				} else {
					this.hideSnapToHelperLineVertical();
				}
			}
			if ((_4acf & draw2d.SnapToHelper.NORTH)
					&& !(_4ad0 & draw2d.SnapToHelper.NORTH)) {
				this.showSnapToHelperLineHorizontal(_4ace.y);
			} else {
				if ((_4acf & draw2d.SnapToHelper.SOUTH)
						&& !(_4ad0 & draw2d.SnapToHelper.SOUTH)) {
					this.showSnapToHelperLineHorizontal(_4ace.getY()
							+ _4ace.getHeight());
				} else {
					this.hideSnapToHelperLineHorizontal();
				}
			}
			return _4ace.getTopLeft();
		}
	} else {
		if (this.snapToGridHelper !== null) {
			var _4acd = _4acb.getSnapToGridAnchor();
			pos.x = pos.x + _4acd.x;
			pos.y = pos.y + _4acd.y;
			var _4ace = new draw2d.Point(pos.x, pos.y);
			this.snapToGridHelper.snapPoint(0, pos, _4ace);
			_4ace.x = _4ace.x - _4acd.x;
			_4ace.y = _4ace.y - _4acd.y;
			return _4ace;
		}
	}
	return pos;
};
draw2d.Workflow.prototype.showSnapToHelperLineHorizontal = function(_4ad2) {
	if (this.horizontalSnapToHelperLine === null) {
		this.horizontalSnapToHelperLine = new draw2d.Line();
		this.horizontalSnapToHelperLine
				.setColor(new draw2d.Color(175, 175, 255));
		this.addFigure(this.horizontalSnapToHelperLine);
	}
	this.horizontalSnapToHelperLine.setStartPoint(0, _4ad2);
	this.horizontalSnapToHelperLine.setEndPoint(this.getWidth(), _4ad2);
};
draw2d.Workflow.prototype.showSnapToHelperLineVertical = function(_4ad3) {
	if (this.verticalSnapToHelperLine === null) {
		this.verticalSnapToHelperLine = new draw2d.Line();
		this.verticalSnapToHelperLine.setColor(new draw2d.Color(175, 175, 255));
		this.addFigure(this.verticalSnapToHelperLine);
	}
	this.verticalSnapToHelperLine.setStartPoint(_4ad3, 0);
	this.verticalSnapToHelperLine.setEndPoint(_4ad3, this.getHeight());
};
draw2d.Workflow.prototype.hideSnapToHelperLines = function() {
	this.hideSnapToHelperLineHorizontal();
	this.hideSnapToHelperLineVertical();
};
draw2d.Workflow.prototype.hideSnapToHelperLineHorizontal = function() {
	if (this.horizontalSnapToHelperLine !== null) {
		this.removeFigure(this.horizontalSnapToHelperLine);
		this.horizontalSnapToHelperLine = null;
	}
};
draw2d.Workflow.prototype.hideSnapToHelperLineVertical = function() {
	if (this.verticalSnapToHelperLine !== null) {
		this.removeFigure(this.verticalSnapToHelperLine);
		this.verticalSnapToHelperLine = null;
	}
};
draw2d.WindowFigure = function(title) {
	this.title = title;
	this.titlebar = null;
	draw2d.Figure.call(this);
	this.setDeleteable(false);
	this.setCanSnapToHelper(false);
	this.setZOrder(draw2d.WindowFigure.ZOrderIndex);
};
draw2d.WindowFigure.prototype = new draw2d.Figure();
draw2d.WindowFigure.prototype.type = ":draw2d.WindowFigure";
draw2d.WindowFigure.ZOrderIndex = 50000;
draw2d.WindowFigure.setZOrderBaseIndex = function(index) {
	draw2d.WindowFigure.ZOrderBaseIndex = index;
};
draw2d.WindowFigure.prototype.hasFixedPosition = function() {
	return true;
};
draw2d.WindowFigure.prototype.hasTitleBar = function() {
	return true;
};
draw2d.WindowFigure.prototype.createHTMLElement = function() {
	var item = draw2d.Figure.prototype.createHTMLElement.call(this);
	item.style.margin = "0px";
	item.style.padding = "0px";
	item.style.border = "1px solid black";
	item.style.backgroundImage = "url(window_bg.png)";
	item.style.zIndex = draw2d.WindowFigure.ZOrderIndex;
	item.style.cursor = null;
	item.className = "WindowFigure";
	if (this.hasTitleBar()) {
		this.titlebar = document.createElement("div");
		this.titlebar.style.position = "absolute";
		this.titlebar.style.left = "0px";
		this.titlebar.style.top = "0px";
		this.titlebar.style.width = this.getWidth() + "px";
		this.titlebar.style.height = "15px";
		this.titlebar.style.margin = "0px";
		this.titlebar.style.padding = "0px";
		this.titlebar.style.font = "normal 10px verdana";
		this.titlebar.style.backgroundColor = "blue";
		this.titlebar.style.borderBottom = "2px solid gray";
		this.titlebar.style.whiteSpace = "nowrap";
		this.titlebar.style.textAlign = "center";
		this.titlebar.style.backgroundImage = "url(window_toolbar.png)";
		this.titlebar.className = "WindowFigure_titlebar";
		this.textNode = document.createTextNode(this.title);
		this.titlebar.appendChild(this.textNode);
		this.disableTextSelection(this.titlebar);
		item.appendChild(this.titlebar);
	}
	return item;
};
draw2d.WindowFigure.prototype.setDocumentDirty = function(_566d) {
};
draw2d.WindowFigure.prototype.onDragend = function() {
};
draw2d.WindowFigure.prototype.onDragstart = function(x, y) {
	if (this.titlebar === null) {
		return false;
	}
	if (this.canDrag === true && x < parseInt(this.titlebar.style.width)
			&& y < parseInt(this.titlebar.style.height)) {
		return true;
	}
	return false;
};
draw2d.WindowFigure.prototype.isSelectable = function() {
	return false;
};
draw2d.WindowFigure.prototype.setCanDrag = function(flag) {
	draw2d.Figure.prototype.setCanDrag.call(this, flag);
	this.html.style.cursor = "";
	if (this.titlebar === null) {
		return;
	}
	if (flag) {
		this.titlebar.style.cursor = "move";
	} else {
		this.titlebar.style.cursor = "";
	}
};
draw2d.WindowFigure.prototype.setWorkflow = function(_5671) {
	var _5672 = this.workflow;
	draw2d.Figure.prototype.setWorkflow.call(this, _5671);
	if (_5672 !== null) {
		_5672.removeSelectionListener(this);
	}
	if (this.workflow !== null) {
		this.workflow.addSelectionListener(this);
	}
};
draw2d.WindowFigure.prototype.setDimension = function(w, h) {
	draw2d.Figure.prototype.setDimension.call(this, w, h);
	if (this.titlebar !== null) {
		this.titlebar.style.width = this.getWidth() + "px";
	}
};
draw2d.WindowFigure.prototype.setTitle = function(title) {
	this.title = title;
};
draw2d.WindowFigure.prototype.getMinWidth = function() {
	return 50;
};
draw2d.WindowFigure.prototype.getMinHeight = function() {
	return 50;
};
draw2d.WindowFigure.prototype.isResizeable = function() {
	return false;
};
draw2d.WindowFigure.prototype.setAlpha = function(_5676) {
};
draw2d.WindowFigure.prototype.setBackgroundColor = function(color) {
	this.bgColor = color;
	if (this.bgColor !== null) {
		this.html.style.backgroundColor = this.bgColor.getHTMLStyle();
	} else {
		this.html.style.backgroundColor = "transparent";
		this.html.style.backgroundImage = "";
	}
};
draw2d.WindowFigure.prototype.setColor = function(color) {
	this.lineColor = color;
	if (this.lineColor !== null) {
		this.html.style.border = this.lineStroke + "px solid "
				+ this.lineColor.getHTMLStyle();
	} else {
		this.html.style.border = "0px";
	}
};
draw2d.WindowFigure.prototype.setLineWidth = function(w) {
	this.lineStroke = w;
	this.html.style.border = this.lineStroke + "px solid black";
};
draw2d.WindowFigure.prototype.onSelectionChanged = function(_567a, model) {
};
draw2d.Button = function(_5544, width, _5546) {
	this.x = 0;
	this.y = 0;
	this.width = 24;
	this.height = 24;
	this.id = draw2d.UUID.create();
	this.enabled = true;
	this.active = false;
	this.palette = _5544;
	this.html = this.createHTMLElement();
	if (width !== undefined && _5546 !== undefined) {
		this.setDimension(width, _5546);
	} else {
		this.setDimension(24, 24);
	}
};
draw2d.Button.prototype.type = "draw2d.Button";
draw2d.Button.prototype.dispose = function() {
};
draw2d.Button.prototype.getImageUrl = function() {
	return this.type + ".png";
};
draw2d.Button.prototype.createHTMLElement = function() {
	var item = document.createElement("div");
	item.id = this.id;
	item.style.position = "absolute";
	item.style.left = this.x + "px";
	item.style.top = this.y + "px";
	item.style.height = this.width + "px";
	item.style.width = this.height + "px";
	item.style.margin = "0px";
	item.style.padding = "0px";
	item.style.outline = "none";
	if (this.getImageUrl() !== null) {
		item.style.backgroundImage = "url(" + this.getImageUrl() + ")";
	} else {
		item.style.backgroundImage = "";
	}
	var oThis = this;
	this.omousedown = function(event) {
		if (oThis.enabled) {
			oThis.setActive(true);
		}
		event.cancelBubble = true;
		event.returnValue = false;
	};
	this.omouseup = function(event) {
		if (oThis.enabled) {
			oThis.setActive(false);
			oThis.execute();
			oThis.palette.setActiveTool(null);
		}
		event.cancelBubble = true;
		event.returnValue = false;
	};
	if (item.addEventListener) {
		item.addEventListener("mousedown", this.omousedown, false);
		item.addEventListener("mouseup", this.omouseup, false);
	} else {
		if (item.attachEvent) {
			item.attachEvent("onmousedown", this.omousedown);
			item.attachEvent("onmouseup", this.omouseup);
		}
	}
	return item;
};
draw2d.Button.prototype.getHTMLElement = function() {
	if (this.html === null) {
		this.html = this.createHTMLElement();
	}
	return this.html;
};
draw2d.Button.prototype.execute = function() {
};
draw2d.Button.prototype.setTooltip = function(_554b) {
	this.tooltip = _554b;
	if (this.tooltip !== null) {
		this.html.title = this.tooltip;
	} else {
		this.html.title = "";
	}
};
draw2d.Button.prototype.getWorkflow = function() {
	return this.getToolPalette().getWorkflow();
};
draw2d.Button.prototype.getToolPalette = function() {
	return this.palette;
};
draw2d.Button.prototype.setActive = function(flag) {
	if (!this.enabled) {
		return;
	}
	this.active = flag;
	if (flag === true) {
		this.html.style.border = "1px inset";
	} else {
		this.html.style.border = "0px";
	}
};
draw2d.Button.prototype.isActive = function() {
	return this.active;
};
draw2d.Button.prototype.setEnabled = function(flag) {
	this.enabled = flag;
	if (flag) {
		this.html.style.filter = "alpha(opacity=100)";
		this.html.style.opacity = "1.0";
	} else {
		this.html.style.filter = "alpha(opacity=30)";
		this.html.style.opacity = "0.3";
	}
};
draw2d.Button.prototype.setDimension = function(w, h) {
	this.width = w;
	this.height = h;
	if (this.html === null) {
		return;
	}
	this.html.style.width = this.width + "px";
	this.html.style.height = this.height + "px";
};
draw2d.Button.prototype.setPosition = function(xPos, yPos) {
	this.x = Math.max(0, xPos);
	this.y = Math.max(0, yPos);
	if (this.html === null) {
		return;
	}
	this.html.style.left = this.x + "px";
	this.html.style.top = this.y + "px";
};
draw2d.Button.prototype.getWidth = function() {
	return this.width;
};
draw2d.Button.prototype.getHeight = function() {
	return this.height;
};
draw2d.Button.prototype.getY = function() {
	return this.y;
};
draw2d.Button.prototype.getX = function() {
	return this.x;
};
draw2d.Button.prototype.getPosition = function() {
	return new draw2d.Point(this.x, this.y);
};
draw2d.ToggleButton = function(_58b2) {
	draw2d.Button.call(this, _58b2);
	this.isDownFlag = false;
};
draw2d.ToggleButton.prototype = new draw2d.Button();
draw2d.ToggleButton.prototype.type = "draw2d.ToggleButton";
draw2d.ToggleButton.prototype.createHTMLElement = function() {
	var item = document.createElement("div");
	item.id = this.id;
	item.style.position = "absolute";
	item.style.left = this.x + "px";
	item.style.top = this.y + "px";
	item.style.height = "24px";
	item.style.width = "24px";
	item.style.margin = "0px";
	item.style.padding = "0px";
	if (this.getImageUrl() !== null) {
		item.style.backgroundImage = "url(" + this.getImageUrl() + ")";
	} else {
		item.style.backgroundImage = "";
	}
	var oThis = this;
	this.omousedown = function(event) {
		if (oThis.enabled) {
			if (!oThis.isDown()) {
				draw2d.Button.prototype.setActive.call(oThis, true);
			}
		}
		event.cancelBubble = true;
		event.returnValue = false;
	};
	this.omouseup = function(event) {
		if (oThis.enabled) {
			if (oThis.isDown()) {
				draw2d.Button.prototype.setActive.call(oThis, false);
			}
			oThis.isDownFlag = !oThis.isDownFlag;
			oThis.execute();
		}
		event.cancelBubble = true;
		event.returnValue = false;
	};
	if (item.addEventListener) {
		item.addEventListener("mousedown", this.omousedown, false);
		item.addEventListener("mouseup", this.omouseup, false);
	} else {
		if (item.attachEvent) {
			item.attachEvent("onmousedown", this.omousedown);
			item.attachEvent("onmouseup", this.omouseup);
		}
	}
	return item;
};
draw2d.ToggleButton.prototype.isDown = function() {
	return this.isDownFlag;
};
draw2d.ToggleButton.prototype.setActive = function(flag) {
	draw2d.Button.prototype.setActive.call(this, flag);
	this.isDownFlag = flag;
};
draw2d.ToggleButton.prototype.execute = function() {
};
draw2d.ToolGeneric = function(_58a4) {
	this.x = 0;
	this.y = 0;
	this.enabled = true;
	this.tooltip = null;
	this.palette = _58a4;
	this.html = this.createHTMLElement();
	this.setDimension(10, 10);
};
draw2d.ToolGeneric.prototype.type = "draw2d.ToolGeneric";
draw2d.ToolGeneric.prototype.dispose = function() {
};
draw2d.ToolGeneric.prototype.getImageUrl = function() {
	return this.type + ".png";
};
draw2d.ToolGeneric.prototype.getWorkflow = function() {
	return this.getToolPalette().getWorkflow();
};
draw2d.ToolGeneric.prototype.getToolPalette = function() {
	return this.palette;
};
draw2d.ToolGeneric.prototype.createHTMLElement = function() {
	var item = document.createElement("div");
	item.id = this.id;
	item.style.position = "absolute";
	item.style.left = this.x + "px";
	item.style.top = this.y + "px";
	item.style.height = "24px";
	item.style.width = "24px";
	item.style.margin = "0px";
	item.style.padding = "0px";
	if (this.getImageUrl() !== null) {
		item.style.backgroundImage = "url(" + this.getImageUrl() + ")";
	} else {
		item.style.backgroundImage = "";
	}
	var oThis = this;
	this.click = function(event) {
		if (oThis.enabled) {
			oThis.palette.setActiveTool(oThis);
		}
		event.cancelBubble = true;
		event.returnValue = false;
	};
	if (item.addEventListener) {
		item.addEventListener("click", this.click, false);
	} else {
		if (item.attachEvent) {
			item.attachEvent("onclick", this.click);
		}
	}
	if (this.tooltip !== null) {
		item.title = this.tooltip;
	} else {
		item.title = "";
	}
	return item;
};
draw2d.ToolGeneric.prototype.getHTMLElement = function() {
	if (this.html === null) {
		this.html = this.createHTMLElement();
	}
	return this.html;
};
draw2d.ToolGeneric.prototype.execute = function(x, y) {
	if (this.enabled) {
		this.palette.setActiveTool(null);
	}
};
draw2d.ToolGeneric.prototype.setTooltip = function(_58aa) {
	this.tooltip = _58aa;
	if (this.tooltip !== null) {
		this.html.title = this.tooltip;
	} else {
		this.html.title = "";
	}
};
draw2d.ToolGeneric.prototype.setActive = function(flag) {
	if (!this.enabled) {
		return;
	}
	if (flag === true) {
		this.html.style.border = "1px inset";
	} else {
		this.html.style.border = "0px";
	}
};
draw2d.ToolGeneric.prototype.setEnabled = function(flag) {
	this.enabled = flag;
	if (flag) {
		this.html.style.filter = "alpha(opacity=100)";
		this.html.style.opacity = "1.0";
	} else {
		this.html.style.filter = "alpha(opacity=30)";
		this.html.style.opacity = "0.3";
	}
};
draw2d.ToolGeneric.prototype.setDimension = function(w, h) {
	this.width = w;
	this.height = h;
	if (this.html === null) {
		return;
	}
	this.html.style.width = this.width + "px";
	this.html.style.height = this.height + "px";
};
draw2d.ToolGeneric.prototype.setPosition = function(xPos, yPos) {
	this.x = Math.max(0, xPos);
	this.y = Math.max(0, yPos);
	if (this.html === null) {
		return;
	}
	this.html.style.left = this.x + "px";
	this.html.style.top = this.y + "px";
};
draw2d.ToolGeneric.prototype.getWidth = function() {
	return this.width;
};
draw2d.ToolGeneric.prototype.getHeight = function() {
	return this.height;
};
draw2d.ToolGeneric.prototype.getY = function() {
	return this.y;
};
draw2d.ToolGeneric.prototype.getX = function() {
	return this.x;
};
draw2d.ToolGeneric.prototype.getPosition = function() {
	return new draw2d.Point(this.x, this.y);
};
draw2d.ToolPalette = function(title) {
	draw2d.WindowFigure.call(this, title);
	this.setDimension(75, 400);
	this.activeTool = null;
	this.children = {};
};
draw2d.ToolPalette.prototype = new draw2d.WindowFigure();
draw2d.ToolPalette.prototype.type = "draw2d.ToolPalette";
draw2d.ToolPalette.prototype.dispose = function() {
	draw2d.WindowFigure.prototype.dispose.call(this);
};
draw2d.ToolPalette.prototype.createHTMLElement = function() {
	var item = draw2d.WindowFigure.prototype.createHTMLElement.call(this);
	this.scrollarea = document.createElement("div");
	this.scrollarea.style.position = "absolute";
	this.scrollarea.style.left = "0px";
	if (this.hasTitleBar()) {
		this.scrollarea.style.top = "15px";
	} else {
		this.scrollarea.style.top = "0px";
	}
	this.scrollarea.style.width = this.getWidth() + "px";
	this.scrollarea.style.height = "15px";
	this.scrollarea.style.margin = "0px";
	this.scrollarea.style.padding = "0px";
	this.scrollarea.style.font = "normal 10px verdana";
	this.scrollarea.style.borderBottom = "2px solid gray";
	this.scrollarea.style.whiteSpace = "nowrap";
	this.scrollarea.style.textAlign = "center";
	this.scrollarea.style.overflowX = "auto";
	this.scrollarea.style.overflowY = "auto";
	this.scrollarea.style.overflow = "auto";
	item.appendChild(this.scrollarea);
	return item;
};
draw2d.ToolPalette.prototype.setDimension = function(w, h) {
	draw2d.WindowFigure.prototype.setDimension.call(this, w, h);
	if (this.scrollarea !== null) {
		this.scrollarea.style.width = this.getWidth() + "px";
		if (this.hasTitleBar()) {
			this.scrollarea.style.height = (this.getHeight() - 15) + "px";
		} else {
			this.scrollarea.style.height = this.getHeight() + "px";
		}
	}
};
draw2d.ToolPalette.prototype.addChild = function(item) {
	this.children[item.id] = item;
	this.scrollarea.appendChild(item.getHTMLElement());
};
draw2d.ToolPalette.prototype.getChild = function(id) {
	return this.children[id];
};
draw2d.ToolPalette.prototype.getActiveTool = function() {
	return this.activeTool;
};
draw2d.ToolPalette.prototype.setActiveTool = function(tool) {
	if (this.activeTool != tool && this.activeTool !== null) {
		this.activeTool.setActive(false);
	}
	if (tool !== null) {
		tool.setActive(true);
	}
	this.activeTool = tool;
};
draw2d.Dialog = function(title) {
	this.buttonbar = null;
	if (title) {
		draw2d.WindowFigure.call(this, title);
	} else {
		draw2d.WindowFigure.call(this, "Dialog");
	}
	this.setDimension(400, 300);
};
draw2d.Dialog.prototype = new draw2d.WindowFigure();
draw2d.Dialog.prototype.type = "draw2d.Dialog";
draw2d.Dialog.prototype.createHTMLElement = function() {
	var item = draw2d.WindowFigure.prototype.createHTMLElement.call(this);
	var oThis = this;
	this.buttonbar = document.createElement("div");
	this.buttonbar.style.position = "absolute";
	this.buttonbar.style.left = "0px";
	this.buttonbar.style.bottom = "0px";
	this.buttonbar.style.width = this.getWidth() + "px";
	this.buttonbar.style.height = "30px";
	this.buttonbar.style.margin = "0px";
	this.buttonbar.style.padding = "0px";
	this.buttonbar.style.font = "normal 10px verdana";
	this.buttonbar.style.backgroundColor = "#c0c0c0";
	this.buttonbar.style.borderBottom = "2px solid gray";
	this.buttonbar.style.whiteSpace = "nowrap";
	this.buttonbar.style.textAlign = "center";
	this.buttonbar.className = "Dialog_buttonbar";
	this.okbutton = document.createElement("button");
	this.okbutton.style.border = "1px solid gray";
	this.okbutton.style.font = "normal 10px verdana";
	this.okbutton.style.width = "80px";
	this.okbutton.style.margin = "5px";
	this.okbutton.className = "Dialog_okbutton";
	this.okbutton.innerHTML = "Ok";
	this.okbutton.onclick = function() {
		var error = null;
		try {
			oThis.onOk();
		} catch (e) {
			error = e;
		}
		oThis.workflow.removeFigure(oThis);
		if (error !== null) {
			throw error;
		}
	};
	this.buttonbar.appendChild(this.okbutton);
	this.cancelbutton = document.createElement("button");
	this.cancelbutton.innerHTML = "Cancel";
	this.cancelbutton.style.font = "normal 10px verdana";
	this.cancelbutton.style.border = "1px solid gray";
	this.cancelbutton.style.width = "80px";
	this.cancelbutton.style.margin = "5px";
	this.cancelbutton.className = "Dialog_cancelbutton";
	this.cancelbutton.onclick = function() {
		var error = null;
		try {
			oThis.onCancel();
		} catch (e) {
			error = e;
		}
		oThis.workflow.removeFigure(oThis);
		if (error !== null) {
			throw error;
		}
	};
	this.buttonbar.appendChild(this.cancelbutton);
	item.appendChild(this.buttonbar);
	return item;
};
draw2d.Dialog.prototype.onOk = function() {
};
draw2d.Dialog.prototype.onCancel = function() {
};
draw2d.Dialog.prototype.setDimension = function(w, h) {
	draw2d.WindowFigure.prototype.setDimension.call(this, w, h);
	if (this.buttonbar !== null) {
		this.buttonbar.style.width = this.getWidth() + "px";
	}
};
draw2d.Dialog.prototype.setWorkflow = function(_5af6) {
	draw2d.WindowFigure.prototype.setWorkflow.call(this, _5af6);
	this.setFocus();
};
draw2d.Dialog.prototype.setFocus = function() {
};
draw2d.Dialog.prototype.onSetDocumentDirty = function() {
};
draw2d.InputDialog = function() {
	draw2d.Dialog.call(this);
	this.setDimension(400, 100);
};
draw2d.InputDialog.prototype = new draw2d.Dialog();
draw2d.InputDialog.prototype.type = "draw2d.InputDialog";
draw2d.InputDialog.prototype.createHTMLElement = function() {
	var item = draw2d.Dialog.prototype.createHTMLElement.call(this);
	return item;
};
draw2d.InputDialog.prototype.onOk = function() {
	this.workflow.removeFigure(this);
};
draw2d.InputDialog.prototype.onCancel = function() {
	this.workflow.removeFigure(this);
};
draw2d.PropertyDialog = function(_4b4f, _4b50, label) {
	this.figure = _4b4f;
	this.propertyName = _4b50;
	this.label = label;
	draw2d.Dialog.call(this);
	this.setDimension(400, 120);
};
draw2d.PropertyDialog.prototype = new draw2d.Dialog();
draw2d.PropertyDialog.prototype.type = "draw2d.PropertyDialog";
draw2d.PropertyDialog.prototype.createHTMLElement = function() {
	var item = draw2d.Dialog.prototype.createHTMLElement.call(this);
	var _4b53 = document.createElement("form");
	_4b53.style.position = "absolute";
	_4b53.style.left = "10px";
	_4b53.style.top = "30px";
	_4b53.style.width = "375px";
	_4b53.style.font = "normal 10px verdana";
	item.appendChild(_4b53);
	this.labelDiv = document.createElement("div");
	this.labelDiv.innerHTML = this.label;
	this.disableTextSelection(this.labelDiv);
	_4b53.appendChild(this.labelDiv);
	this.input = document.createElement("input");
	this.input.style.border = "1px solid gray";
	this.input.style.font = "normal 10px verdana";
	this.input.type = "text";
	var value = this.figure.getProperty(this.propertyName);
	if (value) {
		this.input.value = value;
	} else {
		this.input.value = "";
	}
	this.input.style.width = "100%";
	_4b53.appendChild(this.input);
	this.input.focus();
	return item;
};
draw2d.PropertyDialog.prototype.onOk = function() {
	draw2d.Dialog.prototype.onOk.call(this);
	this.figure.setProperty(this.propertyName, this.input.value);
};
draw2d.AnnotationDialog = function(_57df) {
	this.figure = _57df;
	draw2d.Dialog.call(this);
	this.setDimension(400, 100);
};
draw2d.AnnotationDialog.prototype = new draw2d.Dialog();
draw2d.AnnotationDialog.prototype.type = "draw2d.AnnotationDialog";
draw2d.AnnotationDialog.prototype.createHTMLElement = function() {
	var item = draw2d.Dialog.prototype.createHTMLElement.call(this);
	var _57e1 = document.createElement("form");
	_57e1.style.position = "absolute";
	_57e1.style.left = "10px";
	_57e1.style.top = "30px";
	_57e1.style.width = "375px";
	_57e1.style.font = "normal 10px verdana";
	item.appendChild(_57e1);
	this.label = document.createTextNode("Text");
	_57e1.appendChild(this.label);
	this.input = document.createElement("input");
	this.input.style.border = "1px solid gray";
	this.input.style.font = "normal 10px verdana";
	this.input.type = "text";
	var value = this.figure.getText();
	if (value) {
		this.input.value = value;
	} else {
		this.input.value = "";
	}
	this.input.style.width = "100%";
	_57e1.appendChild(this.input);
	this.input.focus();
	return item;
};
draw2d.AnnotationDialog.prototype.onOk = function() {
	this.workflow.getCommandStack().execute(
			new draw2d.CommandSetText(this.figure, this.input.value));
	this.workflow.removeFigure(this);
};
draw2d.PropertyWindow = function() {
	this.currentSelection = null;
	draw2d.WindowFigure.call(this, "Property Window");
	this.setDimension(200, 100);
};
draw2d.PropertyWindow.prototype = new draw2d.WindowFigure();
draw2d.PropertyWindow.prototype.type = "draw2d.PropertyWindow";
draw2d.PropertyWindow.prototype.dispose = function() {
	draw2d.WindowFigure.prototype.dispose.call(this);
};
draw2d.PropertyWindow.prototype.createHTMLElement = function() {
	var item = draw2d.WindowFigure.prototype.createHTMLElement.call(this);
	item.appendChild(this.createLabel("Type:", 15, 25));
	item.appendChild(this.createLabel("X :", 15, 50));
	item.appendChild(this.createLabel("Y :", 15, 70));
	item.appendChild(this.createLabel("Width :", 85, 50));
	item.appendChild(this.createLabel("Height :", 85, 70));
	this.labelType = this.createLabel("", 50, 25);
	this.labelX = this.createLabel("", 40, 50);
	this.labelY = this.createLabel("", 40, 70);
	this.labelWidth = this.createLabel("", 135, 50);
	this.labelHeight = this.createLabel("", 135, 70);
	this.labelType.style.fontWeight = "normal";
	this.labelX.style.fontWeight = "normal";
	this.labelY.style.fontWeight = "normal";
	this.labelWidth.style.fontWeight = "normal";
	this.labelHeight.style.fontWeight = "normal";
	item.appendChild(this.labelType);
	item.appendChild(this.labelX);
	item.appendChild(this.labelY);
	item.appendChild(this.labelWidth);
	item.appendChild(this.labelHeight);
	return item;
};
draw2d.PropertyWindow.prototype.onSelectionChanged = function(_4b56) {
	draw2d.WindowFigure.prototype.onSelectionChanged.call(this, _4b56);
	if (this.currentSelection !== null) {
		this.currentSelection.detachMoveListener(this);
	}
	this.currentSelection = _4b56;
	if (_4b56 !== null && _4b56 != this) {
		this.labelType.innerHTML = _4b56.type;
		if (_4b56.getX) {
			this.labelX.innerHTML = _4b56.getX();
			this.labelY.innerHTML = _4b56.getY();
			this.labelWidth.innerHTML = _4b56.getWidth();
			this.labelHeight.innerHTML = _4b56.getHeight();
			this.currentSelection = _4b56;
			this.currentSelection.attachMoveListener(this);
		} else {
			this.labelX.innerHTML = "";
			this.labelY.innerHTML = "";
			this.labelWidth.innerHTML = "";
			this.labelHeight.innerHTML = "";
		}
	} else {
		this.labelType.innerHTML = "&lt;none&gt;";
		this.labelX.innerHTML = "";
		this.labelY.innerHTML = "";
		this.labelWidth.innerHTML = "";
		this.labelHeight.innerHTML = "";
	}
};
draw2d.PropertyWindow.prototype.getCurrentSelection = function() {
	return this.currentSelection;
};
draw2d.PropertyWindow.prototype.onOtherFigureMoved = function(_4b57) {
	if (_4b57 == this.currentSelection) {
		this.onSelectionChanged(_4b57);
	}
};
draw2d.PropertyWindow.prototype.createLabel = function(text, x, y) {
	var l = document.createElement("div");
	l.style.position = "absolute";
	l.style.left = x + "px";
	l.style.top = y + "px";
	l.style.font = "normal 10px verdana";
	l.style.whiteSpace = "nowrap";
	l.style.fontWeight = "bold";
	l.innerHTML = text;
	return l;
};
draw2d.ColorDialog = function() {
	this.maxValue = {
		"h" : "359",
		"s" : "100",
		"v" : "100"
	};
	this.HSV = {
		0 : 359,
		1 : 100,
		2 : 100
	};
	this.slideHSV = {
		0 : 359,
		1 : 100,
		2 : 100
	};
	this.SVHeight = 165;
	this.wSV = 162;
	this.wH = 162;
	draw2d.Dialog.call(this, "Color Chooser");
	this.loadSV();
	this.setColor(new draw2d.Color(255, 0, 0));
	this.setDimension(219, 244);
};
draw2d.ColorDialog.prototype = new draw2d.Dialog();
draw2d.ColorDialog.prototype.type = "draw2d.ColorDialog";
draw2d.ColorDialog.prototype.createHTMLElement = function() {
	var oThis = this;
	var item = draw2d.Dialog.prototype.createHTMLElement.call(this);
	this.outerDiv = document.createElement("div");
	this.outerDiv.id = "plugin";
	this.outerDiv.style.top = "15px";
	this.outerDiv.style.left = "0px";
	this.outerDiv.style.width = "201px";
	this.outerDiv.style.position = "absolute";
	this.outerDiv.style.padding = "9px";
	this.outerDiv.display = "block";
	this.outerDiv.style.background = "#0d0d0d";
	this.plugHEX = document.createElement("div");
	this.plugHEX.id = "plugHEX";
	this.plugHEX.innerHTML = "F1FFCC";
	this.plugHEX.style.color = "white";
	this.plugHEX.style.font = "normal 10px verdana";
	this.outerDiv.appendChild(this.plugHEX);
	this.SV = document.createElement("div");
	this.SV.onmousedown = function(event) {
		oThis.mouseDownSV(oThis.SVslide, event);
	};
	this.SV.id = "SV";
	this.SV.style.cursor = "crosshair";
	this.SV.style.background = "#FF0000 url(SatVal.png)";
	this.SV.style.position = "absolute";
	this.SV.style.height = "166px";
	this.SV.style.width = "167px";
	this.SV.style.marginRight = "10px";
	this.SV.style.filter = "progid:DXImageTransform.Microsoft.AlphaImageLoader(src='SatVal.png', sizingMethod='scale')";
	this.SV.style["float"] = "left";
	this.outerDiv.appendChild(this.SV);
	this.SVslide = document.createElement("div");
	this.SVslide.onmousedown = function(event) {
		oThis.mouseDownSV(event);
	};
	this.SVslide.style.top = "40px";
	this.SVslide.style.left = "40px";
	this.SVslide.style.position = "absolute";
	this.SVslide.style.cursor = "crosshair";
	this.SVslide.style.background = "url(slide.gif)";
	this.SVslide.style.height = "9px";
	this.SVslide.style.width = "9px";
	this.SVslide.style.lineHeight = "1px";
	this.outerDiv.appendChild(this.SVslide);
	this.H = document.createElement("form");
	this.H.id = "H";
	this.H.onmousedown = function(event) {
		oThis.mouseDownH(event);
	};
	this.H.style.border = "1px solid #000000";
	this.H.style.cursor = "crosshair";
	this.H.style.position = "absolute";
	this.H.style.width = "19px";
	this.H.style.top = "28px";
	this.H.style.left = "191px";
	this.outerDiv.appendChild(this.H);
	this.Hslide = document.createElement("div");
	this.Hslide.style.top = "-7px";
	this.Hslide.style.left = "-8px";
	this.Hslide.style.background = "url(slideHue.gif)";
	this.Hslide.style.height = "5px";
	this.Hslide.style.width = "33px";
	this.Hslide.style.position = "absolute";
	this.Hslide.style.lineHeight = "1px";
	this.H.appendChild(this.Hslide);
	this.Hmodel = document.createElement("div");
	this.Hmodel.style.height = "1px";
	this.Hmodel.style.width = "19px";
	this.Hmodel.style.lineHeight = "1px";
	this.Hmodel.style.margin = "0px";
	this.Hmodel.style.padding = "0px";
	this.Hmodel.style.fontSize = "1px";
	this.H.appendChild(this.Hmodel);
	item.appendChild(this.outerDiv);
	return item;
};
draw2d.ColorDialog.prototype.onOk = function() {
	draw2d.Dialog.prototype.onOk.call(this);
};
draw2d.browser = function(v) {
	return (Math.max(navigator.userAgent.toLowerCase().indexOf(v), 0));
};
draw2d.ColorDialog.prototype.showColor = function(c) {
	this.plugHEX.style.background = "#" + c;
	this.plugHEX.innerHTML = c;
};
draw2d.ColorDialog.prototype.getSelectedColor = function() {
	var rgb = this.hex2rgb(this.plugHEX.innerHTML);
	return new draw2d.Color(rgb[0], rgb[1], rgb[2]);
};
draw2d.ColorDialog.prototype.setColor = function(color) {
	if (color === null) {
		color = new draw2d.Color(100, 100, 100);
	}
	var hex = this.rgb2hex(Array(color.getRed(), color.getGreen(), color
			.getBlue()));
	this.updateH(hex);
};
draw2d.ColorDialog.prototype.XY = function(e, v) {
	var z = draw2d.browser("msie") ? Array(event.clientX
			+ document.body.scrollLeft, event.clientY + document.body.scrollTop)
			: Array(e.pageX, e.pageY);
	return z[v];
};
draw2d.ColorDialog.prototype.mkHSV = function(a, b, c) {
	return (Math.min(a, Math.max(0, Math.ceil((parseInt(c) / b) * a))));
};
draw2d.ColorDialog.prototype.ckHSV = function(a, b) {
	if (a >= 0 && a <= b) {
		return (a);
	} else {
		if (a > b) {
			return (b);
		} else {
			if (a < 0) {
				return ("-" + oo);
			}
		}
	}
};
draw2d.ColorDialog.prototype.mouseDownH = function(e) {
	this.slideHSV[0] = this.HSV[0];
	var oThis = this;
	this.H.onmousemove = function(e) {
		oThis.dragH(e);
	};
	this.H.onmouseup = function(e) {
		oThis.H.onmousemove = "";
		oThis.H.onmouseup = "";
	};
	this.dragH(e);
};
draw2d.ColorDialog.prototype.dragH = function(e) {
	var y = this.XY(e, 1) - this.getY() - 40;
	this.Hslide.style.top = (this.ckHSV(y, this.wH) - 5) + "px";
	this.slideHSV[0] = this.mkHSV(359, this.wH, this.Hslide.style.top);
	this.updateSV();
	this.showColor(this.commit());
	this.SV.style.backgroundColor = "#"
			+ this.hsv2hex(Array(this.HSV[0], 100, 100));
};
draw2d.ColorDialog.prototype.mouseDownSV = function(o, e) {
	this.slideHSV[0] = this.HSV[0];
	var oThis = this;
	function reset() {
		oThis.SV.onmousemove = "";
		oThis.SV.onmouseup = "";
		oThis.SVslide.onmousemove = "";
		oThis.SVslide.onmouseup = "";
	}
	this.SV.onmousemove = function(e) {
		oThis.dragSV(e);
	};
	this.SV.onmouseup = reset;
	this.SVslide.onmousemove = function(e) {
		oThis.dragSV(e);
	};
	this.SVslide.onmouseup = reset;
	this.dragSV(e);
};
draw2d.ColorDialog.prototype.dragSV = function(e) {
	var x = this.XY(e, 0) - this.getX() - 1;
	var y = this.XY(e, 1) - this.getY() - 20;
	this.SVslide.style.left = this.ckHSV(x, this.wSV) + "px";
	this.SVslide.style.top = this.ckHSV(y, this.wSV) + "px";
	this.slideHSV[1] = this.mkHSV(100, this.wSV, this.SVslide.style.left);
	this.slideHSV[2] = 100 - this.mkHSV(100, this.wSV, this.SVslide.style.top);
	this.updateSV();
};
draw2d.ColorDialog.prototype.commit = function() {
	var r = "hsv";
	var z = {};
	var j = "";
	for ( var i = 0; i <= r.length - 1; i++) {
		j = r.substr(i, 1);
		z[i] = (j == "h") ? this.maxValue[j]
				- this.mkHSV(this.maxValue[j], this.wH, this.Hslide.style.top)
				: this.HSV[i];
	}
	return (this.updateSV(this.hsv2hex(z)));
};
draw2d.ColorDialog.prototype.updateSV = function(v) {
	this.HSV = v ? this.hex2hsv(v) : Array(this.slideHSV[0], this.slideHSV[1],
			this.slideHSV[2]);
	if (!v) {
		v = this.hsv2hex(Array(this.slideHSV[0], this.slideHSV[1],
				this.slideHSV[2]));
	}
	this.showColor(v);
	return v;
};
draw2d.ColorDialog.prototype.loadSV = function() {
	var z = "";
	for ( var i = this.SVHeight; i >= 0; i--) {
		z += "<div style=\"background:#"
				+ this.hsv2hex(Array(Math.round((359 / this.SVHeight) * i),
						100, 100)) + ";\"><br/></div>";
	}
	this.Hmodel.innerHTML = z;
};
draw2d.ColorDialog.prototype.updateH = function(v) {
	this.plugHEX.innerHTML = v;
	this.HSV = this.hex2hsv(v);
	this.SV.style.backgroundColor = "#"
			+ this.hsv2hex(Array(this.HSV[0], 100, 100));
	this.SVslide.style.top = (parseInt(this.wSV - this.wSV
			* (this.HSV[1] / 100)) + 20)
			+ "px";
	this.SVslide.style.left = (parseInt(this.wSV * (this.HSV[1] / 100)) + 5)
			+ "px";
	this.Hslide.style.top = (parseInt(this.wH
			* ((this.maxValue["h"] - this.HSV[0]) / this.maxValue["h"])) - 7)
			+ "px";
};
draw2d.ColorDialog.prototype.toHex = function(v) {
	v = Math.round(Math.min(Math.max(0, v), 255));
	return ("0123456789ABCDEF".charAt((v - v % 16) / 16) + "0123456789ABCDEF"
			.charAt(v % 16));
};
draw2d.ColorDialog.prototype.hex2rgb = function(r) {
	return ( {
		0 : parseInt(r.substr(0, 2), 16),
		1 : parseInt(r.substr(2, 2), 16),
		2 : parseInt(r.substr(4, 2), 16)
	});
};
draw2d.ColorDialog.prototype.rgb2hex = function(r) {
	return (this.toHex(r[0]) + this.toHex(r[1]) + this.toHex(r[2]));
};
draw2d.ColorDialog.prototype.hsv2hex = function(h) {
	return (this.rgb2hex(this.hsv2rgb(h)));
};
draw2d.ColorDialog.prototype.hex2hsv = function(v) {
	return (this.rgb2hsv(this.hex2rgb(v)));
};
draw2d.ColorDialog.prototype.rgb2hsv = function(r) {
	var max = Math.max(r[0], r[1], r[2]);
	var delta = max - Math.min(r[0], r[1], r[2]);
	var H;
	var S;
	var V;
	if (max != 0) {
		S = Math.round(delta / max * 100);
		if (r[0] == max) {
			H = (r[1] - r[2]) / delta;
		} else {
			if (r[1] == max) {
				H = 2 + (r[2] - r[0]) / delta;
			} else {
				if (r[2] == max) {
					H = 4 + (r[0] - r[1]) / delta;
				}
			}
		}
		var H = Math.min(Math.round(H * 60), 360);
		if (H < 0) {
			H += 360;
		}
	}
	return ( {
		0 : H ? H : 0,
		1 : S ? S : 0,
		2 : Math.round((max / 255) * 100)
	});
};
draw2d.ColorDialog.prototype.hsv2rgb = function(r) {
	var R;
	var B;
	var G;
	var S = r[1] / 100;
	var V = r[2] / 100;
	var H = r[0] / 360;
	if (S > 0) {
		if (H >= 1) {
			H = 0;
		}
		H = 6 * H;
		F = H - Math.floor(H);
		A = Math.round(255 * V * (1 - S));
		B = Math.round(255 * V * (1 - (S * F)));
		C = Math.round(255 * V * (1 - (S * (1 - F))));
		V = Math.round(255 * V);
		switch (Math.floor(H)) {
		case 0:
			R = V;
			G = C;
			B = A;
			break;
		case 1:
			R = B;
			G = V;
			B = A;
			break;
		case 2:
			R = A;
			G = V;
			B = C;
			break;
		case 3:
			R = A;
			G = B;
			B = V;
			break;
		case 4:
			R = C;
			G = A;
			B = V;
			break;
		case 5:
			R = V;
			G = A;
			B = B;
			break;
		}
		return ( {
			0 : R ? R : 0,
			1 : G ? G : 0,
			2 : B ? B : 0
		});
	} else {
		return ( {
			0 : (V = Math.round(V * 255)),
			1 : V,
			2 : V
		});
	}
};
draw2d.LineColorDialog = function(_5a31) {
	draw2d.ColorDialog.call(this);
	this.figure = _5a31;
	var color = _5a31.getColor();
	this.updateH(this
			.rgb2hex(color.getRed(), color.getGreen(), color.getBlue()));
};
draw2d.LineColorDialog.prototype = new draw2d.ColorDialog();
draw2d.LineColorDialog.prototype.type = "draw2d.LineColorDialog";
draw2d.LineColorDialog.prototype.onOk = function() {
	var _5a33 = this.workflow;
	draw2d.ColorDialog.prototype.onOk.call(this);
	if (typeof this.figure.setColor == "function") {
		_5a33.getCommandStack()
				.execute(
						new draw2d.CommandSetColor(this.figure, this
								.getSelectedColor()));
		if (_5a33.getCurrentSelection() == this.figure) {
			_5a33.setCurrentSelection(this.figure);
		}
	}
};
draw2d.BackgroundColorDialog = function(_5b1b) {
	draw2d.ColorDialog.call(this);
	this.figure = _5b1b;
	var color = _5b1b.getBackgroundColor();
	if (color !== null) {
		this.updateH(this.rgb2hex(color.getRed(), color.getGreen(), color
				.getBlue()));
	}
};
draw2d.BackgroundColorDialog.prototype = new draw2d.ColorDialog();
draw2d.BackgroundColorDialog.prototype.type = "draw2d.BackgroundColorDialog";
draw2d.BackgroundColorDialog.prototype.onOk = function() {
	var _5b1d = this.workflow;
	draw2d.ColorDialog.prototype.onOk.call(this);
	if (typeof this.figure.setBackgroundColor == "function") {
		_5b1d.getCommandStack().execute(
				new draw2d.CommandSetBackgroundColor(this.figure, this
						.getSelectedColor()));
		if (_5b1d.getCurrentSelection() == this.figure) {
			_5b1d.setCurrentSelection(this.figure);
		}
	}
};
draw2d.AnnotationDialog = function(_57df) {
	this.figure = _57df;
	draw2d.Dialog.call(this);
	this.setDimension(400, 100);
};
draw2d.AnnotationDialog.prototype = new draw2d.Dialog();
draw2d.AnnotationDialog.prototype.type = "draw2d.AnnotationDialog";
draw2d.AnnotationDialog.prototype.createHTMLElement = function() {
	var item = draw2d.Dialog.prototype.createHTMLElement.call(this);
	var _57e1 = document.createElement("form");
	_57e1.style.position = "absolute";
	_57e1.style.left = "10px";
	_57e1.style.top = "30px";
	_57e1.style.width = "375px";
	_57e1.style.font = "normal 10px verdana";
	item.appendChild(_57e1);
	this.label = document.createTextNode("Text");
	_57e1.appendChild(this.label);
	this.input = document.createElement("input");
	this.input.style.border = "1px solid gray";
	this.input.style.font = "normal 10px verdana";
	this.input.type = "text";
	var value = this.figure.getText();
	if (value) {
		this.input.value = value;
	} else {
		this.input.value = "";
	}
	this.input.style.width = "100%";
	_57e1.appendChild(this.input);
	this.input.focus();
	return item;
};
draw2d.AnnotationDialog.prototype.onOk = function() {
	this.workflow.getCommandStack().execute(
			new draw2d.CommandSetText(this.figure, this.input.value));
	this.workflow.removeFigure(this);
};
draw2d.Command = function(label) {
	this.label = label;
};
draw2d.Command.prototype.type = "draw2d.Command";
draw2d.Command.prototype.getLabel = function() {
	return this.label;
};
draw2d.Command.prototype.canExecute = function() {
	return true;
};
draw2d.Command.prototype.execute = function() {
};
draw2d.Command.prototype.cancel = function() {
};
draw2d.Command.prototype.undo = function() {
};
draw2d.Command.prototype.redo = function() {
};
draw2d.CommandStack = function() {
	this.undostack = [];
	this.redostack = [];
	this.maxundo = 50;
	this.eventListeners = new draw2d.ArrayList();
};
draw2d.CommandStack.PRE_EXECUTE = 1;
draw2d.CommandStack.PRE_REDO = 2;
draw2d.CommandStack.PRE_UNDO = 4;
draw2d.CommandStack.POST_EXECUTE = 8;
draw2d.CommandStack.POST_REDO = 16;
draw2d.CommandStack.POST_UNDO = 32;
draw2d.CommandStack.POST_MASK = draw2d.CommandStack.POST_EXECUTE
		| draw2d.CommandStack.POST_UNDO | draw2d.CommandStack.POST_REDO;
draw2d.CommandStack.PRE_MASK = draw2d.CommandStack.PRE_EXECUTE
		| draw2d.CommandStack.PRE_UNDO | draw2d.CommandStack.PRE_REDO;
draw2d.CommandStack.prototype.type = "draw2d.CommandStack";
draw2d.CommandStack.prototype.setUndoLimit = function(count) {
	this.maxundo = count;
};
draw2d.CommandStack.prototype.markSaveLocation = function() {
	this.undostack = [];
	this.redostack = [];
};
draw2d.CommandStack.prototype.execute = function(_5577) {
	if (_5577 === null) {
		return;
	}
	if (_5577.canExecute() == false) {
		return;
	}
	this.notifyListeners(_5577, draw2d.CommandStack.PRE_EXECUTE);
	this.undostack.push(_5577);
	_5577.execute();
	this.redostack = [];
	if (this.undostack.length > this.maxundo) {
		this.undostack = this.undostack.slice(this.undostack.length
				- this.maxundo);
	}
	this.notifyListeners(_5577, draw2d.CommandStack.POST_EXECUTE);
};
draw2d.CommandStack.prototype.undo = function() {
	var _5578 = this.undostack.pop();
	if (_5578) {
		this.notifyListeners(_5578, draw2d.CommandStack.PRE_UNDO);
		this.redostack.push(_5578);
		_5578.undo();
		this.notifyListeners(_5578, draw2d.CommandStack.POST_UNDO);
	}
};
draw2d.CommandStack.prototype.redo = function() {
	var _5579 = this.redostack.pop();
	if (_5579) {
		this.notifyListeners(_5579, draw2d.CommandStack.PRE_REDO);
		this.undostack.push(_5579);
		_5579.redo();
		this.notifyListeners(_5579, draw2d.CommandStack.POST_REDO);
	}
};
draw2d.CommandStack.prototype.canRedo = function() {
	return this.redostack.length > 0;
};
draw2d.CommandStack.prototype.canUndo = function() {
	return this.undostack.length > 0;
};
draw2d.CommandStack.prototype.addCommandStackEventListener = function(_557a) {
	this.eventListeners.add(_557a);
};
draw2d.CommandStack.prototype.removeCommandStackEventListener = function(_557b) {
	this.eventListeners.remove(_557b);
};
draw2d.CommandStack.prototype.notifyListeners = function(_557c, state) {
	var event = new draw2d.CommandStackEvent(_557c, state);
	var size = this.eventListeners.getSize();
	for ( var i = 0; i < size; i++) {
		this.eventListeners.get(i).stackChanged(event);
	}
};
draw2d.CommandStackEvent = function(_507a, _507b) {
	this.command = _507a;
	this.details = _507b;
};
draw2d.CommandStackEvent.prototype.type = "draw2d.CommandStackEvent";
draw2d.CommandStackEvent.prototype.getCommand = function() {
	return this.command;
};
draw2d.CommandStackEvent.prototype.getDetails = function() {
	return this.details;
};
draw2d.CommandStackEvent.prototype.isPostChangeEvent = function() {
	return 0 != (this.getDetails() & draw2d.CommandStack.POST_MASK);
};
draw2d.CommandStackEvent.prototype.isPreChangeEvent = function() {
	return 0 != (this.getDetails() & draw2d.CommandStack.PRE_MASK);
};
draw2d.CommandStackEventListener = function() {
};
draw2d.CommandStackEventListener.prototype.type = "draw2d.CommandStackEventListener";
draw2d.CommandStackEventListener.prototype.stackChanged = function(event) {
};
draw2d.CommandAdd = function(_58b8, _58b9, x, y, _58bc) {
	draw2d.Command.call(this, "add figure");
	if (_58bc === undefined) {
		_58bc = null;
	}
	this.parent = _58bc;
	this.figure = _58b9;
	this.x = x;
	this.y = y;
	this.workflow = _58b8;
};
draw2d.CommandAdd.prototype = new draw2d.Command();
draw2d.CommandAdd.prototype.type = "draw2d.CommandAdd";
draw2d.CommandAdd.prototype.execute = function() {
	this.redo();
};
draw2d.CommandAdd.prototype.redo = function() {
	if (this.x && this.y) {
		this.workflow.addFigure(this.figure, this.x, this.y);
	} else {
		this.workflow.addFigure(this.figure);
	}
	this.workflow.setCurrentSelection(this.figure);
	if (this.parent !== null) {
		this.parent.addChild(this.figure);
	}
};
draw2d.CommandAdd.prototype.undo = function() {
	this.workflow.removeFigure(this.figure);
	this.workflow.setCurrentSelection(null);
	if (this.parent !== null) {
		this.parent.removeChild(this.figure);
	}
};
draw2d.CommandDelete = function(_553a) {
	draw2d.Command.call(this, "delete figure");
	this.parent = _553a.parent;
	this.figure = _553a;
	this.workflow = _553a.workflow;
	this.connections = null;
	this.compartmentDeleteCommands = null;
};
draw2d.CommandDelete.prototype = new draw2d.Command();
draw2d.CommandDelete.prototype.type = "draw2d.CommandDelete";
draw2d.CommandDelete.prototype.execute = function() {
	this.redo();
};
draw2d.CommandDelete.prototype.undo = function() {
	if (this.figure instanceof draw2d.CompartmentFigure) {
		for ( var i = 0; i < this.compartmentDeleteCommands.getSize(); i++) {
			var _553c = this.compartmentDeleteCommands.get(i);
			this.figure.addChild(_553c.figure);
			this.workflow.getCommandStack().undo();
		}
	}
	this.workflow.addFigure(this.figure);
	if (this.figure instanceof draw2d.Connection) {
		this.figure.reconnect();
	}
	this.workflow.setCurrentSelection(this.figure);
	if (this.parent !== null) {
		this.parent.addChild(this.figure);
	}
	for ( var i = 0; i < this.connections.getSize(); ++i) {
		this.workflow.addFigure(this.connections.get(i));
		this.connections.get(i).reconnect();
	}
};
draw2d.CommandDelete.prototype.redo = function() {
	if (this.figure instanceof draw2d.CompartmentFigure) {
		if (this.compartmentDeleteCommands === null) {
			this.compartmentDeleteCommands = new draw2d.ArrayList();
			var _553d = this.figure.getChildren().clone();
			for ( var i = 0; i < _553d.getSize(); i++) {
				var child = _553d.get(i);
				this.figure.removeChild(child);
				var _5540 = new draw2d.CommandDelete(child);
				this.compartmentDeleteCommands.add(_5540);
				this.workflow.getCommandStack().execute(_5540);
			}
		} else {
			for ( var i = 0; i < this.compartmentDeleteCommands.getSize(); i++) {
				this.workflow.redo();
			}
		}
	}
	this.workflow.removeFigure(this.figure);
	this.workflow.setCurrentSelection(null);
	if (this.figure instanceof draw2d.Node && this.connections === null) {
		this.connections = new draw2d.ArrayList();
		var ports = this.figure.getPorts();
		for ( var i = 0; i < ports.getSize(); i++) {
			var port = ports.get(i);
			for ( var c = 0, c_size = port.getConnections().getSize(); c < c_size; c++) {
				if (!this.connections.contains(port.getConnections().get(c))) {
					this.connections.add(port.getConnections().get(c));
				}
			}
		}
	}
	if (this.connections === null) {
		this.connections = new draw2d.ArrayList();
	}
	if (this.parent !== null) {
		this.parent.removeChild(this.figure);
	}
	for ( var i = 0; i < this.connections.getSize(); ++i) {
		this.workflow.removeFigure(this.connections.get(i));
	}
};
draw2d.CommandMove = function(_4fff, x, y) {
	draw2d.Command.call(this, "move figure");
	this.figure = _4fff;
	if (x == undefined) {
		this.oldX = _4fff.getX();
		this.oldY = _4fff.getY();
	} else {
		this.oldX = x;
		this.oldY = y;
	}
	this.oldCompartment = _4fff.getParent();
};
draw2d.CommandMove.prototype = new draw2d.Command();
draw2d.CommandMove.prototype.type = "draw2d.CommandMove";
draw2d.CommandMove.prototype.setStartPosition = function(x, y) {
	this.oldX = x;
	this.oldY = y;
};
draw2d.CommandMove.prototype.setPosition = function(x, y) {
	this.newX = x;
	this.newY = y;
	this.newCompartment = this.figure.workflow.getBestCompartmentFigure(x, y,
			this.figure);
};
draw2d.CommandMove.prototype.canExecute = function() {
	return this.newX != this.oldX || this.newY != this.oldY;
};
draw2d.CommandMove.prototype.execute = function() {
	this.redo();
};
draw2d.CommandMove.prototype.undo = function() {
	this.figure.setPosition(this.oldX, this.oldY);
	if (this.newCompartment !== null) {
		this.newCompartment.removeChild(this.figure);
	}
	if (this.oldCompartment !== null) {
		this.oldCompartment.addChild(this.figure);
	}
	this.figure.workflow.moveResizeHandles(this.figure);
};
draw2d.CommandMove.prototype.redo = function() {
	this.figure.setPosition(this.newX, this.newY);
	if (this.oldCompartment !== null) {
		this.oldCompartment.removeChild(this.figure);
	}
	if (this.newCompartment !== null) {
		this.newCompartment.addChild(this.figure);
	}
	this.figure.workflow.moveResizeHandles(this.figure);
};
draw2d.CommandResize = function(_5570, width, _5572) {
	draw2d.Command.call(this, "resize figure");
	this.figure = _5570;
	if (width === undefined) {
		this.oldWidth = _5570.getWidth();
		this.oldHeight = _5570.getHeight();
	} else {
		this.oldWidth = width;
		this.oldHeight = _5572;
	}
};
draw2d.CommandResize.prototype = new draw2d.Command();
draw2d.CommandResize.prototype.type = "draw2d.CommandResize";
draw2d.CommandResize.prototype.setDimension = function(width, _5574) {
	this.newWidth = width;
	this.newHeight = _5574;
};
draw2d.CommandResize.prototype.canExecute = function() {
	return this.newWidth != this.oldWidth || this.newHeight != this.oldHeight;
};
draw2d.CommandResize.prototype.execute = function() {
	this.redo();
};
draw2d.CommandResize.prototype.undo = function() {
	this.figure.setDimension(this.oldWidth, this.oldHeight);
	this.figure.workflow.moveResizeHandles(this.figure);
};
draw2d.CommandResize.prototype.redo = function() {
	this.figure.setDimension(this.newWidth, this.newHeight);
	this.figure.workflow.moveResizeHandles(this.figure);
};
draw2d.CommandSetText = function(_5771, text) {
	draw2d.Command.call(this, "set text");
	this.figure = _5771;
	this.newText = text;
	this.oldText = _5771.getText();
};
draw2d.CommandSetText.prototype = new draw2d.Command();
draw2d.CommandSetText.prototype.type = "draw2d.CommandSetText";
draw2d.CommandSetText.prototype.execute = function() {
	this.redo();
};
draw2d.CommandSetText.prototype.redo = function() {
	this.figure.setText(this.newText);
};
draw2d.CommandSetText.prototype.undo = function() {
	this.figure.setText(this.oldText);
};
draw2d.CommandSetColor = function(_5581, color) {
	draw2d.Command.call(this, "set color");
	this.figure = _5581;
	this.newColor = color;
	this.oldColor = _5581.getColor();
};
draw2d.CommandSetColor.prototype = new draw2d.Command();
draw2d.CommandSetColor.prototype.type = "draw2d.CommandSetColor";
draw2d.CommandSetColor.prototype.execute = function() {
	this.redo();
};
draw2d.CommandSetColor.prototype.undo = function() {
	this.figure.setColor(this.oldColor);
};
draw2d.CommandSetColor.prototype.redo = function() {
	this.figure.setColor(this.newColor);
};
draw2d.CommandSetBackgroundColor = function(_572e, color) {
	draw2d.Command.call(this, "set background color");
	this.figure = _572e;
	this.newColor = color;
	this.oldColor = _572e.getBackgroundColor();
};
draw2d.CommandSetBackgroundColor.prototype = new draw2d.Command();
draw2d.CommandSetBackgroundColor.prototype.type = "draw2d.CommandSetBackgroundColor";
draw2d.CommandSetBackgroundColor.prototype.execute = function() {
	this.redo();
};
draw2d.CommandSetBackgroundColor.prototype.undo = function() {
	this.figure.setBackgroundColor(this.oldColor);
};
draw2d.CommandSetBackgroundColor.prototype.redo = function() {
	this.figure.setBackgroundColor(this.newColor);
};
draw2d.CommandConnect = function(_5951, _5952, _5953) {
	draw2d.Command.call(this, "create connection");
	this.workflow = _5951;
	this.source = _5952;
	this.target = _5953;
	this.connection = null;
};
draw2d.CommandConnect.prototype = new draw2d.Command();
draw2d.CommandConnect.prototype.type = "draw2d.CommandConnect";
draw2d.CommandConnect.prototype.setConnection = function(_5954) {
	this.connection = _5954;
};
draw2d.CommandConnect.prototype.execute = function() {
	if (this.connection === null) {
		this.connection = new draw2d.Connection();
	}
	this.connection.setSource(this.source);
	this.connection.setTarget(this.target);
	this.workflow.addFigure(this.connection);
};
draw2d.CommandConnect.prototype.redo = function() {
	this.workflow.addFigure(this.connection);
	this.connection.reconnect();
};
draw2d.CommandConnect.prototype.undo = function() {
	this.workflow.removeFigure(this.connection);
};
draw2d.CommandReconnect = function(con) {
	draw2d.Command.call(this, "reconnect connection");
	this.con = con;
	this.oldSourcePort = con.getSource();
	this.oldTargetPort = con.getTarget();
	this.oldRouter = con.getRouter();
	this.con.setRouter(new draw2d.NullConnectionRouter());
};
draw2d.CommandReconnect.prototype = new draw2d.Command();
draw2d.CommandReconnect.prototype.type = "draw2d.CommandReconnect";
draw2d.CommandReconnect.prototype.canExecute = function() {
	return true;
};
draw2d.CommandReconnect.prototype.setNewPorts = function(_5584, _5585) {
	this.newSourcePort = _5584;
	this.newTargetPort = _5585;
};
draw2d.CommandReconnect.prototype.execute = function() {
	this.redo();
};
draw2d.CommandReconnect.prototype.cancel = function() {
	var start = this.con.sourceAnchor.getLocation(this.con.targetAnchor
			.getReferencePoint());
	var end = this.con.targetAnchor.getLocation(this.con.sourceAnchor
			.getReferencePoint());
	this.con.setStartPoint(start.x, start.y);
	this.con.setEndPoint(end.x, end.y);
	this.con.getWorkflow().showLineResizeHandles(this.con);
	this.con.setRouter(this.oldRouter);
};
draw2d.CommandReconnect.prototype.undo = function() {
	this.con.setSource(this.oldSourcePort);
	this.con.setTarget(this.oldTargetPort);
	this.con.setRouter(this.oldRouter);
	if (this.con.getWorkflow().getCurrentSelection() == this.con) {
		this.con.getWorkflow().showLineResizeHandles(this.con);
	}
};
draw2d.CommandReconnect.prototype.redo = function() {
	this.con.setSource(this.newSourcePort);
	this.con.setTarget(this.newTargetPort);
	this.con.setRouter(this.oldRouter);
	if (this.con.getWorkflow().getCurrentSelection() == this.con) {
		this.con.getWorkflow().showLineResizeHandles(this.con);
	}
};
draw2d.CommandMoveLine = function(line, _57a3, _57a4, endX, endY) {
	draw2d.Command.call(this, "move line");
	this.line = line;
	this.startX1 = _57a3;
	this.startY1 = _57a4;
	this.endX1 = endX;
	this.endY1 = endY;
};
draw2d.CommandMoveLine.prototype = new draw2d.Command();
draw2d.CommandMoveLine.prototype.type = "draw2d.CommandMoveLine";
draw2d.CommandMoveLine.prototype.canExecute = function() {
	return this.startX1 != this.startX2 || this.startY1 != this.startY2
			|| this.endX1 != this.endX2 || this.endY1 != this.endY2;
};
draw2d.CommandMoveLine.prototype.execute = function() {
	this.startX2 = this.line.getStartX();
	this.startY2 = this.line.getStartY();
	this.endX2 = this.line.getEndX();
	this.endY2 = this.line.getEndY();
	this.redo();
};
draw2d.CommandMoveLine.prototype.undo = function() {
	this.line.setStartPoint(this.startX1, this.startY1);
	this.line.setEndPoint(this.endX1, this.endY1);
	if (this.line.workflow.getCurrentSelection() == this.line) {
		this.line.workflow.showLineResizeHandles(this.line);
	}
};
draw2d.CommandMoveLine.prototype.redo = function() {
	this.line.setStartPoint(this.startX2, this.startY2);
	this.line.setEndPoint(this.endX2, this.endY2);
	if (this.line.workflow.getCurrentSelection() == this.line) {
		this.line.workflow.showLineResizeHandles(this.line);
	}
};
draw2d.CommandMovePort = function(port) {
	draw2d.Command.call(this, "move port");
	this.port = port;
};
draw2d.CommandMovePort.prototype = new draw2d.Command();
draw2d.CommandMovePort.prototype.type = "draw2d.CommandMovePort";
draw2d.CommandMovePort.prototype.execute = function() {
	this.port.setAlpha(1);
	this.port.setPosition(this.port.originX, this.port.originY);
	this.port.parentNode.workflow.hideConnectionLine();
};
draw2d.CommandMovePort.prototype.undo = function() {
};
draw2d.CommandMovePort.prototype.redo = function() {
};
draw2d.CommandMovePort.prototype.setPosition = function(x, y) {
};
draw2d.Menu = function() {
	this.menuItems = new draw2d.ArrayList();
	draw2d.Figure.call(this);
	this.setSelectable(false);
	this.setDeleteable(false);
	this.setCanDrag(false);
	this.setResizeable(false);
	this.setSelectable(false);
	this.setZOrder(10000);
	this.dirty = false;
};
draw2d.Menu.prototype = new draw2d.Figure();
draw2d.Menu.prototype.type = "draw2d.Menu";
draw2d.Menu.prototype.createHTMLElement = function() {
	var item = document.createElement("div");
	item.style.position = "absolute";
	item.style.left = this.x + "px";
	item.style.top = this.y + "px";
	item.style.margin = "0px";
	item.style.padding = "0px";
	item.style.zIndex = "" + draw2d.Figure.ZOrderBaseIndex;
	item.style.border = "1px solid gray";
	item.style.background = "lavender";
	item.style.cursor = "pointer";
	item.style.width = "auto";
	item.style.height = "auto";
	item.className = "Menu";
	return item;
};
draw2d.Menu.prototype.setWorkflow = function(_5085) {
	this.workflow = _5085;
};
draw2d.Menu.prototype.setDimension = function(w, h) {
};
draw2d.Menu.prototype.appendMenuItem = function(item) {
	this.menuItems.add(item);
	item.parentMenu = this;
	this.dirty = true;
};
draw2d.Menu.prototype.getHTMLElement = function() {
	var html = draw2d.Figure.prototype.getHTMLElement.call(this);
	if (this.dirty) {
		this.createList();
	}
	return html;
};
draw2d.Menu.prototype.createList = function() {
	this.dirty = false;
	this.html.innerHTML = "";
	var oThis = this;
	for ( var i = 0; i < this.menuItems.getSize(); i++) {
		var item = this.menuItems.get(i);
		var li = document.createElement("a");
		li.innerHTML = item.getLabel();
		li.style.display = "block";
		li.style.fontFamily = "Verdana, Arial, Helvetica, sans-serif";
		li.style.fontSize = "9pt";
		li.style.color = "dimgray";
		li.style.borderBottom = "1px solid silver";
		li.style.paddingLeft = "5px";
		li.style.paddingRight = "5px";
		li.style.whiteSpace = "nowrap";
		li.style.cursor = "pointer";
		li.className = "MenuItem";
		this.html.appendChild(li);
		li.menuItem = item;
		if (li.addEventListener) {
			li.addEventListener("click", function(event) {
				var _508f = arguments[0] || window.event;
				_508f.cancelBubble = true;
				_508f.returnValue = false;
				var diffX = _508f.clientX;
				var diffY = _508f.clientY;
				var _5092 = document.body.parentNode.scrollLeft;
				var _5093 = document.body.parentNode.scrollTop;
				this.menuItem.execute(diffX + _5092, diffY + _5093);
			}, false);
			li.addEventListener("mouseup", function(event) {
				event.cancelBubble = true;
				event.returnValue = false;
			}, false);
			li.addEventListener("mousedown", function(event) {
				event.cancelBubble = true;
				event.returnValue = false;
			}, false);
			li.addEventListener("mouseover", function(event) {
				this.style.backgroundColor = "silver";
			}, false);
			li.addEventListener("mouseout", function(event) {
				this.style.backgroundColor = "transparent";
			}, false);
		} else {
			if (li.attachEvent) {
				li.attachEvent("onclick", function(event) {
					var _5099 = arguments[0] || window.event;
					_5099.cancelBubble = true;
					_5099.returnValue = false;
					var diffX = _5099.clientX;
					var diffY = _5099.clientY;
					var _509c = document.body.parentNode.scrollLeft;
					var _509d = document.body.parentNode.scrollTop;
					event.srcElement.menuItem.execute(diffX + _509c, diffY
							+ _509d);
				});
				li.attachEvent("onmousedown", function(event) {
					event.cancelBubble = true;
					event.returnValue = false;
				});
				li.attachEvent("onmouseup", function(event) {
					event.cancelBubble = true;
					event.returnValue = false;
				});
				li.attachEvent("onmouseover", function(event) {
					event.srcElement.style.backgroundColor = "silver";
				});
				li.attachEvent("onmouseout", function(event) {
					event.srcElement.style.backgroundColor = "transparent";
				});
			}
		}
	}
};
draw2d.MenuItem = function(label, _4f03, _4f04) {
	this.label = label;
	this.iconUrl = _4f03;
	this.parentMenu = null;
	this.action = _4f04;
};
draw2d.MenuItem.prototype.type = "draw2d.MenuItem";
draw2d.MenuItem.prototype.isEnabled = function() {
	return true;
};
draw2d.MenuItem.prototype.getLabel = function() {
	return this.label;
};
draw2d.MenuItem.prototype.execute = function(x, y) {
	this.parentMenu.workflow.showMenu(null);
	this.action(x, y);
};
draw2d.Locator = function() {
};
draw2d.Locator.prototype.type = "draw2d.Locator";
draw2d.Locator.prototype.relocate = function(_5077) {
};
draw2d.ConnectionLocator = function(_57d5) {
	draw2d.Locator.call(this);
	this.connection = _57d5;
};
draw2d.ConnectionLocator.prototype = new draw2d.Locator;
draw2d.ConnectionLocator.prototype.type = "draw2d.ConnectionLocator";
draw2d.ConnectionLocator.prototype.getConnection = function() {
	return this.connection;
};
draw2d.ManhattanMidpointLocator = function(_603c) {
	draw2d.ConnectionLocator.call(this, _603c);
};
draw2d.ManhattanMidpointLocator.prototype = new draw2d.ConnectionLocator;
draw2d.ManhattanMidpointLocator.prototype.type = "draw2d.ManhattanMidpointLocator";
draw2d.ManhattanMidpointLocator.prototype.relocate = function(_603d) {
	var conn = this.getConnection();
	var p = new draw2d.Point();
	var _6040 = conn.getPoints();
	var index = Math.floor((_6040.getSize() - 2) / 2);
	if (_6040.getSize() <= index + 1) {
		return;
	}
	var p1 = _6040.get(index);
	var p2 = _6040.get(index + 1);
	p.x = (p2.x - p1.x) / 2 + p1.x + 5;
	p.y = (p2.y - p1.y) / 2 + p1.y + 5;
	_603d.setPosition(p.x, p.y);
};
draw2d.EditPartFactory = function() {
};
draw2d.EditPartFactory.prototype.type = "draw2d.EditPartFactory";
draw2d.EditPartFactory.prototype.createEditPart = function(model) {
};
draw2d.AbstractObjectModel = function() {
	this.listeners = new draw2d.ArrayList();
	this.id = draw2d.UUID.create();
};
draw2d.AbstractObjectModel.EVENT_ELEMENT_ADDED = "element added";
draw2d.AbstractObjectModel.EVENT_ELEMENT_REMOVED = "element removed";
draw2d.AbstractObjectModel.EVENT_CONNECTION_ADDED = "connection addedx";
draw2d.AbstractObjectModel.EVENT_CONNECTION_REMOVED = "connection removed";
draw2d.AbstractObjectModel.prototype.type = "draw2d.AbstractObjectModel";
draw2d.AbstractObjectModel.prototype.getModelChildren = function() {
	return new draw2d.ArrayList();
};
draw2d.AbstractObjectModel.prototype.getModelParent = function() {
	return this.modelParent;
};
draw2d.AbstractObjectModel.prototype.setModelParent = function(_555f) {
	this.modelParent = _555f;
};
draw2d.AbstractObjectModel.prototype.getId = function() {
	return this.id;
};
draw2d.AbstractObjectModel.prototype.firePropertyChange = function(_5560,
		_5561, _5562) {
	var count = this.listeners.getSize();
	if (count === 0) {
		return;
	}
	var event = new draw2d.PropertyChangeEvent(this, _5560, _5561, _5562);
	for ( var i = 0; i < count; i++) {
		try {
			this.listeners.get(i).propertyChange(event);
		} catch (e) {
			alert("Method: draw2d.AbstractObjectModel.prototype.firePropertyChange\n"
					+ e
					+ "\nProperty: "
					+ _5560
					+ "\nListener Class:"
					+ this.listeners.get(i).type);
		}
	}
};
draw2d.AbstractObjectModel.prototype.addPropertyChangeListener = function(_5566) {
	if (_5566 !== null) {
		this.listeners.add(_5566);
	}
};
draw2d.AbstractObjectModel.prototype.removePropertyChangeListener = function(
		_5567) {
	if (_5567 !== null) {
		this.listeners.remove(_5567);
	}
};
draw2d.AbstractObjectModel.prototype.getPersistentAttributes = function() {
	return {
		id : this.id
	};
};
draw2d.AbstractConnectionModel = function() {
	draw2d.AbstractObjectModel.call(this);
};
draw2d.AbstractConnectionModel.prototype = new draw2d.AbstractObjectModel();
draw2d.AbstractConnectionModel.prototype.type = "draw2d.AbstractConnectionModel";
draw2d.AbstractConnectionModel.prototype.getSourceModel = function() {
	throw "you must override the method [AbstractConnectionModel.prototype.getSourceModel]";
};
draw2d.AbstractConnectionModel.prototype.getTargetModel = function() {
	throw "you must override the method [AbstractConnectionModel.prototype.getTargetModel]";
};
draw2d.AbstractConnectionModel.prototype.getSourcePortName = function() {
	throw "you must override the method [AbstractConnectionModel.prototype.getSourcePortName]";
};
draw2d.AbstractConnectionModel.prototype.getTargetPortName = function() {
	throw "you must override the method [AbstractConnectionModel.prototype.getTargetPortName]";
};
draw2d.AbstractConnectionModel.prototype.getSourcePortModel = function() {
	throw "you must override the method [AbstractConnectionModel.prototype.getSourcePortModel]";
};
draw2d.AbstractConnectionModel.prototype.getTargetPortModel = function() {
	throw "you must override the method [AbstractConnectionModel.prototype.getTargetPortModel]";
};
draw2d.PropertyChangeEvent = function(model, _5919, _591a, _591b) {
	this.model = model;
	this.property = _5919;
	this.oldValue = _591a;
	this.newValue = _591b;
};
draw2d.PropertyChangeEvent.prototype.type = "draw2d.PropertyChangeEvent";
draw2d.GraphicalViewer = function(id) {
	try {
		draw2d.Workflow.call(this, id);
		this.factory = null;
		this.model = null;
		this.initDone = false;
	} catch (e) {
		pushErrorStack(e, "draw2d.GraphicalViewer=function(/*:String*/ id)");
	}
};
draw2d.GraphicalViewer.prototype = new draw2d.Workflow();
draw2d.GraphicalViewer.prototype.type = "draw2d.GraphicalViewer";
draw2d.GraphicalViewer.prototype.setEditPartFactory = function(_56c3) {
	this.factory = _56c3;
	this.checkInit();
};
draw2d.GraphicalViewer.prototype.setModel = function(model) {
	try {
		if (model instanceof draw2d.AbstractObjectModel) {
			this.model = model;
			this.checkInit();
			this.model.addPropertyChangeListener(this);
		} else {
			alert("Invalid model class type:" + model.type);
		}
	} catch (e) {
		pushErrorStack(
				e,
				"draw2d.GraphicalViewer.prototype.setModel=function(/*:draw2d.AbstractObjectModel*/ model )");
	}
};
draw2d.GraphicalViewer.prototype.propertyChange = function(event) {
	switch (event.property) {
	case draw2d.AbstractObjectModel.EVENT_ELEMENT_REMOVED:
		var _56c6 = this.getFigure(event.oldValue.getId());
		this.removeFigure(_56c6);
		break;
	case draw2d.AbstractObjectModel.EVENT_ELEMENT_ADDED:
		var _56c6 = this.factory.createEditPart(event.newValue);
		_56c6.setId(event.newValue.getId());
		this.addFigure(_56c6);
		this.setCurrentSelection(_56c6);
		break;
	}
};
draw2d.GraphicalViewer.prototype.checkInit = function() {
	if (this.factory !== null && this.model !== null && this.initDone == false) {
		try {
			var _56c7 = this.model.getModelChildren();
			var count = _56c7.getSize();
			for ( var i = 0; i < count; i++) {
				var child = _56c7.get(i);
				var _56cb = this.factory.createEditPart(child);
				_56cb.setId(child.getId());
				this.addFigure(_56cb);
			}
		} catch (e) {
			pushErrorStack(e,
					"draw2d.GraphicalViewer.prototype.checkInit=function()[addFigures]");
		}
		try {
			var _56cc = this.getDocument().getFigures();
			var count = _56cc.getSize();
			for ( var i = 0; i < count; i++) {
				var _56cb = _56cc.get(i);
				if (_56cb instanceof draw2d.Node) {
					this.refreshConnections(_56cb);
				}
			}
		} catch (e) {
			pushErrorStack(e,
					"draw2d.GraphicalViewer.prototype.checkInit=function()[refreshConnections]");
		}
	}
};
draw2d.GraphicalViewer.prototype.refreshConnections = function(node) {
	try {
		var _56ce = new draw2d.ArrayList();
		var _56cf = node.getModelSourceConnections();
		var count = _56cf.getSize();
		for ( var i = 0; i < count; i++) {
			var _56d2 = _56cf.get(i);
			_56ce.add(_56d2.getId());
			var _56d3 = this.getLine(_56d2.getId());
			if (_56d3 === null) {
				_56d3 = this.factory.createEditPart(_56d2);
				var _56d4 = _56d2.getSourceModel();
				var _56d5 = _56d2.getTargetModel();
				var _56d6 = this.getFigure(_56d4.getId());
				var _56d7 = this.getFigure(_56d5.getId());
				var _56d8 = _56d6.getOutputPort(_56d2.getSourcePortName());
				var _56d9 = _56d7.getInputPort(_56d2.getTargetPortName());
				_56d3.setTarget(_56d9);
				_56d3.setSource(_56d8);
				_56d3.setId(_56d2.getId());
				this.addFigure(_56d3);
				this.setCurrentSelection(_56d3);
			}
		}
		var ports = node.getOutputPorts();
		count = ports.getSize();
		for ( var i = 0; i < count; i++) {
			var _56db = ports.get(i).getConnections();
			var _56dc = _56db.getSize();
			for ( var ii = 0; ii < _56dc; ii++) {
				var _56de = _56db.get(ii);
				if (!_56ce.contains(_56de.getId())) {
					this.removeFigure(_56de);
					_56ce.add(_56de.getId());
				}
			}
		}
	} catch (e) {
		pushErrorStack(
				e,
				"draw2d.GraphicalViewer.prototype.refreshConnections=function(/*:draw2d.Node*/ node )");
	}
};
draw2d.GraphicalEditor = function(id) {
	try {
		this.view = new draw2d.GraphicalViewer(id);
		this.initializeGraphicalViewer();
	} catch (e) {
		pushErrorStack(e, "draw2d.GraphicalEditor=function(/*:String*/ id)");
	}
};
draw2d.GraphicalEditor.prototype.type = "draw2d.GraphicalEditor";
draw2d.GraphicalEditor.prototype.initializeGraphicalViewer = function() {
};
draw2d.GraphicalEditor.prototype.getGraphicalViewer = function() {
	return this.view;
};
var whitespace = "\n\r\t ";
XMLP = function(_595d) {
	_595d = SAXStrings.replace(_595d, null, null, "\r\n", "\n");
	_595d = SAXStrings.replace(_595d, null, null, "\r", "\n");
	this.m_xml = _595d;
	this.m_iP = 0;
	this.m_iState = XMLP._STATE_PROLOG;
	this.m_stack = new Stack();
	this._clearAttributes();
};
XMLP._NONE = 0;
XMLP._ELM_B = 1;
XMLP._ELM_E = 2;
XMLP._ELM_EMP = 3;
XMLP._ATT = 4;
XMLP._TEXT = 5;
XMLP._ENTITY = 6;
XMLP._PI = 7;
XMLP._CDATA = 8;
XMLP._COMMENT = 9;
XMLP._DTD = 10;
XMLP._ERROR = 11;
XMLP._CONT_XML = 0;
XMLP._CONT_ALT = 1;
XMLP._ATT_NAME = 0;
XMLP._ATT_VAL = 1;
XMLP._STATE_PROLOG = 1;
XMLP._STATE_DOCUMENT = 2;
XMLP._STATE_MISC = 3;
XMLP._errs = [];
XMLP._errs[XMLP.ERR_CLOSE_PI = 0] = "PI: missing closing sequence";
XMLP._errs[XMLP.ERR_CLOSE_DTD = 1] = "DTD: missing closing sequence";
XMLP._errs[XMLP.ERR_CLOSE_COMMENT = 2] = "Comment: missing closing sequence";
XMLP._errs[XMLP.ERR_CLOSE_CDATA = 3] = "CDATA: missing closing sequence";
XMLP._errs[XMLP.ERR_CLOSE_ELM = 4] = "Element: missing closing sequence";
XMLP._errs[XMLP.ERR_CLOSE_ENTITY = 5] = "Entity: missing closing sequence";
XMLP._errs[XMLP.ERR_PI_TARGET = 6] = "PI: target is required";
XMLP._errs[XMLP.ERR_ELM_EMPTY = 7] = "Element: cannot be both empty and closing";
XMLP._errs[XMLP.ERR_ELM_NAME = 8] = "Element: name must immediatly follow \"<\"";
XMLP._errs[XMLP.ERR_ELM_LT_NAME = 9] = "Element: \"<\" not allowed in element names";
XMLP._errs[XMLP.ERR_ATT_VALUES = 10] = "Attribute: values are required and must be in quotes";
XMLP._errs[XMLP.ERR_ATT_LT_NAME = 11] = "Element: \"<\" not allowed in attribute names";
XMLP._errs[XMLP.ERR_ATT_LT_VALUE = 12] = "Attribute: \"<\" not allowed in attribute values";
XMLP._errs[XMLP.ERR_ATT_DUP = 13] = "Attribute: duplicate attributes not allowed";
XMLP._errs[XMLP.ERR_ENTITY_UNKNOWN = 14] = "Entity: unknown entity";
XMLP._errs[XMLP.ERR_INFINITELOOP = 15] = "Infininte loop";
XMLP._errs[XMLP.ERR_DOC_STRUCTURE = 16] = "Document: only comments, processing instructions, or whitespace allowed outside of document element";
XMLP._errs[XMLP.ERR_ELM_NESTING = 17] = "Element: must be nested correctly";
XMLP.prototype._addAttribute = function(name, value) {
	this.m_atts[this.m_atts.length] = new Array(name, value);
};
XMLP.prototype._checkStructure = function(_5960) {
	if (XMLP._STATE_PROLOG == this.m_iState) {
		if ((XMLP._TEXT == _5960) || (XMLP._ENTITY == _5960)) {
			if (SAXStrings.indexOfNonWhitespace(this.getContent(), this
					.getContentBegin(), this.getContentEnd()) != -1) {
				return this._setErr(XMLP.ERR_DOC_STRUCTURE);
			}
		}
		if ((XMLP._ELM_B == _5960) || (XMLP._ELM_EMP == _5960)) {
			this.m_iState = XMLP._STATE_DOCUMENT;
		}
	}
	if (XMLP._STATE_DOCUMENT == this.m_iState) {
		if ((XMLP._ELM_B == _5960) || (XMLP._ELM_EMP == _5960)) {
			this.m_stack.push(this.getName());
		}
		if ((XMLP._ELM_E == _5960) || (XMLP._ELM_EMP == _5960)) {
			var _5961 = this.m_stack.pop();
			if ((_5961 === null) || (_5961 != this.getName())) {
				return this._setErr(XMLP.ERR_ELM_NESTING);
			}
		}
		if (this.m_stack.count() === 0) {
			this.m_iState = XMLP._STATE_MISC;
			return _5960;
		}
	}
	if (XMLP._STATE_MISC == this.m_iState) {
		if ((XMLP._ELM_B == _5960) || (XMLP._ELM_E == _5960)
				|| (XMLP._ELM_EMP == _5960) || (XMLP.EVT_DTD == _5960)) {
			return this._setErr(XMLP.ERR_DOC_STRUCTURE);
		}
		if ((XMLP._TEXT == _5960) || (XMLP._ENTITY == _5960)) {
			if (SAXStrings.indexOfNonWhitespace(this.getContent(), this
					.getContentBegin(), this.getContentEnd()) != -1) {
				return this._setErr(XMLP.ERR_DOC_STRUCTURE);
			}
		}
	}
	return _5960;
};
XMLP.prototype._clearAttributes = function() {
	this.m_atts = [];
};
XMLP.prototype._findAttributeIndex = function(name) {
	for ( var i = 0; i < this.m_atts.length; i++) {
		if (this.m_atts[i][XMLP._ATT_NAME] == name) {
			return i;
		}
	}
	return -1;
};
XMLP.prototype.getAttributeCount = function() {
	return this.m_atts ? this.m_atts.length : 0;
};
XMLP.prototype.getAttributeName = function(index) {
	return ((index < 0) || (index >= this.m_atts.length)) ? null
			: this.m_atts[index][XMLP._ATT_NAME];
};
XMLP.prototype.getAttributeValue = function(index) {
	return ((index < 0) || (index >= this.m_atts.length)) ? null
			: __unescapeString(this.m_atts[index][XMLP._ATT_VAL]);
};
XMLP.prototype.getAttributeValueByName = function(name) {
	return this.getAttributeValue(this._findAttributeIndex(name));
};
XMLP.prototype.getColumnNumber = function() {
	return SAXStrings.getColumnNumber(this.m_xml, this.m_iP);
};
XMLP.prototype.getContent = function() {
	return (this.m_cSrc == XMLP._CONT_XML) ? this.m_xml : this.m_cAlt;
};
XMLP.prototype.getContentBegin = function() {
	return this.m_cB;
};
XMLP.prototype.getContentEnd = function() {
	return this.m_cE;
};
XMLP.prototype.getLineNumber = function() {
	return SAXStrings.getLineNumber(this.m_xml, this.m_iP);
};
XMLP.prototype.getName = function() {
	return this.m_name;
};
XMLP.prototype.next = function() {
	return this._checkStructure(this._parse());
};
XMLP.prototype._parse = function() {
	if (this.m_iP == this.m_xml.length) {
		return XMLP._NONE;
	}
	if (this.m_iP == this.m_xml.indexOf("<?", this.m_iP)) {
		return this._parsePI(this.m_iP + 2);
	} else {
		if (this.m_iP == this.m_xml.indexOf("<!DOCTYPE", this.m_iP)) {
			return this._parseDTD(this.m_iP + 9);
		} else {
			if (this.m_iP == this.m_xml.indexOf("<!--", this.m_iP)) {
				return this._parseComment(this.m_iP + 4);
			} else {
				if (this.m_iP == this.m_xml.indexOf("<![CDATA[", this.m_iP)) {
					return this._parseCDATA(this.m_iP + 9);
				} else {
					if (this.m_iP == this.m_xml.indexOf("<", this.m_iP)) {
						return this._parseElement(this.m_iP + 1);
					} else {
						if (this.m_iP == this.m_xml.indexOf("&", this.m_iP)) {
							return this._parseEntity(this.m_iP + 1);
						} else {
							return this._parseText(this.m_iP);
						}
					}
				}
			}
		}
	}
};
XMLP.prototype._parseAttribute = function(iB, iE) {
	var iNB, iNE, iEq, iVB, iVE;
	var _596a, strN, strV;
	this.m_cAlt = "";
	iNB = SAXStrings.indexOfNonWhitespace(this.m_xml, iB, iE);
	if ((iNB == -1) || (iNB >= iE)) {
		return iNB;
	}
	iEq = this.m_xml.indexOf("=", iNB);
	if ((iEq == -1) || (iEq > iE)) {
		return this._setErr(XMLP.ERR_ATT_VALUES);
	}
	iNE = SAXStrings.lastIndexOfNonWhitespace(this.m_xml, iNB, iEq);
	iVB = SAXStrings.indexOfNonWhitespace(this.m_xml, iEq + 1, iE);
	if ((iVB == -1) || (iVB > iE)) {
		return this._setErr(XMLP.ERR_ATT_VALUES);
	}
	_596a = this.m_xml.charAt(iVB);
	if (SAXStrings.QUOTES.indexOf(_596a) == -1) {
		return this._setErr(XMLP.ERR_ATT_VALUES);
	}
	iVE = this.m_xml.indexOf(_596a, iVB + 1);
	if ((iVE == -1) || (iVE > iE)) {
		return this._setErr(XMLP.ERR_ATT_VALUES);
	}
	strN = this.m_xml.substring(iNB, iNE + 1);
	strV = this.m_xml.substring(iVB + 1, iVE);
	if (strN.indexOf("<") != -1) {
		return this._setErr(XMLP.ERR_ATT_LT_NAME);
	}
	if (strV.indexOf("<") != -1) {
		return this._setErr(XMLP.ERR_ATT_LT_VALUE);
	}
	strV = SAXStrings.replace(strV, null, null, "\n", " ");
	strV = SAXStrings.replace(strV, null, null, "\t", " ");
	iRet = this._replaceEntities(strV);
	if (iRet == XMLP._ERROR) {
		return iRet;
	}
	strV = this.m_cAlt;
	if (this._findAttributeIndex(strN) == -1) {
		this._addAttribute(strN, strV);
	} else {
		return this._setErr(XMLP.ERR_ATT_DUP);
	}
	this.m_iP = iVE + 2;
	return XMLP._ATT;
};
XMLP.prototype._parseCDATA = function(iB) {
	var iE = this.m_xml.indexOf("]]>", iB);
	if (iE == -1) {
		return this._setErr(XMLP.ERR_CLOSE_CDATA);
	}
	this._setContent(XMLP._CONT_XML, iB, iE);
	this.m_iP = iE + 3;
	return XMLP._CDATA;
};
XMLP.prototype._parseComment = function(iB) {
	var iE = this.m_xml.indexOf("-" + "->", iB);
	if (iE == -1) {
		return this._setErr(XMLP.ERR_CLOSE_COMMENT);
	}
	this._setContent(XMLP._CONT_XML, iB, iE);
	this.m_iP = iE + 3;
	return XMLP._COMMENT;
};
XMLP.prototype._parseDTD = function(iB) {
	var iE, strClose, iInt, iLast;
	iE = this.m_xml.indexOf(">", iB);
	if (iE == -1) {
		return this._setErr(XMLP.ERR_CLOSE_DTD);
	}
	iInt = this.m_xml.indexOf("[", iB);
	strClose = ((iInt != -1) && (iInt < iE)) ? "]>" : ">";
	while (true) {
		if (iE == iLast) {
			return this._setErr(XMLP.ERR_INFINITELOOP);
		}
		iLast = iE;
		iE = this.m_xml.indexOf(strClose, iB);
		if (iE == -1) {
			return this._setErr(XMLP.ERR_CLOSE_DTD);
		}
		if (this.m_xml.substring(iE - 1, iE + 2) != "]]>") {
			break;
		}
	}
	this.m_iP = iE + strClose.length;
	return XMLP._DTD;
};
XMLP.prototype._parseElement = function(iB) {
	var iE, iDE, iNE, iRet;
	var iType, strN, iLast;
	iDE = iE = this.m_xml.indexOf(">", iB);
	if (iE == -1) {
		return this._setErr(XMLP.ERR_CLOSE_ELM);
	}
	if (this.m_xml.charAt(iB) == "/") {
		iType = XMLP._ELM_E;
		iB++;
	} else {
		iType = XMLP._ELM_B;
	}
	if (this.m_xml.charAt(iE - 1) == "/") {
		if (iType == XMLP._ELM_E) {
			return this._setErr(XMLP.ERR_ELM_EMPTY);
		}
		iType = XMLP._ELM_EMP;
		iDE--;
	}
	iDE = SAXStrings.lastIndexOfNonWhitespace(this.m_xml, iB, iDE);
	if (iE - iB != 1) {
		if (SAXStrings.indexOfNonWhitespace(this.m_xml, iB, iDE) != iB) {
			return this._setErr(XMLP.ERR_ELM_NAME);
		}
	}
	this._clearAttributes();
	iNE = SAXStrings.indexOfWhitespace(this.m_xml, iB, iDE);
	if (iNE == -1) {
		iNE = iDE + 1;
	} else {
		this.m_iP = iNE;
		while (this.m_iP < iDE) {
			if (this.m_iP == iLast) {
				return this._setErr(XMLP.ERR_INFINITELOOP);
			}
			iLast = this.m_iP;
			iRet = this._parseAttribute(this.m_iP, iDE);
			if (iRet == XMLP._ERROR) {
				return iRet;
			}
		}
	}
	strN = this.m_xml.substring(iB, iNE);
	if (strN.indexOf("<") != -1) {
		return this._setErr(XMLP.ERR_ELM_LT_NAME);
	}
	this.m_name = strN;
	this.m_iP = iE + 1;
	return iType;
};
XMLP.prototype._parseEntity = function(iB) {
	var iE = this.m_xml.indexOf(";", iB);
	if (iE == -1) {
		return this._setErr(XMLP.ERR_CLOSE_ENTITY);
	}
	this.m_iP = iE + 1;
	return this._replaceEntity(this.m_xml, iB, iE);
};
XMLP.prototype._parsePI = function(iB) {
	var iE, iTB, iTE, iCB, iCE;
	iE = this.m_xml.indexOf("?>", iB);
	if (iE == -1) {
		return this._setErr(XMLP.ERR_CLOSE_PI);
	}
	iTB = SAXStrings.indexOfNonWhitespace(this.m_xml, iB, iE);
	if (iTB == -1) {
		return this._setErr(XMLP.ERR_PI_TARGET);
	}
	iTE = SAXStrings.indexOfWhitespace(this.m_xml, iTB, iE);
	if (iTE == -1) {
		iTE = iE;
	}
	iCB = SAXStrings.indexOfNonWhitespace(this.m_xml, iTE, iE);
	if (iCB == -1) {
		iCB = iE;
	}
	iCE = SAXStrings.lastIndexOfNonWhitespace(this.m_xml, iCB, iE);
	if (iCE == -1) {
		iCE = iE - 1;
	}
	this.m_name = this.m_xml.substring(iTB, iTE);
	this._setContent(XMLP._CONT_XML, iCB, iCE + 1);
	this.m_iP = iE + 2;
	return XMLP._PI;
};
XMLP.prototype._parseText = function(iB) {
	var iE, iEE;
	iE = this.m_xml.indexOf("<", iB);
	if (iE == -1) {
		iE = this.m_xml.length;
	}
	iEE = this.m_xml.indexOf("&", iB);
	if ((iEE != -1) && (iEE <= iE)) {
		iE = iEE;
	}
	this._setContent(XMLP._CONT_XML, iB, iE);
	this.m_iP = iE;
	return XMLP._TEXT;
};
XMLP.prototype._replaceEntities = function(strD, iB, iE) {
	if (SAXStrings.isEmpty(strD)) {
		return "";
	}
	iB = iB || 0;
	iE = iE || strD.length;
	var iEB, iEE, strRet = "";
	iEB = strD.indexOf("&", iB);
	iEE = iB;
	while ((iEB > 0) && (iEB < iE)) {
		strRet += strD.substring(iEE, iEB);
		iEE = strD.indexOf(";", iEB) + 1;
		if ((iEE === 0) || (iEE > iE)) {
			return this._setErr(XMLP.ERR_CLOSE_ENTITY);
		}
		iRet = this._replaceEntity(strD, iEB + 1, iEE - 1);
		if (iRet == XMLP._ERROR) {
			return iRet;
		}
		strRet += this.m_cAlt;
		iEB = strD.indexOf("&", iEE);
	}
	if (iEE != iE) {
		strRet += strD.substring(iEE, iE);
	}
	this._setContent(XMLP._CONT_ALT, strRet);
	return XMLP._ENTITY;
};
XMLP.prototype._replaceEntity = function(strD, iB, iE) {
	if (SAXStrings.isEmpty(strD)) {
		return -1;
	}
	iB = iB || 0;
	iE = iE || strD.length;
	switch (strD.substring(iB, iE)) {
	case "amp":
		strEnt = "&";
		break;
	case "lt":
		strEnt = "<";
		break;
	case "gt":
		strEnt = ">";
		break;
	case "apos":
		strEnt = "'";
		break;
	case "quot":
		strEnt = "\"";
		break;
	default:
		if (strD.charAt(iB) == "#") {
			strEnt = String.fromCharCode(parseInt(strD.substring(iB + 1, iE)));
		} else {
			return this._setErr(XMLP.ERR_ENTITY_UNKNOWN);
		}
		break;
	}
	this._setContent(XMLP._CONT_ALT, strEnt);
	return XMLP._ENTITY;
};
XMLP.prototype._setContent = function(iSrc) {
	var args = arguments;
	if (XMLP._CONT_XML == iSrc) {
		this.m_cAlt = null;
		this.m_cB = args[1];
		this.m_cE = args[2];
	} else {
		this.m_cAlt = args[1];
		this.m_cB = 0;
		this.m_cE = args[1].length;
	}
	this.m_cSrc = iSrc;
};
XMLP.prototype._setErr = function(iErr) {
	var _5984 = XMLP._errs[iErr];
	this.m_cAlt = _5984;
	this.m_cB = 0;
	this.m_cE = _5984.length;
	this.m_cSrc = XMLP._CONT_ALT;
	return XMLP._ERROR;
};
SAXDriver = function() {
	this.m_hndDoc = null;
	this.m_hndErr = null;
	this.m_hndLex = null;
};
SAXDriver.DOC_B = 1;
SAXDriver.DOC_E = 2;
SAXDriver.ELM_B = 3;
SAXDriver.ELM_E = 4;
SAXDriver.CHARS = 5;
SAXDriver.PI = 6;
SAXDriver.CD_B = 7;
SAXDriver.CD_E = 8;
SAXDriver.CMNT = 9;
SAXDriver.DTD_B = 10;
SAXDriver.DTD_E = 11;
SAXDriver.prototype.parse = function(strD) {
	var _5986 = new XMLP(strD);
	if (this.m_hndDoc && this.m_hndDoc.setDocumentLocator) {
		this.m_hndDoc.setDocumentLocator(this);
	}
	this.m_parser = _5986;
	this.m_bErr = false;
	if (!this.m_bErr) {
		this._fireEvent(SAXDriver.DOC_B);
	}
	this._parseLoop();
	if (!this.m_bErr) {
		this._fireEvent(SAXDriver.DOC_E);
	}
	this.m_xml = null;
	this.m_iP = 0;
};
SAXDriver.prototype.setDocumentHandler = function(hnd) {
	this.m_hndDoc = hnd;
};
SAXDriver.prototype.setErrorHandler = function(hnd) {
	this.m_hndErr = hnd;
};
SAXDriver.prototype.setLexicalHandler = function(hnd) {
	this.m_hndLex = hnd;
};
SAXDriver.prototype.getColumnNumber = function() {
	return this.m_parser.getColumnNumber();
};
SAXDriver.prototype.getLineNumber = function() {
	return this.m_parser.getLineNumber();
};
SAXDriver.prototype.getMessage = function() {
	return this.m_strErrMsg;
};
SAXDriver.prototype.getPublicId = function() {
	return null;
};
SAXDriver.prototype.getSystemId = function() {
	return null;
};
SAXDriver.prototype.getLength = function() {
	return this.m_parser.getAttributeCount();
};
SAXDriver.prototype.getName = function(index) {
	return this.m_parser.getAttributeName(index);
};
SAXDriver.prototype.getValue = function(index) {
	return this.m_parser.getAttributeValue(index);
};
SAXDriver.prototype.getValueByName = function(name) {
	return this.m_parser.getAttributeValueByName(name);
};
SAXDriver.prototype._fireError = function(_598d) {
	this.m_strErrMsg = _598d;
	this.m_bErr = true;
	if (this.m_hndErr && this.m_hndErr.fatalError) {
		this.m_hndErr.fatalError(this);
	}
};
SAXDriver.prototype._fireEvent = function(iEvt) {
	var hnd, func, args = arguments, iLen = args.length - 1;
	if (this.m_bErr) {
		return;
	}
	if (SAXDriver.DOC_B == iEvt) {
		func = "startDocument";
		hnd = this.m_hndDoc;
	} else {
		if (SAXDriver.DOC_E == iEvt) {
			func = "endDocument";
			hnd = this.m_hndDoc;
		} else {
			if (SAXDriver.ELM_B == iEvt) {
				func = "startElement";
				hnd = this.m_hndDoc;
			} else {
				if (SAXDriver.ELM_E == iEvt) {
					func = "endElement";
					hnd = this.m_hndDoc;
				} else {
					if (SAXDriver.CHARS == iEvt) {
						func = "characters";
						hnd = this.m_hndDoc;
					} else {
						if (SAXDriver.PI == iEvt) {
							func = "processingInstruction";
							hnd = this.m_hndDoc;
						} else {
							if (SAXDriver.CD_B == iEvt) {
								func = "startCDATA";
								hnd = this.m_hndLex;
							} else {
								if (SAXDriver.CD_E == iEvt) {
									func = "endCDATA";
									hnd = this.m_hndLex;
								} else {
									if (SAXDriver.CMNT == iEvt) {
										func = "comment";
										hnd = this.m_hndLex;
									}
								}
							}
						}
					}
				}
			}
		}
	}
	if (hnd && hnd[func]) {
		if (0 == iLen) {
			hnd[func]();
		} else {
			if (1 == iLen) {
				hnd[func](args[1]);
			} else {
				if (2 == iLen) {
					hnd[func](args[1], args[2]);
				} else {
					if (3 == iLen) {
						hnd[func](args[1], args[2], args[3]);
					}
				}
			}
		}
	}
};
SAXDriver.prototype._parseLoop = function(_5990) {
	var _5991, _5990;
	_5990 = this.m_parser;
	while (!this.m_bErr) {
		_5991 = _5990.next();
		if (_5991 == XMLP._ELM_B) {
			this._fireEvent(SAXDriver.ELM_B, _5990.getName(), this);
		} else {
			if (_5991 == XMLP._ELM_E) {
				this._fireEvent(SAXDriver.ELM_E, _5990.getName());
			} else {
				if (_5991 == XMLP._ELM_EMP) {
					this._fireEvent(SAXDriver.ELM_B, _5990.getName(), this);
					this._fireEvent(SAXDriver.ELM_E, _5990.getName());
				} else {
					if (_5991 == XMLP._TEXT) {
						this._fireEvent(SAXDriver.CHARS, _5990.getContent(),
								_5990.getContentBegin(), _5990.getContentEnd()
										- _5990.getContentBegin());
					} else {
						if (_5991 == XMLP._ENTITY) {
							this._fireEvent(SAXDriver.CHARS,
									_5990.getContent(),
									_5990.getContentBegin(), _5990
											.getContentEnd()
											- _5990.getContentBegin());
						} else {
							if (_5991 == XMLP._PI) {
								this._fireEvent(SAXDriver.PI, _5990.getName(),
										_5990.getContent().substring(
												_5990.getContentBegin(),
												_5990.getContentEnd()));
							} else {
								if (_5991 == XMLP._CDATA) {
									this._fireEvent(SAXDriver.CD_B);
									this._fireEvent(SAXDriver.CHARS, _5990
											.getContent(), _5990
											.getContentBegin(), _5990
											.getContentEnd()
											- _5990.getContentBegin());
									this._fireEvent(SAXDriver.CD_E);
								} else {
									if (_5991 == XMLP._COMMENT) {
										this._fireEvent(SAXDriver.CMNT, _5990
												.getContent(), _5990
												.getContentBegin(), _5990
												.getContentEnd()
												- _5990.getContentBegin());
									} else {
										if (_5991 == XMLP._DTD) {
										} else {
											if (_5991 == XMLP._ERROR) {
												this._fireError(_5990
														.getContent());
											} else {
												if (_5991 == XMLP._NONE) {
													return;
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
};
SAXStrings = function() {
};
SAXStrings.WHITESPACE = " \t\n\r";
SAXStrings.QUOTES = "\"'";
SAXStrings.getColumnNumber = function(strD, iP) {
	if (SAXStrings.isEmpty(strD)) {
		return -1;
	}
	iP = iP || strD.length;
	var arrD = strD.substring(0, iP).split("\n");
	var _5995 = arrD[arrD.length - 1];
	arrD.length--;
	var _5996 = arrD.join("\n").length;
	return iP - _5996;
};
SAXStrings.getLineNumber = function(strD, iP) {
	if (SAXStrings.isEmpty(strD)) {
		return -1;
	}
	iP = iP || strD.length;
	return strD.substring(0, iP).split("\n").length;
};
SAXStrings.indexOfNonWhitespace = function(strD, iB, iE) {
	if (SAXStrings.isEmpty(strD)) {
		return -1;
	}
	iB = iB || 0;
	iE = iE || strD.length;
	for ( var i = iB; i < iE; i++) {
		if (SAXStrings.WHITESPACE.indexOf(strD.charAt(i)) == -1) {
			return i;
		}
	}
	return -1;
};
SAXStrings.indexOfWhitespace = function(strD, iB, iE) {
	if (SAXStrings.isEmpty(strD)) {
		return -1;
	}
	iB = iB || 0;
	iE = iE || strD.length;
	for ( var i = iB; i < iE; i++) {
		if (SAXStrings.WHITESPACE.indexOf(strD.charAt(i)) != -1) {
			return i;
		}
	}
	return -1;
};
SAXStrings.isEmpty = function(strD) {
	return (strD === null) || (strD.length === 0);
};
SAXStrings.lastIndexOfNonWhitespace = function(strD, iB, iE) {
	if (SAXStrings.isEmpty(strD)) {
		return -1;
	}
	iB = iB || 0;
	iE = iE || strD.length;
	for ( var i = iE - 1; i >= iB; i--) {
		if (SAXStrings.WHITESPACE.indexOf(strD.charAt(i)) == -1) {
			return i;
		}
	}
	return -1;
};
SAXStrings.replace = function(strD, iB, iE, strF, strR) {
	if (SAXStrings.isEmpty(strD)) {
		return "";
	}
	iB = iB || 0;
	iE = iE || strD.length;
	return strD.substring(iB, iE).split(strF).join(strR);
};
Stack = function() {
	this.m_arr = [];
};
Stack.prototype.clear = function() {
	this.m_arr = [];
};
Stack.prototype.count = function() {
	return this.m_arr.length;
};
Stack.prototype.destroy = function() {
	this.m_arr = null;
};
Stack.prototype.peek = function() {
	if (this.m_arr.length === 0) {
		return null;
	}
	return this.m_arr[this.m_arr.length - 1];
};
Stack.prototype.pop = function() {
	if (this.m_arr.length === 0) {
		return null;
	}
	var o = this.m_arr[this.m_arr.length - 1];
	this.m_arr.length--;
	return o;
};
Stack.prototype.push = function(o) {
	this.m_arr[this.m_arr.length] = o;
};
function isEmpty(str) {
	return (str === null) || (str.length == 0);
}
function trim(_59ae, _59af, _59b0) {
	if (isEmpty(_59ae)) {
		return "";
	}
	if (_59af === null) {
		_59af = true;
	}
	if (_59b0 === null) {
		_59b0 = true;
	}
	var left = 0;
	var right = 0;
	var i = 0;
	var k = 0;
	if (_59af == true) {
		while ((i < _59ae.length)
				&& (whitespace.indexOf(_59ae.charAt(i++)) != -1)) {
			left++;
		}
	}
	if (_59b0 == true) {
		k = _59ae.length - 1;
		while ((k >= left) && (whitespace.indexOf(_59ae.charAt(k--)) != -1)) {
			right++;
		}
	}
	return _59ae.substring(left, _59ae.length - right);
}
function __escapeString(str) {
	var _59b6 = /&/g;
	var _59b7 = /</g;
	var _59b8 = />/g;
	var _59b9 = /"/g;
	var _59ba = /'/g;
	str = str.replace(_59b6, "&amp;");
	str = str.replace(_59b7, "&lt;");
	str = str.replace(_59b8, "&gt;");
	str = str.replace(_59b9, "&quot;");
	str = str.replace(_59ba, "&apos;");
	return str;
}
function __unescapeString(str) {
	var _59bc = /&amp;/g;
	var _59bd = /&lt;/g;
	var _59be = /&gt;/g;
	var _59bf = /&quot;/g;
	var _59c0 = /&apos;/g;
	str = str.replace(_59bc, "&");
	str = str.replace(_59bd, "<");
	str = str.replace(_59be, ">");
	str = str.replace(_59bf, "\"");
	str = str.replace(_59c0, "'");
	return str;
}
function addClass(_619a, _619b) {
	if (_619a) {
		if (_619a.indexOf("|" + _619b + "|") < 0) {
			_619a += _619b + "|";
		}
	} else {
		_619a = "|" + _619b + "|";
	}
	return _619a;
}
DOMException = function(code) {
	this._class = addClass(this._class, "DOMException");
	this.code = code;
};
DOMException.INDEX_SIZE_ERR = 1;
DOMException.DOMSTRING_SIZE_ERR = 2;
DOMException.HIERARCHY_REQUEST_ERR = 3;
DOMException.WRONG_DOCUMENT_ERR = 4;
DOMException.INVALID_CHARACTER_ERR = 5;
DOMException.NO_DATA_ALLOWED_ERR = 6;
DOMException.NO_MODIFICATION_ALLOWED_ERR = 7;
DOMException.NOT_FOUND_ERR = 8;
DOMException.NOT_SUPPORTED_ERR = 9;
DOMException.INUSE_ATTRIBUTE_ERR = 10;
DOMException.INVALID_STATE_ERR = 11;
DOMException.SYNTAX_ERR = 12;
DOMException.INVALID_MODIFICATION_ERR = 13;
DOMException.NAMESPACE_ERR = 14;
DOMException.INVALID_ACCESS_ERR = 15;
DOMImplementation = function() {
	this._class = addClass(this._class, "DOMImplementation");
	this._p = null;
	this.preserveWhiteSpace = false;
	this.namespaceAware = true;
	this.errorChecking = true;
};
DOMImplementation.prototype.escapeString = function DOMNode__escapeString(str) {
	return __escapeString(str);
};
DOMImplementation.prototype.unescapeString = function DOMNode__unescapeString(
		str) {
	return __unescapeString(str);
};
DOMImplementation.prototype.hasFeature = function DOMImplementation_hasFeature(
		_619f, _61a0) {
	var ret = false;
	if (_619f.toLowerCase() == "xml") {
		ret = (!_61a0 || (_61a0 == "1.0") || (_61a0 == "2.0"));
	} else {
		if (_619f.toLowerCase() == "core") {
			ret = (!_61a0 || (_61a0 == "2.0"));
		}
	}
	return ret;
};
DOMImplementation.prototype.loadXML = function DOMImplementation_loadXML(_61a2) {
	var _61a3;
	try {
		_61a3 = new XMLP(_61a2);
	} catch (e) {
		alert("Error Creating the SAX Parser. Did you include xmlsax.js or tinyxmlsax.js in your web page?\nThe SAX parser is needed to populate XML for <SCRIPT>'s W3C DOM Parser with data.");
	}
	var doc = new DOMDocument(this);
	this._parseLoop(doc, _61a3);
	doc._parseComplete = true;
	return doc;
};
DOMImplementation.prototype.translateErrCode = function DOMImplementation_translateErrCode(
		code) {
	var msg = "";
	switch (code) {
	case DOMException.INDEX_SIZE_ERR:
		msg = "INDEX_SIZE_ERR: Index out of bounds";
		break;
	case DOMException.DOMSTRING_SIZE_ERR:
		msg = "DOMSTRING_SIZE_ERR: The resulting string is too long to fit in a DOMString";
		break;
	case DOMException.HIERARCHY_REQUEST_ERR:
		msg = "HIERARCHY_REQUEST_ERR: The Node can not be inserted at this location";
		break;
	case DOMException.WRONG_DOCUMENT_ERR:
		msg = "WRONG_DOCUMENT_ERR: The source and the destination Documents are not the same";
		break;
	case DOMException.INVALID_CHARACTER_ERR:
		msg = "INVALID_CHARACTER_ERR: The string contains an invalid character";
		break;
	case DOMException.NO_DATA_ALLOWED_ERR:
		msg = "NO_DATA_ALLOWED_ERR: This Node / NodeList does not support data";
		break;
	case DOMException.NO_MODIFICATION_ALLOWED_ERR:
		msg = "NO_MODIFICATION_ALLOWED_ERR: This object cannot be modified";
		break;
	case DOMException.NOT_FOUND_ERR:
		msg = "NOT_FOUND_ERR: The item cannot be found";
		break;
	case DOMException.NOT_SUPPORTED_ERR:
		msg = "NOT_SUPPORTED_ERR: This implementation does not support function";
		break;
	case DOMException.INUSE_ATTRIBUTE_ERR:
		msg = "INUSE_ATTRIBUTE_ERR: The Attribute has already been assigned to another Element";
		break;
	case DOMException.INVALID_STATE_ERR:
		msg = "INVALID_STATE_ERR: The object is no longer usable";
		break;
	case DOMException.SYNTAX_ERR:
		msg = "SYNTAX_ERR: Syntax error";
		break;
	case DOMException.INVALID_MODIFICATION_ERR:
		msg = "INVALID_MODIFICATION_ERR: Cannot change the type of the object";
		break;
	case DOMException.NAMESPACE_ERR:
		msg = "NAMESPACE_ERR: The namespace declaration is incorrect";
		break;
	case DOMException.INVALID_ACCESS_ERR:
		msg = "INVALID_ACCESS_ERR: The object does not support this function";
		break;
	default:
		msg = "UNKNOWN: Unknown Exception Code (" + code + ")";
	}
	return msg;
};
DOMImplementation.prototype._parseLoop = function DOMImplementation__parseLoop(
		doc, p) {
	var iEvt, iNode, iAttr, strName;
	iNodeParent = doc;
	var _61aa = 0;
	var _61ab = [];
	var _61ac = [];
	if (this.namespaceAware) {
		var iNS = doc.createNamespace("");
		iNS.setValue("http://www.w3.org/2000/xmlns/");
		doc._namespaces.setNamedItem(iNS);
	}
	while (true) {
		iEvt = p.next();
		if (iEvt == XMLP._ELM_B) {
			var pName = p.getName();
			pName = trim(pName, true, true);
			if (!this.namespaceAware) {
				iNode = doc.createElement(p.getName());
				for ( var i = 0; i < p.getAttributeCount(); i++) {
					strName = p.getAttributeName(i);
					iAttr = iNode.getAttributeNode(strName);
					if (!iAttr) {
						iAttr = doc.createAttribute(strName);
					}
					iAttr.setValue(p.getAttributeValue(i));
					iNode.setAttributeNode(iAttr);
				}
			} else {
				iNode = doc.createElementNS("", p.getName());
				iNode._namespaces = iNodeParent._namespaces._cloneNodes(iNode);
				for ( var i = 0; i < p.getAttributeCount(); i++) {
					strName = p.getAttributeName(i);
					if (this._isNamespaceDeclaration(strName)) {
						var _61b0 = this._parseNSName(strName);
						if (strName != "xmlns") {
							iNS = doc.createNamespace(strName);
						} else {
							iNS = doc.createNamespace("");
						}
						iNS.setValue(p.getAttributeValue(i));
						iNode._namespaces.setNamedItem(iNS);
					} else {
						iAttr = iNode.getAttributeNode(strName);
						if (!iAttr) {
							iAttr = doc.createAttributeNS("", strName);
						}
						iAttr.setValue(p.getAttributeValue(i));
						iNode.setAttributeNodeNS(iAttr);
						if (this._isIdDeclaration(strName)) {
							iNode.id = p.getAttributeValue(i);
						}
					}
				}
				if (iNode._namespaces.getNamedItem(iNode.prefix)) {
					iNode.namespaceURI = iNode._namespaces
							.getNamedItem(iNode.prefix).value;
				}
				for ( var i = 0; i < iNode.attributes.length; i++) {
					if (iNode.attributes.item(i).prefix != "") {
						if (iNode._namespaces.getNamedItem(iNode.attributes
								.item(i).prefix)) {
							iNode.attributes.item(i).namespaceURI = iNode._namespaces
									.getNamedItem(iNode.attributes.item(i).prefix).value;
						}
					}
				}
			}
			if (iNodeParent.nodeType == DOMNode.DOCUMENT_NODE) {
				iNodeParent.documentElement = iNode;
			}
			iNodeParent.appendChild(iNode);
			iNodeParent = iNode;
		} else {
			if (iEvt == XMLP._ELM_E) {
				iNodeParent = iNodeParent.parentNode;
			} else {
				if (iEvt == XMLP._ELM_EMP) {
					pName = p.getName();
					pName = trim(pName, true, true);
					if (!this.namespaceAware) {
						iNode = doc.createElement(pName);
						for ( var i = 0; i < p.getAttributeCount(); i++) {
							strName = p.getAttributeName(i);
							iAttr = iNode.getAttributeNode(strName);
							if (!iAttr) {
								iAttr = doc.createAttribute(strName);
							}
							iAttr.setValue(p.getAttributeValue(i));
							iNode.setAttributeNode(iAttr);
						}
					} else {
						iNode = doc.createElementNS("", p.getName());
						iNode._namespaces = iNodeParent._namespaces
								._cloneNodes(iNode);
						for ( var i = 0; i < p.getAttributeCount(); i++) {
							strName = p.getAttributeName(i);
							if (this._isNamespaceDeclaration(strName)) {
								var _61b0 = this._parseNSName(strName);
								if (strName != "xmlns") {
									iNS = doc.createNamespace(strName);
								} else {
									iNS = doc.createNamespace("");
								}
								iNS.setValue(p.getAttributeValue(i));
								iNode._namespaces.setNamedItem(iNS);
							} else {
								iAttr = iNode.getAttributeNode(strName);
								if (!iAttr) {
									iAttr = doc.createAttributeNS("", strName);
								}
								iAttr.setValue(p.getAttributeValue(i));
								iNode.setAttributeNodeNS(iAttr);
								if (this._isIdDeclaration(strName)) {
									iNode.id = p.getAttributeValue(i);
								}
							}
						}
						if (iNode._namespaces.getNamedItem(iNode.prefix)) {
							iNode.namespaceURI = iNode._namespaces
									.getNamedItem(iNode.prefix).value;
						}
						for ( var i = 0; i < iNode.attributes.length; i++) {
							if (iNode.attributes.item(i).prefix != "") {
								if (iNode._namespaces
										.getNamedItem(iNode.attributes.item(i).prefix)) {
									iNode.attributes.item(i).namespaceURI = iNode._namespaces
											.getNamedItem(iNode.attributes
													.item(i).prefix).value;
								}
							}
						}
					}
					if (iNodeParent.nodeType == DOMNode.DOCUMENT_NODE) {
						iNodeParent.documentElement = iNode;
					}
					iNodeParent.appendChild(iNode);
				} else {
					if (iEvt == XMLP._TEXT || iEvt == XMLP._ENTITY) {
						var _61b1 = p.getContent().substring(
								p.getContentBegin(), p.getContentEnd());
						if (!this.preserveWhiteSpace) {
							if (trim(_61b1, true, true) == "") {
								_61b1 = "";
							}
						}
						if (_61b1.length > 0) {
							var _61b2 = doc.createTextNode(_61b1);
							iNodeParent.appendChild(_61b2);
							if (iEvt == XMLP._ENTITY) {
								_61ab[_61ab.length] = _61b2;
							} else {
								_61ac[_61ac.length] = _61b2;
							}
						}
					} else {
						if (iEvt == XMLP._PI) {
							iNodeParent.appendChild(doc
									.createProcessingInstruction(p.getName(), p
											.getContent().substring(
													p.getContentBegin(),
													p.getContentEnd())));
						} else {
							if (iEvt == XMLP._CDATA) {
								_61b1 = p.getContent().substring(
										p.getContentBegin(), p.getContentEnd());
								if (!this.preserveWhiteSpace) {
									_61b1 = trim(_61b1, true, true);
									_61b1.replace(/ +/g, " ");
								}
								if (_61b1.length > 0) {
									iNodeParent.appendChild(doc
											.createCDATASection(_61b1));
								}
							} else {
								if (iEvt == XMLP._COMMENT) {
									var _61b1 = p.getContent().substring(
											p.getContentBegin(),
											p.getContentEnd());
									if (!this.preserveWhiteSpace) {
										_61b1 = trim(_61b1, true, true);
										_61b1.replace(/ +/g, " ");
									}
									if (_61b1.length > 0) {
										iNodeParent.appendChild(doc
												.createComment(_61b1));
									}
								} else {
									if (iEvt == XMLP._DTD) {
									} else {
										if (iEvt == XMLP._ERROR) {
											throw (new DOMException(
													DOMException.SYNTAX_ERR));
										} else {
											if (iEvt == XMLP._NONE) {
												if (iNodeParent == doc) {
													break;
												} else {
													throw (new DOMException(
															DOMException.SYNTAX_ERR));
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	var _61b3 = _61ab.length;
	for (intLoop = 0; intLoop < _61b3; intLoop++) {
		var _61b4 = _61ab[intLoop];
		var _61b5 = _61b4.getParentNode();
		if (_61b5) {
			_61b5.normalize();
			if (!this.preserveWhiteSpace) {
				var _61b6 = _61b5.getChildNodes();
				var _61b7 = _61b6.getLength();
				for (intLoop2 = 0; intLoop2 < _61b7; intLoop2++) {
					var child = _61b6.item(intLoop2);
					if (child.getNodeType() == DOMNode.TEXT_NODE) {
						var _61b9 = child.getData();
						_61b9 = trim(_61b9, true, true);
						_61b9.replace(/ +/g, " ");
						child.setData(_61b9);
					}
				}
			}
		}
	}
	if (!this.preserveWhiteSpace) {
		var _61b3 = _61ac.length;
		for (intLoop = 0; intLoop < _61b3; intLoop++) {
			var node = _61ac[intLoop];
			if (node.getParentNode() !== null) {
				var _61bb = node.getData();
				_61bb = trim(_61bb, true, true);
				_61bb.replace(/ +/g, " ");
				node.setData(_61bb);
			}
		}
	}
};
DOMImplementation.prototype._isNamespaceDeclaration = function DOMImplementation__isNamespaceDeclaration(
		_61bc) {
	return (_61bc.indexOf("xmlns") > -1);
};
DOMImplementation.prototype._isIdDeclaration = function DOMImplementation__isIdDeclaration(
		_61bd) {
	return (_61bd.toLowerCase() == "id");
};
DOMImplementation.prototype._isValidName = function DOMImplementation__isValidName(
		name) {
	return name.match(re_validName);
};
re_validName = /^[a-zA-Z_:][a-zA-Z0-9\.\-_:]*$/;
DOMImplementation.prototype._isValidString = function DOMImplementation__isValidString(
		name) {
	return (name.search(re_invalidStringChars) < 0);
};
re_invalidStringChars = /\x01|\x02|\x03|\x04|\x05|\x06|\x07|\x08|\x0B|\x0C|\x0E|\x0F|\x10|\x11|\x12|\x13|\x14|\x15|\x16|\x17|\x18|\x19|\x1A|\x1B|\x1C|\x1D|\x1E|\x1F|\x7F/;
DOMImplementation.prototype._parseNSName = function DOMImplementation__parseNSName(
		_61c0) {
	var _61c1 = {};
	_61c1.prefix = _61c0;
	_61c1.namespaceName = "";
	delimPos = _61c0.indexOf(":");
	if (delimPos > -1) {
		_61c1.prefix = _61c0.substring(0, delimPos);
		_61c1.namespaceName = _61c0.substring(delimPos + 1, _61c0.length);
	}
	return _61c1;
};
DOMImplementation.prototype._parseQName = function DOMImplementation__parseQName(
		_61c2) {
	var _61c3 = {};
	_61c3.localName = _61c2;
	_61c3.prefix = "";
	delimPos = _61c2.indexOf(":");
	if (delimPos > -1) {
		_61c3.prefix = _61c2.substring(0, delimPos);
		_61c3.localName = _61c2.substring(delimPos + 1, _61c2.length);
	}
	return _61c3;
};
DOMNodeList = function(_61c4, _61c5) {
	this._class = addClass(this._class, "DOMNodeList");
	this._nodes = [];
	this.length = 0;
	this.parentNode = _61c5;
	this.ownerDocument = _61c4;
	this._readonly = false;
};
DOMNodeList.prototype.getLength = function DOMNodeList_getLength() {
	return this.length;
};
DOMNodeList.prototype.item = function DOMNodeList_item(index) {
	var ret = null;
	if ((index >= 0) && (index < this._nodes.length)) {
		ret = this._nodes[index];
	}
	return ret;
};
DOMNodeList.prototype._findItemIndex = function DOMNodeList__findItemIndex(id) {
	var ret = -1;
	if (id > -1) {
		for ( var i = 0; i < this._nodes.length; i++) {
			if (this._nodes[i]._id == id) {
				ret = i;
				break;
			}
		}
	}
	return ret;
};
DOMNodeList.prototype._insertBefore = function DOMNodeList__insertBefore(_61cb,
		_61cc) {
	if ((_61cc >= 0) && (_61cc < this._nodes.length)) {
		var _61cd = [];
		_61cd = this._nodes.slice(0, _61cc);
		if (_61cb.nodeType == DOMNode.DOCUMENT_FRAGMENT_NODE) {
			_61cd = _61cd.concat(_61cb.childNodes._nodes);
		} else {
			_61cd[_61cd.length] = _61cb;
		}
		this._nodes = _61cd.concat(this._nodes.slice(_61cc));
		this.length = this._nodes.length;
	}
};
DOMNodeList.prototype._replaceChild = function DOMNodeList__replaceChild(_61ce,
		_61cf) {
	var ret = null;
	if ((_61cf >= 0) && (_61cf < this._nodes.length)) {
		ret = this._nodes[_61cf];
		if (_61ce.nodeType == DOMNode.DOCUMENT_FRAGMENT_NODE) {
			var _61d1 = [];
			_61d1 = this._nodes.slice(0, _61cf);
			_61d1 = _61d1.concat(_61ce.childNodes._nodes);
			this._nodes = _61d1.concat(this._nodes.slice(_61cf + 1));
		} else {
			this._nodes[_61cf] = _61ce;
		}
	}
	return ret;
};
DOMNodeList.prototype._removeChild = function DOMNodeList__removeChild(_61d2) {
	var ret = null;
	if (_61d2 > -1) {
		ret = this._nodes[_61d2];
		var _61d4 = [];
		_61d4 = this._nodes.slice(0, _61d2);
		this._nodes = _61d4.concat(this._nodes.slice(_61d2 + 1));
		this.length = this._nodes.length;
	}
	return ret;
};
DOMNodeList.prototype._appendChild = function DOMNodeList__appendChild(_61d5) {
	if (_61d5.nodeType == DOMNode.DOCUMENT_FRAGMENT_NODE) {
		this._nodes = this._nodes.concat(_61d5.childNodes._nodes);
	} else {
		this._nodes[this._nodes.length] = _61d5;
	}
	this.length = this._nodes.length;
};
DOMNodeList.prototype._cloneNodes = function DOMNodeList__cloneNodes(deep,
		_61d7) {
	var _61d8 = new DOMNodeList(this.ownerDocument, _61d7);
	for ( var i = 0; i < this._nodes.length; i++) {
		_61d8._appendChild(this._nodes[i].cloneNode(deep));
	}
	return _61d8;
};
DOMNodeList.prototype.toString = function DOMNodeList_toString() {
	var ret = "";
	for ( var i = 0; i < this.length; i++) {
		ret += this._nodes[i].toString();
	}
	return ret;
};
DOMNamedNodeMap = function(_61dc, _61dd) {
	this._class = addClass(this._class, "DOMNamedNodeMap");
	this.DOMNodeList = DOMNodeList;
	this.DOMNodeList(_61dc, _61dd);
};
DOMNamedNodeMap.prototype = new DOMNodeList;
DOMNamedNodeMap.prototype.getNamedItem = function DOMNamedNodeMap_getNamedItem(
		name) {
	var ret = null;
	var _61e0 = this._findNamedItemIndex(name);
	if (_61e0 > -1) {
		ret = this._nodes[_61e0];
	}
	return ret;
};
DOMNamedNodeMap.prototype.setNamedItem = function DOMNamedNodeMap_setNamedItem(
		arg) {
	if (this.ownerDocument.implementation.errorChecking) {
		if (this.ownerDocument != arg.ownerDocument) {
			throw (new DOMException(DOMException.WRONG_DOCUMENT_ERR));
		}
		if (this._readonly || (this.parentNode && this.parentNode._readonly)) {
			throw (new DOMException(DOMException.NO_MODIFICATION_ALLOWED_ERR));
		}
		if (arg.ownerElement && (arg.ownerElement != this.parentNode)) {
			throw (new DOMException(DOMException.INUSE_ATTRIBUTE_ERR));
		}
	}
	var _61e2 = this._findNamedItemIndex(arg.name);
	var ret = null;
	if (_61e2 > -1) {
		ret = this._nodes[_61e2];
		if (this.ownerDocument.implementation.errorChecking && ret._readonly) {
			throw (new DOMException(DOMException.NO_MODIFICATION_ALLOWED_ERR));
		} else {
			this._nodes[_61e2] = arg;
		}
	} else {
		this._nodes[this.length] = arg;
	}
	this.length = this._nodes.length;
	arg.ownerElement = this.parentNode;
	return ret;
};
DOMNamedNodeMap.prototype.removeNamedItem = function DOMNamedNodeMap_removeNamedItem(
		name) {
	var ret = null;
	if (this.ownerDocument.implementation.errorChecking
			&& (this._readonly || (this.parentNode && this.parentNode._readonly))) {
		throw (new DOMException(DOMException.NO_MODIFICATION_ALLOWED_ERR));
	}
	var _61e6 = this._findNamedItemIndex(name);
	if (this.ownerDocument.implementation.errorChecking && (_61e6 < 0)) {
		throw (new DOMException(DOMException.NOT_FOUND_ERR));
	}
	var _61e7 = this._nodes[_61e6];
	if (this.ownerDocument.implementation.errorChecking && _61e7._readonly) {
		throw (new DOMException(DOMException.NO_MODIFICATION_ALLOWED_ERR));
	}
	return this._removeChild(_61e6);
};
DOMNamedNodeMap.prototype.getNamedItemNS = function DOMNamedNodeMap_getNamedItemNS(
		_61e8, _61e9) {
	var ret = null;
	var _61eb = this._findNamedItemNSIndex(_61e8, _61e9);
	if (_61eb > -1) {
		ret = this._nodes[_61eb];
	}
	return ret;
};
DOMNamedNodeMap.prototype.setNamedItemNS = function DOMNamedNodeMap_setNamedItemNS(
		arg) {
	if (this.ownerDocument.implementation.errorChecking) {
		if (this._readonly || (this.parentNode && this.parentNode._readonly)) {
			throw (new DOMException(DOMException.NO_MODIFICATION_ALLOWED_ERR));
		}
		if (this.ownerDocument != arg.ownerDocument) {
			throw (new DOMException(DOMException.WRONG_DOCUMENT_ERR));
		}
		if (arg.ownerElement && (arg.ownerElement != this.parentNode)) {
			throw (new DOMException(DOMException.INUSE_ATTRIBUTE_ERR));
		}
	}
	var _61ed = this._findNamedItemNSIndex(arg.namespaceURI, arg.localName);
	var ret = null;
	if (_61ed > -1) {
		ret = this._nodes[_61ed];
		if (this.ownerDocument.implementation.errorChecking && ret._readonly) {
			throw (new DOMException(DOMException.NO_MODIFICATION_ALLOWED_ERR));
		} else {
			this._nodes[_61ed] = arg;
		}
	} else {
		this._nodes[this.length] = arg;
	}
	this.length = this._nodes.length;
	arg.ownerElement = this.parentNode;
	return ret;
};
DOMNamedNodeMap.prototype.removeNamedItemNS = function DOMNamedNodeMap_removeNamedItemNS(
		_61ef, _61f0) {
	var ret = null;
	if (this.ownerDocument.implementation.errorChecking
			&& (this._readonly || (this.parentNode && this.parentNode._readonly))) {
		throw (new DOMException(DOMException.NO_MODIFICATION_ALLOWED_ERR));
	}
	var _61f2 = this._findNamedItemNSIndex(_61ef, _61f0);
	if (this.ownerDocument.implementation.errorChecking && (_61f2 < 0)) {
		throw (new DOMException(DOMException.NOT_FOUND_ERR));
	}
	var _61f3 = this._nodes[_61f2];
	if (this.ownerDocument.implementation.errorChecking && _61f3._readonly) {
		throw (new DOMException(DOMException.NO_MODIFICATION_ALLOWED_ERR));
	}
	return this._removeChild(_61f2);
};
DOMNamedNodeMap.prototype._findNamedItemIndex = function DOMNamedNodeMap__findNamedItemIndex(
		name) {
	var ret = -1;
	for ( var i = 0; i < this._nodes.length; i++) {
		if (this._nodes[i].name == name) {
			ret = i;
			break;
		}
	}
	return ret;
};
DOMNamedNodeMap.prototype._findNamedItemNSIndex = function DOMNamedNodeMap__findNamedItemNSIndex(
		_61f7, _61f8) {
	var ret = -1;
	if (_61f8) {
		for ( var i = 0; i < this._nodes.length; i++) {
			if ((this._nodes[i].namespaceURI == _61f7)
					&& (this._nodes[i].localName == _61f8)) {
				ret = i;
				break;
			}
		}
	}
	return ret;
};
DOMNamedNodeMap.prototype._hasAttribute = function DOMNamedNodeMap__hasAttribute(
		name) {
	var ret = false;
	var _61fd = this._findNamedItemIndex(name);
	if (_61fd > -1) {
		ret = true;
	}
	return ret;
};
DOMNamedNodeMap.prototype._hasAttributeNS = function DOMNamedNodeMap__hasAttributeNS(
		_61fe, _61ff) {
	var ret = false;
	var _6201 = this._findNamedItemNSIndex(_61fe, _61ff);
	if (_6201 > -1) {
		ret = true;
	}
	return ret;
};
DOMNamedNodeMap.prototype._cloneNodes = function DOMNamedNodeMap__cloneNodes(
		_6202) {
	var _6203 = new DOMNamedNodeMap(this.ownerDocument, _6202);
	for ( var i = 0; i < this._nodes.length; i++) {
		_6203._appendChild(this._nodes[i].cloneNode(false));
	}
	return _6203;
};
DOMNamedNodeMap.prototype.toString = function DOMNamedNodeMap_toString() {
	var ret = "";
	for ( var i = 0; i < this.length - 1; i++) {
		ret += this._nodes[i].toString() + " ";
	}
	if (this.length > 0) {
		ret += this._nodes[this.length - 1].toString();
	}
	return ret;
};
DOMNamespaceNodeMap = function(_6207, _6208) {
	this._class = addClass(this._class, "DOMNamespaceNodeMap");
	this.DOMNamedNodeMap = DOMNamedNodeMap;
	this.DOMNamedNodeMap(_6207, _6208);
};
DOMNamespaceNodeMap.prototype = new DOMNamedNodeMap;
DOMNamespaceNodeMap.prototype._findNamedItemIndex = function DOMNamespaceNodeMap__findNamedItemIndex(
		_6209) {
	var ret = -1;
	for ( var i = 0; i < this._nodes.length; i++) {
		if (this._nodes[i].localName == _6209) {
			ret = i;
			break;
		}
	}
	return ret;
};
DOMNamespaceNodeMap.prototype._cloneNodes = function DOMNamespaceNodeMap__cloneNodes(
		_620c) {
	var _620d = new DOMNamespaceNodeMap(this.ownerDocument, _620c);
	for ( var i = 0; i < this._nodes.length; i++) {
		_620d._appendChild(this._nodes[i].cloneNode(false));
	}
	return _620d;
};
DOMNamespaceNodeMap.prototype.toString = function DOMNamespaceNodeMap_toString() {
	var ret = "";
	for ( var ind = 0; ind < this._nodes.length; ind++) {
		var ns = null;
		try {
			var ns = this.parentNode.parentNode._namespaces
					.getNamedItem(this._nodes[ind].localName);
		} catch (e) {
			break;
		}
		if (!(ns && ("" + ns.nodeValue == "" + this._nodes[ind].nodeValue))) {
			ret += this._nodes[ind].toString() + " ";
		}
	}
	return ret;
};
DOMNode = function(_6212) {
	this._class = addClass(this._class, "DOMNode");
	if (_6212) {
		this._id = _6212._genId();
	}
	this.namespaceURI = "";
	this.prefix = "";
	this.localName = "";
	this.nodeName = "";
	this.nodeValue = "";
	this.nodeType = 0;
	this.parentNode = null;
	this.childNodes = new DOMNodeList(_6212, this);
	this.firstChild = null;
	this.lastChild = null;
	this.previousSibling = null;
	this.nextSibling = null;
	this.attributes = new DOMNamedNodeMap(_6212, this);
	this.ownerDocument = _6212;
	this._namespaces = new DOMNamespaceNodeMap(_6212, this);
	this._readonly = false;
};
DOMNode.ELEMENT_NODE = 1;
DOMNode.ATTRIBUTE_NODE = 2;
DOMNode.TEXT_NODE = 3;
DOMNode.CDATA_SECTION_NODE = 4;
DOMNode.ENTITY_REFERENCE_NODE = 5;
DOMNode.ENTITY_NODE = 6;
DOMNode.PROCESSING_INSTRUCTION_NODE = 7;
DOMNode.COMMENT_NODE = 8;
DOMNode.DOCUMENT_NODE = 9;
DOMNode.DOCUMENT_TYPE_NODE = 10;
DOMNode.DOCUMENT_FRAGMENT_NODE = 11;
DOMNode.NOTATION_NODE = 12;
DOMNode.NAMESPACE_NODE = 13;
DOMNode.prototype.hasAttributes = function DOMNode_hasAttributes() {
	if (this.attributes.length === 0) {
		return false;
	} else {
		return true;
	}
};
DOMNode.prototype.getNodeName = function DOMNode_getNodeName() {
	return this.nodeName;
};
DOMNode.prototype.getNodeValue = function DOMNode_getNodeValue() {
	return this.nodeValue;
};
DOMNode.prototype.setNodeValue = function DOMNode_setNodeValue(_6213) {
	if (this.ownerDocument.implementation.errorChecking && this._readonly) {
		throw (new DOMException(DOMException.NO_MODIFICATION_ALLOWED_ERR));
	}
	this.nodeValue = _6213;
};
DOMNode.prototype.getNodeType = function DOMNode_getNodeType() {
	return this.nodeType;
};
DOMNode.prototype.getParentNode = function DOMNode_getParentNode() {
	return this.parentNode;
};
DOMNode.prototype.getChildNodes = function DOMNode_getChildNodes() {
	return this.childNodes;
};
DOMNode.prototype.getFirstChild = function DOMNode_getFirstChild() {
	return this.firstChild;
};
DOMNode.prototype.getLastChild = function DOMNode_getLastChild() {
	return this.lastChild;
};
DOMNode.prototype.getPreviousSibling = function DOMNode_getPreviousSibling() {
	return this.previousSibling;
};
DOMNode.prototype.getNextSibling = function DOMNode_getNextSibling() {
	return this.nextSibling;
};
DOMNode.prototype.getAttributes = function DOMNode_getAttributes() {
	return this.attributes;
};
DOMNode.prototype.getOwnerDocument = function DOMNode_getOwnerDocument() {
	return this.ownerDocument;
};
DOMNode.prototype.getNamespaceURI = function DOMNode_getNamespaceURI() {
	return this.namespaceURI;
};
DOMNode.prototype.getPrefix = function DOMNode_getPrefix() {
	return this.prefix;
};
DOMNode.prototype.setPrefix = function DOMNode_setPrefix(_6214) {
	if (this.ownerDocument.implementation.errorChecking) {
		if (this._readonly) {
			throw (new DOMException(DOMException.NO_MODIFICATION_ALLOWED_ERR));
		}
		if (!this.ownerDocument.implementation._isValidName(_6214)) {
			throw (new DOMException(DOMException.INVALID_CHARACTER_ERR));
		}
		if (!this.ownerDocument._isValidNamespace(this.namespaceURI, _6214
				+ ":" + this.localName)) {
			throw (new DOMException(DOMException.NAMESPACE_ERR));
		}
		if ((_6214 == "xmlns")
				&& (this.namespaceURI != "http://www.w3.org/2000/xmlns/")) {
			throw (new DOMException(DOMException.NAMESPACE_ERR));
		}
		if ((_6214 == "") && (this.localName == "xmlns")) {
			throw (new DOMException(DOMException.NAMESPACE_ERR));
		}
	}
	this.prefix = _6214;
	if (this.prefix != "") {
		this.nodeName = this.prefix + ":" + this.localName;
	} else {
		this.nodeName = this.localName;
	}
};
DOMNode.prototype.getLocalName = function DOMNode_getLocalName() {
	return this.localName;
};
DOMNode.prototype.insertBefore = function DOMNode_insertBefore(_6215, _6216) {
	var _6217;
	if (this.ownerDocument.implementation.errorChecking) {
		if (this._readonly) {
			throw (new DOMException(DOMException.NO_MODIFICATION_ALLOWED_ERR));
		}
		if (this.ownerDocument != _6215.ownerDocument) {
			throw (new DOMException(DOMException.WRONG_DOCUMENT_ERR));
		}
		if (this._isAncestor(_6215)) {
			throw (new DOMException(DOMException.HIERARCHY_REQUEST_ERR));
		}
	}
	if (_6216) {
		var _6218 = this.childNodes._findItemIndex(_6216._id);
		if (this.ownerDocument.implementation.errorChecking && (_6218 < 0)) {
			throw (new DOMException(DOMException.NOT_FOUND_ERR));
		}
		var _6219 = _6215.parentNode;
		if (_6219) {
			_6219.removeChild(_6215);
		}
		this.childNodes._insertBefore(_6215, this.childNodes
				._findItemIndex(_6216._id));
		_6217 = _6216.previousSibling;
		if (_6215.nodeType == DOMNode.DOCUMENT_FRAGMENT_NODE) {
			if (_6215.childNodes._nodes.length > 0) {
				for ( var ind = 0; ind < _6215.childNodes._nodes.length; ind++) {
					_6215.childNodes._nodes[ind].parentNode = this;
				}
				_6216.previousSibling = _6215.childNodes._nodes[_6215.childNodes._nodes.length - 1];
			}
		} else {
			_6215.parentNode = this;
			_6216.previousSibling = _6215;
		}
	} else {
		_6217 = this.lastChild;
		this.appendChild(_6215);
	}
	if (_6215.nodeType == DOMNode.DOCUMENT_FRAGMENT_NODE) {
		if (_6215.childNodes._nodes.length > 0) {
			if (_6217) {
				_6217.nextSibling = _6215.childNodes._nodes[0];
			} else {
				this.firstChild = _6215.childNodes._nodes[0];
			}
			_6215.childNodes._nodes[0].previousSibling = _6217;
			_6215.childNodes._nodes[_6215.childNodes._nodes.length - 1].nextSibling = _6216;
		}
	} else {
		if (_6217) {
			_6217.nextSibling = _6215;
		} else {
			this.firstChild = _6215;
		}
		_6215.previousSibling = _6217;
		_6215.nextSibling = _6216;
	}
	return _6215;
};
DOMNode.prototype.replaceChild = function DOMNode_replaceChild(_621b, _621c) {
	var ret = null;
	if (this.ownerDocument.implementation.errorChecking) {
		if (this._readonly) {
			throw (new DOMException(DOMException.NO_MODIFICATION_ALLOWED_ERR));
		}
		if (this.ownerDocument != _621b.ownerDocument) {
			throw (new DOMException(DOMException.WRONG_DOCUMENT_ERR));
		}
		if (this._isAncestor(_621b)) {
			throw (new DOMException(DOMException.HIERARCHY_REQUEST_ERR));
		}
	}
	var index = this.childNodes._findItemIndex(_621c._id);
	if (this.ownerDocument.implementation.errorChecking && (index < 0)) {
		throw (new DOMException(DOMException.NOT_FOUND_ERR));
	}
	var _621f = _621b.parentNode;
	if (_621f) {
		_621f.removeChild(_621b);
	}
	ret = this.childNodes._replaceChild(_621b, index);
	if (_621b.nodeType == DOMNode.DOCUMENT_FRAGMENT_NODE) {
		if (_621b.childNodes._nodes.length > 0) {
			for ( var ind = 0; ind < _621b.childNodes._nodes.length; ind++) {
				_621b.childNodes._nodes[ind].parentNode = this;
			}
			if (_621c.previousSibling) {
				_621c.previousSibling.nextSibling = _621b.childNodes._nodes[0];
			} else {
				this.firstChild = _621b.childNodes._nodes[0];
			}
			if (_621c.nextSibling) {
				_621c.nextSibling.previousSibling = _621b;
			} else {
				this.lastChild = _621b.childNodes._nodes[_621b.childNodes._nodes.length - 1];
			}
			_621b.childNodes._nodes[0].previousSibling = _621c.previousSibling;
			_621b.childNodes._nodes[_621b.childNodes._nodes.length - 1].nextSibling = _621c.nextSibling;
		}
	} else {
		_621b.parentNode = this;
		if (_621c.previousSibling) {
			_621c.previousSibling.nextSibling = _621b;
		} else {
			this.firstChild = _621b;
		}
		if (_621c.nextSibling) {
			_621c.nextSibling.previousSibling = _621b;
		} else {
			this.lastChild = _621b;
		}
		_621b.previousSibling = _621c.previousSibling;
		_621b.nextSibling = _621c.nextSibling;
	}
	return ret;
};
DOMNode.prototype.removeChild = function DOMNode_removeChild(_6221) {
	if (this.ownerDocument.implementation.errorChecking
			&& (this._readonly || _6221._readonly)) {
		throw (new DOMException(DOMException.NO_MODIFICATION_ALLOWED_ERR));
	}
	var _6222 = this.childNodes._findItemIndex(_6221._id);
	if (this.ownerDocument.implementation.errorChecking && (_6222 < 0)) {
		throw (new DOMException(DOMException.NOT_FOUND_ERR));
	}
	this.childNodes._removeChild(_6222);
	_6221.parentNode = null;
	if (_6221.previousSibling) {
		_6221.previousSibling.nextSibling = _6221.nextSibling;
	} else {
		this.firstChild = _6221.nextSibling;
	}
	if (_6221.nextSibling) {
		_6221.nextSibling.previousSibling = _6221.previousSibling;
	} else {
		this.lastChild = _6221.previousSibling;
	}
	_6221.previousSibling = null;
	_6221.nextSibling = null;
	return _6221;
};
DOMNode.prototype.appendChild = function DOMNode_appendChild(_6223) {
	if (this.ownerDocument.implementation.errorChecking) {
		if (this._readonly) {
			throw (new DOMException(DOMException.NO_MODIFICATION_ALLOWED_ERR));
		}
		if (this.ownerDocument != _6223.ownerDocument) {
			throw (new DOMException(DOMException.WRONG_DOCUMENT_ERR));
		}
		if (this._isAncestor(_6223)) {
			throw (new DOMException(DOMException.HIERARCHY_REQUEST_ERR));
		}
	}
	var _6224 = _6223.parentNode;
	if (_6224) {
		_6224.removeChild(_6223);
	}
	this.childNodes._appendChild(_6223);
	if (_6223.nodeType == DOMNode.DOCUMENT_FRAGMENT_NODE) {
		if (_6223.childNodes._nodes.length > 0) {
			for ( var ind = 0; ind < _6223.childNodes._nodes.length; ind++) {
				_6223.childNodes._nodes[ind].parentNode = this;
			}
			if (this.lastChild) {
				this.lastChild.nextSibling = _6223.childNodes._nodes[0];
				_6223.childNodes._nodes[0].previousSibling = this.lastChild;
				this.lastChild = _6223.childNodes._nodes[_6223.childNodes._nodes.length - 1];
			} else {
				this.lastChild = _6223.childNodes._nodes[_6223.childNodes._nodes.length - 1];
				this.firstChild = _6223.childNodes._nodes[0];
			}
		}
	} else {
		_6223.parentNode = this;
		if (this.lastChild) {
			this.lastChild.nextSibling = _6223;
			_6223.previousSibling = this.lastChild;
			this.lastChild = _6223;
		} else {
			this.lastChild = _6223;
			this.firstChild = _6223;
		}
	}
	return _6223;
};
DOMNode.prototype.hasChildNodes = function DOMNode_hasChildNodes() {
	return (this.childNodes.length > 0);
};
DOMNode.prototype.cloneNode = function DOMNode_cloneNode(deep) {
	try {
		return this.ownerDocument.importNode(this, deep);
	} catch (e) {
		return null;
	}
};
DOMNode.prototype.normalize = function DOMNode_normalize() {
	var inode;
	var _6228 = new DOMNodeList();
	if (this.nodeType == DOMNode.ELEMENT_NODE
			|| this.nodeType == DOMNode.DOCUMENT_NODE) {
		var _6229 = null;
		for ( var i = 0; i < this.childNodes.length; i++) {
			inode = this.childNodes.item(i);
			if (inode.nodeType == DOMNode.TEXT_NODE) {
				if (inode.length < 1) {
					_6228._appendChild(inode);
				} else {
					if (_6229) {
						_6229.appendData(inode.data);
						_6228._appendChild(inode);
					} else {
						_6229 = inode;
					}
				}
			} else {
				_6229 = null;
				inode.normalize();
			}
		}
		for ( var i = 0; i < _6228.length; i++) {
			inode = _6228.item(i);
			inode.parentNode.removeChild(inode);
		}
	}
};
DOMNode.prototype.isSupported = function DOMNode_isSupported(_622b, _622c) {
	return this.ownerDocument.implementation.hasFeature(_622b, _622c);
};
DOMNode.prototype.getElementsByTagName = function DOMNode_getElementsByTagName(
		_622d) {
	return this._getElementsByTagNameRecursive(_622d, new DOMNodeList(
			this.ownerDocument));
};
DOMNode.prototype._getElementsByTagNameRecursive = function DOMNode__getElementsByTagNameRecursive(
		_622e, _622f) {
	if (this.nodeType == DOMNode.ELEMENT_NODE
			|| this.nodeType == DOMNode.DOCUMENT_NODE) {
		if ((this.nodeName == _622e) || (_622e == "*")) {
			_622f._appendChild(this);
		}
		for ( var i = 0; i < this.childNodes.length; i++) {
			_622f = this.childNodes.item(i)._getElementsByTagNameRecursive(
					_622e, _622f);
		}
	}
	return _622f;
};
DOMNode.prototype.getXML = function DOMNode_getXML() {
	return this.toString();
};
DOMNode.prototype.getElementsByTagNameNS = function DOMNode_getElementsByTagNameNS(
		_6231, _6232) {
	return this._getElementsByTagNameNSRecursive(_6231, _6232, new DOMNodeList(
			this.ownerDocument));
};
DOMNode.prototype._getElementsByTagNameNSRecursive = function DOMNode__getElementsByTagNameNSRecursive(
		_6233, _6234, _6235) {
	if (this.nodeType == DOMNode.ELEMENT_NODE
			|| this.nodeType == DOMNode.DOCUMENT_NODE) {
		if (((this.namespaceURI == _6233) || (_6233 == "*"))
				&& ((this.localName == _6234) || (_6234 == "*"))) {
			_6235._appendChild(this);
		}
		for ( var i = 0; i < this.childNodes.length; i++) {
			_6235 = this.childNodes.item(i)._getElementsByTagNameNSRecursive(
					_6233, _6234, _6235);
		}
	}
	return _6235;
};
DOMNode.prototype._isAncestor = function DOMNode__isAncestor(node) {
	return ((this == node) || ((this.parentNode) && (this.parentNode
			._isAncestor(node))));
};
DOMNode.prototype.importNode = function DOMNode_importNode(_6238, deep) {
	var _623a;
	this.getOwnerDocument()._performingImportNodeOperation = true;
	try {
		if (_6238.nodeType == DOMNode.ELEMENT_NODE) {
			if (!this.ownerDocument.implementation.namespaceAware) {
				_623a = this.ownerDocument.createElement(_6238.tagName);
				for ( var i = 0; i < _6238.attributes.length; i++) {
					_623a.setAttribute(_6238.attributes.item(i).name,
							_6238.attributes.item(i).value);
				}
			} else {
				_623a = this.ownerDocument.createElementNS(_6238.namespaceURI,
						_6238.nodeName);
				for ( var i = 0; i < _6238.attributes.length; i++) {
					_623a.setAttributeNS(_6238.attributes.item(i).namespaceURI,
							_6238.attributes.item(i).name, _6238.attributes
									.item(i).value);
				}
				for ( var i = 0; i < _6238._namespaces.length; i++) {
					_623a._namespaces._nodes[i] = this.ownerDocument
							.createNamespace(_6238._namespaces.item(i).localName);
					_623a._namespaces._nodes[i].setValue(_6238._namespaces
							.item(i).value);
				}
			}
		} else {
			if (_6238.nodeType == DOMNode.ATTRIBUTE_NODE) {
				if (!this.ownerDocument.implementation.namespaceAware) {
					_623a = this.ownerDocument.createAttribute(_6238.name);
				} else {
					_623a = this.ownerDocument.createAttributeNS(
							_6238.namespaceURI, _6238.nodeName);
					for ( var i = 0; i < _6238._namespaces.length; i++) {
						_623a._namespaces._nodes[i] = this.ownerDocument
								.createNamespace(_6238._namespaces.item(i).localName);
						_623a._namespaces._nodes[i].setValue(_6238._namespaces
								.item(i).value);
					}
				}
				_623a.setValue(_6238.value);
			} else {
				if (_6238.nodeType == DOMNode.DOCUMENT_FRAGMENT) {
					_623a = this.ownerDocument.createDocumentFragment();
				} else {
					if (_6238.nodeType == DOMNode.NAMESPACE_NODE) {
						_623a = this.ownerDocument
								.createNamespace(_6238.nodeName);
						_623a.setValue(_6238.value);
					} else {
						if (_6238.nodeType == DOMNode.TEXT_NODE) {
							_623a = this.ownerDocument
									.createTextNode(_6238.data);
						} else {
							if (_6238.nodeType == DOMNode.CDATA_SECTION_NODE) {
								_623a = this.ownerDocument
										.createCDATASection(_6238.data);
							} else {
								if (_6238.nodeType == DOMNode.PROCESSING_INSTRUCTION_NODE) {
									_623a = this.ownerDocument
											.createProcessingInstruction(
													_6238.target, _6238.data);
								} else {
									if (_6238.nodeType == DOMNode.COMMENT_NODE) {
										_623a = this.ownerDocument
												.createComment(_6238.data);
									} else {
										throw (new DOMException(
												DOMException.NOT_SUPPORTED_ERR));
									}
								}
							}
						}
					}
				}
			}
		}
		if (deep) {
			for ( var i = 0; i < _6238.childNodes.length; i++) {
				_623a.appendChild(this.ownerDocument.importNode(
						_6238.childNodes.item(i), true));
			}
		}
		this.getOwnerDocument()._performingImportNodeOperation = false;
		return _623a;
	} catch (eAny) {
		this.getOwnerDocument()._performingImportNodeOperation = false;
		throw eAny;
	}
};
DOMNode.prototype.__escapeString = function DOMNode__escapeString(str) {
	return __escapeString(str);
};
DOMNode.prototype.__unescapeString = function DOMNode__unescapeString(str) {
	return __unescapeString(str);
};
DOMDocument = function(_623e) {
	this._class = addClass(this._class, "DOMDocument");
	this.DOMNode = DOMNode;
	this.DOMNode(this);
	this.doctype = null;
	this.implementation = _623e;
	this.documentElement = null;
	this.all = [];
	this.nodeName = "#document";
	this.nodeType = DOMNode.DOCUMENT_NODE;
	this._id = 0;
	this._lastId = 0;
	this._parseComplete = false;
	this.ownerDocument = this;
	this._performingImportNodeOperation = false;
};
DOMDocument.prototype = new DOMNode;
DOMDocument.prototype.getDoctype = function DOMDocument_getDoctype() {
	return this.doctype;
};
DOMDocument.prototype.getImplementation = function DOMDocument_implementation() {
	return this.implementation;
};
DOMDocument.prototype.getDocumentElement = function DOMDocument_getDocumentElement() {
	return this.documentElement;
};
DOMDocument.prototype.createElement = function DOMDocument_createElement(_623f) {
	if (this.ownerDocument.implementation.errorChecking
			&& (!this.ownerDocument.implementation._isValidName(_623f))) {
		throw (new DOMException(DOMException.INVALID_CHARACTER_ERR));
	}
	var node = new DOMElement(this);
	node.tagName = _623f;
	node.nodeName = _623f;
	this.all[this.all.length] = node;
	return node;
};
DOMDocument.prototype.createDocumentFragment = function DOMDocument_createDocumentFragment() {
	var node = new DOMDocumentFragment(this);
	return node;
};
DOMDocument.prototype.createTextNode = function DOMDocument_createTextNode(data) {
	var node = new DOMText(this);
	node.data = data;
	node.nodeValue = data;
	node.length = data.length;
	return node;
};
DOMDocument.prototype.createComment = function DOMDocument_createComment(data) {
	var node = new DOMComment(this);
	node.data = data;
	node.nodeValue = data;
	node.length = data.length;
	return node;
};
DOMDocument.prototype.createCDATASection = function DOMDocument_createCDATASection(
		data) {
	var node = new DOMCDATASection(this);
	node.data = data;
	node.nodeValue = data;
	node.length = data.length;
	return node;
};
DOMDocument.prototype.createProcessingInstruction = function DOMDocument_createProcessingInstruction(
		_6248, data) {
	if (this.ownerDocument.implementation.errorChecking
			&& (!this.implementation._isValidName(_6248))) {
		throw (new DOMException(DOMException.INVALID_CHARACTER_ERR));
	}
	var node = new DOMProcessingInstruction(this);
	node.target = _6248;
	node.nodeName = _6248;
	node.data = data;
	node.nodeValue = data;
	node.length = data.length;
	return node;
};
DOMDocument.prototype.createAttribute = function DOMDocument_createAttribute(
		name) {
	if (this.ownerDocument.implementation.errorChecking
			&& (!this.ownerDocument.implementation._isValidName(name))) {
		throw (new DOMException(DOMException.INVALID_CHARACTER_ERR));
	}
	var node = new DOMAttr(this);
	node.name = name;
	node.nodeName = name;
	return node;
};
DOMDocument.prototype.createElementNS = function DOMDocument_createElementNS(
		_624d, _624e) {
	if (this.ownerDocument.implementation.errorChecking) {
		if (!this.ownerDocument._isValidNamespace(_624d, _624e)) {
			throw (new DOMException(DOMException.NAMESPACE_ERR));
		}
		if (!this.ownerDocument.implementation._isValidName(_624e)) {
			throw (new DOMException(DOMException.INVALID_CHARACTER_ERR));
		}
	}
	var node = new DOMElement(this);
	var qname = this.implementation._parseQName(_624e);
	node.nodeName = _624e;
	node.namespaceURI = _624d;
	node.prefix = qname.prefix;
	node.localName = qname.localName;
	node.tagName = _624e;
	this.all[this.all.length] = node;
	return node;
};
DOMDocument.prototype.createAttributeNS = function DOMDocument_createAttributeNS(
		_6251, _6252) {
	if (this.ownerDocument.implementation.errorChecking) {
		if (!this.ownerDocument._isValidNamespace(_6251, _6252, true)) {
			throw (new DOMException(DOMException.NAMESPACE_ERR));
		}
		if (!this.ownerDocument.implementation._isValidName(_6252)) {
			throw (new DOMException(DOMException.INVALID_CHARACTER_ERR));
		}
	}
	var node = new DOMAttr(this);
	var qname = this.implementation._parseQName(_6252);
	node.nodeName = _6252;
	node.namespaceURI = _6251;
	node.prefix = qname.prefix;
	node.localName = qname.localName;
	node.name = _6252;
	node.nodeValue = "";
	return node;
};
DOMDocument.prototype.createNamespace = function DOMDocument_createNamespace(
		_6255) {
	var node = new DOMNamespace(this);
	var qname = this.implementation._parseQName(_6255);
	node.nodeName = _6255;
	node.prefix = qname.prefix;
	node.localName = qname.localName;
	node.name = _6255;
	node.nodeValue = "";
	return node;
};
DOMDocument.prototype.getElementById = function DOMDocument_getElementById(
		_6258) {
	retNode = null;
	for ( var i = 0; i < this.all.length; i++) {
		var node = this.all[i];
		if ((node.id == _6258)
				&& (node._isAncestor(node.ownerDocument.documentElement))) {
			retNode = node;
			break;
		}
	}
	return retNode;
};
DOMDocument.prototype._genId = function DOMDocument__genId() {
	this._lastId += 1;
	return this._lastId;
};
DOMDocument.prototype._isValidNamespace = function DOMDocument__isValidNamespace(
		_625b, _625c, _625d) {
	if (this._performingImportNodeOperation == true) {
		return true;
	}
	var valid = true;
	var qName = this.implementation._parseQName(_625c);
	if (this._parseComplete == true) {
		if (qName.localName.indexOf(":") > -1) {
			valid = false;
		}
		if ((valid) && (!_625d)) {
			if (!_625b) {
				valid = false;
			}
		}
		if ((valid) && (qName.prefix == "")) {
			valid = false;
		}
	}
	if ((valid) && (qName.prefix == "xml")
			&& (_625b != "http://www.w3.org/XML/1998/namespace")) {
		valid = false;
	}
	return valid;
};
DOMDocument.prototype.toString = function DOMDocument_toString() {
	return "" + this.childNodes;
};
DOMElement = function(_6260) {
	this._class = addClass(this._class, "DOMElement");
	this.DOMNode = DOMNode;
	this.DOMNode(_6260);
	this.tagName = "";
	this.id = "";
	this.nodeType = DOMNode.ELEMENT_NODE;
};
DOMElement.prototype = new DOMNode;
DOMElement.prototype.getTagName = function DOMElement_getTagName() {
	return this.tagName;
};
DOMElement.prototype.getAttribute = function DOMElement_getAttribute(name) {
	var ret = "";
	var attr = this.attributes.getNamedItem(name);
	if (attr) {
		ret = attr.value;
	}
	return ret;
};
DOMElement.prototype.setAttribute = function DOMElement_setAttribute(name,
		value) {
	var attr = this.attributes.getNamedItem(name);
	if (!attr) {
		attr = this.ownerDocument.createAttribute(name);
	}
	var value = new String(value);
	if (this.ownerDocument.implementation.errorChecking) {
		if (attr._readonly) {
			throw (new DOMException(DOMException.NO_MODIFICATION_ALLOWED_ERR));
		}
		if (!this.ownerDocument.implementation._isValidString(value)) {
			throw (new DOMException(DOMException.INVALID_CHARACTER_ERR));
		}
	}
	if (this.ownerDocument.implementation._isIdDeclaration(name)) {
		this.id = value;
	}
	attr.value = value;
	attr.nodeValue = value;
	if (value.length > 0) {
		attr.specified = true;
	} else {
		attr.specified = false;
	}
	this.attributes.setNamedItem(attr);
};
DOMElement.prototype.removeAttribute = function DOMElement_removeAttribute(name) {
	return this.attributes.removeNamedItem(name);
};
DOMElement.prototype.getAttributeNode = function DOMElement_getAttributeNode(
		name) {
	return this.attributes.getNamedItem(name);
};
DOMElement.prototype.setAttributeNode = function DOMElement_setAttributeNode(
		_6269) {
	if (this.ownerDocument.implementation._isIdDeclaration(_6269.name)) {
		this.id = _6269.value;
	}
	return this.attributes.setNamedItem(_6269);
};
DOMElement.prototype.removeAttributeNode = function DOMElement_removeAttributeNode(
		_626a) {
	if (this.ownerDocument.implementation.errorChecking && _626a._readonly) {
		throw (new DOMException(DOMException.NO_MODIFICATION_ALLOWED_ERR));
	}
	var _626b = this.attributes._findItemIndex(_626a._id);
	if (this.ownerDocument.implementation.errorChecking && (_626b < 0)) {
		throw (new DOMException(DOMException.NOT_FOUND_ERR));
	}
	return this.attributes._removeChild(_626b);
};
DOMElement.prototype.getAttributeNS = function DOMElement_getAttributeNS(_626c,
		_626d) {
	var ret = "";
	var attr = this.attributes.getNamedItemNS(_626c, _626d);
	if (attr) {
		ret = attr.value;
	}
	return ret;
};
DOMElement.prototype.setAttributeNS = function DOMElement_setAttributeNS(_6270,
		_6271, value) {
	var attr = this.attributes.getNamedItem(_6270, _6271);
	if (!attr) {
		attr = this.ownerDocument.createAttributeNS(_6270, _6271);
	}
	var value = new String(value);
	if (this.ownerDocument.implementation.errorChecking) {
		if (attr._readonly) {
			throw (new DOMException(DOMException.NO_MODIFICATION_ALLOWED_ERR));
		}
		if (!this.ownerDocument._isValidNamespace(_6270, _6271)) {
			throw (new DOMException(DOMException.NAMESPACE_ERR));
		}
		if (!this.ownerDocument.implementation._isValidString(value)) {
			throw (new DOMException(DOMException.INVALID_CHARACTER_ERR));
		}
	}
	if (this.ownerDocument.implementation._isIdDeclaration(name)) {
		this.id = value;
	}
	attr.value = value;
	attr.nodeValue = value;
	if (value.length > 0) {
		attr.specified = true;
	} else {
		attr.specified = false;
	}
	this.attributes.setNamedItemNS(attr);
};
DOMElement.prototype.removeAttributeNS = function DOMElement_removeAttributeNS(
		_6274, _6275) {
	return this.attributes.removeNamedItemNS(_6274, _6275);
};
DOMElement.prototype.getAttributeNodeNS = function DOMElement_getAttributeNodeNS(
		_6276, _6277) {
	return this.attributes.getNamedItemNS(_6276, _6277);
};
DOMElement.prototype.setAttributeNodeNS = function DOMElement_setAttributeNodeNS(
		_6278) {
	if ((_6278.prefix == "")
			&& this.ownerDocument.implementation._isIdDeclaration(_6278.name)) {
		this.id = _6278.value;
	}
	return this.attributes.setNamedItemNS(_6278);
};
DOMElement.prototype.hasAttribute = function DOMElement_hasAttribute(name) {
	return this.attributes._hasAttribute(name);
};
DOMElement.prototype.hasAttributeNS = function DOMElement_hasAttributeNS(_627a,
		_627b) {
	return this.attributes._hasAttributeNS(_627a, _627b);
};
DOMElement.prototype.toString = function DOMElement_toString() {
	var ret = "";
	var ns = this._namespaces.toString();
	if (ns.length > 0) {
		ns = " " + ns;
	}
	var attrs = this.attributes.toString();
	if (attrs.length > 0) {
		attrs = " " + attrs;
	}
	ret += "<" + this.nodeName + ns + attrs + ">";
	ret += this.childNodes.toString();
	ret += "</" + this.nodeName + ">";
	return ret;
};
DOMAttr = function(_627f) {
	this._class = addClass(this._class, "DOMAttr");
	this.DOMNode = DOMNode;
	this.DOMNode(_627f);
	this.name = "";
	this.specified = false;
	this.value = "";
	this.nodeType = DOMNode.ATTRIBUTE_NODE;
	this.ownerElement = null;
	this.childNodes = null;
	this.attributes = null;
};
DOMAttr.prototype = new DOMNode;
DOMAttr.prototype.getName = function DOMAttr_getName() {
	return this.nodeName;
};
DOMAttr.prototype.getSpecified = function DOMAttr_getSpecified() {
	return this.specified;
};
DOMAttr.prototype.getValue = function DOMAttr_getValue() {
	return this.nodeValue;
};
DOMAttr.prototype.setValue = function DOMAttr_setValue(value) {
	if (this.ownerDocument.implementation.errorChecking && this._readonly) {
		throw (new DOMException(DOMException.NO_MODIFICATION_ALLOWED_ERR));
	}
	this.setNodeValue(value);
};
DOMAttr.prototype.setNodeValue = function DOMAttr_setNodeValue(value) {
	this.nodeValue = new String(value);
	this.value = this.nodeValue;
	this.specified = (this.value.length > 0);
};
DOMAttr.prototype.toString = function DOMAttr_toString() {
	var ret = "";
	ret += this.nodeName + "=\"" + this.__escapeString(this.nodeValue) + "\"";
	return ret;
};
DOMAttr.prototype.getOwnerElement = function() {
	return this.ownerElement;
};
DOMNamespace = function(_6283) {
	this._class = addClass(this._class, "DOMNamespace");
	this.DOMNode = DOMNode;
	this.DOMNode(_6283);
	this.name = "";
	this.specified = false;
	this.value = "";
	this.nodeType = DOMNode.NAMESPACE_NODE;
};
DOMNamespace.prototype = new DOMNode;
DOMNamespace.prototype.getValue = function DOMNamespace_getValue() {
	return this.nodeValue;
};
DOMNamespace.prototype.setValue = function DOMNamespace_setValue(value) {
	this.nodeValue = new String(value);
	this.value = this.nodeValue;
};
DOMNamespace.prototype.toString = function DOMNamespace_toString() {
	var ret = "";
	if (this.nodeName != "") {
		ret += this.nodeName + "=\"" + this.__escapeString(this.nodeValue)
				+ "\"";
	} else {
		ret += "xmlns=\"" + this.__escapeString(this.nodeValue) + "\"";
	}
	return ret;
};
DOMCharacterData = function(_6286) {
	this._class = addClass(this._class, "DOMCharacterData");
	this.DOMNode = DOMNode;
	this.DOMNode(_6286);
	this.data = "";
	this.length = 0;
};
DOMCharacterData.prototype = new DOMNode;
DOMCharacterData.prototype.getData = function DOMCharacterData_getData() {
	return this.nodeValue;
};
DOMCharacterData.prototype.setData = function DOMCharacterData_setData(data) {
	this.setNodeValue(data);
};
DOMCharacterData.prototype.setNodeValue = function DOMCharacterData_setNodeValue(
		data) {
	if (this.ownerDocument.implementation.errorChecking && this._readonly) {
		throw (new DOMException(DOMException.NO_MODIFICATION_ALLOWED_ERR));
	}
	this.nodeValue = new String(data);
	this.data = this.nodeValue;
	this.length = this.nodeValue.length;
};
DOMCharacterData.prototype.getLength = function DOMCharacterData_getLength() {
	return this.nodeValue.length;
};
DOMCharacterData.prototype.substringData = function DOMCharacterData_substringData(
		_6289, count) {
	var ret = null;
	if (this.data) {
		if (this.ownerDocument.implementation.errorChecking
				&& ((_6289 < 0) || (_6289 > this.data.length) || (count < 0))) {
			throw (new DOMException(DOMException.INDEX_SIZE_ERR));
		}
		if (!count) {
			ret = this.data.substring(_6289);
		} else {
			ret = this.data.substring(_6289, _6289 + count);
		}
	}
	return ret;
};
DOMCharacterData.prototype.appendData = function DOMCharacterData_appendData(
		arg) {
	if (this.ownerDocument.implementation.errorChecking && this._readonly) {
		throw (new DOMException(DOMException.NO_MODIFICATION_ALLOWED_ERR));
	}
	this.setData("" + this.data + arg);
};
DOMCharacterData.prototype.insertData = function DOMCharacterData_insertData(
		_628d, arg) {
	if (this.ownerDocument.implementation.errorChecking && this._readonly) {
		throw (new DOMException(DOMException.NO_MODIFICATION_ALLOWED_ERR));
	}
	if (this.data) {
		if (this.ownerDocument.implementation.errorChecking
				&& ((_628d < 0) || (_628d > this.data.length))) {
			throw (new DOMException(DOMException.INDEX_SIZE_ERR));
		}
		this.setData(this.data.substring(0, _628d).concat(arg,
				this.data.substring(_628d)));
	} else {
		if (this.ownerDocument.implementation.errorChecking && (_628d != 0)) {
			throw (new DOMException(DOMException.INDEX_SIZE_ERR));
		}
		this.setData(arg);
	}
};
DOMCharacterData.prototype.deleteData = function DOMCharacterData_deleteData(
		_628f, count) {
	if (this.ownerDocument.implementation.errorChecking && this._readonly) {
		throw (new DOMException(DOMException.NO_MODIFICATION_ALLOWED_ERR));
	}
	if (this.data) {
		if (this.ownerDocument.implementation.errorChecking
				&& ((_628f < 0) || (_628f > this.data.length) || (count < 0))) {
			throw (new DOMException(DOMException.INDEX_SIZE_ERR));
		}
		if (!count || (_628f + count) > this.data.length) {
			this.setData(this.data.substring(0, _628f));
		} else {
			this.setData(this.data.substring(0, _628f).concat(
					this.data.substring(_628f + count)));
		}
	}
};
DOMCharacterData.prototype.replaceData = function DOMCharacterData_replaceData(
		_6291, count, arg) {
	if (this.ownerDocument.implementation.errorChecking && this._readonly) {
		throw (new DOMException(DOMException.NO_MODIFICATION_ALLOWED_ERR));
	}
	if (this.data) {
		if (this.ownerDocument.implementation.errorChecking
				&& ((_6291 < 0) || (_6291 > this.data.length) || (count < 0))) {
			throw (new DOMException(DOMException.INDEX_SIZE_ERR));
		}
		this.setData(this.data.substring(0, _6291).concat(arg,
				this.data.substring(_6291 + count)));
	} else {
		this.setData(arg);
	}
};
DOMText = function(_6294) {
	this._class = addClass(this._class, "DOMText");
	this.DOMCharacterData = DOMCharacterData;
	this.DOMCharacterData(_6294);
	this.nodeName = "#text";
	this.nodeType = DOMNode.TEXT_NODE;
};
DOMText.prototype = new DOMCharacterData;
DOMText.prototype.splitText = function DOMText_splitText(_6295) {
	var data, inode;
	if (this.ownerDocument.implementation.errorChecking) {
		if (this._readonly) {
			throw (new DOMException(DOMException.NO_MODIFICATION_ALLOWED_ERR));
		}
		if ((_6295 < 0) || (_6295 > this.data.length)) {
			throw (new DOMException(DOMException.INDEX_SIZE_ERR));
		}
	}
	if (this.parentNode) {
		data = this.substringData(_6295);
		inode = this.ownerDocument.createTextNode(data);
		if (this.nextSibling) {
			this.parentNode.insertBefore(inode, this.nextSibling);
		} else {
			this.parentNode.appendChild(inode);
		}
		this.deleteData(_6295);
	}
	return inode;
};
DOMText.prototype.toString = function DOMText_toString() {
	return this.__escapeString("" + this.nodeValue);
};
DOMCDATASection = function(_6297) {
	this._class = addClass(this._class, "DOMCDATASection");
	this.DOMCharacterData = DOMCharacterData;
	this.DOMCharacterData(_6297);
	this.nodeName = "#cdata-section";
	this.nodeType = DOMNode.CDATA_SECTION_NODE;
};
DOMCDATASection.prototype = new DOMCharacterData;
DOMCDATASection.prototype.splitText = function DOMCDATASection_splitText(_6298) {
	var data, inode;
	if (this.ownerDocument.implementation.errorChecking) {
		if (this._readonly) {
			throw (new DOMException(DOMException.NO_MODIFICATION_ALLOWED_ERR));
		}
		if ((_6298 < 0) || (_6298 > this.data.length)) {
			throw (new DOMException(DOMException.INDEX_SIZE_ERR));
		}
	}
	if (this.parentNode) {
		data = this.substringData(_6298);
		inode = this.ownerDocument.createCDATASection(data);
		if (this.nextSibling) {
			this.parentNode.insertBefore(inode, this.nextSibling);
		} else {
			this.parentNode.appendChild(inode);
		}
		this.deleteData(_6298);
	}
	return inode;
};
DOMCDATASection.prototype.toString = function DOMCDATASection_toString() {
	var ret = "";
	ret += "<![CDATA[" + this.nodeValue + "]]>";
	return ret;
};
DOMComment = function(_629b) {
	this._class = addClass(this._class, "DOMComment");
	this.DOMCharacterData = DOMCharacterData;
	this.DOMCharacterData(_629b);
	this.nodeName = "#comment";
	this.nodeType = DOMNode.COMMENT_NODE;
};
DOMComment.prototype = new DOMCharacterData;
DOMComment.prototype.toString = function DOMComment_toString() {
	var ret = "";
	ret += "<!--" + this.nodeValue + "-->";
	return ret;
};
DOMProcessingInstruction = function(_629d) {
	this._class = addClass(this._class, "DOMProcessingInstruction");
	this.DOMNode = DOMNode;
	this.DOMNode(_629d);
	this.target = "";
	this.data = "";
	this.nodeType = DOMNode.PROCESSING_INSTRUCTION_NODE;
};
DOMProcessingInstruction.prototype = new DOMNode;
DOMProcessingInstruction.prototype.getTarget = function DOMProcessingInstruction_getTarget() {
	return this.nodeName;
};
DOMProcessingInstruction.prototype.getData = function DOMProcessingInstruction_getData() {
	return this.nodeValue;
};
DOMProcessingInstruction.prototype.setData = function DOMProcessingInstruction_setData(
		data) {
	this.setNodeValue(data);
};
DOMProcessingInstruction.prototype.setNodeValue = function DOMProcessingInstruction_setNodeValue(
		data) {
	if (this.ownerDocument.implementation.errorChecking && this._readonly) {
		throw (new DOMException(DOMException.NO_MODIFICATION_ALLOWED_ERR));
	}
	this.nodeValue = new String(data);
	this.data = this.nodeValue;
};
DOMProcessingInstruction.prototype.toString = function DOMProcessingInstruction_toString() {
	var ret = "";
	ret += "<?" + this.nodeName + " " + this.nodeValue + " ?>";
	return ret;
};
DOMDocumentFragment = function(_62a1) {
	this._class = addClass(this._class, "DOMDocumentFragment");
	this.DOMNode = DOMNode;
	this.DOMNode(_62a1);
	this.nodeName = "#document-fragment";
	this.nodeType = DOMNode.DOCUMENT_FRAGMENT_NODE;
};
DOMDocumentFragment.prototype = new DOMNode;
DOMDocumentFragment.prototype.toString = function DOMDocumentFragment_toString() {
	var xml = "";
	var _62a3 = this.getChildNodes().getLength();
	for (intLoop = 0; intLoop < _62a3; intLoop++) {
		xml += this.getChildNodes().item(intLoop).toString();
	}
	return xml;
};
DOMDocumentType = function() {
	alert("DOMDocumentType.constructor(): Not Implemented");
};
DOMEntity = function() {
	alert("DOMEntity.constructor(): Not Implemented");
};
DOMEntityReference = function() {
	alert("DOMEntityReference.constructor(): Not Implemented");
};
DOMNotation = function() {
	alert("DOMNotation.constructor(): Not Implemented");
};
Strings = new Object();
Strings.WHITESPACE = " \t\n\r";
Strings.QUOTES = "\"'";
Strings.isEmpty = function Strings_isEmpty(strD) {
	return (strD === null) || (strD.length === 0);
};
Strings.indexOfNonWhitespace = function Strings_indexOfNonWhitespace(strD, iB,
		iE) {
	if (Strings.isEmpty(strD)) {
		return -1;
	}
	iB = iB || 0;
	iE = iE || strD.length;
	for ( var i = iB; i < iE; i++) {
		if (Strings.WHITESPACE.indexOf(strD.charAt(i)) == -1) {
			return i;
		}
	}
	return -1;
};
Strings.lastIndexOfNonWhitespace = function Strings_lastIndexOfNonWhitespace(
		strD, iB, iE) {
	if (Strings.isEmpty(strD)) {
		return -1;
	}
	iB = iB || 0;
	iE = iE || strD.length;
	for ( var i = iE - 1; i >= iB; i--) {
		if (Strings.WHITESPACE.indexOf(strD.charAt(i)) == -1) {
			return i;
		}
	}
	return -1;
};
Strings.indexOfWhitespace = function Strings_indexOfWhitespace(strD, iB, iE) {
	if (Strings.isEmpty(strD)) {
		return -1;
	}
	iB = iB || 0;
	iE = iE || strD.length;
	for ( var i = iB; i < iE; i++) {
		if (Strings.WHITESPACE.indexOf(strD.charAt(i)) != -1) {
			return i;
		}
	}
	return -1;
};
Strings.replace = function Strings_replace(strD, iB, iE, strF, strR) {
	if (Strings.isEmpty(strD)) {
		return "";
	}
	iB = iB || 0;
	iE = iE || strD.length;
	return strD.substring(iB, iE).split(strF).join(strR);
};
Strings.getLineNumber = function Strings_getLineNumber(strD, iP) {
	if (Strings.isEmpty(strD)) {
		return -1;
	}
	iP = iP || strD.length;
	return strD.substring(0, iP).split("\n").length;
};
Strings.getColumnNumber = function Strings_getColumnNumber(strD, iP) {
	if (Strings.isEmpty(strD)) {
		return -1;
	}
	iP = iP || strD.length;
	var arrD = strD.substring(0, iP).split("\n");
	var _62bb = arrD[arrD.length - 1];
	arrD.length--;
	var _62bc = arrD.join("\n").length;
	return iP - _62bc;
};
StringBuffer = function() {
	this._a = [];
};
StringBuffer.prototype.append = function StringBuffer_append(d) {
	this._a[this._a.length] = d;
};
StringBuffer.prototype.toString = function StringBuffer_toString() {
	return this._a.join("");
};
draw2d.XMLSerializer = function() {
	alert("do not init this class. Use the static methods instead");
};
draw2d.XMLSerializer.toXML = function(obj, _5717, _5718) {
	if (_5717 == undefined) {
		_5717 = "model";
	}
	_5718 = _5718 ? _5718 : "";
	var t = draw2d.XMLSerializer.getTypeName(obj);
	var s = _5718 + "<" + _5717 + " type=\"" + t + "\">";
	switch (t) {
	case "int":
	case "number":
	case "boolean":
		s += obj;
		break;
	case "string":
		s += draw2d.XMLSerializer.xmlEncode(obj);
		break;
	case "date":
		s += obj.toLocaleString();
		break;
	case "Array":
	case "array":
		s += "\n";
		var _571b = _5718 + "   ";
		for ( var i = 0; i < obj.length; i++) {
			s += draw2d.XMLSerializer.toXML(obj[i], ("element"), _571b);
		}
		s += _5718;
		break;
	default:
		if (obj !== null) {
			s += "\n";
			if (obj instanceof draw2d.ArrayList) {
				obj.trimToSize();
			}
			var _571d = obj.getPersistentAttributes();
			var _571b = _5718 + "   ";
			for ( var name in _571d) {
				s += draw2d.XMLSerializer.toXML(_571d[name], name, _571b);
			}
			s += _5718;
		}
		break;
	}
	s += "</" + _5717 + ">\n";
	return s;
};
draw2d.XMLSerializer.isSimpleVar = function(t) {
	switch (t) {
	case "int":
	case "string":
	case "String":
	case "Number":
	case "number":
	case "Boolean":
	case "boolean":
	case "bool":
	case "dateTime":
	case "Date":
	case "date":
	case "float":
		return true;
	}
	return false;
};
draw2d.XMLSerializer.getTypeName = function(obj) {
	if (obj === null) {
		return "undefined";
	}
	if (obj instanceof Array) {
		return "Array";
	}
	if (obj instanceof Date) {
		return "Date";
	}
	var t = typeof (obj);
	if (t == "number") {
		return (parseInt(obj).toString() == obj) ? "int" : "number";
	}
	if (draw2d.XMLSerializer.isSimpleVar(t)) {
		return t;
	}
	return obj.type.replace("@NAMESPACE" + "@", "");
};
draw2d.XMLSerializer.xmlEncode = function(_5722) {
	var _5723 = _5722;
	var amp = /&/gi;
	var gt = />/gi;
	var lt = /</gi;
	var quot = /"/gi;
	var apos = /'/gi;
	var _5729 = "&#62;";
	var _572a = "&#38;#60;";
	var _572b = "&#38;#38;";
	var _572c = "&#34;";
	var _572d = "&#39;";
	_5723 = _5723.replace(amp, _572b);
	_5723 = _5723.replace(quot, _572c);
	_5723 = _5723.replace(lt, _572a);
	_5723 = _5723.replace(gt, _5729);
	_5723 = _5723.replace(apos, _572d);
	return _5723;
};
draw2d.XMLDeserializer = function() {
	alert("do not init this class. Use the static methods instead");
};
draw2d.XMLDeserializer.fromXML = function(node, _4fe9) {
	var _4fea = "" + node.getAttributes().getNamedItem("type").getNodeValue();
	var value = node.getNodeValue();
	switch (_4fea) {
	case "int":
		try {
			return parseInt("" + node.getChildNodes().item(0).getNodeValue());
		} catch (e) {
			alert("Error:" + e + "\nDataType:" + _4fea + "\nXML Node:" + node);
		}
	case "string":
	case "String":
		try {
			if (node.getChildNodes().getLength() > 0) {
				return "" + node.getChildNodes().item(0).getNodeValue();
			}
			return "";
		} catch (e) {
			alert("Error:" + e + "\nDataType:" + _4fea + "\nXML Node:" + node);
		}
	case "Number":
	case "number":
		try {
			return parseFloat("" + node.getChildNodes().item(0).getNodeValue());
		} catch (e) {
			alert("Error:" + e + "\nDataType:" + _4fea + "\nXML Node:" + node);
		}
	case "Boolean":
	case "boolean":
	case "bool":
		try {
			return "true" == ("" + node.getChildNodes().item(0).getNodeValue())
					.toLowerCase();
		} catch (e) {
			alert("Error:" + e + "\nDataType:" + _4fea + "\nXML Node:" + node);
		}
	case "dateTime":
	case "Date":
	case "date":
		try {
			return new Date("" + node.getChildNodes().item(0).getNodeValue());
		} catch (e) {
			alert("Error:" + e + "\nDataType:" + _4fea + "\nXML Node:" + node);
		}
	case "float":
		try {
			return parseFloat("" + node.getChildNodes().item(0).getNodeValue());
		} catch (e) {
			alert("Error:" + e + "\nDataType:" + _4fea + "\nXML Node:" + node);
		}
		break;
	}
	_4fea = _4fea.replace("@NAMESPACE" + "@", "");
	var obj = eval("new " + _4fea + "()");
	if (_4fe9 != undefined && obj.setModelParent != undefined) {
		obj.setModelParent(_4fe9);
	}
	var _4fed = node.getChildNodes();
	for ( var i = 0; i < _4fed.length; i++) {
		var child = _4fed.item(i);
		var _4ff0 = child.getNodeName();
		if (obj instanceof Array) {
			_4ff0 = i;
		}
		obj[_4ff0] = draw2d.XMLDeserializer.fromXML(child,
				obj instanceof draw2d.AbstractObjectModel ? obj : _4fe9);
	}
	return obj;
};
draw2d.EditPolicy = function(_5cb1) {
	this.policy = _5cb1;
};
draw2d.EditPolicy.DELETE = "DELETE";
draw2d.EditPolicy.MOVE = "MOVE";
draw2d.EditPolicy.CONNECT = "CONNECT";
draw2d.EditPolicy.RESIZE = "RESIZE";
draw2d.EditPolicy.prototype.type = "draw2d.EditPolicy";
draw2d.EditPolicy.prototype.getPolicy = function() {
	return this.policy;
};
draw2d.AbstractPalettePart = function() {
	this.x = 0;
	this.y = 0;
	this.html = null;
};
draw2d.AbstractPalettePart.prototype.type = "draw2d.AbstractPalettePart";
draw2d.AbstractPalettePart.prototype = new draw2d.Draggable();
draw2d.AbstractPalettePart.prototype.createHTMLElement = function() {
	var item = document.createElement("div");
	item.id = this.id;
	item.style.position = "absolute";
	item.style.height = "24px";
	item.style.width = "24px";
	return item;
};
draw2d.AbstractPalettePart.prototype.setEnviroment = function(_6008, _6009) {
	this.palette = _6009;
	this.workflow = _6008;
};
draw2d.AbstractPalettePart.prototype.getHTMLElement = function() {
	if (this.html === null) {
		this.html = this.createHTMLElement();
		draw2d.Draggable.call(this, this.html);
	}
	return this.html;
};
draw2d.AbstractPalettePart.prototype.onDrop = function(_600a, _600b) {
	var _600c = this.workflow.getScrollLeft();
	var _600d = this.workflow.getScrollTop();
	var _600e = this.workflow.getAbsoluteX();
	var _600f = this.workflow.getAbsoluteY();
	this.setPosition(this.x, this.y);
	this.execute(_600a + _600c - _600e, _600b + _600d - _600f);
};
draw2d.AbstractPalettePart.prototype.execute = function(x, y) {
	alert("inerited class should override the method 'draw2d.AbstractPalettePart.prototype.execute'");
};
draw2d.AbstractPalettePart.prototype.setTooltip = function(_6012) {
	this.tooltip = _6012;
	if (this.tooltip !== null) {
		this.html.title = this.tooltip;
	} else {
		this.html.title = "";
	}
};
draw2d.AbstractPalettePart.prototype.setDimension = function(w, h) {
	this.width = w;
	this.height = h;
	if (this.html === null) {
		return;
	}
	this.html.style.width = this.width + "px";
	this.html.style.height = this.height + "px";
};
draw2d.AbstractPalettePart.prototype.setPosition = function(xPos, yPos) {
	this.x = Math.max(0, xPos);
	this.y = Math.max(0, yPos);
	if (this.html === null) {
		return;
	}
	this.html.style.left = this.x + "px";
	this.html.style.top = this.y + "px";
	this.html.style.cursor = "move";
};
draw2d.AbstractPalettePart.prototype.getWidth = function() {
	return this.width;
};
draw2d.AbstractPalettePart.prototype.getHeight = function() {
	return this.height;
};
draw2d.AbstractPalettePart.prototype.getY = function() {
	return this.y;
};
draw2d.AbstractPalettePart.prototype.getX = function() {
	return this.x;
};
draw2d.AbstractPalettePart.prototype.getPosition = function() {
	return new draw2d.Point(this.x, this.y);
};
draw2d.AbstractPalettePart.prototype.disableTextSelection = function(e) {
	if (typeof e.onselectstart != "undefined") {
		e.onselectstart = function() {
			return false;
		};
	} else {
		if (typeof e.style.MozUserSelect != "undefined") {
			e.style.MozUserSelect = "none";
		}
	}
};
draw2d.ExternalPalette = function(_5b29, divId) {
	this.html = document.getElementById(divId);
	this.workflow = _5b29;
	this.parts = new draw2d.ArrayList();
};
draw2d.ExternalPalette.prototype.type = "draw2d.ExternalPalette";
draw2d.ExternalPalette.prototype.getHTMLElement = function() {
	return this.html;
};
draw2d.ExternalPalette.prototype.addPalettePart = function(part) {
	if (!(part instanceof draw2d.AbstractPalettePart)) {
		throw "parameter is not instanceof [draw2d.AbstractPalettePart]";
	}
	this.parts.add(part);
	this.html.appendChild(part.getHTMLElement());
	part.setEnviroment(this.workflow, this);
};
