/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.act.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.act.mapper.TaTaskCopyMapper;
import com.biz.crm.act.model.TaProcessOptRecordEntity;
import com.biz.crm.act.model.TaTaskCopyEntity;
import com.biz.crm.act.service.ITaProcessOptRecordService;
import com.biz.crm.act.service.ITaTaskCopyService;
import com.biz.crm.act.service.ITaTaskService;
import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.activiti.Column;
import com.biz.crm.eunm.activiti.Indicator;
import com.biz.crm.eunm.activiti.IndicatorStr;
import com.biz.crm.mdm.position.MdmPositionFeign;
import com.biz.crm.nebular.activiti.act.req.CopyToUserReqVO;
import com.biz.crm.nebular.activiti.act.req.ReadCopyTaskReqVO;
import com.biz.crm.nebular.activiti.act.req.TaskCopyReqVO;
import com.biz.crm.nebular.activiti.task.req.CopyTaskReqVO;
import com.biz.crm.nebular.activiti.task.resp.CopyTaskRspVO;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionDetailRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.Result;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.activiti.engine.task.TaskInfo;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="taTaskCopyService")
public class TaTaskCopyServiceImpl
extends ServiceImpl<TaTaskCopyMapper, TaTaskCopyEntity>
implements ITaTaskCopyService {
    private static final Logger log = LoggerFactory.getLogger(TaTaskCopyServiceImpl.class);
    @Autowired
    private ITaTaskService taTaskService;
    @Autowired
    private MdmPositionFeign mdmPositionFeign;
    @Resource
    private TaTaskCopyMapper taTaskCopyMapper;
    @Autowired
    private ITaProcessOptRecordService taProcessOptRecordService;

    @Override
    public String copyTaskToOne(TaskCopyReqVO reqVO) {
        TaskInfo taskInfo = this.taTaskService.getTaskInfoByTaskId(reqVO.getTaskId());
        AssertUtils.isNotNull((Object)taskInfo, (String)"\u672a\u627e\u5230\u5f85\u6284\u9001\u7684\u8282\u70b9");
        AssertUtils.isNotEmpty((Collection)reqVO.getUsers(), (String)"\u6284\u9001\u76ee\u6807\u4e0d\u80fd\u4e3a\u7a7a!");
        int total = reqVO.getUsers().size();
        int success = 0;
        List userList = reqVO.getUsers();
        String msg = "";
        Result resultSend = this.mdmPositionFeign.getPositionDetail(null, reqVO.getFromUserPosCode());
        MdmPositionDetailRespVo positionUserSend = (MdmPositionDetailRespVo)ApiResultUtil.objResult((Result)resultSend, (boolean)Boolean.TRUE);
        AssertUtils.isTrue((boolean)reqVO.getFromUserCode().equals(positionUserSend.getUser().getUserName()), (String)"\u5f53\u524d\u5c97\u4f4d\u4e0b\u4eba\u5458\u4e0d\u5339\u914d!");
        for (CopyToUserReqVO user : userList) {
            try {
                Result resultTo = this.mdmPositionFeign.getPositionDetail(null, user.getPosCode());
                MdmPositionDetailRespVo positionUserTo = (MdmPositionDetailRespVo)ApiResultUtil.objResult((Result)resultTo, (boolean)Boolean.TRUE);
                AssertUtils.isTrue((boolean)user.getUserCode().equals(positionUserTo.getUser().getUserName()), (String)"\u6284\u9001\u5c97\u4f4d\u4e0b\u4eba\u5458\u4e0d\u5339\u914d!");
                AssertUtils.isTrue((!positionUserSend.getUser().getUserName().equals(positionUserTo.getUser().getUserName()) ? 1 : 0) != 0, (String)"\u4e0d\u80fd\u7ed9\u81ea\u5df1\u6284\u9001!");
                TaTaskCopyEntity taskCopy = new TaTaskCopyEntity();
                taskCopy.setTaskId(taskInfo.getId()).setProcessInstId(taskInfo.getProcessInstanceId()).setTaskDefKey("CP:" + taskInfo.getTaskDefinitionKey()).setTaskName(taskInfo.getName()).setUserCode(user.getUserCode()).setUserName(positionUserTo.getUser().getFullName()).setPosCode(user.getPosCode()).setPosName(positionUserTo.getPositionName()).setFromUser(reqVO.getFromUserCode()).setFromUserName(positionUserSend.getUser().getFullName()).setFromPosCode(positionUserSend.getPositionCode()).setFromPosName(positionUserSend.getPositionName()).setStatus(Indicator.COPY_TASK_STATUS_UNREAD.getCode());
                this.save((Object)taskCopy);
                TaProcessOptRecordEntity optRecord = new TaProcessOptRecordEntity();
                optRecord.setProcessInstId(taskCopy.getProcessInstId()).setTaskId(taskInfo.getId()).setTaskDefKey(taskCopy.getTaskDefKey()).setTaskName(taskInfo.getName()).setUserCode(reqVO.getFromUserCode()).setUserName(positionUserSend.getUser().getUserName()).setPositionCode(positionUserSend.getPositionCode()).setPositionName(positionUserSend.getPositionName()).setProcessVersionKey(taskInfo.getProcessDefinitionId()).setOperation(IndicatorStr.PROCESS_BTN_INFORM.getCode()).setContent(positionUserSend.getUser().getFullName() + "\u53d1\u8d77\u4e86\u6284\u9001\u64cd\u4f5c\uff0c\u6284\u9001\u7ed9:" + positionUserTo.getUser().getFullName()).setCreateTime(new Date()).setSourceId(taskCopy.getId());
                if (StringUtils.isNotEmpty((CharSequence)reqVO.getRemark())) {
                    optRecord.setContent(optRecord.getContent() + "|" + reqVO.getRemark());
                }
                this.taProcessOptRecordService.save((Object)optRecord);
                ++success;
            }
            catch (Exception e) {
                e.printStackTrace();
                msg = msg + e.getMessage() + ",";
            }
        }
        msg = msg + "\u603b\u8ba1\u6284\u9001\u76ee\u6807\u6570\u91cf:" + total + ",\u6284\u9001\u6210\u529f\u6570\u91cf:" + success;
        return msg;
    }

    @Override
    public String readCopyTask(ReadCopyTaskReqVO reqVO) {
        TaTaskCopyEntity copy = (TaTaskCopyEntity)((Object)this.taTaskCopyMapper.selectById((Serializable)((Object)reqVO.getCopyTaskId())));
        if (Indicator.COPY_TASK_STATUS_READ.getCode() == copy.getStatus().intValue()) {
            throw new BusinessException("\u8282\u70b9\u5df2\u662f\u5df2\u9605\u72b6\u6001!");
        }
        Date nowTime = new Date();
        copy.setStatus(Indicator.COPY_TASK_STATUS_READ.getCode());
        copy.setReadTime(nowTime);
        this.taTaskCopyMapper.updateById((Object)copy);
        TaskInfo taskInfo = this.taTaskService.getTaskInfoByTaskId(copy.getTaskId());
        TaProcessOptRecordEntity optRecord = new TaProcessOptRecordEntity();
        optRecord.setProcessInstId(copy.getProcessInstId()).setTaskId(copy.getId()).setTaskDefKey("COPY_TASK").setTaskName("\u6284\u9001\u8282\u70b9").setUserCode(copy.getUserCode()).setUserName(copy.getUserName()).setPositionCode(copy.getPosCode()).setPositionName(copy.getPosName()).setProcessVersionKey(taskInfo.getProcessDefinitionId()).setOperation(IndicatorStr.PROCESS_BTN_ISSUE.getCode()).setCreateTime(nowTime).setSourceId(copy.getId());
        if (StringUtils.isNotEmpty((CharSequence)reqVO.getRemark())) {
            optRecord.setContent(reqVO.getRemark());
        } else {
            optRecord.setContent("\u5df2\u9605");
        }
        this.taProcessOptRecordService.save((Object)optRecord);
        return "\u5904\u7406\u6210\u529f\uff01";
    }

    @Override
    public PageResult<CopyTaskRspVO> findMyCopyTask(CopyTaskReqVO reqVO) {
        Page taskRspVOPage = PageUtil.buildPage((Integer)reqVO.getPageNum(), (Integer)reqVO.getPageSize());
        List<CopyTaskRspVO> list = this.taTaskCopyMapper.queryCopyTask((Page<CopyTaskReqVO>)taskRspVOPage, reqVO);
        list.forEach(vo -> vo.setStatusDesc(Column.COPY_TASK_STATUS.getLabelByCode(vo.getStatus())));
        return PageResult.builder().count(Long.valueOf(taskRspVOPage.getTotal())).data(list).build();
    }

    @Override
    public int countCopyTask(CopyTaskReqVO reqVO) {
        return this.taTaskCopyMapper.countCopyTask(reqVO);
    }
}

