/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.act.controller;

import com.biz.crm.act.service.ITaActBaseProcessService;
import com.biz.crm.activiti.service.IActivitiMyTaskService;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.activiti.act.req.TaActBaseProcessReqVo;
import com.biz.crm.nebular.activiti.act.req.TaActDelegateReqVo;
import com.biz.crm.nebular.activiti.act.resp.TaActBaseProcessRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/taactbaseprocess"})
@Api(tags={"\u6d41\u7a0b\u5b9e\u4f8b\u63a5\u53e3"})
public class TaActBaseProcessController {
    private static final Logger log = LoggerFactory.getLogger(TaActBaseProcessController.class);
    @Autowired
    private ITaActBaseProcessService taActBaseProcessService;
    @Autowired
    private IActivitiMyTaskService activitiMyTaskService;

    @ApiOperation(value="\u67e5\u8be2\u6240\u6709\u6d41\u7a0b\u5b9e\u4f8b")
    @PostMapping(value={"/list"})
    @CrmLog
    public Result<PageResult<TaActBaseProcessRespVo>> list(@RequestBody TaActBaseProcessReqVo taActBaseProcessReqVo) {
        PageResult<TaActBaseProcessRespVo> result = this.taActBaseProcessService.findList(taActBaseProcessReqVo);
        return Result.ok(result);
    }

    @ApiOperation(value="\u67e5\u8be2")
    @GetMapping(value={"/query"})
    @CrmLog
    public Result<TaActBaseProcessRespVo> query(@RequestParam(value="id") String id) {
        TaActBaseProcessRespVo respVo = this.taActBaseProcessService.query(id);
        return Result.ok((Object)respVo);
    }

    @ApiOperation(value="\u65b0\u589e")
    @PostMapping(value={"/save"})
    @CrmLog
    public Result save(@RequestBody TaActBaseProcessReqVo taActBaseProcessReqVo) {
        this.taActBaseProcessService.save(taActBaseProcessReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u66f4\u65b0")
    @PostMapping(value={"/update"})
    @CrmLog
    public Result update(@RequestBody TaActBaseProcessReqVo taActBaseProcessReqVo) {
        this.taActBaseProcessService.update(taActBaseProcessReqVo);
        return Result.ok((String)"\u4fee\u6539\u6210\u529f");
    }

    @ApiOperation(value="\u5220\u9664")
    @PostMapping(value={"/delete"})
    @CrmLog
    public Result delete(@RequestBody List<String> ids) {
        this.taActBaseProcessService.deleteBatch(ids);
        return Result.ok((String)"\u5220\u9664\u6210\u529f");
    }

    @ApiOperation(value="\u542f\u7528")
    @PostMapping(value={"/enable"})
    @CrmLog
    public Result enable(@RequestBody List<String> ids) {
        this.taActBaseProcessService.enableBatch(ids);
        return Result.ok((String)"\u542f\u7528\u6210\u529f");
    }

    @ApiOperation(value="\u5173\u95ed")
    @PostMapping(value={"/close"})
    @CrmLog
    public Result close(@RequestBody TaActBaseProcessReqVo reqVo) {
        this.taActBaseProcessService.closeBatch(reqVo);
        return Result.ok((String)"\u5173\u95ed\u6210\u529f");
    }

    @ApiOperation(value="\u7981\u7528")
    @PostMapping(value={"/disable"})
    @CrmLog
    public Result disable(@RequestBody List<String> ids) {
        this.taActBaseProcessService.disableBatch(ids);
        return Result.ok((String)"\u7981\u7528\u6210\u529f");
    }

    @ApiOperation(value="\u59d4\u6d3e")
    @PostMapping(value={"/delegate"})
    @CrmLog
    public Result delegate(@RequestBody TaActDelegateReqVo taActDelegateReqVo) {
        AssertUtils.isNotEmpty((String)taActDelegateReqVo.getDelegatePositionCode(), (String)"\u59d4\u6d3e\u5c97\u4f4d\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        AssertUtils.isNotEmpty((String)taActDelegateReqVo.getTaskId(), (String)"\u59d4\u6d3e\u4efb\u52a1Id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        this.taActBaseProcessService.delegateProcess(taActDelegateReqVo);
        return Result.ok((String)"\u59d4\u6d3e\u6210\u529f");
    }

    @ApiOperation(value="\u83b7\u53d6\u6d41\u7a0b\u7684\u5f85\u529e\u8282\u70b9\u5217\u8868")
    @PostMapping(value={"/getRunTask"})
    @CrmLog
    public Result getRunTask(@RequestBody TaActBaseProcessReqVo taActBaseProcessReqVo) {
        AssertUtils.isNotNull((Object)taActBaseProcessReqVo.getProcessInstanceId(), (String)"\u6d41\u7a0b\u5b9e\u4f8bID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        return Result.ok(this.activitiMyTaskService.getRunTask(taActBaseProcessReqVo.getProcessInstanceId()));
    }
}

