/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.listener.base;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.DelegateTask;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="flowListenerFactory")
public class FlowListenerFactory {
    private static final String FUN_NAME_NOTIFY = "toNotify";
    private Map<String, Object> listeners;

    public FlowListenerFactory() {
        if (this.listeners == null) {
            this.listeners = new HashMap<String, Object>();
        }
    }

    public Object getListener(String packageName) throws RuntimeException {
        if (StringUtils.isEmpty((CharSequence)packageName)) {
            return null;
        }
        Object listener = this.listeners.get(packageName);
        if (listener == null) {
            try {
                Class<?> listenerClass = Class.forName(packageName);
                if (listenerClass != null) {
                    listener = listenerClass.newInstance();
                    this.listeners.put(packageName, listener);
                }
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
            catch (InstantiationException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
        return listener;
    }

    public DelegateTask notifyTask(Object listener, DelegateTask delegateTask) throws Exception {
        Class<?> clazz = listener.getClass();
        Method method = clazz.getDeclaredMethod(FUN_NAME_NOTIFY, DelegateTask.class);
        return (DelegateTask)method.invoke(listener, delegateTask);
    }

    public DelegateExecution notifyExecution(Object listener, DelegateExecution execution) throws Exception {
        Class<?> clazz = listener.getClass();
        Method method = clazz.getDeclaredMethod(FUN_NAME_NOTIFY, DelegateExecution.class);
        return (DelegateExecution)method.invoke(listener, execution);
    }

    public Map<String, Object> getListeners() {
        return this.listeners;
    }

    public void setListeners(Map<String, Object> listeners) {
        this.listeners = listeners;
    }
}

