/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.act.controller;

import com.biz.crm.act.service.ITaActTargetService;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.activiti.act.req.TaActTargetReqVo;
import com.biz.crm.nebular.activiti.act.resp.TaActTargetRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/taacttarget"})
@Api(tags={"\u5de5\u4f5c\u6d41\u6307\u6807"})
public class TaActTragetController {
    private static final Logger log = LoggerFactory.getLogger(TaActTragetController.class);
    @Resource
    private ITaActTargetService taActTargetService;

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @PostMapping(value={"/list"})
    @CrmLog
    public Result<PageResult<TaActTargetRespVo>> list(@RequestBody TaActTargetReqVo taActFileReqVo) {
        PageResult<TaActTargetRespVo> result = this.taActTargetService.findList(taActFileReqVo);
        return Result.ok(result);
    }

    @ApiOperation(value="\u67e5\u8be2")
    @GetMapping(value={"/query"})
    @CrmLog
    public Result<TaActTargetRespVo> query(@RequestParam(value="id") String id) {
        TaActTargetRespVo respVo = this.taActTargetService.query(id);
        return Result.ok((Object)respVo);
    }

    @ApiOperation(value="\u65b0\u589e")
    @PostMapping(value={"/save"})
    @CrmLog
    public Result save(@RequestBody TaActTargetReqVo taActFileReqVo) {
        AssertUtils.isNotEmpty((String)taActFileReqVo.getProcessKey(), (String)"processKey\u4e0d\u80fd\u4e3a\u7a7a");
        this.taActTargetService.save(taActFileReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u66f4\u65b0")
    @PostMapping(value={"/update"})
    @CrmLog
    public Result update(@RequestBody TaActTargetReqVo taActFileReqVo) {
        this.taActTargetService.update(taActFileReqVo);
        return Result.ok((String)"\u4fee\u6539\u6210\u529f");
    }

    @ApiOperation(value="\u5220\u9664")
    @PostMapping(value={"/delete"})
    @CrmLog
    public Result delete(@RequestBody List<String> ids) {
        this.taActTargetService.deleteBatch(ids);
        return Result.ok((String)"\u5220\u9664\u6210\u529f");
    }

    @ApiOperation(value="\u542f\u7528")
    @PostMapping(value={"/enable"})
    @CrmLog
    public Result enable(@RequestBody TaActTargetReqVo taActFileReqVo) {
        this.taActTargetService.enableBatch(taActFileReqVo);
        return Result.ok((String)"\u542f\u7528\u6210\u529f");
    }

    @ApiOperation(value="\u7981\u7528")
    @PostMapping(value={"/disable"})
    @CrmLog
    public Result disable(@RequestBody TaActTargetReqVo taActFileReqVo) {
        this.taActTargetService.disableBatch(taActFileReqVo);
        return Result.ok((String)"\u7981\u7528\u6210\u529f");
    }
}

