/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.act.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.act.mapper.TaProcessCostTypeMapper;
import com.biz.crm.act.model.TaProcessCostTypeEntity;
import com.biz.crm.act.service.ITaProcessCostTypeService;
import com.biz.crm.base.BusinessException;
import com.biz.crm.exception.CrmExceptionType;
import com.biz.crm.exception.activiti.ActivitiException;
import com.biz.crm.nebular.activiti.act.req.ProcessCostTypeQueryVo;
import com.biz.crm.util.AssertUtils;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnMissingBean(name={"TaProcessCostTypeServiceImpl"})
public class TaProcessCostTypeServiceImpl
extends ServiceImpl<TaProcessCostTypeMapper, TaProcessCostTypeEntity>
implements ITaProcessCostTypeService {
    private static final Logger log = LoggerFactory.getLogger(TaProcessCostTypeServiceImpl.class);
    @Resource
    private TaProcessCostTypeMapper taProcessCostTypeMapper;

    @Override
    public TaProcessCostTypeEntity findExactOneByFormCostSmall(ProcessCostTypeQueryVo queryVo) {
        AssertUtils.isNotEmpty((String)queryVo.getCostType(), (CrmExceptionType)ActivitiException.ACT_PARAM_COST_TYPE);
        AssertUtils.isNotEmpty((String)queryVo.getFormType(), (CrmExceptionType)ActivitiException.ACT_PARAM_FORM_TYPE);
        List<TaProcessCostTypeEntity> costTypes = this.taProcessCostTypeMapper.findByFormCostSmall(queryVo);
        AssertUtils.isNotEmpty(costTypes, (CrmExceptionType)ActivitiException.PROCESS_MODEL_NOT_FOUND);
        if (costTypes.size() > 1) {
            throw new BusinessException("\u5339\u914d\u5230\u591a\u4e2a\u6d41\u7a0b\u5b9a\u4e49\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570");
        }
        return costTypes.get(0);
    }
}

