/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.config;

import com.biz.crm.base.BusinessException;
import com.biz.crm.config.GlobalExceptionHandler;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.activiti.engine.ActivitiException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

@ControllerAdvice
public class ActivitiGlobalExceptionHandler
extends GlobalExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(ActivitiGlobalExceptionHandler.class);

    @ExceptionHandler(value={Exception.class})
    @ResponseBody
    public Result errorHandler(Exception e, HttpServletRequest request, HttpServletResponse response) {
        if (e instanceof ActivitiException) {
            return Result.error((String)e.getMessage());
        }
        return super.errorHandler(e, request, response);
    }

    @ExceptionHandler(value={BusinessException.class})
    @ResponseBody
    public Result errorHandler(BusinessException e, HttpServletRequest request, HttpServletResponse response) {
        log.info("\u5de5\u4f5c\u6d41\u81ea\u5b9a\u4e49\u5f02\u5e38");
        if (StringUtils.isEmpty((String)e.getMsg())) {
            Throwable cause = e.getCause();
            if (cause == null) {
                cause = e;
            }
            return Result.error((String)cause.getMessage());
        }
        return super.errorHandler(e, request, response);
    }
}

