/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.listener;

import com.biz.crm.activiti.entity.ActivitiBusinessEntity;
import com.biz.crm.activiti.service.ActivitiBusinessService;
import com.biz.crm.base.BusinessException;
import com.biz.crm.config.SpringApplicationContextUtil;
import com.biz.crm.copy.service.ActivitiCopyConfigService;
import com.biz.crm.design.eunm.EventNameEunm;
import com.biz.crm.eunm.activiti.ActivitiOperateTypeEnum;
import com.biz.crm.eunm.activiti.ProcessInstanceStatusEnum;
import com.biz.crm.nebular.activiti.act.ActivitiCallBackVo;
import com.biz.crm.util.ActivityUtils;
import java.util.HashSet;
import java.util.Map;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.ExecutionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class GlobalExecutionListener
implements ExecutionListener {
    private static final Logger log = LoggerFactory.getLogger(GlobalExecutionListener.class);

    @Transactional(rollbackFor={Exception.class})
    public void notify(DelegateExecution execution) throws Exception {
        ActivitiBusinessService activitiBusinessService = (ActivitiBusinessService)SpringApplicationContextUtil.getApplicationContext().getBean(ActivitiBusinessService.class);
        String eventName = execution.getEventName();
        log.info("\u6d41\u7a0b\u5168\u5c40\u76d1\u542c\uff1a" + eventName);
        if (EventNameEunm.eventNameEunm.END.getCode().equals(eventName)) {
            log.info("\u7ed3\u675f\u6d41\u7a0b");
            Map map = execution.getVariables();
            Object object = map.get("approveOpt");
            if (object == null) {
                throw new BusinessException("\u6d41\u7a0b\u64cd\u4f5c\u7c7b\u578b\u672a\u8bbe\u7f6e[approveOpt]");
            }
            String approveOpt = object.toString();
            String processInstanceId = execution.getProcessInstanceId();
            String bpmStatus = null;
            Integer callBackProcessStatus = null;
            if ("PASS".equals(approveOpt)) {
                bpmStatus = ActivitiOperateTypeEnum.PASS.getCode();
                callBackProcessStatus = 2;
            } else if ("ABORT".equals(approveOpt)) {
                callBackProcessStatus = 3;
                bpmStatus = ActivitiOperateTypeEnum.REJECT.getCode();
            } else if ("RECOVER".equals(approveOpt)) {
                callBackProcessStatus = 5;
                bpmStatus = ActivitiOperateTypeEnum.RECOVER.getCode();
            } else {
                throw new BusinessException("\u6d41\u7a0b\u64cd\u4f5c\u7c7b\u578b\u8bbe\u9519\u8bef[" + approveOpt + "]");
            }
            ActivitiBusinessEntity businessEntity = activitiBusinessService.updateBpmStatus(processInstanceId, bpmStatus, ProcessInstanceStatusEnum.END.getCode());
            this.doCopyTask(businessEntity.getProcessKey(), businessEntity.getProcessInstanceId(), bpmStatus);
            ActivitiCallBackVo callBackVo = new ActivitiCallBackVo();
            callBackVo.setCallBackFeign(businessEntity.getCallBackFeign());
            callBackVo.setFormNo(businessEntity.getBusinessId());
            callBackVo.setProcessNo(businessEntity.getCrmProcessInstanceId());
            callBackVo.setProcessState(callBackProcessStatus);
            ActivityUtils.processCallBack((ActivitiCallBackVo)callBackVo);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void doCopyTask(String processKey, String processInstanceId, String bpmStatus) {
        HashSet<String> set = new HashSet<String>();
        set.add(ActivitiOperateTypeEnum.PASS.getCode());
        if (!set.contains(bpmStatus)) {
            return;
        }
        ActivitiCopyConfigService activitiCopyConfigService = (ActivitiCopyConfigService)SpringApplicationContextUtil.getApplicationContext().getBean(ActivitiCopyConfigService.class);
        activitiCopyConfigService.doCopyTask(null, processInstanceId);
    }
}

