/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.listener.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.exception.CommonException;
import com.biz.crm.exception.CrmExceptionType;
import com.biz.crm.listener.mapper.TaListenerMapper;
import com.biz.crm.listener.model.TaListenerEntity;
import com.biz.crm.listener.service.ITaListenerService;
import com.biz.crm.listener.service.impl.ListenerHelper;
import com.biz.crm.nebular.activiti.listener.req.TaListenerQueryVO;
import com.biz.crm.nebular.activiti.listener.req.TaListenerReqVo;
import com.biz.crm.nebular.activiti.listener.resp.TaListenerRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="taListenerService")
@ConditionalOnMissingBean(name={"TaListenerServiceExpandImpl"})
public class TaListenerServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<TaListenerMapper, TaListenerEntity>
implements ITaListenerService {
    private static final Logger log = LoggerFactory.getLogger(TaListenerServiceImpl.class);
    @Resource
    private TaListenerMapper taListenerMapper;
    @Autowired
    private ListenerHelper listenerHelper;

    @Override
    public PageResult<TaListenerRespVo> findList(TaListenerReqVo reqVo) {
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<TaListenerRespVo> list = this.taListenerMapper.findList((Page<TaListenerRespVo>)page, reqVo);
        list.forEach(l -> this.listenerHelper.convertValue((TaListenerRespVo)l));
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public TaListenerRespVo query(String id) {
        TaListenerEntity entity = (TaListenerEntity)((Object)this.taListenerMapper.selectById((Serializable)((Object)id)));
        if (ObjectUtils.isNotEmpty((Object)((Object)entity))) {
            TaListenerRespVo taListenerRespVo = (TaListenerRespVo)CrmBeanUtil.copy((Object)((Object)entity), TaListenerRespVo.class);
            return this.listenerHelper.convertValue(taListenerRespVo);
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(TaListenerReqVo reqVo) {
        this.listenerHelper.saveCheck(reqVo);
        TaListenerEntity entity = (TaListenerEntity)((Object)CrmBeanUtil.copy((Object)reqVo, TaListenerEntity.class));
        entity.setDefaultListener(0);
        this.save((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(TaListenerReqVo reqVo) {
        AssertUtils.isNotNull((Object)reqVo.getId(), (String)"\u8bf7\u4f20\u5165\u9700\u8981\u66f4\u65b0\u7684\u76d1\u542c\u5668\u7f16\u7801\uff01");
        this.listenerHelper.saveCheck(reqVo);
        TaListenerEntity entity = (TaListenerEntity)((Object)CrmBeanUtil.copy((Object)reqVo, TaListenerEntity.class));
        this.updateById((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<String> ids) {
        AssertUtils.isNotEmpty(ids, (CrmExceptionType)CommonException.IDS_NULL);
        List taListenerEntities = this.taListenerMapper.selectList((Wrapper)Wrappers.lambdaQuery(TaListenerEntity.class).in(BaseIdEntity::getId, ids));
        taListenerEntities.forEach(o -> AssertUtils.isTrue((!StringUtils.equals((CharSequence)CrmEnableStatusEnum.ENABLE.getCode(), (CharSequence)o.getEnableStatus()) ? 1 : 0) != 0, (String)"\u542f\u7528\u7684\u76d1\u542c\u5668\u4e0d\u5141\u8bb8\u5220\u9664\u64cd\u4f5c"));
        this.taListenerMapper.deleteBatchIds(ids);
    }

    @Override
    public List<TaListenerQueryVO> findExtListenerList(TaListenerQueryVO queryVO) {
        return this.taListenerMapper.findExtListenerList(queryVO);
    }

    @Override
    public void enableBatch(List<String> ids) {
        AssertUtils.isNotEmpty(ids, (CrmExceptionType)CommonException.IDS_NULL);
        List entities = this.taListenerMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)entities)) {
            entities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(entities);
    }

    @Override
    public void disableBatch(List<String> ids) {
        AssertUtils.isNotEmpty(ids, (CrmExceptionType)CommonException.IDS_NULL);
        List entities = this.taListenerMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)entities)) {
            entities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(entities);
    }

    @Override
    public PageResult<TaListenerRespVo> queryBotBinding(TaListenerReqVo taListenerReqVo) {
        Page page = PageUtil.buildPage((Integer)taListenerReqVo.getPageNum(), (Integer)taListenerReqVo.getPageSize());
        List<TaListenerRespVo> list = this.taListenerMapper.queryNotBinding((Page<TaListenerRespVo>)page, taListenerReqVo);
        list.forEach(l -> this.listenerHelper.convertValue((TaListenerRespVo)l));
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }
}

