/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.activiti.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.activiti.entity.TaTargetModelEntity;
import com.biz.crm.activiti.mapper.TaActTargetMapper;
import com.biz.crm.activiti.service.ITaActTargetService;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.GlobalWhetherEnum;
import com.biz.crm.nebular.activiti.act.req.TaActTargetReqVo;
import com.biz.crm.nebular.activiti.act.resp.TaActTargetRespVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"TaActTargetExpandServiceImpl"})
public class TaActTargetServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<TaActTargetMapper, TaTargetModelEntity>
implements ITaActTargetService {
    private static final Logger log = LoggerFactory.getLogger(TaActTargetServiceImpl.class);
    @Resource
    private TaActTargetMapper taActTargetMapper;

    @Override
    public PageResult<TaActTargetRespVo> findList(TaActTargetReqVo reqVo) {
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<TaActTargetRespVo> list = this.taActTargetMapper.findList((Page<TaActTargetRespVo>)page, reqVo);
        list.forEach(respVo -> respVo.setVisibleName(GlobalWhetherEnum.getDesByCode((String)respVo.getVisible())));
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public List<TaActTargetRespVo> findByProcessKey(String procInstId) {
        List<TaActTargetRespVo> list = this.taActTargetMapper.findByProcessKey(procInstId);
        list.forEach(respVo -> respVo.setVisibleName(GlobalWhetherEnum.getDesByCode((String)respVo.getVisible())));
        return list;
    }

    @Override
    public TaActTargetRespVo query(String id) {
        TaTargetModelEntity taTargetModelEntity = (TaTargetModelEntity)this.getById((Serializable)((Object)id));
        if (ObjectUtils.isNotNull((Object[])new Object[]{taTargetModelEntity})) {
            TaActTargetRespVo respVo = (TaActTargetRespVo)CrmBeanUtil.copy((Object)taTargetModelEntity, TaActTargetRespVo.class);
            respVo.setVisibleName(GlobalWhetherEnum.getDesByCode((String)respVo.getVisible()));
            return respVo;
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(TaActTargetReqVo reqVo) {
        TaTargetModelEntity entity = (TaTargetModelEntity)CrmBeanUtil.copy((Object)reqVo, TaTargetModelEntity.class);
        this.save(entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(TaActTargetReqVo reqVo) {
        TaTargetModelEntity entity = (TaTargetModelEntity)CrmBeanUtil.copy((Object)reqVo, TaTargetModelEntity.class);
        this.saveOrUpdate(entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<String> ids) {
        List taActFileEntities = this.taActTargetMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)taActFileEntities)) {
            taActFileEntities.forEach(o -> this.removeById((Serializable)((Object)o.getId())));
        }
        this.updateBatchById(taActFileEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(TaActTargetReqVo reqVo) {
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(TaActTargetReqVo reqVo) {
    }
}

