/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.design.service.impl;

import com.biz.crm.activiti.entity.ActReModelEntity;
import com.biz.crm.activiti.mapper.ActReModelMapper;
import com.biz.crm.base.BusinessException;
import com.biz.crm.design.service.DesignService;
import com.biz.crm.design.vo.NewModelVo;
import com.biz.crm.design.vo.SaveModelVo;
import com.biz.crm.eunm.activiti.Indicator;
import com.biz.crm.nebular.activiti.vo.ActReModel;
import com.biz.crm.util.AssertUtils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Objects;
import javax.annotation.Resource;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.repository.Model;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.PNGTranscoder;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DesignServiceImpl
implements DesignService {
    private static final Logger log = LoggerFactory.getLogger(DesignServiceImpl.class);
    @Resource
    private ActReModelMapper actReModelMapper;
    @Resource
    private RepositoryService repositoryService;
    @Autowired
    private ObjectMapper objectMapper;

    @Override
    public ActReModel getByNameOrKey(String name, String key) {
        return this.actReModelMapper.getByNameOrKey(name, key);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String newModel(NewModelVo newModelVo) {
        Model model = this.repositoryService.newModel();
        String name = newModelVo.getName();
        String description = "";
        int revision = 1;
        String key = newModelVo.getKey();
        ActReModel actReModel = this.getByNameOrKey(name, key);
        AssertUtils.isTrue((boolean)Objects.isNull(actReModel), (String)("\u540d\u5b57\u6216\u8005\u6d41\u7a0bkey\u91cd\u590d[" + name + "][" + key + "]"));
        ObjectNode modelNode = this.objectMapper.createObjectNode();
        modelNode.put("name", name);
        modelNode.put("description", description);
        modelNode.put("revision", revision);
        model.setName(name);
        model.setKey(key);
        model.setMetaInfo(modelNode.toString());
        model.setVersion(Integer.valueOf(1));
        this.repositoryService.saveModel(model);
        String id = model.getId();
        ObjectNode editorNode = this.objectMapper.createObjectNode();
        editorNode.put("id", "canvas");
        editorNode.put("resourceId", "canvas");
        ObjectNode stencilSetNode = this.objectMapper.createObjectNode();
        stencilSetNode.put("namespace", "http://b3mn.org/stencilset/bpmn2.0#");
        editorNode.put("stencilset", (JsonNode)stencilSetNode);
        try {
            this.repositoryService.addModelEditorSource(id, editorNode.toString().getBytes("utf-8"));
        }
        catch (UnsupportedEncodingException e) {
            log.error("{}", (Throwable)e);
            throw new BusinessException("\u8c03\u7528\u5de5\u4f5c\u6d41\u65b0\u5efa\u6a21\u578b\u65b9\u6cd5\u5f02\u5e38");
        }
        ActReModelEntity entity = (ActReModelEntity)this.actReModelMapper.selectById((Serializable)((Object)id));
        entity.setProcessStatus(Integer.valueOf(Indicator.PROCESS_STATE_EDIT.getCode()));
        this.actReModelMapper.updateById(entity);
        return id;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateModel(SaveModelVo saveModelVo) {
        try {
            AssertUtils.isNotEmpty((String)saveModelVo.getModelId(), (String)"\u6d41\u7a0b\u6a21\u578bid\u4e0d\u80fd\u4e3a\u7a7a");
            Model model = this.repositoryService.getModel(saveModelVo.getModelId());
            ObjectNode modelJson = (ObjectNode)this.objectMapper.readTree(model.getMetaInfo());
            modelJson.put("name", saveModelVo.getName());
            modelJson.put("description", saveModelVo.getDescription());
            model.setMetaInfo(modelJson.toString());
            model.setName(saveModelVo.getName());
            model.setVersion(Integer.valueOf(1));
            this.repositoryService.saveModel(model);
            this.repositoryService.addModelEditorSource(model.getId(), saveModelVo.getJson_xml().getBytes("utf-8"));
            ByteArrayInputStream svgStream = new ByteArrayInputStream(saveModelVo.getSvg_xml().getBytes("utf-8"));
            TranscoderInput input = new TranscoderInput((InputStream)svgStream);
            PNGTranscoder transCoder = new PNGTranscoder();
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            TranscoderOutput output = new TranscoderOutput((OutputStream)outStream);
            transCoder.transcode(input, output);
            byte[] result = outStream.toByteArray();
            this.repositoryService.addModelEditorSourceExtra(model.getId(), result);
            outStream.close();
            ActReModelEntity entity = (ActReModelEntity)this.actReModelMapper.selectById((Serializable)((Object)saveModelVo.getModelId()));
            entity.setProcessStatus(Integer.valueOf(Indicator.PROCESS_STATE_EDIT.getCode()));
            this.actReModelMapper.updateById(entity);
        }
        catch (Exception e) {
            log.error("Error saving model", (Throwable)e);
            throw new ActivitiException("Error saving model", (Throwable)e);
        }
    }

    @Override
    public ObjectNode getEditorJson(String modelId) {
        ObjectNode modelNode = null;
        Model model = this.repositoryService.getModel(modelId);
        if (model != null) {
            try {
                if (StringUtils.isNotEmpty((CharSequence)model.getMetaInfo())) {
                    modelNode = (ObjectNode)this.objectMapper.readTree(model.getMetaInfo());
                } else {
                    modelNode = this.objectMapper.createObjectNode();
                    modelNode.put("name", model.getName());
                }
                modelNode.put("modelId", model.getId());
                ObjectNode editorJsonNode = (ObjectNode)this.objectMapper.readTree(new String(this.repositoryService.getModelEditorSource(model.getId()), "utf-8"));
                modelNode.put("model", (JsonNode)editorJsonNode);
            }
            catch (Exception e) {
                log.error("Error creating model JSON", (Throwable)e);
                throw new ActivitiException("Error creating model JSON", (Throwable)e);
            }
        }
        return modelNode;
    }
}

