package com.biz.crm.common;


import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;

/**
 * 字典明细的记录信息
 *
 * @author zxw
 */
@ApiModel(value = "DictItemVo", description = " 字典明细的记录信息")
@AllArgsConstructor
@NoArgsConstructor
@Data
@Accessors(chain = true)
public class DictItemVo implements Serializable {


    private static final long serialVersionUID = 2583644610136995214L;
    /**
     * 字典的值. *
     */
    @ApiModelProperty(name = "dictValue", value = "字典值", required = true)
    private String dictValue;

    /**
     * 字典的名称. *
     */
    @ApiModelProperty(name = "dictKey", value = "字典名称", required = true)
    private String dictKey;


}
