package com.biz.crm.nebular.activiti.modeler.req;

import com.biz.crm.config.CrmColumnResolve;
import com.biz.crm.nebular.mdm.PageVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * @CLASS_DESCRIBE: 流程模型请求vo
 * @AUTHOR: create by zkey on 2020-10-31
 */
@Data
@Builder
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ActivitiModelerReqVo", description = "流程模型vo")
@CrmColumnResolve
public class ActivitiModelerReqVo extends PageVo {

    @ApiModelProperty("流程名称")
    private String name;

    @ApiModelProperty("流程版本号")
    private Integer version;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("流程key")
    private String key;
}
