package com.biz.crm.nebular.activiti.vo;

import com.biz.crm.nebular.mdm.CrmBaseVo;
import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @Project crm
 * @PackageName com.biz.crm.nebular.activiti.vo
 * @ClassName ProcessInstanceQueryReqVo
 * @Author HuangLong
 * @Date 2021/5/12 17:30
 * @Description 流程实例查询请求vo
 */
@Data
public class ProcessInstanceQueryReqVo extends CrmExtTenVo {

    @ApiModelProperty(value = "业务表单id主键")
    private String businessId;

    @ApiModelProperty(value = "业务表单编码")
    private String businessNo;

    @ApiModelProperty(value = "流程key")
    private String processKey;

    @ApiModelProperty(value = "流程名称")
    private String processName;

    @ApiModelProperty(value = "流程标题")
    private String processTitle;

    @ApiModelProperty(value = "发起人")
    private String commitCode;

    @ApiModelProperty(value = "发起人名称")
    private String commitName;

    @ApiModelProperty(value = "审批状态")
    private String bpmStatus;

    @ApiModelProperty(value = "流程实例状态(启用,禁用,暂停,结束)")
    private String processInstanceStatus;

    @ApiModelProperty(value = "处理开始时间")
    private String doneBeginDate;

    @ApiModelProperty(value = "处理结束时间")
    private String doneEndDate;

    @ApiModelProperty(value = "流程发起开始时间")
    private String commitBeginDate;

    @ApiModelProperty(value = "流程发起结束时间")
    private String commitEndDate;

    private String costType;

    private String formType;

    @ApiModelProperty(value = "业务表单编号")
    private String crmProcessInstanceId;

    @ApiModelProperty(value = "发起人组织名称")
    private String commitByOrgName;
}
