package com.biz.crm.nebular.dms.notice;

import com.biz.crm.config.CrmDict;
import com.biz.crm.nebular.mdm.CrmExtVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumnRelation;
import com.bizunited.platform.saturn.engine.annotation.SaturnDomain;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * @Description: 公司资料主表
 * @Author: zhangyuzhu
 * @Date: 2020/9/10 14:46
 **/
//@Entity
//@Table(name = "dms_notice")
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "公告主信息的vo")
@SaturnEntity(name = "NoticeVo", description = "公告主信息")
@SaturnDomain(value = "notice")
public class NoticeVo extends CrmExtVo {

    @ApiModelProperty(value = "标题")
    @SaturnColumn(description = "标题")
    private String title;


    @ApiModelProperty(value = "类型")
    @SaturnColumn(description = "类型")
    private Integer type;

    @ApiModelProperty(value = "类型名称")
    @SaturnColumn(description = "类型名称")
    @CrmDict(typeCode="notice_type",dictCodeField="type")
    private String typeName;


    @ApiModelProperty(value = "发布部门code")
    @SaturnColumn(description = "发布部门code")
    private String publishOrgCode;


    @ApiModelProperty(value = "发布部门名称")
    @SaturnColumn(description = "发布部门名称")
    private String publishOrgName;


    @ApiModelProperty(value = "公告状态")
    @SaturnColumn(description = "公告状态")
    private Integer noticeState;


    @CrmDict(typeCode="notice_state",dictCodeField="noticeState")
    @ApiModelProperty(value = "公告状态名称")
    @SaturnColumn(description = "公告状态名称")
    private String noticeStateName;


    @ApiModelProperty(value = "生效开始时间")
    @SaturnColumn(description = "生效开始时间")
    private String startTime;


    @ApiModelProperty(value = "生效结束时间")
    @SaturnColumn(description = "生效结束时间")
    private String endTime;


    @ApiModelProperty(value = "访问人数")
    @SaturnColumn(description = "访问人数")
    private Integer visitNum;


    @ApiModelProperty(value = "公告内容")
    @SaturnColumn(description = "公告内容")
    private String content;

    /***/
    @ApiModelProperty(value = "消息状态")
    private Integer msgState;

    @ApiModelProperty(value = "文件信息")
    @SaturnColumn(description = "文件信息")
    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
    private List<NoticeFileVo>  files;

    @ApiModelProperty(value = "范围信息（组织-包含）")
    @SaturnColumn(description = "范围信息（组织-包含）")
    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
    private List<NoticeAreaVo>  orgs;

    @ApiModelProperty(value = "范围信息（组织-不包含）")
    @SaturnColumn(description = "范围信息（组织-不包含）")
    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
    private List<NoticeAreaVo>  nonOrgs;

    @ApiModelProperty(value = "范围信息（客户-包含）")
    @SaturnColumn(description = "范围信息（客户-包含）")
    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
    private List<NoticeAreaVo>  customers;

    @ApiModelProperty(value = "范围信息（客户-不包含）")
    @SaturnColumn(description = "范围信息（客户-不包含）")
    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
    private List<NoticeAreaVo>  nonCustomers;
}
