package com.biz.crm.nebular.dms.npromotion.bo;

import com.biz.crm.nebular.dms.promotion.PromotionRuleEditVo;
import com.biz.crm.nebular.dms.npromotion.vo.PromotionProductVo;
import com.biz.crm.nebular.dms.npromotion.vo.PromotionSaleProductVo;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * 政策计算入参
 * @Author: chenrong
 * @Date: 2021/4/22 15:49
 */
@Data
@Accessors(chain = true)
public class CalculateParamBo implements Serializable {

  //政策编码
  private String promotionCode;
  //政策类型
  private String promotionType;
  //本品购买量
  private List<PromotionSaleProductVo> saleProductVos;
  //政策阶梯列表
  private List<PromotionRuleEditVo.ControlRow> ladderList;
  //条件规则函数 bean Name
  private String conditionRuleFunctionBeanName;
  //政策所剩可用余额
  private BigDecimal variable;
  //价格
  private Map<String, BigDecimal> prices;
  //政策中本品列表
  private List<PromotionProductVo> currentProductVos;
  //政策中的赠品列表
  private List<PromotionProductVo> giftProductVos;
}
