package com.biz.crm.nebular.dms.npromotion.vo;

import com.biz.crm.nebular.dms.promotion.PromotionRuleEditVo;
import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.List;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 促销阶梯命中计算结果对象
 * @Author: chenrong
 * @Date: 2021/4/21 11:19
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel(value = "促销阶梯命中计算结果对象")
public class CalculateHitResultVo extends CrmExtTenVo {

  private static final long serialVersionUID = 2839780113321014898L;

  @ApiModelProperty(value = "计算结果数据类型，数量？金额？……")
  private String valueType;

  @ApiModelProperty(value = "计算结果单位类型")
  private String unitType;

  @ApiModelProperty(value = "计算结果")
  private BigDecimal value;

  @ApiModelProperty(value = "使用的阶梯")
  private List<PromotionRuleEditVo.ControlRow> ladderUsed;

  @ApiModelProperty(value = "阶梯匹配状态，只要有一个阶梯匹配上，就为true")
  private boolean matchState;

  @ApiModelProperty(value = "未匹配到阶梯时的描述说明")
  private String matchMsg;
}
