package com.biz.crm.nebular.dms.order;

import io.swagger.models.auth.In;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/** 业务实体，为算价最小起订量提供
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2021/3/7 12:22
 **/
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class CalMinBuyNumDo {

    /**
     * 数量
     */
    private Integer num;

    /**
     * 赠品数量
     */
    private Integer giftNum;

    /**
     * 产品名称
     */
    private String productName;

    /**
     * 产品编码
     */
    private String productCode;


    /**
     * 初始化
     * @param num
     * @param giftNum
     * @param productName
     * @param productCode
     * @return
     */
    public static CalMinBuyNumDo newInstance(Integer num,Integer giftNum, String productName, String productCode) {
        CalMinBuyNumDo calMinBuyNumDo = new CalMinBuyNumDo();
        calMinBuyNumDo.setNum(num);
        calMinBuyNumDo.setGiftNum(giftNum);
        calMinBuyNumDo.setProductCode(productCode);
        calMinBuyNumDo.setProductName(productName);
        return calMinBuyNumDo;
    }
}
